/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.kernel;

import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.jdbc.common.apps.AutoIncrementPC1;
import org.apache.openjpa.persistence.jdbc.common.apps.AutoIncrementPC2;
import org.apache.openjpa.persistence.jdbc.common.apps.AutoIncrementPC3;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;

public class TestEJBAutoIncrement
extends BaseJDBCTest {
    private int oid2;
    private long oid3;
    private long oid4;
    private long oid2a;
    private long oid2b;
    private long oid3b;
    private long oid3a;

    public TestEJBAutoIncrement(String name) {
        super(name);
    }

    public void setUp() {
        this.deleteAll(AutoIncrementPC1.class);
        this.deleteAll(AutoIncrementPC2.class);
        this.deleteAll(AutoIncrementPC3.class);
    }

    public void testInsert() {
        AutoIncrementPC2 pc1 = new AutoIncrementPC2(1);
        pc1.setStringField("pc1");
        pc1.setIntField(1);
        pc1.getSetField().add("string1");
        pc1.getSetField().add("string2");
        AutoIncrementPC2 pc2 = new AutoIncrementPC2(2);
        pc2.setStringField("pc2");
        pc2.setIntField(2);
        pc2.getSetField().add("string3");
        pc2.getSetField().add("string4");
        AutoIncrementPC3 pc3 = new AutoIncrementPC3(3);
        pc3.setStringField("pc3");
        pc3.getSetField().add("string5");
        pc3.getSetField().add("string6");
        AutoIncrementPC3 pc4 = new AutoIncrementPC3(4);
        pc4.setStringField("pc4");
        pc4.getSetField().add("string7");
        pc4.getSetField().add("string8");
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persist((Object)pc1);
        em.persist((Object)pc2);
        em.persist((Object)pc3);
        em.persist((Object)pc4);
        this.oid2 = pc2.getId();
        this.oid4 = pc4.getId();
        TestEJBAutoIncrement.assertEquals((Object)pc2, (Object)em.find(AutoIncrementPC2.class, (Object)this.oid2));
        TestEJBAutoIncrement.assertEquals((Object)pc4, (Object)em.find(AutoIncrementPC3.class, (Object)this.oid4));
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        pc2 = (AutoIncrementPC2)em.find(AutoIncrementPC2.class, (Object)2);
        pc4 = (AutoIncrementPC3)em.find(AutoIncrementPC3.class, (Object)4);
        TestEJBAutoIncrement.assertEquals((String)"pc2", (String)pc2.getStringField());
        TestEJBAutoIncrement.assertEquals((int)2, (int)pc2.getIntField());
        TestEJBAutoIncrement.assertEquals((String)"pc4", (String)pc4.getStringField());
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testUpdate() {
        AutoIncrementPC2 pc2 = new AutoIncrementPC2(1);
        pc2.setStringField("pc2");
        pc2.setIntField(2);
        AutoIncrementPC3 pc3 = new AutoIncrementPC3(2);
        pc3.setStringField("pc3");
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persist((Object)pc2);
        em.persist((Object)pc3);
        this.endTx((EntityManager)em);
        this.oid2 = pc2.getId();
        this.oid3 = pc3.getId();
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        pc2 = (AutoIncrementPC2)em.find(AutoIncrementPC2.class, (Object)this.oid2);
        pc3 = (AutoIncrementPC3)em.find(AutoIncrementPC3.class, (Object)this.oid3);
        TestEJBAutoIncrement.assertEquals((String)"pc2", (String)pc2.getStringField());
        TestEJBAutoIncrement.assertEquals((int)2, (int)pc2.getIntField());
        TestEJBAutoIncrement.assertEquals((String)"pc3", (String)pc3.getStringField());
        pc2.setStringField("pc2a");
        pc2.setIntField(3);
        pc3.setStringField("pc3a");
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        pc2 = (AutoIncrementPC2)em.find(AutoIncrementPC2.class, (Object)this.oid2);
        pc3 = (AutoIncrementPC3)em.find(AutoIncrementPC3.class, (Object)this.oid3);
        TestEJBAutoIncrement.assertEquals((String)"pc2a", (String)pc2.getStringField());
        TestEJBAutoIncrement.assertEquals((int)3, (int)pc2.getIntField());
        TestEJBAutoIncrement.assertEquals((String)"pc3a", (String)pc3.getStringField());
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testCircularReferences() {
        AutoIncrementPC2 pc2a = new AutoIncrementPC2(1);
        pc2a.setStringField("pc2a");
        pc2a.setIntField(1);
        AutoIncrementPC2 pc2b = new AutoIncrementPC2(2);
        pc2b.setStringField("pc2b");
        pc2b.setIntField(2);
        AutoIncrementPC3 pc3 = new AutoIncrementPC3(3);
        pc3.setStringField("pc3");
        pc2a.setOneOne(pc2b);
        pc2b.setOneOne(pc2a);
        pc3.setOneOne(pc3);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persist((Object)pc2a);
        em.persist((Object)pc2b);
        em.persist((Object)pc3);
        this.endTx((EntityManager)em);
        this.oid2a = pc2a.getId();
        this.oid2b = pc2b.getId();
        this.oid3 = pc3.getId();
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        pc2a = (AutoIncrementPC2)em.find(AutoIncrementPC2.class, (Object)this.oid2a);
        pc2b = (AutoIncrementPC2)em.find(AutoIncrementPC2.class, (Object)this.oid2b);
        pc3 = (AutoIncrementPC3)em.find(AutoIncrementPC3.class, (Object)this.oid3);
        TestEJBAutoIncrement.assertEquals((String)"pc2a", (String)pc2a.getStringField());
        TestEJBAutoIncrement.assertEquals((int)1, (int)pc2a.getIntField());
        TestEJBAutoIncrement.assertEquals((String)"pc2b", (String)pc2b.getStringField());
        TestEJBAutoIncrement.assertEquals((int)2, (int)pc2b.getIntField());
        TestEJBAutoIncrement.assertEquals((String)"pc3", (String)pc3.getStringField());
        TestEJBAutoIncrement.assertEquals((Object)pc2b, (Object)pc2a.getOneOne());
        TestEJBAutoIncrement.assertEquals((Object)pc2a, (Object)pc2b.getOneOne());
        TestEJBAutoIncrement.assertEquals((Object)pc3, (Object)pc3.getOneOne());
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testMultipleFlushes() {
        AutoIncrementPC2 pc2 = new AutoIncrementPC2(1);
        pc2.setStringField("pc2");
        pc2.setIntField(2);
        AutoIncrementPC3 pc3 = new AutoIncrementPC3(2);
        pc3.setStringField("pc3");
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persist((Object)pc2);
        em.persist((Object)pc3);
        this.oid2 = pc2.getId();
        this.oid3 = pc3.getId();
        em.flush();
        this.oid2a = pc2.getId();
        this.oid3a = pc3.getId();
        TestEJBAutoIncrement.assertEquals((long)this.oid2, (long)this.oid2a);
        TestEJBAutoIncrement.assertEquals((long)this.oid3, (long)this.oid3a);
        long id = pc3.getId();
        TestEJBAutoIncrement.assertEquals((Object)pc2, (Object)em.find(AutoIncrementPC2.class, (Object)this.oid2a));
        TestEJBAutoIncrement.assertEquals((Object)pc3, (Object)em.find(AutoIncrementPC3.class, (Object)this.oid3a));
        pc2.setStringField("pc2a");
        pc2.setIntField(3);
        pc3.setStringField("pc3a");
        em.flush();
        this.oid2b = pc2.getId();
        this.oid3b = pc3.getId();
        TestEJBAutoIncrement.assertEquals((long)this.oid2, (long)this.oid2b);
        TestEJBAutoIncrement.assertEquals((long)this.oid3, (long)this.oid3b);
        TestEJBAutoIncrement.assertEquals((long)id, (long)pc3.getId());
        TestEJBAutoIncrement.assertEquals((Object)pc2, (Object)em.find(AutoIncrementPC2.class, (Object)this.oid2b));
        TestEJBAutoIncrement.assertEquals((Object)pc3, (Object)em.find(AutoIncrementPC3.class, (Object)this.oid3b));
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        pc2 = (AutoIncrementPC2)em.find(AutoIncrementPC2.class, (Object)this.oid2b);
        pc3 = (AutoIncrementPC3)em.find(AutoIncrementPC3.class, (Object)this.oid3b);
        TestEJBAutoIncrement.assertEquals((String)"pc2a", (String)pc2.getStringField());
        TestEJBAutoIncrement.assertEquals((int)3, (int)pc2.getIntField());
        TestEJBAutoIncrement.assertEquals((String)"pc3a", (String)pc3.getStringField());
        TestEJBAutoIncrement.assertEquals((long)id, (long)pc3.getId());
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }
}

