/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.kernel;

import java.util.Iterator;
import javax.persistence.EntityManager;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.lib.jdbc.AbstractJDBCListener;
import org.apache.openjpa.lib.jdbc.JDBCEvent;
import org.apache.openjpa.persistence.Extent;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.jdbc.common.apps.DataStoreTripsPC;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;

public class TestDataStoreTrips
extends BaseJDBCTest {
    private OpenJPAEntityManagerFactory _factory = null;
    private Object _oid = null;
    private SelectCounter _counter = null;

    public TestDataStoreTrips() {
    }

    public TestDataStoreTrips(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.deleteAll(DataStoreTripsPC.class);
        OpenJPAEntityManager em = this.currentEntityManager();
        OpenJPAEntityManager kem = OpenJPAPersistence.cast((EntityManager)em);
        JDBCConfiguration conf = (JDBCConfiguration)((OpenJPAEntityManagerSPI)kem).getConfiguration();
        ClassMapping mapping = conf.getMappingRepositoryInstance().getMapping(DataStoreTripsPC.class, null, true);
        String table = conf.getDBDictionaryInstance().getFullName(mapping.getTable(), false);
        this._factory = this.getEmf();
        OpenJPAEntityManager pm = this._factory.createEntityManager();
        this.startTx((EntityManager)pm);
        DataStoreTripsPC pc = new DataStoreTripsPC(0);
        pm.persist((Object)pc);
        this._oid = pm.getObjectId((Object)pc);
        for (int i = 1; i < 10; ++i) {
            pm.persist((Object)new DataStoreTripsPC(i));
        }
        this.endTx((EntityManager)pm);
        em.close();
        pm = this._factory.createEntityManager();
        pm.getObjectId(this._oid);
        pm.close();
        this._counter = (SelectCounter)((JDBCConfiguration)((OpenJPAEntityManagerFactorySPI)this._factory).getConfiguration()).getJDBCListenerInstances()[0];
        this._counter.selects = 0;
        this._counter.counts = 0;
    }

    public void testTrips() {
        OpenJPAEntityManager pm = this._factory.createEntityManager();
        Extent ext = pm.createExtent(DataStoreTripsPC.class, true);
        Iterator itr = ext.iterator();
        while (itr.hasNext()) {
            itr.next();
        }
        ext.closeAll();
        pm.close();
        TestDataStoreTrips.assertTrue((this._counter.selects > 0 ? 1 : 0) != 0);
        TestDataStoreTrips.assertTrue((String)("Should have been 1-3 trips to the data store; got " + this._counter.selects), (this._counter.selects < 5 ? 1 : 0) != 0);
    }

    public void testExistsCalls() {
        OpenJPAEntityManager pm = this._factory.createEntityManager();
        pm.getObjectId(this._oid);
        TestDataStoreTrips.assertEquals((int)0, (int)this._counter.counts);
        TestDataStoreTrips.assertEquals((int)1, (int)this._counter.selects);
        pm.getObjectId(this._oid);
        TestDataStoreTrips.assertEquals((int)1, (int)this._counter.counts);
        TestDataStoreTrips.assertEquals((int)2, (int)this._counter.selects);
        pm.getObjectId(this._oid);
        TestDataStoreTrips.assertEquals((int)2, (int)this._counter.counts);
        TestDataStoreTrips.assertEquals((int)3, (int)this._counter.selects);
        pm.getObjectId(this._oid);
        TestDataStoreTrips.assertEquals((int)2, (int)this._counter.counts);
        TestDataStoreTrips.assertEquals((int)3, (int)this._counter.selects);
        this.startTx((EntityManager)pm);
        pm.getObjectId(this._oid);
        TestDataStoreTrips.assertEquals((int)2, (int)this._counter.counts);
        TestDataStoreTrips.assertEquals((int)4, (int)this._counter.selects);
        pm.getObjectId(this._oid);
        TestDataStoreTrips.assertEquals((int)2, (int)this._counter.counts);
        TestDataStoreTrips.assertEquals((int)4, (int)this._counter.selects);
        this.rollbackTx((EntityManager)pm);
        pm.close();
    }

    public static class SelectCounter
    extends AbstractJDBCListener {
        public int selects = 0;
        public int counts = 0;
        private String _table = null;

        public void setTable(String table) {
            this._table = table;
        }

        public void beforeExecuteStatement(JDBCEvent event) {
            if (event.getSQL().indexOf(this._table) != -1) {
                ++this.selects;
            }
            if (event.getSQL().indexOf(" COUNT(") != -1) {
                ++this.counts;
            }
        }
    }
}

