/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.kernel;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.meta.MappingTool;
import org.apache.openjpa.kernel.Extent;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.jdbc.common.apps.ByteArrayPKPC;
import org.apache.openjpa.persistence.jdbc.common.apps.ByteArrayPKPC2;
import org.apache.openjpa.persistence.jdbc.common.apps.ByteArrayPKPCId;
import org.apache.openjpa.persistence.jdbc.kernel.BaseJDBCTest;

public class TestByteArrayAppId
extends BaseJDBCTest {
    private static boolean _init = false;
    private static int TEST_COUNT = 0;
    private static OpenJPAEntityManagerFactory _pmf = null;

    public TestByteArrayAppId(String name) {
        super(name);
    }

    public boolean skipTest() {
        return this.getCurrentPlatform() != AbstractTestCase.Platform.DB2;
    }

    public void setUp() throws Exception {
        if (!_init) {
            _pmf = this.getEmf(this.getProps());
            this.initialize((JDBCConfiguration)((OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.cast((EntityManagerFactory)_pmf)).getConfiguration());
            _init = true;
        }
        OpenJPAEntityManager pm = _pmf.createEntityManager();
        this.startTx((EntityManager)pm);
        this.deleteAll(ByteArrayPKPC.class, (EntityManager)pm);
        this.endTx((EntityManager)pm);
        pm.close();
        pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        ByteArrayPKPC2 testBytes = new ByteArrayPKPC2(new byte[]{1, 2}, "child");
        testBytes.setSubfield("sub");
        testBytes.setParent(new ByteArrayPKPC(new byte[]{3, 4}, "parent"));
        pm.persist((Object)testBytes);
        this.endTx((EntityManager)pm);
        pm.close();
        ++TEST_COUNT;
    }

    @Override
    public void tearDown() throws Exception {
        if (TEST_COUNT >= 9) {
            this.closeEMF((EntityManagerFactory)_pmf);
            _pmf = null;
            _init = false;
            super.tearDown();
        }
    }

    private void initialize(JDBCConfiguration conf) throws Exception {
        OpenJPAEntityManager em = this.currentEntityManager();
        OpenJPAEntityManager kem = OpenJPAPersistence.cast((EntityManager)em);
        MappingTool tool = new MappingTool((JDBCConfiguration)((OpenJPAEntityManagerSPI)kem).getConfiguration(), "refresh", false);
        tool.run(ByteArrayPKPC.class);
        tool.run(ByteArrayPKPC2.class);
        tool.record();
    }

    public void testGetObjectIdClass() {
        OpenJPAEntityManager em = this.currentEntityManager();
        OpenJPAEntityManager pm = OpenJPAPersistence.cast((EntityManager)em);
        TestByteArrayAppId.assertEquals(ByteArrayPKPCId.class, (Object)pm.getObjectIdClass(ByteArrayPKPC.class));
        TestByteArrayAppId.assertEquals(ByteArrayPKPCId.class, (Object)pm.getObjectIdClass(ByteArrayPKPC2.class));
        pm.close();
        em.close();
    }

    public void testGetSubclassObjectById() {
        ByteArrayPKPC2 bytes2 = this.getChild();
        TestByteArrayAppId.assertNotNull((Object)bytes2);
        TestByteArrayAppId.assertEquals((int)1, (int)bytes2.getPK()[0]);
        TestByteArrayAppId.assertEquals((int)2, (int)bytes2.getPK()[1]);
        TestByteArrayAppId.assertEquals((String)"child", (String)bytes2.getStringField());
        TestByteArrayAppId.assertEquals((String)"sub", (String)bytes2.getSubfield());
        TestByteArrayAppId.assertNotNull((Object)bytes2.getParent());
        TestByteArrayAppId.assertEquals((int)3, (int)bytes2.getParent().getPK()[0]);
        TestByteArrayAppId.assertEquals((int)4, (int)bytes2.getParent().getPK()[1]);
        TestByteArrayAppId.assertEquals((String)"parent", (String)bytes2.getParent().getStringField());
        TestByteArrayAppId.assertNull((Object)bytes2.getParent().getParent());
    }

    public void testGetObjectById() {
        ByteArrayPKPC bytes = this.getParent();
        TestByteArrayAppId.assertNotNull((Object)bytes);
        TestByteArrayAppId.assertEquals((int)3, (int)bytes.getPK()[0]);
        TestByteArrayAppId.assertEquals((int)4, (int)bytes.getPK()[1]);
        TestByteArrayAppId.assertEquals((String)"parent", (String)bytes.getStringField());
        TestByteArrayAppId.assertNull((Object)bytes.getParent());
    }

    public void testGetObjectId() {
        OpenJPAEntityManager em = this.currentEntityManager();
        OpenJPAEntityManager kem = OpenJPAPersistence.cast((EntityManager)em);
        if (!((OpenJPAEntityManagerSPI)kem).getConfiguration().getCompatibilityInstance().getCopyObjectIds()) {
            return;
        }
        ByteArrayPKPCId oid = new ByteArrayPKPCId();
        oid.pk = new byte[]{1, 2};
        ByteArrayPKPC bytes = (ByteArrayPKPC)kem.getObjectId((Object)oid);
        ByteArrayPKPCId oidCopy = (ByteArrayPKPCId)kem.getObjectId((Object)bytes);
        TestByteArrayAppId.assertTrue((String)"Oid not copied.", (oid != oidCopy ? 1 : 0) != 0);
        TestByteArrayAppId.assertEquals((int)1, (int)oidCopy.pk[0]);
        TestByteArrayAppId.assertEquals((int)2, (int)oidCopy.pk[1]);
        em.close();
        kem.close();
    }

    public void testChangeIdentity() {
        ByteArrayPKPC2 bytes = this.getChild();
        OpenJPAEntityManager pm = OpenJPAPersistence.getEntityManager((Object)bytes);
        this.startTx((EntityManager)pm);
        bytes.setPK(bytes.getPK());
        try {
            bytes.setPK(new byte[]{5, 6});
            TestByteArrayAppId.fail((String)"Allowed changing of pk.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.rollbackTx((EntityManager)pm);
        pm.close();
    }

    public void testPKRetain() {
        ByteArrayPKPC2 bytes = this.getChild();
        OpenJPAEntityManager pm = OpenJPAPersistence.getEntityManager((Object)bytes);
        this.startTx((EntityManager)pm);
        bytes.setParent(null);
        this.endTx((EntityManager)pm);
        TestByteArrayAppId.assertEquals((int)1, (int)bytes.getPK()[0]);
        TestByteArrayAppId.assertEquals((int)2, (int)bytes.getPK()[1]);
        try {
            bytes.getParent();
            TestByteArrayAppId.fail((String)"Allowed read of non-pk value outside of transaction.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            bytes.setPK(new byte[]{5, 6});
            TestByteArrayAppId.fail((String)"Allowed setting of pk value outside of transaction.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        pm.close();
    }

    public void testDeleteAndInsert() {
        OpenJPAEntityManager em = this.currentEntityManager();
        OpenJPAEntityManager kem = OpenJPAPersistence.cast((EntityManager)em);
        this.startTx((EntityManager)kem);
        for (int i = 0; i < 20; ++i) {
            ByteArrayPKPC bytes = new ByteArrayPKPC(new byte[]{(byte)(i + 5), (byte)(i + 6)}, String.valueOf(i));
            kem.persist((Object)bytes);
        }
        this.endTx((EntityManager)kem);
        kem.close();
        kem = _pmf.createEntityManager();
        this.startTx((EntityManager)kem);
        Extent extent = (Extent)kem.createExtent(ByteArrayPKPC.class, false);
        kem.detachAll((Collection)extent.list());
        extent.closeAll();
        ByteArrayPKPC owner = new ByteArrayPKPC();
        kem.persist((Object)owner);
        owner.setPK(new byte[]{100, 101});
        owner.setStringField("owner");
        for (int i = 0; i < 20; ++i) {
            ByteArrayPKPC bytes = new ByteArrayPKPC(new byte[]{(byte)(i + 5), (byte)(i + 6)}, String.valueOf(i));
            kem.persist((Object)bytes);
            TestByteArrayAppId.assertEquals((Object)bytes, (Object)this.getStateManager(bytes, (EntityManager)kem).getManagedInstance());
            owner.getRels().add(bytes);
        }
        this.endTx((EntityManager)kem);
        Object oid = kem.getObjectId((Object)owner);
        this.assertOwner(kem, oid);
        kem.close();
        kem = _pmf.createEntityManager();
        this.assertOwner(kem, oid);
        em.close();
        kem.close();
    }

    public void testQuery() {
        OpenJPAEntityManager pm = _pmf.createEntityManager();
        Object q = null;
        q.declareParameters("byte[] bytes");
        Collection results = null;
        TestByteArrayAppId.assertEquals((int)1, (int)results.size());
        ByteArrayPKPC2 child = (ByteArrayPKPC2)results.iterator().next();
        TestByteArrayAppId.assertEquals((String)"child", (String)child.getStringField());
        q.closeAll();
        pm.close();
    }

    public void testConflictingIds() {
        OpenJPAEntityManager pm = _pmf.createEntityManager();
        this.startTx((EntityManager)pm);
        ByteArrayPKPC owner = new ByteArrayPKPC();
        pm.persist((Object)owner);
        owner.setPK(new byte[]{100, 101});
        owner.setStringField("owner");
        for (int i = 0; i < 20; ++i) {
            ByteArrayPKPC bytes = new ByteArrayPKPC();
            pm.persist((Object)bytes);
            TestByteArrayAppId.assertEquals((Object)bytes, (Object)this.getStateManager(bytes, (EntityManager)pm).getManagedInstance());
            bytes.setPK(new byte[]{(byte)(i + 5), (byte)(i + 6)});
            bytes.setStringField(String.valueOf(i));
            owner.getRels().add(bytes);
        }
        this.endTx((EntityManager)pm);
        Object oid = pm.getObjectId((Object)owner);
        this.assertOwner(pm, oid);
        pm.close();
        pm = _pmf.createEntityManager();
        this.assertOwner(pm, oid);
        pm.close();
    }

    private void assertOwner(OpenJPAEntityManager pm, Object oid) {
        ByteArrayPKPC owner = (ByteArrayPKPC)pm.getObjectId(oid);
        TestByteArrayAppId.assertEquals((int)100, (int)owner.getPK()[0]);
        TestByteArrayAppId.assertEquals((int)101, (int)owner.getPK()[1]);
        TestByteArrayAppId.assertEquals((String)"owner", (String)owner.getStringField());
        List rels = owner.getRels();
        TestByteArrayAppId.assertEquals((int)20, (int)rels.size());
        for (int i = 0; i < rels.size(); ++i) {
            ByteArrayPKPC bytes = (ByteArrayPKPC)rels.get(i);
            TestByteArrayAppId.assertEquals((int)(i + 5), (int)bytes.getPK()[0]);
            TestByteArrayAppId.assertEquals((int)(i + 6), (int)bytes.getPK()[1]);
            TestByteArrayAppId.assertEquals((String)String.valueOf(i), (String)bytes.getStringField());
        }
    }

    private ByteArrayPKPC getParent() {
        ByteArrayPKPCId oid = new ByteArrayPKPCId();
        oid.pk = new byte[]{3, 4};
        OpenJPAEntityManager pm = _pmf.createEntityManager();
        return (ByteArrayPKPC)pm.getObjectId((Object)oid);
    }

    private ByteArrayPKPC2 getChild() {
        ByteArrayPKPCId oid = new ByteArrayPKPCId();
        oid.pk = new byte[]{1, 2};
        OpenJPAEntityManager pm = _pmf.createEntityManager();
        return (ByteArrayPKPC2)pm.getObjectId((Object)oid);
    }

    public static void main(String[] args) {
    }

    private Map getProps() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("openjpa.jdbc.DBDictionary", "");
        props.put("UseGetBytesForBlobs", "true");
        props.put("UseSetBytesForBlobs", "true");
        props.put("BatchLimit", "0");
        return props;
    }
}

