/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.common.apps;

import java.io.Serializable;
import org.apache.openjpa.persistence.jdbc.common.apps.ByteArrayPKPC;

public class ByteArrayPKPCId
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public byte[] pk;

    public ByteArrayPKPCId() {
    }

    public ByteArrayPKPCId(String fromString) {
        this.pk = ByteArrayPKPCId.toBytes(fromString);
    }

    public String toString() {
        return ByteArrayPKPCId.toString(this.pk);
    }

    public int hashCode() {
        return ByteArrayPKPCId.hashCode(this.pk);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ByteArrayPKPCId)) {
            return false;
        }
        ByteArrayPKPCId other = (ByteArrayPKPCId)obj;
        return ByteArrayPKPCId.equals(this.pk, other.pk);
    }

    private static byte[] toBytes(String s) {
        if ("null".equals(s)) {
            return null;
        }
        int len = s.length();
        byte[] r = new byte[len / 2];
        for (int i = 0; i < r.length; ++i) {
            int digit1 = s.charAt(i * 2);
            int digit2 = s.charAt(i * 2 + 1);
            if (digit1 >= 48 && digit1 <= 57) {
                digit1 -= 48;
            } else if (digit1 >= 65 && digit1 <= 70) {
                digit1 -= 55;
            }
            if (digit2 >= 48 && digit2 <= 57) {
                digit2 -= 48;
            } else if (digit2 >= 65 && digit2 <= 70) {
                digit2 -= 55;
            }
            r[i] = (byte)((digit1 << 4) + digit2);
        }
        return r;
    }

    private static String toString(byte[] b) {
        if (b == null) {
            return "null";
        }
        StringBuilder r = new StringBuilder(b.length * 2);
        for (byte value : b) {
            for (int j = 1; j >= 0; --j) {
                r.append(HEX[value >> j * 4 & 0xF]);
            }
        }
        return r.toString();
    }

    private static boolean equals(byte[] b1, byte[] b2) {
        if (b1 == null && b2 == null) {
            return true;
        }
        if (b1 == null || b2 == null) {
            return false;
        }
        if (b1.length != b2.length) {
            return false;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    private static int hashCode(byte[] b) {
        if (b == null) {
            return 0;
        }
        int sum = 0;
        for (byte value : b) {
            sum += value;
        }
        return sum;
    }

    static {
        Class<ByteArrayPKPC> clazz = ByteArrayPKPC.class;
    }
}

