/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.annotations;

import java.util.Date;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.strats.NoneVersionStrategy;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.annotations.AnnoTest1;
import org.apache.openjpa.persistence.jdbc.annotations.AnnoTest2;
import org.apache.openjpa.persistence.jdbc.annotations.AnnoTest3;
import org.apache.openjpa.persistence.jdbc.annotations.EmbedOwner;
import org.apache.openjpa.persistence.jdbc.annotations.EmbedValue;
import org.apache.openjpa.persistence.jdbc.annotations.Flat1;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestVersion
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(AnnoTest1.class, AnnoTest2.class, AnnoTest3.class, Flat1.class, EmbedOwner.class, EmbedValue.class, CLEAR_TABLES, "openjpa.ConnectionFactoryProperties", "printParameters=true");
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        AnnoTest1 test1 = new AnnoTest1();
        test1.setPk(5L);
        test1.setBasic(50);
        test1.setTransient(500);
        em.persist((Object)test1);
        AnnoTest2 test2 = new AnnoTest2();
        test2.setPk1(5L);
        test2.setPk2("bar");
        test2.setBasic("50");
        em.persist((Object)test2);
        AnnoTest3 test3 = new AnnoTest3();
        test3.setPk(3L);
        test3.setBasic2(50);
        em.persist((Object)test3);
        em.getTransaction().commit();
        em.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVersionNumeric() {
        OpenJPAEntityManagerSPI em1 = this.emf.createEntityManager();
        em1.getTransaction().begin();
        OpenJPAEntityManagerSPI em2 = this.emf.createEntityManager();
        em2.getTransaction().begin();
        AnnoTest1 pc1 = (AnnoTest1)em1.find(AnnoTest1.class, (Object)5L);
        AnnoTest1 pc2 = (AnnoTest1)em2.find(AnnoTest1.class, (Object)5L);
        TestVersion.assertEquals((int)1, (int)pc1.getVersion());
        TestVersion.assertEquals((int)1, (int)pc2.getVersion());
        TestVersion.assertEquals((int)0, (int)pc1.getTransient());
        pc1.setBasic(75);
        pc2.setBasic(75);
        em1.getTransaction().commit();
        em1.close();
        em1 = this.emf.createEntityManager();
        pc1 = (AnnoTest1)em1.find(AnnoTest1.class, (Object)5L);
        TestVersion.assertEquals((int)2, (int)pc1.getVersion());
        em1.close();
        try {
            em2.getTransaction().commit();
            TestVersion.fail((String)"Optimistic fail");
        }
        catch (Exception exception) {
        }
        finally {
            em2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVersionTimestamp() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        OpenJPAEntityManagerSPI em1 = this.emf.createEntityManager();
        em1.getTransaction().begin();
        OpenJPAEntityManagerSPI em2 = this.emf.createEntityManager();
        em2.getTransaction().begin();
        AnnoTest2 pc1 = (AnnoTest2)em1.find(AnnoTest2.class, (Object)new AnnoTest2.Oid(5L, "bar"));
        AnnoTest2 pc2 = (AnnoTest2)em2.find(AnnoTest2.class, (Object)new AnnoTest2.Oid(5L, "bar"));
        TestVersion.assertNotNull((Object)pc1.getVersion());
        TestVersion.assertEquals((Object)pc1.getVersion(), (Object)pc2.getVersion());
        pc1.setBasic("75");
        pc2.setBasic("75");
        em1.getTransaction().commit();
        em1.close();
        em1 = this.emf.createEntityManager();
        pc1 = (AnnoTest2)em1.find(AnnoTest2.class, (Object)new AnnoTest2.Oid(5L, "bar"));
        Date pc1Version = pc1.getVersion();
        Date pc2Version = pc2.getVersion();
        TestVersion.assertTrue((pc1Version.compareTo(pc2Version) > 0 ? 1 : 0) != 0);
        em1.close();
        try {
            em2.getTransaction().commit();
            TestVersion.fail((String)"Optimistic fail");
        }
        catch (Exception exception) {
        }
        finally {
            em2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVersionSubclass() {
        OpenJPAEntityManagerSPI em1 = this.emf.createEntityManager();
        em1.getTransaction().begin();
        OpenJPAEntityManagerSPI em2 = this.emf.createEntityManager();
        em2.getTransaction().begin();
        AnnoTest3 pc1 = (AnnoTest3)em1.find(AnnoTest3.class, (Object)3L);
        AnnoTest3 pc2 = (AnnoTest3)em2.find(AnnoTest3.class, (Object)3L);
        TestVersion.assertEquals((int)1, (int)pc1.getVersion());
        TestVersion.assertEquals((int)1, (int)pc2.getVersion());
        pc1.setBasic2(75);
        pc2.setBasic2(75);
        em1.getTransaction().commit();
        em1.close();
        em1 = this.emf.createEntityManager();
        pc1 = (AnnoTest3)em1.find(AnnoTest3.class, (Object)3L);
        TestVersion.assertEquals((int)2, (int)pc1.getVersion());
        em1.close();
        try {
            em2.getTransaction().commit();
            TestVersion.fail((String)"Optimistic fail");
        }
        catch (Exception exception) {
        }
        finally {
            em2.close();
        }
    }

    public void testVersionNoChange() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        AnnoTest1 pc = (AnnoTest1)em.find(AnnoTest1.class, (Object)5L);
        TestVersion.assertEquals((int)1, (int)pc.getVersion());
        TestVersion.assertEquals((int)0, (int)pc.getTransient());
        pc.setTransient(750);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        pc = (AnnoTest1)em.find(AnnoTest1.class, (Object)5L);
        TestVersion.assertEquals((int)1, (int)pc.getVersion());
        TestVersion.assertEquals((int)0, (int)pc.getTransient());
        em.close();
    }

    public void testNoDefaultVersionWithoutFieldOrColumn() {
        ClassMapping cls = ((JDBCConfiguration)this.emf.getConfiguration()).getMappingRepositoryInstance().getMapping(EmbedOwner.class, null, true);
        TestVersion.assertEquals((Object)NoneVersionStrategy.getInstance(), (Object)cls.getVersion().getStrategy());
        TestVersion.assertEquals((int)0, (int)cls.getVersion().getColumns().length);
    }

    public void testVersionWithField() {
        ClassMapping cls = ((JDBCConfiguration)this.emf.getConfiguration()).getMappingRepositoryInstance().getMapping(AnnoTest1.class, null, true);
        TestVersion.assertTrue((NoneVersionStrategy.getInstance() != cls.getVersion().getStrategy() ? 1 : 0) != 0);
        TestVersion.assertEquals((int)1, (int)cls.getVersion().getColumns().length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNullInitialVersion() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManagerSPI em2 = this.emf.createEntityManager();
        try {
            AnnoTest1 e = new AnnoTest1(System.currentTimeMillis());
            em.getTransaction().begin();
            em.persist((Object)e);
            em.createQuery("UPDATE AnnoTest1 a SET a.version=null where a.pk=:pk").setParameter("pk", (Object)e.getPk()).executeUpdate();
            em.getTransaction().commit();
            em.close();
            em = this.emf.createEntityManager();
            em.getTransaction().begin();
            em2.getTransaction().begin();
            AnnoTest1 e2 = (AnnoTest1)em2.find(AnnoTest1.class, (Object)e.getPk());
            e = (AnnoTest1)em.find(AnnoTest1.class, (Object)e.getPk());
            e.setBasic(1);
            em.getTransaction().commit();
            e2 = (AnnoTest1)em2.find(AnnoTest1.class, (Object)e.getPk());
            em2.refresh((Object)e2);
            System.out.println(e2.getBasic());
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }
}

