/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.annotations;

import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.strats.FullClassStrategy;
import org.apache.openjpa.jdbc.meta.strats.NoneDiscriminatorStrategy;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.annotations.EmbedOwner;
import org.apache.openjpa.persistence.jdbc.annotations.EmbedValue;
import org.apache.openjpa.persistence.jdbc.annotations.TablePerClass1;
import org.apache.openjpa.persistence.jdbc.annotations.TablePerClass2;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestTablePerClassInheritance
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(TablePerClass1.class, TablePerClass2.class, EmbedOwner.class, EmbedValue.class, CLEAR_TABLES);
    }

    public void testMapping() {
        ClassMapping mapping = ((JDBCConfiguration)this.emf.getConfiguration()).getMappingRepositoryInstance().getMapping(TablePerClass2.class, null, true);
        TestTablePerClassInheritance.assertTrue((boolean)(mapping.getStrategy() instanceof FullClassStrategy));
        TestTablePerClassInheritance.assertTrue((boolean)(mapping.getDiscriminator().getStrategy() instanceof NoneDiscriminatorStrategy));
        TestTablePerClassInheritance.assertNull((Object)mapping.getJoinForeignKey());
        TestTablePerClassInheritance.assertNull((Object)mapping.getJoinablePCSuperclassMapping());
        TestTablePerClassInheritance.assertEquals((String)"TPC_BASIC", (String)mapping.getFieldMapping("basic").getColumns()[0].getName());
        ClassMapping embed = mapping.getFieldMapping("embed").getEmbeddedMapping();
        TestTablePerClassInheritance.assertEquals((String)"TPC_EMB_BASIC", (String)embed.getFieldMapping("basic").getColumns()[0].getName());
        ClassMapping sup = mapping.getPCSuperclassMapping();
        TestTablePerClassInheritance.assertEquals(TablePerClass1.class, (Object)sup.getDescribedType());
        TestTablePerClassInheritance.assertTrue((boolean)(sup.getStrategy() instanceof FullClassStrategy));
        TestTablePerClassInheritance.assertTrue((boolean)(sup.getDiscriminator().getStrategy() instanceof NoneDiscriminatorStrategy));
        TestTablePerClassInheritance.assertEquals((String)"TPC_BASIC", (String)sup.getFieldMapping("basic").getColumns()[0].getName());
        embed = sup.getFieldMapping("embed").getEmbeddedMapping();
        TestTablePerClassInheritance.assertEquals((String)"TPC_EMB_BASIC", (String)embed.getFieldMapping("basic").getColumns()[0].getName());
    }

    public void testInsertAndRetrieve() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        TablePerClass1 tpc1 = new TablePerClass1();
        tpc1.setBasic(1);
        EmbedValue ev = new EmbedValue();
        ev.setBasic("11");
        tpc1.setEmbed(ev);
        TablePerClass2 tpc2 = new TablePerClass2();
        tpc2.setBasic(2);
        tpc2.setBasic2("2");
        ev = new EmbedValue();
        ev.setBasic("22");
        tpc2.setEmbed(ev);
        em.persistAll(new Object[]{tpc1, tpc2});
        em.getTransaction().commit();
        int id1 = tpc1.getPk();
        int id2 = tpc2.getPk();
        em.close();
        em = this.emf.createEntityManager();
        tpc1 = (TablePerClass1)em.find(TablePerClass1.class, (Object)id1);
        TestTablePerClassInheritance.assertEquals((int)1, (int)tpc1.getBasic());
        TestTablePerClassInheritance.assertEquals((String)"11", (String)tpc1.getEmbed().getBasic());
        tpc2 = (TablePerClass2)em.find(TablePerClass1.class, (Object)id2);
        TestTablePerClassInheritance.assertEquals((int)2, (int)tpc2.getBasic());
        TestTablePerClassInheritance.assertEquals((String)"2", (String)tpc2.getBasic2());
        TestTablePerClassInheritance.assertEquals((String)"22", (String)tpc2.getEmbed().getBasic());
        em.close();
    }
}

