/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.annotations;

import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.annotations.AnnoTest1;
import org.apache.openjpa.persistence.jdbc.annotations.AnnoTest2;
import org.apache.openjpa.persistence.jdbc.annotations.Flat1;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestSerializedLobs
extends SingleEMFTestCase {
    private static final Date DATE = new Date();

    @Override
    public void setUp() {
        this.setUp(AnnoTest1.class, AnnoTest2.class, Flat1.class, CLEAR_TABLES);
    }

    public void testSerialized() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        AnnoTest1 pc1 = new AnnoTest1(1L);
        AnnoTest1 pc2 = new AnnoTest1(2L);
        pc1.setSerialized("ASDASD");
        pc2.setSerialized(DATE);
        em.persist((Object)pc1);
        em.persist((Object)pc2);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        pc1 = (AnnoTest1)em.find(AnnoTest1.class, (Object)1L);
        pc2 = (AnnoTest1)em.find(AnnoTest1.class, (Object)2L);
        TestSerializedLobs.assertEquals((Object)"ASDASD", (Object)pc1.getSerialized());
        TestSerializedLobs.assertEquals((Object)DATE, (Object)pc2.getSerialized());
        em.close();
    }

    public void testBlob() throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        AnnoTest1 pc = new AnnoTest1(1L);
        pc.setBlob("Not Null".getBytes());
        em.persist((Object)pc);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        pc = (AnnoTest1)em.find(AnnoTest1.class, (Object)1L);
        TestSerializedLobs.assertEquals((String)"Not Null", (String)new String(pc.getBlob()));
        Connection conn = (Connection)em.getConnection();
        Statement stmnt = conn.createStatement();
        ResultSet rs = stmnt.executeQuery("SELECT BLOBVAL FROM ANNOTEST1 WHERE PK = 1");
        TestSerializedLobs.assertTrue((boolean)rs.next());
        JDBCConfiguration conf = (JDBCConfiguration)em.getConfiguration();
        DBDictionary dict = conf.getDBDictionaryInstance();
        if (dict.useGetBytesForBlobs) {
            rs.getBytes(1);
        } else if (dict.useGetObjectForBlobs) {
            rs.getObject(1);
        } else {
            Blob blob = rs.getBlob(1);
            blob.getBytes(1L, (int)blob.length());
        }
        TestSerializedLobs.assertEquals((String)"Not Null", (String)new String(pc.getBlob()));
        try {
            rs.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            stmnt.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        em.close();
    }

    public void testClob() throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        AnnoTest1 pc = new AnnoTest1(1L);
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < 1000; ++i) {
            buf.append((char)(97 + i % 24));
        }
        pc.setClob(buf.toString());
        em.persist((Object)pc);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        pc = (AnnoTest1)em.find(AnnoTest1.class, (Object)1L);
        String str = pc.getClob();
        TestSerializedLobs.assertEquals((int)1000, (int)str.length());
        for (int i = 0; i < str.length(); ++i) {
            TestSerializedLobs.assertEquals((int)(97 + i % 24), (int)str.charAt(i));
        }
        em.close();
    }

    public void testNullableClob() throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        AnnoTest1 pc = new AnnoTest1(1L);
        em.persist((Object)pc);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        pc = (AnnoTest1)em.find(AnnoTest1.class, (Object)1L);
        String str = pc.getClob();
        TestSerializedLobs.assertNull((Object)str);
        em.close();
    }

    public void testNullableBlob() throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        AnnoTest1 pc = new AnnoTest1(1L);
        em.persist((Object)pc);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        pc = (AnnoTest1)em.find(AnnoTest1.class, (Object)1L);
        byte[] bl = pc.getBlob();
        TestSerializedLobs.assertNull((Object)bl);
        em.close();
    }
}

