/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.annotations;

import java.lang.reflect.Array;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.strats.MultiColumnVersionStrategy;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.annotations.MultiColumnSecondaryVersionPC;
import org.apache.openjpa.persistence.jdbc.annotations.MultiColumnVersionPC;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestMultiColumnVersion
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(MultiColumnVersionPC.class, MultiColumnSecondaryVersionPC.class, CLEAR_TABLES);
    }

    public void testVersionStrategyIsSet() {
        this.assertStrategy(MultiColumnVersionPC.class);
        this.assertStrategy(MultiColumnSecondaryVersionPC.class);
    }

    public void assertStrategy(Class cls) {
        ClassMapping mapping = this.getMapping(cls);
        TestMultiColumnVersion.assertNotNull((Object)mapping.getVersion());
        TestMultiColumnVersion.assertTrue((boolean)(mapping.getVersion().getStrategy() instanceof MultiColumnVersionStrategy));
    }

    public void testVersionOnPersistAndUpdateForSingleTable() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        MultiColumnVersionPC pc = new MultiColumnVersionPC();
        TestMultiColumnVersion.assertEquals(null, (Object)em.getVersion((Object)pc));
        em.persist((Object)pc);
        em.getTransaction().commit();
        TestMultiColumnVersion.assertVersionEquals(new Number[]{1, 1, Float.valueOf(1.0f)}, em.getVersion((Object)pc));
        em.getTransaction().begin();
        pc.setName("updated");
        em.merge((Object)pc);
        em.getTransaction().commit();
        TestMultiColumnVersion.assertVersionEquals(new Number[]{2, 2, Float.valueOf(2.0f)}, em.getVersion((Object)pc));
        em.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentOptimisticUpdateFailsForSingleTable() {
        OpenJPAEntityManagerSPI em1 = this.emf.createEntityManager();
        em1.getTransaction().begin();
        OpenJPAEntityManagerSPI em2 = this.emf.createEntityManager();
        em2.getTransaction().begin();
        MultiColumnVersionPC pc1 = new MultiColumnVersionPC();
        em1.persist((Object)pc1);
        em1.getTransaction().commit();
        em1.getTransaction().begin();
        Object oid = em1.getObjectId((Object)pc1);
        MultiColumnVersionPC pc2 = (MultiColumnVersionPC)em2.find(MultiColumnVersionPC.class, oid);
        TestMultiColumnVersion.assertVersionEquals(em1.getVersion((Object)pc1), em2.getVersion((Object)pc2));
        pc1.setName("Updated in em1");
        pc2.setName("Updated in em2");
        em1.getTransaction().commit();
        em1.close();
        try {
            em2.getTransaction().commit();
            TestMultiColumnVersion.fail((String)"Optimistic fail");
        }
        catch (Exception exception) {
        }
        finally {
            em2.close();
        }
    }

    public void testConcurrentOptimisticReadSucceedsForSingleTable() {
        OpenJPAEntityManagerSPI em1 = this.emf.createEntityManager();
        em1.getTransaction().begin();
        OpenJPAEntityManagerSPI em2 = this.emf.createEntityManager();
        em2.getTransaction().begin();
        MultiColumnVersionPC pc1 = new MultiColumnVersionPC();
        em1.persist((Object)pc1);
        em1.getTransaction().commit();
        em1.getTransaction().begin();
        Object oid = em1.getObjectId((Object)pc1);
        MultiColumnVersionPC pc2 = (MultiColumnVersionPC)em2.find(MultiColumnVersionPC.class, oid);
        TestMultiColumnVersion.assertVersionEquals(em1.getVersion((Object)pc1), em2.getVersion((Object)pc2));
        em1.getTransaction().commit();
        em1.close();
        em2.getTransaction().commit();
        em2.close();
    }

    public void testVersionOnPersistAndUpdateForMultiTable() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        MultiColumnSecondaryVersionPC pc = new MultiColumnSecondaryVersionPC();
        TestMultiColumnVersion.assertEquals(null, (Object)em.getVersion((Object)pc));
        em.persist((Object)pc);
        em.getTransaction().commit();
        TestMultiColumnVersion.assertVersionEquals(new Number[]{1, 1, 1, 1}, em.getVersion((Object)pc));
        em.getTransaction().begin();
        pc.setName("updated");
        em.merge((Object)pc);
        em.getTransaction().commit();
        TestMultiColumnVersion.assertVersionEquals(new Number[]{2, 2, 2, 2}, em.getVersion((Object)pc));
        em.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentOptimisticUpdateFailsForMultiTable() {
        OpenJPAEntityManagerSPI em1 = this.emf.createEntityManager();
        em1.getTransaction().begin();
        OpenJPAEntityManagerSPI em2 = this.emf.createEntityManager();
        em2.getTransaction().begin();
        MultiColumnSecondaryVersionPC pc1 = new MultiColumnSecondaryVersionPC();
        em1.persist((Object)pc1);
        em1.getTransaction().commit();
        em1.getTransaction().begin();
        Object oid = em1.getObjectId((Object)pc1);
        MultiColumnSecondaryVersionPC pc2 = (MultiColumnSecondaryVersionPC)em2.find(MultiColumnSecondaryVersionPC.class, oid);
        TestMultiColumnVersion.assertVersionEquals(em1.getVersion((Object)pc1), em2.getVersion((Object)pc2));
        pc1.setName("Updated in em1");
        pc2.setName("Updated in em2");
        em1.getTransaction().commit();
        em1.close();
        try {
            em2.getTransaction().commit();
            TestMultiColumnVersion.fail((String)"Optimistic fail");
        }
        catch (Exception exception) {
        }
        finally {
            em2.close();
        }
    }

    public void testConcurrentOptimisticReadSucceedsForMultiTable() {
        OpenJPAEntityManagerSPI em1 = this.emf.createEntityManager();
        em1.getTransaction().begin();
        OpenJPAEntityManagerSPI em2 = this.emf.createEntityManager();
        em2.getTransaction().begin();
        MultiColumnSecondaryVersionPC pc1 = new MultiColumnSecondaryVersionPC();
        em1.persist((Object)pc1);
        em1.getTransaction().commit();
        em1.getTransaction().begin();
        Object oid = em1.getObjectId((Object)pc1);
        MultiColumnSecondaryVersionPC pc2 = (MultiColumnSecondaryVersionPC)em2.find(MultiColumnSecondaryVersionPC.class, oid);
        TestMultiColumnVersion.assertVersionEquals(em1.getVersion((Object)pc1), em2.getVersion((Object)pc2));
        em1.getTransaction().commit();
        em1.close();
        em2.getTransaction().commit();
        em2.close();
    }

    static void assertVersionEquals(Object expected, Object actual) {
        TestMultiColumnVersion.assertTrue((boolean)expected.getClass().isArray());
        TestMultiColumnVersion.assertTrue((boolean)actual.getClass().isArray());
        TestMultiColumnVersion.assertEquals((int)Array.getLength(expected), (int)Array.getLength(actual));
        int n = Array.getLength(expected);
        for (int i = 0; i < n; ++i) {
            Object v1 = Array.get(expected, i);
            Object v2 = Array.get(actual, i);
            TestMultiColumnVersion.assertTrue((String)("element " + i + " mismatch. Expeceted: " + v1 + " actual: " + v2), (Math.abs(((Number)v1).doubleValue() - ((Number)v2).doubleValue()) < 0.01 ? 1 : 0) != 0);
        }
    }
}

