/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.annotations;

import java.util.Set;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.annotations.AnnoTest1;
import org.apache.openjpa.persistence.jdbc.annotations.AnnoTest2;
import org.apache.openjpa.persistence.jdbc.annotations.Flat1;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestManyToMany
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(AnnoTest1.class, AnnoTest2.class, Flat1.class, CLEAR_TABLES);
    }

    public void testManyToMany() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        AnnoTest1 pc = new AnnoTest1(4L);
        em.persist((Object)pc);
        for (int i = 0; i < 3; ++i) {
            AnnoTest2 pc2 = new AnnoTest2(5 + i, "foo" + i);
            pc.getManyMany().add(pc2);
            em.persist((Object)pc2);
        }
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        pc = (AnnoTest1)em.find(AnnoTest1.class, (Object)4L);
        Set<AnnoTest2> many = pc.getManyMany();
        TestManyToMany.assertEquals((int)3, (int)many.size());
        block6: for (AnnoTest2 manyPc2 : many) {
            switch ((int)manyPc2.getPk1()) {
                case 5: {
                    TestManyToMany.assertEquals((String)"foo0", (String)manyPc2.getPk2());
                    continue block6;
                }
                case 6: {
                    TestManyToMany.assertEquals((String)"foo1", (String)manyPc2.getPk2());
                    continue block6;
                }
                case 7: {
                    TestManyToMany.assertEquals((String)"foo2", (String)manyPc2.getPk2());
                    continue block6;
                }
            }
            TestManyToMany.fail((String)("bad pk:" + manyPc2.getPk1()));
        }
        em.close();
    }

    public void testInverseOwnerManyToMany() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        AnnoTest1 pc = new AnnoTest1(4L);
        em.persist((Object)pc);
        for (int i = 0; i < 3; ++i) {
            AnnoTest2 pc2 = new AnnoTest2(5 + i, "foo" + i);
            pc2.getManyMany().add(pc);
            em.persist((Object)pc2);
        }
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        pc = (AnnoTest1)em.find(AnnoTest1.class, (Object)4L);
        Set<AnnoTest2> many = pc.getInverseOwnerManyMany();
        TestManyToMany.assertEquals((int)3, (int)many.size());
        block6: for (AnnoTest2 manyPc2 : many) {
            TestManyToMany.assertTrue((boolean)manyPc2.getManyMany().contains(pc));
            switch ((int)manyPc2.getPk1()) {
                case 5: {
                    TestManyToMany.assertEquals((String)"foo0", (String)manyPc2.getPk2());
                    continue block6;
                }
                case 6: {
                    TestManyToMany.assertEquals((String)"foo1", (String)manyPc2.getPk2());
                    continue block6;
                }
                case 7: {
                    TestManyToMany.assertEquals((String)"foo2", (String)manyPc2.getPk2());
                    continue block6;
                }
            }
            TestManyToMany.fail((String)("bad pk:" + manyPc2.getPk1()));
        }
        em.close();
    }
}

