/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.annotations;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.persistence.jdbc.annotations.EntityWithIndices;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;
import org.junit.Test;

public class TestIndices
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(EntityWithIndices.class, CLEAR_TABLES);
    }

    @Test
    public void testIndicesCreated() {
        JDBCConfiguration conf = (JDBCConfiguration)this.emf.getConfiguration();
        ClassMapping cls = conf.getMappingRepositoryInstance().getMapping(EntityWithIndices.class, null, true);
        Table table = cls.getTable();
        Index idx1 = table.getIndex(DBIdentifier.newIndex((String)"idx_index1"));
        TestIndices.assertNotNull((String)"Defined index should exist", (Object)idx1);
        TestIndices.assertFalse((boolean)idx1.isUnique());
        Index idx2 = table.getIndex(DBIdentifier.newIndex((String)"idx_long"));
        TestIndices.assertNotNull((String)"Defined index should exist", (Object)idx2);
        TestIndices.assertTrue((boolean)idx2.isUnique());
        HashSet<String> indexedCols = new HashSet<String>();
        for (Index idx : table.getIndexes()) {
            for (Column col : idx.getColumns()) {
                indexedCols.add(col.getIdentifier().getName());
            }
        }
        TestIndices.assertTrue((boolean)indexedCols.contains("INDEX1"));
        TestIndices.assertTrue((boolean)indexedCols.contains("LONG_NAME"));
        TestIndices.assertFalse((boolean)indexedCols.contains("NAME"));
        this.assertIndexColumns(table, "idx_wo_spaces", "INDEX1", "COL2", "COL3");
        this.assertIndexColumns(table, "idx_with_spaces", "LONG_NAME", "COL2", "COL3");
    }

    private void assertIndexColumns(Table table, String indexName, String ... assertedColumnNames) {
        Index idx = table.getIndex(DBIdentifier.newIndex((String)indexName));
        TestIndices.assertNotNull((String)"Defined index should exist", (Object)idx);
        List indexColumnNames = Arrays.stream(idx.getColumns()).map(c -> c.getIdentifier().getName()).collect(Collectors.toList());
        for (String assertedColumnName : assertedColumnNames) {
            TestIndices.assertTrue((String)("Column " + assertedColumnName + " does not exist in index " + indexName), (boolean)indexColumnNames.contains(assertedColumnName));
        }
    }
}

