/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.annotations;

import javax.persistence.Query;
import org.apache.openjpa.enhance.ClassRedefiner;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.annotations.Generator;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestGenerators
extends SingleEMFTestCase {
    Log _log;

    @Override
    public void setUp() throws Exception {
        this.setUp(Generator.class, CLEAR_TABLES);
        this._log = this.emf.getConfiguration().getLog("openjpa.Runtime");
    }

    public void testGet() {
        if (!PersistenceCapable.class.isAssignableFrom(Generator.class) && !ClassRedefiner.canRedefineClasses((Log)this._log)) {
            TestGenerators.fail((String)"This test requires a higher level of enhancement than is available in the current environment.");
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Generator g = new Generator();
        g.setPk(5);
        em.persist((Object)g);
        this.assertPks(g);
        em.getTransaction().commit();
        em.close();
        this.assertNew();
    }

    public void testFlush() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Generator g = new Generator();
        g.setPk(5);
        em.persist((Object)g);
        em.flush();
        this.assertPks(g);
        em.getTransaction().commit();
        em.close();
        this.assertNew();
    }

    public void testCommit() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Generator g = new Generator();
        g.setPk(5);
        em.persist((Object)g);
        em.getTransaction().commit();
        em.close();
        this.assertNew();
    }

    private void assertNew() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query q = em.createQuery("select g from Generator g where g.stringField = 'foo'");
        for (Object o : q.getResultList()) {
            this.assertPks((Generator)o);
        }
        em.close();
    }

    private void assertPks(Generator g) {
        TestGenerators.assertNotEquals(0, g.getPk());
        TestGenerators.assertNotNull((Object)g.getPk2());
        TestGenerators.assertNotEquals(0, g);
        TestGenerators.assertNotEquals(0, g.getPk3());
    }
}

