/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.annotations;

import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.meta.FetchGroup;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.persistence.jdbc.annotations.ExtensionsEntity;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestExtensionAnnotations
extends SingleEMFTestCase {
    private ClassMapping _mapping;

    @Override
    public void setUp() {
        this.setUp(ExtensionsEntity.class);
        this._mapping = ((JDBCConfiguration)this.emf.getConfiguration()).getMappingRepositoryInstance().getMapping(ExtensionsEntity.class, null, true);
    }

    public void testDataStoreId() {
        TestExtensionAnnotations.assertEquals((int)1, (int)this._mapping.getIdentityType());
        TestExtensionAnnotations.assertEquals((int)2, (int)this._mapping.getIdentityStrategy());
        TestExtensionAnnotations.assertEquals((String)"system", (String)this._mapping.getIdentitySequenceName());
    }

    public void testDataCache() {
        TestExtensionAnnotations.assertNull((Object)this._mapping.getDataCacheName());
    }

    public void testFetchGroups() {
        FetchGroup fg = this._mapping.getFetchGroup("detail");
        TestExtensionAnnotations.assertNotNull((Object)fg);
        TestExtensionAnnotations.assertFalse((boolean)fg.isPostLoad());
        FieldMapping fm = this._mapping.getFieldMapping("rel");
        TestExtensionAnnotations.assertEquals((int)1, (int)fm.getCustomFetchGroups().length);
        TestExtensionAnnotations.assertEquals((String)"detail", (String)fm.getCustomFetchGroups()[0]);
        TestExtensionAnnotations.assertEquals((int)-1, (int)fg.getRecursionDepth((FieldMetaData)fm));
        fm = this._mapping.getFieldMapping("seq");
        TestExtensionAnnotations.assertEquals((int)1, (int)fm.getCustomFetchGroups().length);
        TestExtensionAnnotations.assertEquals((String)"detail", (String)fm.getCustomFetchGroups()[0]);
        TestExtensionAnnotations.assertEquals((int)1, (int)fg.getRecursionDepth((FieldMetaData)fm));
    }

    public void testValueStrategy() {
        TestExtensionAnnotations.assertEquals((int)6, (int)this._mapping.getField("uuid").getValueStrategy());
        TestExtensionAnnotations.assertEquals((int)5, (int)this._mapping.getField("uuidString").getValueStrategy());
        TestExtensionAnnotations.assertEquals((int)8, (int)this._mapping.getField("uuidT4Hex").getValueStrategy());
        TestExtensionAnnotations.assertEquals((int)7, (int)this._mapping.getField("uuidT4String").getValueStrategy());
        FieldMapping seq = this._mapping.getFieldMapping("seq");
        TestExtensionAnnotations.assertEquals((int)2, (int)seq.getValueStrategy());
        TestExtensionAnnotations.assertEquals((String)"system", (String)seq.getValueSequenceName());
    }

    public void testReadOnly() {
        TestExtensionAnnotations.assertEquals((int)2, (int)this._mapping.getField("seq").getUpdateStrategy());
    }

    public void testInverseLogical() {
        TestExtensionAnnotations.assertEquals((String)"owner", (String)this._mapping.getField("rel").getInverse());
        TestExtensionAnnotations.assertNull((Object)this._mapping.getField("owner").getInverse());
    }

    public void testDependent() {
        TestExtensionAnnotations.assertEquals((int)2, (int)this._mapping.getField("rel").getCascadeDelete());
        TestExtensionAnnotations.assertEquals((int)0, (int)this._mapping.getField("eager").getCascadeDelete());
        TestExtensionAnnotations.assertEquals((int)2, (int)this._mapping.getField("eager").getElement().getCascadeDelete());
    }

    public void testLRS() {
        TestExtensionAnnotations.assertTrue((boolean)this._mapping.getField("lrs").isLRS());
        TestExtensionAnnotations.assertFalse((boolean)this._mapping.getField("eager").isLRS());
    }

    public void testClassCriteria() {
        TestExtensionAnnotations.assertTrue((boolean)this._mapping.getFieldMapping("eager").getElementMapping().getUseClassCriteria());
        TestExtensionAnnotations.assertFalse((boolean)this._mapping.getFieldMapping("eager").getUseClassCriteria());
        TestExtensionAnnotations.assertFalse((boolean)this._mapping.getFieldMapping("lrs").getElementMapping().getUseClassCriteria());
    }

    public void testExternalValues() {
        FieldMapping externalValues = this._mapping.getFieldMapping("externalValues");
        TestExtensionAnnotations.assertEquals((int)2, (int)externalValues.getDeclaredTypeCode());
        TestExtensionAnnotations.assertEquals((int)5, (int)externalValues.getTypeCode());
        TestExtensionAnnotations.assertEquals((Object)1, externalValues.getExternalValueMap().get(Character.valueOf('M')));
        TestExtensionAnnotations.assertEquals((Object)2, externalValues.getExternalValueMap().get(Character.valueOf('F')));
    }

    public void testExternalizer() {
        FieldMapping externalizer = this._mapping.getFieldMapping("externalizer");
        TestExtensionAnnotations.assertEquals((int)8, (int)externalizer.getDeclaredTypeCode());
        TestExtensionAnnotations.assertEquals((int)9, (int)externalizer.getTypeCode());
        TestExtensionAnnotations.assertEquals((Object)"java.lang.String", (Object)externalizer.getExternalValue(String.class, null));
        TestExtensionAnnotations.assertEquals(String.class, (Object)externalizer.getFieldValue((Object)String.class.getName(), null));
    }
}

