/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.annotations;

import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.jdbc.annotations.EmbeddedIdClass;
import org.apache.openjpa.persistence.jdbc.annotations.EmbeddedIdEntity;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestEmbeddedId
extends SingleEMFTestCase {
    EmbeddedIdClass _oid;
    EmbeddedIdClass _roid;

    @Override
    public void setUp() {
        this.setUp(EmbeddedIdEntity.class, EmbeddedIdClass.class, CLEAR_TABLES);
        this._oid = new EmbeddedIdClass();
        this._oid.setPk1(1L);
        this._oid.setPk2(2L);
        EmbeddedIdEntity e = new EmbeddedIdEntity();
        e.setId(this._oid);
        e.setValue("e");
        this._roid = new EmbeddedIdClass();
        this._roid.setPk1(2L);
        this._roid.setPk2(3L);
        EmbeddedIdEntity rel = new EmbeddedIdEntity();
        rel.setId(this._roid);
        rel.setValue("r");
        e.setRelation(rel);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persistAll(new Object[]{e, rel});
        em.getTransaction().commit();
        em.close();
    }

    public void testGetObjectId() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EmbeddedIdEntity e = (EmbeddedIdEntity)em.find(EmbeddedIdEntity.class, (Object)this._oid);
        TestEmbeddedId.assertNotNull((Object)e);
        TestEmbeddedId.assertEquals((String)"e", (String)e.getValue());
        TestEmbeddedId.assertNull((Object)e.getMappingOverrideRelation());
        TestEmbeddedId.assertNotNull((Object)e.getRelation());
        TestEmbeddedId.assertEquals((String)"r", (String)e.getRelation().getValue());
        TestEmbeddedId.assertEquals((Object)this._oid, (Object)em.getObjectId((Object)e));
        TestEmbeddedId.assertEquals((Object)this._roid, (Object)em.getObjectId((Object)e.getRelation()));
        TestEmbeddedId.assertEquals((Object)this._oid, (Object)e.getId());
        TestEmbeddedId.assertEquals((Object)this._roid, (Object)e.getRelation().getId());
        TestEmbeddedId.assertNull((Object)((PersistenceCapable)e.getId()).pcGetGenericContext());
        em.close();
    }

    public void testMutateEmbeddedIdFieldValueOfNew() {
        EmbeddedIdEntity e1 = new EmbeddedIdEntity();
        e1.setValue("e1");
        EmbeddedIdEntity e2 = new EmbeddedIdEntity();
        e2.setValue("e2");
        EmbeddedIdClass id = new EmbeddedIdClass();
        e2.setId(id);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persistAll(new Object[]{e1, e2});
        EmbeddedIdClass oid = new EmbeddedIdClass();
        oid.setPk1(4L);
        oid.setPk2(5L);
        e1.setId(oid);
        e2.getId().setPk1(6L);
        e2.getId().setPk2(7L);
        em.getTransaction().commit();
        EmbeddedIdClass oid1 = e1.getId();
        TestEmbeddedId.assertEquals((Object)oid1, (Object)em.getObjectId((Object)e1));
        TestEmbeddedId.assertEquals((long)4L, (long)oid1.getPk1());
        TestEmbeddedId.assertEquals((long)5L, (long)oid1.getPk2());
        EmbeddedIdClass oid2 = e2.getId();
        TestEmbeddedId.assertEquals((long)6L, (long)oid2.getPk1());
        TestEmbeddedId.assertEquals((long)7L, (long)oid2.getPk2());
        em.close();
        em = this.emf.createEntityManager();
        e1 = (EmbeddedIdEntity)em.find(EmbeddedIdEntity.class, (Object)oid1);
        e2 = (EmbeddedIdEntity)em.find(EmbeddedIdEntity.class, (Object)oid2);
        TestEmbeddedId.assertEquals((Object)oid1, (Object)em.getObjectId((Object)e1));
        TestEmbeddedId.assertEquals((Object)oid2, (Object)em.getObjectId((Object)e2));
        TestEmbeddedId.assertEquals((Object)oid1, (Object)e1.getId());
        TestEmbeddedId.assertEquals((Object)oid2, (Object)e2.getId());
        em.close();
    }

    public void testMutateEmbeddedIdFieldValueOfExisting() {
        OpenJPAEntityManagerSPI em;
        block2: {
            em = this.emf.createEntityManager();
            em.getTransaction().begin();
            EmbeddedIdEntity e = (EmbeddedIdEntity)em.find(EmbeddedIdEntity.class, (Object)this._oid);
            e.setValue("changed");
            try {
                e.getId().setPk1(9L);
                em.getTransaction().commit();
                TestEmbeddedId.fail((String)"Committed with changed oid field.");
            }
            catch (RuntimeException re) {
                if (!em.getTransaction().isActive()) break block2;
                em.getTransaction().rollback();
            }
        }
        em.close();
    }

    public void testDetachAttach() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EmbeddedIdEntity e = (EmbeddedIdEntity)em.find(EmbeddedIdEntity.class, (Object)this._oid);
        e.getRelation();
        em.close();
        e.setValue("echanged");
        e.getRelation().setValue("rchanged");
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        EmbeddedIdEntity me = (EmbeddedIdEntity)em.mergeAll(new Object[]{e, e.getRelation()})[0];
        TestEmbeddedId.assertTrue((me != e ? 1 : 0) != 0);
        TestEmbeddedId.assertNotNull((Object)me.getRelation());
        TestEmbeddedId.assertTrue((me.getRelation() != e.getRelation() ? 1 : 0) != 0);
        TestEmbeddedId.assertEquals((String)"echanged", (String)me.getValue());
        TestEmbeddedId.assertEquals((String)"rchanged", (String)me.getRelation().getValue());
        TestEmbeddedId.assertEquals((Object)this._oid, (Object)me.getId());
        TestEmbeddedId.assertEquals((Object)this._oid, (Object)em.getObjectId((Object)me));
        TestEmbeddedId.assertEquals((Object)this._roid, (Object)me.getRelation().getId());
        TestEmbeddedId.assertEquals((Object)this._roid, (Object)em.getObjectId((Object)me.getRelation()));
        em.getTransaction().commit();
        em.close();
    }

    public void testQuery() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAQuery q = em.createQuery("select e from EmbeddedIdEntity e where e.id.pk1 = 1");
        EmbeddedIdEntity e = (EmbeddedIdEntity)q.getSingleResult();
        TestEmbeddedId.assertEquals((Object)this._oid, (Object)e.getId());
        TestEmbeddedId.assertEquals((String)"e", (String)e.getValue());
        q = em.createQuery("select e.id.pk2 from EmbeddedIdEntity e where e.id.pk1 = 1");
        TestEmbeddedId.assertEquals((Object)this._oid.getPk2(), (Object)q.getSingleResult());
        q = em.createQuery("select e.id from EmbeddedIdEntity e where e.id.pk1 = 1");
        TestEmbeddedId.assertEquals((Object)this._oid, (Object)q.getSingleResult());
        em.close();
    }

    public void testAutoAssigned() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        EmbeddedIdEntity e = new EmbeddedIdEntity();
        em.persist((Object)e);
        EmbeddedIdClass oid = e.getId();
        TestEmbeddedId.assertNotNull((Object)oid);
        TestEmbeddedId.assertTrue((oid.getPk3() != 0L ? 1 : 0) != 0);
        TestEmbeddedId.assertEquals((Object)oid, (Object)em.getObjectId((Object)e));
        em.getTransaction().commit();
        TestEmbeddedId.assertEquals((Object)oid, (Object)em.getObjectId((Object)e));
        em.close();
        em = this.emf.createEntityManager();
        e = (EmbeddedIdEntity)em.find(EmbeddedIdEntity.class, (Object)oid);
        TestEmbeddedId.assertEquals((Object)oid, (Object)em.getObjectId((Object)e));
        em.close();
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        e = new EmbeddedIdEntity();
        oid = new EmbeddedIdClass();
        oid.setPk1(4L);
        oid.setPk2(5L);
        e.setId(oid);
        em.persist((Object)e);
        oid = e.getId();
        TestEmbeddedId.assertEquals((long)4L, (long)oid.getPk1());
        TestEmbeddedId.assertEquals((long)5L, (long)oid.getPk2());
        TestEmbeddedId.assertTrue((oid.getPk3() != 0L ? 1 : 0) != 0);
        TestEmbeddedId.assertEquals((Object)oid, (Object)em.getObjectId((Object)e));
        em.getTransaction().commit();
        TestEmbeddedId.assertEquals((Object)oid, (Object)em.getObjectId((Object)e));
        em.close();
        em = this.emf.createEntityManager();
        e = (EmbeddedIdEntity)em.find(EmbeddedIdEntity.class, (Object)oid);
        TestEmbeddedId.assertEquals((Object)oid, (Object)em.getObjectId((Object)e));
        em.close();
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        e = new EmbeddedIdEntity();
        em.persist((Object)e);
        em.getTransaction().commit();
        oid = e.getId();
        TestEmbeddedId.assertTrue((oid.getPk3() != 0L ? 1 : 0) != 0);
        TestEmbeddedId.assertEquals((Object)oid, (Object)em.getObjectId((Object)e));
        em.close();
        em = this.emf.createEntityManager();
        e = (EmbeddedIdEntity)em.find(EmbeddedIdEntity.class, (Object)oid);
        TestEmbeddedId.assertEquals((Object)oid, (Object)em.getObjectId((Object)e));
        em.close();
    }
}

