/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc;

import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DB2Dictionary;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.HSQLDictionary;
import org.apache.openjpa.persistence.InvalidStateException;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.jdbc.IsolationLevel;
import org.apache.openjpa.persistence.jdbc.JDBCFetchPlan;
import org.apache.openjpa.persistence.simple.AllFieldTypes;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestIsolationLevelOverride
extends SQLListenerTestCase {
    @Override
    public void setUp() {
        this.setUp(AllFieldTypes.class, "openjpa.Optimistic", "false", "openjpa.LockManager", "pessimistic");
    }

    public void testIsolationOverrideViaFetchPlan() {
        this.testIsolationLevelOverride(false, false);
    }

    public void testIsolationOverrideViaHint() {
        this.testIsolationLevelOverride(true, false);
    }

    public void testIsolationOverrideViaStringHint() {
        this.testIsolationLevelOverride(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsolationLevelOverride(boolean useHintsAndQueries, boolean useStringHints) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        DBDictionary dict = ((JDBCConfiguration)em.getConfiguration()).getDBDictionaryInstance();
        if (dict instanceof HSQLDictionary) {
            return;
        }
        this.sql.clear();
        try {
            em.getTransaction().begin();
            if (useHintsAndQueries) {
                OpenJPAQuery q = em.createQuery("select o from AllFieldTypes o where o.intField = :p");
                q.setParameter("p", (Object)0);
                if (useStringHints) {
                    q.setHint("openjpa.FetchPlan.Isolation", (Object)"SERIALIZABLE");
                } else {
                    q.setHint("openjpa.FetchPlan.Isolation", (Object)IsolationLevel.SERIALIZABLE);
                }
                TestIsolationLevelOverride.assertEquals((Object)IsolationLevel.SERIALIZABLE, (Object)((JDBCFetchPlan)q.getFetchPlan()).getIsolation());
                q.getResultList();
                if (dict instanceof DB2Dictionary) {
                    int db2server = ((DB2Dictionary)dict).getDb2ServerType();
                    if (db2server == 1 || db2server == 2) {
                        TestIsolationLevelOverride.assertEquals((int)1, (int)this.sql.size());
                        this.assertContainsSQL(" FOR UPDATE");
                    } else if (db2server == 3 || db2server == 4) {
                        TestIsolationLevelOverride.assertEquals((int)1, (int)this.sql.size());
                        this.assertContainsSQL(" FOR READ ONLY WITH RR USE AND KEEP UPDATE LOCKS");
                    } else if (db2server == 5) {
                        TestIsolationLevelOverride.assertEquals((int)1, (int)this.sql.size());
                        this.assertContainsSQL(" FOR READ ONLY WITH RR USE AND KEEP EXCLUSIVE LOCKS");
                    } else {
                        TestIsolationLevelOverride.fail((String)"OpenJPA currently only supports per-query isolation level configuration on the following databases: DB2");
                    }
                }
            } else {
                ((JDBCFetchPlan)em.getFetchPlan()).setIsolation(IsolationLevel.SERIALIZABLE);
                em.find(AllFieldTypes.class, (Object)0);
                if (dict instanceof DB2Dictionary) {
                    int db2server = ((DB2Dictionary)dict).getDb2ServerType();
                    if (db2server == 1 || db2server == 2) {
                        TestIsolationLevelOverride.assertEquals((int)1, (int)this.sql.size());
                        this.assertContainsSQL(" optimize for 1 row FOR UPDATE");
                    } else if (db2server == 3 || db2server == 4) {
                        TestIsolationLevelOverride.assertEquals((int)1, (int)this.sql.size());
                        this.assertContainsSQL(" optimize for 1 row FOR READ ONLY WITH RR USE AND KEEP UPDATE LOCKS");
                    } else if (db2server == 5) {
                        TestIsolationLevelOverride.assertEquals((int)1, (int)this.sql.size());
                        this.assertContainsSQL(" optimize for 1 row FOR READ ONLY WITH RR USE AND KEEP EXCLUSIVE LOCKS");
                    } else {
                        TestIsolationLevelOverride.fail((String)"OpenJPA currently only supports per-query isolation level configuration on the following databases: DB2");
                    }
                }
            }
        }
        catch (InvalidStateException pe) {
            if (dict instanceof DB2Dictionary) {
                throw pe;
            }
        }
        finally {
            em.getTransaction().rollback();
            em.close();
        }
    }
}

