/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc;

import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DB2Dictionary;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.simple.AllFieldTypes;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestIsolationFecthHint
extends SQLListenerTestCase {
    @Override
    public void setUp() {
        this.setUp(AllFieldTypes.class, CLEAR_TABLES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFetchPlanIsolationURHint() {
        try (OpenJPAEntityManagerSPI em = this.emf.createEntityManager();){
            DBDictionary dict = ((JDBCConfiguration)em.getConfiguration()).getDBDictionaryInstance();
            if (dict instanceof DB2Dictionary) {
                AllFieldTypes allFieldTypes = new AllFieldTypes();
                allFieldTypes.setStringField("testString");
                allFieldTypes.setIntField(2012);
                em.getTransaction().begin();
                em.persist((Object)allFieldTypes);
                OpenJPAQuery query = em.createQuery("select e from AllFieldTypes e where e.stringField = ?1");
                query.setParameter(1, (Object)"testString");
                query.setHint("openjpa.FetchPlan.Isolation", (Object)"READ_UNCOMMITTED");
                TestIsolationFecthHint.assertEquals((int)1, (int)query.getResultList().size());
                this.assertContainsSQL("FOR READ ONLY WITH UR");
                em.getTransaction().rollback();
            }
        }
    }
}

