/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.inheritance.polymorphic;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.inheritance.polymorphic.BaseEntity;
import org.apache.openjpa.persistence.inheritance.polymorphic.EnglishParagraph;
import org.apache.openjpa.persistence.inheritance.polymorphic.FrenchParagraph;
import org.apache.openjpa.persistence.inheritance.polymorphic.GermanParagraph;
import org.apache.openjpa.persistence.inheritance.polymorphic.Translatable;
import org.apache.openjpa.persistence.inheritance.polymorphic.Translation;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestTablePerClassInheritanceWithAbstractRoot
extends SingleEMFTestCase {
    Class<?>[] UNJOINED_SUBCLASSES = new Class[]{EnglishParagraph.class, FrenchParagraph.class, GermanParagraph.class};

    @Override
    public void setUp() {
        this.setUp(CLEAR_TABLES, Translation.class, BaseEntity.class, EnglishParagraph.class, FrenchParagraph.class, GermanParagraph.class, Translatable.class);
    }

    public void populate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        EnglishParagraph english = new EnglishParagraph();
        FrenchParagraph french = new FrenchParagraph();
        GermanParagraph german = new GermanParagraph();
        Translation translation1 = new Translation();
        Translation translation2 = new Translation();
        Translation translation3 = new Translation();
        Translation translation4 = new Translation();
        english.setContent("Hello");
        french.setContent("Bon jour");
        german.setContent("Guten Tag");
        translation1.setTranslatable(english);
        translation2.setTranslatable(english);
        translation3.setTranslatable(french);
        translation4.setTranslatable(german);
        english.addTranslation(translation1);
        english.addTranslation(translation2);
        french.addTranslation(translation3);
        german.addTranslation(translation4);
        em.persist((Object)translation1);
        em.persist((Object)translation2);
        em.persist((Object)translation3);
        em.persist((Object)translation4);
        em.getTransaction().commit();
        em.close();
    }

    public void testConsistency() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        int nTranslatableBefore = this.count(this.UNJOINED_SUBCLASSES);
        int nTranslationBefore = this.count((Class)Translation.class);
        this.populate();
        int nTranslatableAfter = this.count(this.UNJOINED_SUBCLASSES);
        int nTranslationAfter = this.count((Class)Translation.class);
        TestTablePerClassInheritanceWithAbstractRoot.assertEquals((int)(nTranslatableBefore + 3), (int)nTranslatableAfter);
        TestTablePerClassInheritanceWithAbstractRoot.assertEquals((int)(nTranslationBefore + 4), (int)nTranslationAfter);
        em.getTransaction().begin();
        List result = em.createQuery("SELECT p FROM Translation p").getResultList();
        TestTablePerClassInheritanceWithAbstractRoot.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
        for (Translation translation : result) {
            TestTablePerClassInheritanceWithAbstractRoot.assertTrue((boolean)translation.getTranslatable().getTranslations().contains(translation));
        }
        em.getTransaction().rollback();
        em.close();
    }

    void linkConsistently(Translation translation, Translatable translatable) {
        translatable.addTranslation(translation);
        translation.setTranslatable(translatable);
    }

    public int count(Class c) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Integer n = ((Number)em.createQuery("SELECT COUNT(p) FROM " + c.getSimpleName() + " p").getSingleResult()).intValue();
        this.closeEM((EntityManager)em);
        return n;
    }

    public int count(Class<?> ... classes) {
        int total = 0;
        for (Class<?> c : classes) {
            total += this.count((Class)c);
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEntityTypeForTablePerClassInheritance() {
        this.populate();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String query = "select tr from Translatable tr join tr.translations t where TYPE(tr) = EnglishParagraph";
        List rs = em.createQuery(query).getResultList();
        TestTablePerClassInheritanceWithAbstractRoot.assertEquals((int)2, (int)rs.size());
        for (Object o : rs) {
            TestTablePerClassInheritanceWithAbstractRoot.assertTrue((boolean)(o instanceof EnglishParagraph));
        }
        query = "select distinct tr from Translatable tr join tr.translations t where TYPE(tr) = EnglishParagraph or TYPE(tr) = FrenchParagraph";
        rs = em.createQuery(query).getResultList();
        TestTablePerClassInheritanceWithAbstractRoot.assertEquals((int)2, (int)rs.size());
        for (Object r : rs) {
            TestTablePerClassInheritanceWithAbstractRoot.assertTrue((!(r instanceof GermanParagraph) ? 1 : 0) != 0);
        }
        query = "select distinct tr from Translatable tr join tr.translations t where TYPE(tr) in (?1, ?2)";
        try {
            rs = em.createQuery(query).setParameter(1, EnglishParagraph.class).setParameter(2, FrenchParagraph.class).getResultList();
        }
        catch (ArgumentException argumentException) {
            // empty catch block
        }
        query = "select tr from Translatable tr join tr.translations t where TYPE(tr) <> EnglishParagraph";
        try {
            rs = em.createQuery(query).getResultList();
        }
        catch (ArgumentException argumentException) {
            // empty catch block
        }
        String query1 = "select t from Translation t where TYPE(t.translatable) = EnglishParagraph";
        try {
            rs = em.createQuery(query1).getResultList();
        }
        catch (ArgumentException r) {
            // empty catch block
        }
        query1 = "select tr from Translatable tr join tr.translations t where TYPE(tr) in ?1";
        ArrayList<Class> params = new ArrayList<Class>(2);
        params.add(EnglishParagraph.class);
        params.add(FrenchParagraph.class);
        try {
            rs = em.createQuery(query).setParameter(1, params).getResultList();
        }
        catch (ArgumentException argumentException) {
        }
        finally {
            em.close();
        }
    }
}

