/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.inheritance.polymorphic;

import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.Version;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;
import org.apache.openjpa.util.UserException;

@MappedSuperclass
public abstract class BaseEntity
implements PersistenceCapable {
    @Id
    @GeneratedValue
    private long id;
    @Version
    private long version;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient boolean pcVersionInit;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Lorg$apache$openjpa$persistence$inheritance$polymorphic$BaseEntity;
    private transient Object pcDetachedState;

    public long getId() {
        return BaseEntity.pcGetid(this);
    }

    public long getVersion() {
        return BaseEntity.pcGetversion(this);
    }

    public int pcGetEnhancementContractVersion() {
        return 196634845;
    }

    static {
        pcFieldNames = new String[]{"id", "version"};
        Class[] classArray = new Class[2];
        classArray[0] = Long.TYPE;
        classArray[1] = Long.TYPE;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 21};
        Class clazz = class$Lorg$apache$openjpa$persistence$inheritance$polymorphic$BaseEntity != null ? class$Lorg$apache$openjpa$persistence$inheritance$polymorphic$BaseEntity : (class$Lorg$apache$openjpa$persistence$inheritance$polymorphic$BaseEntity = BaseEntity.class$("org.apache.openjpa.persistence.inheritance.polymorphic.BaseEntity"));
        PCRegistry.register((Class)clazz, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"BaseEntity", null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.id = 0L;
        this.version = 0L;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        throw new UserException();
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        throw new UserException();
    }

    protected static int pcGetManagedFieldCount() {
        return 2;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.id = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.version = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                this.pcVersionInit = true;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.id);
                return;
            }
            case 1: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.version);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(BaseEntity baseEntity, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.id = baseEntity.id;
                return;
            }
            case 1: {
                this.version = baseEntity.version;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        BaseEntity baseEntity = (BaseEntity)object;
        if (baseEntity.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(baseEntity, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return new Long(this.version);
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        LongId longId = (LongId)object;
        fieldConsumer.storeLongField(0 + pcInheritedFieldCount, longId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        LongId longId = (LongId)object;
        this.id = longId.getId();
    }

    public Class pcGetIDOwningClass() {
        Class clazz = class$Lorg$apache$openjpa$persistence$inheritance$polymorphic$BaseEntity != null ? class$Lorg$apache$openjpa$persistence$inheritance$polymorphic$BaseEntity : (class$Lorg$apache$openjpa$persistence$inheritance$polymorphic$BaseEntity = BaseEntity.class$("org.apache.openjpa.persistence.inheritance.polymorphic.BaseEntity"));
        return clazz;
    }

    public Object pcNewObjectIdInstance(Object object) {
        return new LongId(this.pcGetIDOwningClass(), (String)object);
    }

    public Object pcNewObjectIdInstance() {
        return new LongId(this.pcGetIDOwningClass(), this.id);
    }

    private static final long pcGetid(BaseEntity baseEntity) {
        if (baseEntity.pcStateManager == null) {
            return baseEntity.id;
        }
        int n = pcInheritedFieldCount + 0;
        baseEntity.pcStateManager.accessingField(n);
        return baseEntity.id;
    }

    private static final void pcSetid(BaseEntity baseEntity, long l) {
        if (baseEntity.pcStateManager == null) {
            baseEntity.id = l;
            return;
        }
        baseEntity.pcStateManager.settingLongField((PersistenceCapable)baseEntity, pcInheritedFieldCount + 0, baseEntity.id, l, 0);
    }

    private static final long pcGetversion(BaseEntity baseEntity) {
        if (baseEntity.pcStateManager == null) {
            return baseEntity.version;
        }
        int n = pcInheritedFieldCount + 1;
        baseEntity.pcStateManager.accessingField(n);
        return baseEntity.version;
    }

    private static final void pcSetversion(BaseEntity baseEntity, long l) {
        if (baseEntity.pcStateManager == null) {
            baseEntity.version = l;
            baseEntity.pcVersionInit = true;
            return;
        }
        baseEntity.pcStateManager.settingLongField((PersistenceCapable)baseEntity, pcInheritedFieldCount + 1, baseEntity.version, l, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.version != 0L) {
            return Boolean.TRUE;
        }
        if (this.pcVersionInit) {
            return Boolean.TRUE;
        }
        return null;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

