/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.inheritance.mappedsuperclass;

import java.util.List;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.inheritance.mappedsuperclass.CashBaseEntity;
import org.apache.openjpa.persistence.inheritance.mappedsuperclass.DerivedEntityFromMappedSuperWithoutId;
import org.apache.openjpa.persistence.inheritance.mappedsuperclass.MappedSuperWithoutId;
import org.apache.openjpa.persistence.inheritance.mappedsuperclass.SituationDA;
import org.apache.openjpa.persistence.inheritance.mappedsuperclass.ValuableItemDA;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestMappedSuperClass
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(CashBaseEntity.class, SituationDA.class, ValuableItemDA.class, MappedSuperWithoutId.class, DerivedEntityFromMappedSuperWithoutId.class, CLEAR_TABLES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMappedSuperClass() {
        int i;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        for (i = 0; i < 3; ++i) {
            SituationDA s = new SituationDA();
            s.setCashBoxPeriodSerial("test");
            s.setType((short)(i + 1));
            em.persist((Object)s);
        }
        for (i = 0; i < 3; ++i) {
            ValuableItemDA v = new ValuableItemDA();
            v.setCode((short)(10 + i));
            em.persist((Object)v);
        }
        em.getTransaction().commit();
        em.clear();
        String query = "select s from CashBaseEntity s where TYPE(s) = SituationDA";
        List rs = em.createQuery(query).getResultList();
        for (Object r : rs) {
            TestMappedSuperClass.assertTrue((boolean)(r instanceof SituationDA));
        }
        query = "select s from CashBaseEntity s where TYPE(s) <> ValuableItemDA";
        try {
            rs = em.createQuery(query).getResultList();
        }
        catch (ArgumentException argumentException) {
        }
        finally {
            em.close();
        }
    }

    public void testMergeNewInstanceDerivedFromMappedSuperClassWithoutIdentityField() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        long id = System.currentTimeMillis();
        DerivedEntityFromMappedSuperWithoutId pc = new DerivedEntityFromMappedSuperWithoutId();
        pc.setId(id);
        pc.setName("abc");
        em.persist((Object)pc);
        em.getTransaction().commit();
        em.close();
        DerivedEntityFromMappedSuperWithoutId newpc = new DerivedEntityFromMappedSuperWithoutId();
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        newpc.setId(id);
        newpc.setName("xyz");
        em.merge((Object)newpc);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        DerivedEntityFromMappedSuperWithoutId found = (DerivedEntityFromMappedSuperWithoutId)em.find(DerivedEntityFromMappedSuperWithoutId.class, (Object)id);
        TestMappedSuperClass.assertNotNull((Object)found);
        TestMappedSuperClass.assertEquals((String)"xyz", (String)found.getName());
    }
}

