/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.inheritance.datacache;

import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.inheritance.entity.Department;
import org.apache.openjpa.persistence.inheritance.entity.Employee;
import org.apache.openjpa.persistence.inheritance.entity.FTEmployee;
import org.apache.openjpa.persistence.inheritance.entity.Manager;
import org.apache.openjpa.persistence.inheritance.entity.PTEmployee;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestInheritanceWithDataCache
extends SingleEMFTestCase {
    Object[] props = new Object[]{FTEmployee.class, Employee.class, Manager.class, PTEmployee.class, Department.class, "openjpa.DataCache", "true", CLEAR_TABLES};

    @Override
    public void setUp() throws Exception {
        super.setUp(this.props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() throws Exception {
        try (OpenJPAEntityManagerSPI em = this.emf.createEntityManager();){
            em.getTransaction().begin();
            Manager m = new Manager();
            m.setId(1);
            em.persist((Object)m);
            Department dept = new Department();
            dept.setId(1);
            dept.setDepartmentManager(m);
            em.persist((Object)dept);
            m.setDepartment(dept);
            em.getTransaction().commit();
            em.clear();
            this.emf.getCache().evictAll();
            Employee e = (Employee)em.find(Employee.class, (Object)1);
            TestInheritanceWithDataCache.assertNotNull((Object)e);
            TestInheritanceWithDataCache.assertTrue((boolean)(e instanceof Manager));
            em.clear();
            e = (Employee)em.find(Employee.class, (Object)1);
            TestInheritanceWithDataCache.assertNotNull((Object)e);
            TestInheritanceWithDataCache.assertTrue((boolean)(e instanceof Manager));
        }
    }
}

