/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.inheritance;

import junit.textui.TestRunner;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.inheritance.EntityL3;
import org.apache.openjpa.persistence.inheritance.MappedSuperclassBase;
import org.apache.openjpa.persistence.inheritance.MappedSuperclassL2;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestMultipleMappedSuperclassHierarchy
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(MappedSuperclassBase.class, MappedSuperclassL2.class, EntityL3.class);
    }

    public void testPersist() {
        EntityL3 ent = new EntityL3();
        ent.setL2Data(99);
        ent.setL3Data(100);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)ent);
        em.getTransaction().commit();
        long id = ent.getId();
        TestMultipleMappedSuperclassHierarchy.assertTrue((id != 0L ? 1 : 0) != 0);
        em.close();
        em = this.emf.createEntityManager();
        ent = (EntityL3)em.find(EntityL3.class, (Object)id);
        TestMultipleMappedSuperclassHierarchy.assertNotNull((Object)ent);
        TestMultipleMappedSuperclassHierarchy.assertEquals((int)99, (int)ent.getL2Data());
        TestMultipleMappedSuperclassHierarchy.assertEquals((int)100, (int)ent.getL3Data());
        em.close();
    }

    public static void main(String[] args) {
        TestRunner.run(TestMultipleMappedSuperclassHierarchy.class);
    }
}

