/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.inheritance;

import java.lang.reflect.Method;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.Discriminator;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.inheritance.entity.AbstractClass;
import org.apache.openjpa.persistence.inheritance.entity.BaseClass;
import org.apache.openjpa.persistence.inheritance.entity.BaseClass2;
import org.apache.openjpa.persistence.inheritance.entity.BaseClass3;
import org.apache.openjpa.persistence.inheritance.entity.BaseClass4;
import org.apache.openjpa.persistence.inheritance.entity.BaseClass5;
import org.apache.openjpa.persistence.inheritance.entity.BaseClass6;
import org.apache.openjpa.persistence.inheritance.entity.ImplClassA;
import org.apache.openjpa.persistence.inheritance.entity.ManagedIface;
import org.apache.openjpa.persistence.inheritance.entity.ManagedIface2;
import org.apache.openjpa.persistence.inheritance.entity.MappedSuper;
import org.apache.openjpa.persistence.inheritance.entity.MidClass;
import org.apache.openjpa.persistence.inheritance.entity.MidClass2;
import org.apache.openjpa.persistence.inheritance.entity.MidClass3;
import org.apache.openjpa.persistence.inheritance.entity.SubclassA;
import org.apache.openjpa.persistence.inheritance.entity.SubclassB;
import org.apache.openjpa.persistence.inheritance.entity.SubclassC;
import org.apache.openjpa.persistence.inheritance.entity.SubclassD;
import org.apache.openjpa.persistence.inheritance.entity.SubclassE;
import org.apache.openjpa.persistence.inheritance.entity.SubclassF;
import org.apache.openjpa.persistence.inheritance.entity.SubclassG;
import org.apache.openjpa.persistence.inheritance.entity.SubclassH;
import org.apache.openjpa.persistence.inheritance.entity.SubclassI;
import org.apache.openjpa.persistence.inheritance.entity.SubclassJ;
import org.apache.openjpa.persistence.inheritance.entity.SubclassK;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestDefaultInheritanceStrategy
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(BaseClass.class, SubclassA.class, SubclassB.class, SubclassC.class, MappedSuper.class, SubclassD.class, BaseClass2.class, MidClass.class, SubclassE.class, ManagedIface.class, ImplClassA.class, ManagedIface2.class, BaseClass3.class, SubclassF.class, BaseClass4.class, SubclassG.class, BaseClass5.class, MidClass2.class, SubclassH.class, AbstractClass.class, SubclassI.class, SubclassJ.class, BaseClass6.class, SubclassK.class, "openjpa.jdbc.FinderCache", "true", CLEAR_TABLES);
    }

    private Class[] classArray(Class ... classes) {
        return classes;
    }

    public void testSimpleDefaultInheritance() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        SubclassA sca = new SubclassA();
        sca.setId(0);
        sca.setName("SubclassABaseClassName0");
        sca.setClassAName("SubclassAName0");
        SubclassA sca2 = new SubclassA();
        sca2.setId(1);
        sca2.setName("SubclassABaseClassName1");
        sca2.setClassAName("SubclassAName1");
        SubclassB scb = new SubclassB();
        scb.setId(2);
        scb.setName("SubclassBBaseClassName");
        scb.setClassBName("SubclassBName");
        BaseClass b = new BaseClass();
        b.setName("BaseClassName");
        b.setId(3);
        em.getTransaction().begin();
        em.persist((Object)sca);
        em.persist((Object)sca2);
        em.persist((Object)scb);
        em.persist((Object)b);
        em.getTransaction().commit();
        em.clear();
        String query = "select a from BaseClass a where TYPE(a) = BaseClass";
        List rs = em.createQuery(query).getResultList();
        TestDefaultInheritanceStrategy.assertTrue((boolean)(rs.get(0) instanceof BaseClass));
        query = "select a from BaseClass a where TYPE(a) = SubclassA";
        rs = em.createQuery(query).getResultList();
        TestDefaultInheritanceStrategy.assertTrue((boolean)(rs.get(0) instanceof SubclassA));
        em.clear();
        this.verifyDtypeColumnEntriesAndMapping((EntityManager)em, "BaseClass", 4, BaseClass.class);
        this.verifyInheritanceQueryResult((EntityManager)em, "SubclassA", this.classArray(SubclassA.class), 0, 1);
        this.verifyInheritanceQueryResult((EntityManager)em, "SubclassB", this.classArray(SubclassB.class), 2);
        this.verifyInheritanceQueryResult((EntityManager)em, "BaseClass", this.classArray(BaseClass.class), 0, 1, 2, 3);
        em.close();
    }

    public void testMappedSuperclass() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        SubclassC sc = new SubclassC();
        sc.setId(1010);
        sc.setName("SubclassCMappedSuperName");
        sc.setClassCName("SubclassCName");
        SubclassD sd = new SubclassD();
        sd.setId(2020);
        sd.setName("SubclassDMappedSuperName");
        sd.setClassDName("SubclassDName");
        em.persist((Object)sc);
        em.persist((Object)sd);
        em.getTransaction().commit();
        em.clear();
        SubclassD sd2 = (SubclassD)em.find(SubclassD.class, (Object)2020);
        TestDefaultInheritanceStrategy.assertEquals((int)2020, (int)sd2.getId());
        this.verifyNoDypeColumn((EntityManager)em, "SubclassC");
        this.verifyNoDypeColumn((EntityManager)em, "SubclassD");
        this.verifyInheritanceQueryResult((EntityManager)em, "SubclassC", this.classArray(SubclassC.class, MappedSuper.class), 1010);
        this.verifyInheritanceQueryResult((EntityManager)em, "SubclassD", this.classArray(SubclassD.class, MappedSuper.class), 2020);
        em.close();
    }

    public void testTwoLevelInheritance() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        SubclassE sc = new SubclassE();
        sc.setId(0);
        sc.setName("SubclassEBaseClassName");
        sc.setMidClassName("SubclassEMidClassName");
        sc.setClassEName("SubclassCName");
        MidClass mc = new MidClass();
        mc.setId(1);
        mc.setName("MidClassBaseClassName");
        mc.setMidClassName("MidClassName");
        BaseClass2 b2 = new BaseClass2();
        b2.setName("BaseClass2Name");
        b2.setId(2);
        em.persist((Object)sc);
        em.persist((Object)mc);
        em.persist((Object)b2);
        em.getTransaction().commit();
        em.clear();
        String query = "select a from BaseClass2 a where TYPE(a) = MidClass";
        List rs = em.createQuery(query).getResultList();
        for (Object value : rs) {
            TestDefaultInheritanceStrategy.assertTrue((boolean)(value instanceof MidClass));
        }
        query = "select a from BaseClass2 a where TYPE(a) = SubclassE";
        rs = em.createQuery(query).getResultList();
        for (Object o : rs) {
            TestDefaultInheritanceStrategy.assertTrue((boolean)(o instanceof SubclassE));
        }
        query = "select a from BaseClass2 a where TYPE(a) = BaseClass2";
        rs = em.createQuery(query).getResultList();
        for (Object r : rs) {
            TestDefaultInheritanceStrategy.assertTrue((boolean)(r instanceof BaseClass2));
        }
        em.clear();
        this.verifyDtypeColumnEntriesAndMapping((EntityManager)em, "BaseClass2", 3, BaseClass2.class);
        this.verifyNoDypeColumn((EntityManager)em, "MidClass");
        this.verifyNoDypeColumn((EntityManager)em, "SubclassE");
        this.verifyInheritanceQueryResult((EntityManager)em, "SubclassE", this.classArray(SubclassE.class, MidClass.class, BaseClass2.class), 0);
        this.verifyInheritanceQueryResult((EntityManager)em, "MidClass", this.classArray(MidClass.class), 0, 1);
        this.verifyInheritanceQueryResult((EntityManager)em, "BaseClass2", this.classArray(BaseClass2.class), 0, 1, 2);
        em.close();
    }

    public void testManagedInterface() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ManagedIface mif = (ManagedIface)em.createInstance(ManagedIface.class);
        mif.setIntFieldSup(10);
        ImplClassA ica = new ImplClassA();
        ica.setImplClassAName("ImplClassAName");
        ica.setIntFieldSup(11);
        em.persist((Object)mif);
        em.persist((Object)ica);
        em.getTransaction().commit();
        em.clear();
        this.verifyNoDypeColumn((EntityManager)em, "ManagedIface");
        this.verifyNoDypeColumn((EntityManager)em, "ImplClassA");
        this.verifyInheritanceQueryResult((EntityManager)em, "ImplClassA", this.classArray(ImplClassA.class, ManagedIface.class), ica.getId());
        this.verifyInheritanceQueryResult((EntityManager)em, "ManagedIface", this.classArray(ManagedIface.class), mif.getId(), ica.getId());
        em.close();
    }

    public void testManagedInterfaceAndBase() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ManagedIface2 mif2 = (ManagedIface2)em.createInstance(ManagedIface2.class);
        mif2.setIntFieldSup(12);
        SubclassF scf = new SubclassF();
        scf.setClassFName("SubclassFName");
        scf.setIntFieldSup(13);
        BaseClass3 bc3 = new BaseClass3();
        bc3.setName("BaseClass3");
        em.persist((Object)mif2);
        em.persist((Object)scf);
        em.persist((Object)bc3);
        em.getTransaction().commit();
        em.clear();
        this.verifyNoDypeColumn((EntityManager)em, "ManagedIface2");
        this.verifyNoDypeColumn((EntityManager)em, "SubclassF");
        this.verifyDtypeColumnEntriesAndMapping((EntityManager)em, "BaseClass3", 2, BaseClass3.class);
        this.verifyInheritanceQueryResult((EntityManager)em, "SubclassF", this.classArray(SubclassF.class, ManagedIface2.class, BaseClass3.class), scf.getId());
        this.verifyInheritanceQueryResult((EntityManager)em, "BaseClass3", this.classArray(BaseClass3.class), scf.getId(), bc3.getId());
        this.verifyInheritanceQueryResult((EntityManager)em, "ManagedIface2", this.classArray(ManagedIface2.class), scf.getId(), mif2.getId());
        em.close();
    }

    public void testSubclassSpecifiedInheritance() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        SubclassG scg = new SubclassG();
        scg.setId(0);
        scg.setName("SubclassGBaseClass4Name");
        scg.setClassGName("SubclassGName");
        BaseClass4 b = new BaseClass4();
        b.setName("BaseClass4Name");
        b.setId(1);
        em.getTransaction().begin();
        em.persist((Object)scg);
        em.persist((Object)b);
        em.getTransaction().commit();
        em.clear();
        this.verifyDtypeColumnEntriesAndMapping((EntityManager)em, "BaseClass4", 2, BaseClass4.class);
        this.verifyNoDypeColumn((EntityManager)em, "SubclassG");
        this.verifyInheritanceQueryResult((EntityManager)em, "SubclassG", this.classArray(SubclassG.class, BaseClass4.class), 0);
        this.verifyInheritanceQueryResult((EntityManager)em, "BaseClass4", this.classArray(BaseClass4.class), 0, 1);
        em.close();
    }

    public void testCircularInheritedRelationships() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        SubclassH sch = new SubclassH();
        sch.setId(1);
        sch.setClassHName("SubclassHName");
        sch.setName("SubclassHBaseClass5Name");
        sch.setMidClass2Name("SubclassHMidClass2Name");
        BaseClass5 bc5 = new BaseClass5();
        bc5.setId(2);
        bc5.setName("BaseClass5Name");
        bc5.setSubclassh(sch);
        sch.setBaseclass5(bc5);
        MidClass2 mc2 = new MidClass2();
        mc2.setId(3);
        mc2.setMidClass2Name("MidClass2Name");
        mc2.setName("MidClass2BaseClass5Name");
        mc2.setSubclassh(sch);
        em.getTransaction().begin();
        em.persist((Object)sch);
        em.persist((Object)bc5);
        em.persist((Object)mc2);
        em.getTransaction().commit();
        em.clear();
        this.verifyDtypeColumnEntriesAndMapping((EntityManager)em, "BaseClass5", 3, BaseClass5.class);
        this.verifyNoDypeColumn((EntityManager)em, "MidClass2");
        this.verifyNoDypeColumn((EntityManager)em, "SubclassH");
        this.verifyInheritanceQueryResult((EntityManager)em, "SubclassH", this.classArray(SubclassH.class, MidClass2.class, BaseClass5.class), 1);
        this.verifyInheritanceQueryResult((EntityManager)em, "MidClass2", this.classArray(MidClass2.class, BaseClass5.class), 1, 3);
        this.verifyInheritanceQueryResult((EntityManager)em, "BaseClass5", this.classArray(BaseClass5.class), 1, 2, 3);
        em.clear();
        sch = (SubclassH)em.find(SubclassH.class, (Object)1);
        TestDefaultInheritanceStrategy.assertEquals((String)sch.getName(), (String)"SubclassHBaseClass5Name");
        TestDefaultInheritanceStrategy.assertEquals((String)sch.getMidClass2Name(), (String)"SubclassHMidClass2Name");
        TestDefaultInheritanceStrategy.assertEquals((int)sch.getBaseclass5().getId(), (int)2);
        bc5 = (BaseClass5)em.find(BaseClass5.class, (Object)3);
        TestDefaultInheritanceStrategy.assertEquals((String)bc5.getName(), (String)"MidClass2BaseClass5Name");
        TestDefaultInheritanceStrategy.assertEquals((int)bc5.getSubclassh().getId(), (int)1);
        bc5 = (BaseClass5)em.find(BaseClass5.class, (Object)2);
        TestDefaultInheritanceStrategy.assertEquals((String)bc5.getName(), (String)"BaseClass5Name");
        TestDefaultInheritanceStrategy.assertEquals((int)bc5.getSubclassh().getId(), (int)1);
        mc2 = (MidClass2)em.find(MidClass2.class, (Object)3);
        TestDefaultInheritanceStrategy.assertEquals((String)mc2.getName(), (String)"MidClass2BaseClass5Name");
        TestDefaultInheritanceStrategy.assertEquals((String)mc2.getMidClass2Name(), (String)"MidClass2Name");
        TestDefaultInheritanceStrategy.assertEquals((int)bc5.getSubclassh().getId(), (int)1);
        em.close();
    }

    public void testAbstractEntityInheritance() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        SubclassI sci = new SubclassI();
        sci.setId(1);
        sci.setClassIName("SubclassIName");
        sci.setName("SubclassIBaseClassName");
        SubclassJ scj = new SubclassJ();
        scj.setId(2);
        scj.setClassJName("SubclassJName");
        scj.setName("SubclassJBaseClassName");
        em.getTransaction().begin();
        em.persist((Object)sci);
        em.persist((Object)scj);
        em.getTransaction().commit();
        em.clear();
        this.verifyDtypeColumnEntriesAndMapping((EntityManager)em, "AbstractClass", 2, AbstractClass.class);
        this.verifyNoDypeColumn((EntityManager)em, "SubclassI");
        this.verifyNoDypeColumn((EntityManager)em, "SubclassJ");
        this.verifyInheritanceQueryResult((EntityManager)em, "AbstractClass", this.classArray(AbstractClass.class), 1, 2);
        this.verifyInheritanceQueryResult((EntityManager)em, "SubclassI", this.classArray(AbstractClass.class, SubclassI.class), 1);
        this.verifyInheritanceQueryResult((EntityManager)em, "SubclassJ", this.classArray(AbstractClass.class, SubclassJ.class), 2);
        em.close();
    }

    public void testMidNonEntityInheritance() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        SubclassK sck = new SubclassK();
        sck.setId(1);
        sck.setClassKName("SubclassKName");
        sck.setMidClass3Name("SubclassKMidClass3Name");
        sck.setName("SubclassKBaseClass6Name");
        BaseClass6 bk6 = new BaseClass6();
        bk6.setId(3);
        bk6.setName("BaseClass6Name");
        em.getTransaction().begin();
        em.persist((Object)sck);
        em.persist((Object)bk6);
        em.getTransaction().commit();
        em.clear();
        this.verifyDtypeColumnEntriesAndMapping((EntityManager)em, "BaseClass6", 2, BaseClass6.class);
        this.verifyNoDypeColumn((EntityManager)em, "SubclassK");
        this.verifyInheritanceQueryResult((EntityManager)em, "BaseClass6", this.classArray(BaseClass6.class), 1, 3);
        this.verifyInheritanceQueryResult((EntityManager)em, "SubclassK", this.classArray(BaseClass6.class, MidClass3.class, SubclassK.class), 1);
        em.close();
    }

    public void testFinder() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        SubclassK sck = new SubclassK();
        sck.setId(479);
        sck.setClassKName("SubclassKName");
        sck.setMidClass3Name("SubclassKMidClass3Name");
        sck.setName("SubclassKBaseClass6Name");
        BaseClass6 bk6 = new BaseClass6();
        bk6.setId(302);
        bk6.setName("BaseClass6Name");
        SubclassI sci = new SubclassI();
        sci.setId(109);
        sci.setClassIName("SubclassIName");
        sci.setName("SubclassIBaseClassName");
        SubclassJ scj = new SubclassJ();
        scj.setId(238);
        scj.setClassJName("SubclassJName");
        scj.setName("SubclassJBaseClassName");
        em.getTransaction().begin();
        em.persist((Object)sck);
        em.persist((Object)bk6);
        em.persist((Object)sci);
        em.persist((Object)scj);
        em.getTransaction().commit();
        em.clear();
        this.verifyInheritanceFinderResult((EntityManager)em, SubclassK.class, 479);
        this.verifyInheritanceFinderResult((EntityManager)em, BaseClass6.class, 479, 302);
        this.verifyInheritanceFinderResult((EntityManager)em, SubclassI.class, 109);
        this.verifyInheritanceFinderResult((EntityManager)em, SubclassJ.class, 238);
        em.close();
    }

    private void verifyDtypeColumnEntriesAndMapping(EntityManager em, String table, int entries, Class baseClass) {
        try {
            Query qry = em.createNativeQuery("SELECT DTYPE FROM " + table);
            List vals = qry.getResultList();
            TestDefaultInheritanceStrategy.assertTrue((String)("Query should have returned " + entries + " values"), (vals.size() == entries ? 1 : 0) != 0);
        }
        catch (Exception e) {
            TestDefaultInheritanceStrategy.fail((String)("Exception querying DTYPE column: " + e.getMessage()));
        }
        ClassMapping cm = this.getMapping(baseClass);
        Discriminator d = cm.getDiscriminator();
        Column[] cols = d.getColumns();
        TestDefaultInheritanceStrategy.assertTrue((String)"Discriminator should use DTYPE column", (cols != null && cols.length == 1 && cols[0].getName().equals("DTYPE") ? 1 : 0) != 0);
    }

    private void verifyNoDypeColumn(EntityManager em, String table) {
        try {
            Query qry = em.createNativeQuery("SELECT DTYPE FROM " + table);
            qry.getResultList();
            TestDefaultInheritanceStrategy.fail((String)("Expected exception.  DTYPE column should not exist on " + table));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void verifyInheritanceQueryResult(EntityManager em, String entity, Class[] types, int ... expectedValues) {
        String jpql = "SELECT e FROM " + entity + " e";
        Query qry = em.createQuery(jpql);
        List col = qry.getResultList();
        TestDefaultInheritanceStrategy.assertTrue((String)("Query should return " + expectedValues.length + " entities"), (col.size() == expectedValues.length ? 1 : 0) != 0);
        int count = 0;
        for (Object ent : col) {
            if (types != null) {
                for (Class type : types) {
                    TestDefaultInheritanceStrategy.assertTrue((boolean)type.isInstance(ent));
                }
            }
            int id = -1;
            try {
                Method mth = ent.getClass().getMethod("getId", null);
                id = (Integer)mth.invoke(ent, (Object[])null);
            }
            catch (Exception e) {
                TestDefaultInheritanceStrategy.fail((String)("Caught unexepcted exception getting entity id: " + e.getMessage()));
            }
            for (int expectedValue : expectedValues) {
                if (expectedValue != id) continue;
                ++count;
            }
        }
        TestDefaultInheritanceStrategy.assertTrue((String)("Returned unexpected entities " + col + " for " + jpql), (count == expectedValues.length ? 1 : 0) != 0);
    }

    private void verifyInheritanceFinderResult(EntityManager em, Class entityType, int ... ids) {
        for (int j = 0; j < 2; ++j) {
            em.clear();
            for (int id : ids) {
                Object pc = em.find(entityType, (Object)id);
                TestDefaultInheritanceStrategy.assertTrue((boolean)entityType.isAssignableFrom(pc.getClass()));
            }
        }
    }
}

