/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.identity;

import java.math.BigDecimal;
import junit.textui.TestRunner;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.identity.SQLBigDecimalIdEntity;
import org.apache.openjpa.persistence.test.AllowFailure;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestSQLBigDecimalId
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(SQLBigDecimalIdEntity.class, DROP_TABLES);
    }

    public void testPersist() {
        long time = System.currentTimeMillis() / 1000L * 1000L;
        BigDecimal decimal = new BigDecimal(time);
        SQLBigDecimalIdEntity e = new SQLBigDecimalIdEntity();
        e.setId(decimal);
        e.setData(1);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)e);
        em.getTransaction().commit();
        TestSQLBigDecimalId.assertEquals((long)time, (long)e.getId().longValue());
        em.close();
        em = this.emf.createEntityManager();
        e = (SQLBigDecimalIdEntity)em.find(SQLBigDecimalIdEntity.class, (Object)decimal);
        TestSQLBigDecimalId.assertEquals((int)1, (int)e.getData());
        em.close();
    }

    @AllowFailure
    public void testQuery() {
        int data = 156;
        BigDecimal decimal = new BigDecimal(1234);
        SQLBigDecimalIdEntity e = new SQLBigDecimalIdEntity();
        e.setId(decimal);
        e.setData(data);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)e);
        em.getTransaction().commit();
        SQLBigDecimalIdEntity e2 = (SQLBigDecimalIdEntity)em.createQuery("SELECT a FROM SQLBigDecimalIdEntity a WHERE a.data=" + data).getSingleResult();
        TestSQLBigDecimalId.assertEquals((Object)e, (Object)e2);
        em.close();
    }

    public static void main(String[] args) {
        TestRunner.run(TestSQLBigDecimalId.class);
    }
}

