/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.identity;

import java.util.List;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import junit.textui.TestRunner;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.OracleDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.identity.IdentityGenerationType;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestGenerationType
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        if (this.getName().endsWith("WithoutGetGeneratedKeys")) {
            this.setUp(IdentityGenerationType.class, "openjpa.jdbc.DBDictionary", "supportsGetGeneratedKeys=false");
        } else {
            this.setUp(IdentityGenerationType.class);
        }
    }

    private boolean supportsAutoAssign() {
        return ((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance().supportsAutoAssign;
    }

    public void testCreateEntityManager() {
        if (!this.supportsAutoAssign()) {
            return;
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction t = em.getTransaction();
        TestGenerationType.assertNotNull((Object)t);
        t.begin();
        t.setRollbackOnly();
        t.rollback();
        TestGenerationType.assertTrue((boolean)(em instanceof OpenJPAEntityManager));
        OpenJPAEntityManager ojem = (OpenJPAEntityManager)em;
        ojem.getFetchPlan().setMaxFetchDepth(-1);
        TestGenerationType.assertEquals((int)-1, (int)ojem.getFetchPlan().getMaxFetchDepth());
        em.close();
    }

    public void testPersist() {
        if (!this.supportsAutoAssign()) {
            return;
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)new IdentityGenerationType());
        em.getTransaction().commit();
        em.close();
    }

    public void testQuery() {
        if (!this.supportsAutoAssign()) {
            return;
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        IdentityGenerationType igt = new IdentityGenerationType();
        igt.setSomeData("SomeString");
        em.persist((Object)igt);
        em.persist((Object)new IdentityGenerationType());
        em.getTransaction().commit();
        Query q = em.createQuery("select x from IdentityGenerationType x");
        List l = q.getResultList();
        TestGenerationType.assertEquals((int)2, (int)l.size());
        em.close();
    }

    public void testPersistWithoutGetGeneratedKeys() {
        this.testPersist();
    }

    public void testQueryWithoutGetGeneratedKeys() {
        if (this.getDBDictionary() instanceof OracleDictionary) {
            return;
        }
        this.testQuery();
    }

    public static void main(String[] args) {
        TestRunner.run(TestGenerationType.class);
    }
}

