/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.identity;

import java.sql.Connection;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.openjpa.jdbc.sql.DerbyDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.identity.ComplexCompoundIdTestEntity;
import org.apache.openjpa.persistence.identity.SimpleCompoundIdTestEntity;
import org.apache.openjpa.persistence.identity.TypeEntity;
import org.apache.openjpa.persistence.test.DatabasePlatform;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

@DatabasePlatform(value="org.apache.derby.jdbc.EmbeddedDriver")
public class TestCompundIdWithNull
extends SingleEMFTestCase {
    private static boolean tablesCreated = false;

    @Override
    public void setUp() throws Exception {
        this.setSupportedDatabases(DerbyDictionary.class);
        if (this.isTestsDisabled()) {
            return;
        }
        super.setUp(SimpleCompoundIdTestEntity.class, ComplexCompoundIdTestEntity.class, TypeEntity.class);
        if (!tablesCreated) {
            this.createTables((EntityManager)this.emf.createEntityManager());
            tablesCreated = true;
        }
    }

    public void testSimpleCompoundIdTestEntity() throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String jpql = "SELECT o FROM SimpleCompoundIdTestEntity o ORDER BY o.secondId";
        List list = em.createQuery(jpql, SimpleCompoundIdTestEntity.class).getResultList();
        TestCompundIdWithNull.assertEquals((int)2, (int)list.size());
        TestCompundIdWithNull.assertEquals((Object)123L, (Object)((SimpleCompoundIdTestEntity)list.get(0)).getSecondId());
        SimpleCompoundIdTestEntity secondResult = (SimpleCompoundIdTestEntity)list.get(1);
        TestCompundIdWithNull.assertNotNull((String)"BUG (JIRA-1397)! Result list contains null in second element", (Object)secondResult);
        TestCompundIdWithNull.assertNull((Object)secondResult.getSecondId());
        em.close();
    }

    public void testComplexCompoundIdTestEntity() throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String jpql = "SELECT o FROM ComplexCompoundIdTestEntity o ORDER BY o.type";
        List list = em.createQuery(jpql, ComplexCompoundIdTestEntity.class).getResultList();
        TestCompundIdWithNull.assertEquals((int)2, (int)list.size());
        ComplexCompoundIdTestEntity secondResult = (ComplexCompoundIdTestEntity)list.get(1);
        TestCompundIdWithNull.assertNotNull((String)"Result list contains null in second element", (Object)secondResult);
        TestCompundIdWithNull.assertNull((String)"Result list's second record secondId field was not null", (Object)secondResult.getType());
        em.close();
    }

    private void createTables(EntityManager em) throws Exception {
        em.getTransaction().begin();
        OpenJPAEntityManager kem = OpenJPAPersistence.cast((EntityManager)em);
        Connection conn = (Connection)kem.getConnection();
        try {
            conn.createStatement().execute("DROP TABLE test_type");
            conn.createStatement().execute("DROP TABLE test_simple");
            conn.createStatement().execute("DROP TABLE test_complex");
        }
        catch (Exception exception) {
            // empty catch block
        }
        conn.createStatement().execute("CREATE TABLE test_simple(firstId NUMERIC, secondId NUMERIC)");
        conn.createStatement().execute("INSERT INTO test_simple(firstId, secondId) VALUES (1, 123)");
        conn.createStatement().execute("INSERT INTO test_simple(firstId, secondId) VALUES (1, NULL)");
        conn.createStatement().execute("CREATE TABLE test_type(id NUMERIC CONSTRAINT test_type_pk PRIMARY KEY, code VARCHAR(16))");
        conn.createStatement().execute("INSERT INTO test_type(id, code) VALUES (987, 'ABC')");
        conn.createStatement().execute("CREATE TABLE test_complex(id NUMERIC, type_id NUMERIC)");
        conn.createStatement().execute("INSERT INTO test_complex(id, type_id) VALUES (1, 987)");
        conn.createStatement().execute("INSERT INTO test_complex(id, type_id) VALUES (1, NULL)");
        conn.close();
        em.flush();
        em.getTransaction().commit();
        em.close();
    }
}

