/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.identity;

import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.identity.BooleanIdEntity;
import org.apache.openjpa.persistence.identity.CompoundBooleanId;
import org.apache.openjpa.persistence.identity.CompoundBooleanIdEntity;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestBooleanId
extends SQLListenerTestCase {
    private EntityManager em;
    private BooleanIdEntity se;
    private CompoundBooleanIdEntity ce;

    @Override
    public void setUp() throws Exception {
        super.setUp(BooleanIdEntity.class, CompoundBooleanIdEntity.class, DROP_TABLES);
        TestBooleanId.assertTrue((this.emf != null ? 1 : 0) != 0);
    }

    @Override
    public void tearDown() throws Exception {
        this.closeEM(this.em);
        super.tearDown();
    }

    public void testSimpleBooleanIdEntity() {
        this.se = new BooleanIdEntity(true, "name");
        this.em = this.emf.createEntityManager();
        this.em.getTransaction().begin();
        this.em.persist((Object)this.se);
        this.em.getTransaction().commit();
        TestBooleanId.assertEquals((boolean)true, (boolean)this.se.getId());
        this.em.close();
        this.em = this.emf.createEntityManager();
        this.se = (BooleanIdEntity)this.em.find(BooleanIdEntity.class, (Object)true);
        TestBooleanId.assertNotNull((Object)this.se);
    }

    public void testCompoundIdEntity() {
        this.em = this.emf.createEntityManager();
        this.testCompoundIdEntity("string1", true, true);
        this.testCompoundIdEntity("string1", true, false);
        this.testCompoundIdEntity("string1", false, true);
        this.testCompoundIdEntity("string2", true, true);
        this.testCompoundIdEntity("string2", false, true);
        this.createCompoundIdEntityWithoutBoolean("string3");
        this.em.close();
    }

    private void testCompoundIdEntity(String stringId, boolean booleanId, boolean expectSuccess) {
        try {
            this.em.getTransaction().begin();
            this.ce = new CompoundBooleanIdEntity();
            this.ce.setStringId(stringId);
            this.ce.setBooleanId(booleanId);
            this.em.persist((Object)this.ce);
            this.em.getTransaction().commit();
        }
        catch (Throwable e) {
            TestBooleanId.assertFalse((boolean)expectSuccess);
            this.em.getTransaction().rollback();
        }
        this.ce = null;
        this.em.clear();
        if (expectSuccess) {
            this.em.getTransaction().begin();
            CompoundBooleanId cpdId = new CompoundBooleanId();
            cpdId.setBooleanId(booleanId);
            cpdId.setStringId(stringId);
            this.ce = (CompoundBooleanIdEntity)this.em.find(CompoundBooleanIdEntity.class, (Object)cpdId);
            TestBooleanId.assertNotNull((Object)this.ce);
            this.em.getTransaction().commit();
        }
    }

    private void createCompoundIdEntityWithoutBoolean(String stringId) {
        this.em.getTransaction().begin();
        this.ce = new CompoundBooleanIdEntity();
        this.ce.setStringId(stringId);
        this.em.persist((Object)this.ce);
        this.em.getTransaction().commit();
        this.ce = null;
        this.em.clear();
        this.em.getTransaction().begin();
        CompoundBooleanId cpdId = new CompoundBooleanId();
        cpdId.setStringId(stringId);
        this.ce = (CompoundBooleanIdEntity)this.em.find(CompoundBooleanIdEntity.class, (Object)cpdId);
        TestBooleanId.assertNotNull((Object)this.ce);
        this.em.getTransaction().commit();
    }
}

