/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.graph;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Properties;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.OneToOne;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.graph.Relation;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;

@Entity
public class PersistentRelation<V1, V2>
implements Relation<V1, V2>,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue
    private long id;
    @OneToOne(optional=false, targetEntity=Entity.class, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.DETACH, CascadeType.REFRESH})
    private V1 source;
    @OneToOne(optional=true, targetEntity=Entity.class, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.DETACH, CascadeType.REFRESH})
    private V2 target;
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private Properties attrs;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$util$Properties;
    static /* synthetic */ Class class$Ljava$lang$Object;
    static /* synthetic */ Class class$Lorg$apache$openjpa$persistence$graph$PersistentRelation;
    private transient Object pcDetachedState;

    protected PersistentRelation() {
    }

    public PersistentRelation(V1 s, V2 t) {
        if (s == null) {
            throw new NullPointerException("Can not create relation from a null source vertex");
        }
        this.source = s;
        this.target = t;
        this.attrs = new Properties();
    }

    public long getId() {
        return PersistentRelation.pcGetid(this);
    }

    @Override
    public V1 getSource() {
        return (V1)PersistentRelation.pcGetsource(this);
    }

    @Override
    public V2 getTarget() {
        return (V2)PersistentRelation.pcGettarget(this);
    }

    @Override
    public boolean hasAttribute(String attr) {
        return PersistentRelation.pcGetattrs(this).containsKey(attr);
    }

    @Override
    public Object getAttribute(String attr) {
        return PersistentRelation.pcGetattrs(this).get(attr);
    }

    @Override
    public Properties getAttributes() {
        return PersistentRelation.pcGetattrs(this);
    }

    @Override
    public Relation<V1, V2> addAttribute(String attr, Object v) {
        PersistentRelation.pcGetattrs(this).put(attr, v);
        return this;
    }

    @Override
    public Relation<V1, V2> removeAttribute(String attr) {
        PersistentRelation.pcGetattrs(this).remove(attr);
        return this;
    }

    public String toString() {
        return PersistentRelation.pcGetsource(this) + "->" + PersistentRelation.pcGettarget(this);
    }

    public int pcGetEnhancementContractVersion() {
        return 196634845;
    }

    static {
        pcFieldNames = new String[]{"attrs", "id", "source", "target"};
        Class[] classArray = new Class[4];
        Class clazz = class$Ljava$util$Properties != null ? class$Ljava$util$Properties : (class$Ljava$util$Properties = PersistentRelation.class$("java.util.Properties"));
        classArray[0] = clazz;
        classArray[1] = Long.TYPE;
        Class clazz2 = class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = PersistentRelation.class$("java.lang.Object"));
        classArray[2] = clazz2;
        classArray[3] = class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = PersistentRelation.class$("java.lang.Object"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{21, 26, 10, 10};
        Class clazz3 = class$Lorg$apache$openjpa$persistence$graph$PersistentRelation != null ? class$Lorg$apache$openjpa$persistence$graph$PersistentRelation : (class$Lorg$apache$openjpa$persistence$graph$PersistentRelation = PersistentRelation.class$("org.apache.openjpa.persistence.graph.PersistentRelation"));
        PCRegistry.register((Class)clazz3, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"PersistentRelation", new PersistentRelation());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.attrs = null;
        this.id = 0L;
        this.source = null;
        this.target = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        PersistentRelation<V1, V2> persistentRelation = new PersistentRelation<V1, V2>();
        if (bl) {
            persistentRelation.pcClearFields();
        }
        persistentRelation.pcStateManager = stateManager;
        persistentRelation.pcCopyKeyFieldsFromObjectId(object);
        return persistentRelation;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        PersistentRelation<V1, V2> persistentRelation = new PersistentRelation<V1, V2>();
        if (bl) {
            persistentRelation.pcClearFields();
        }
        persistentRelation.pcStateManager = stateManager;
        return persistentRelation;
    }

    protected static int pcGetManagedFieldCount() {
        return 4;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.attrs = (Properties)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.id = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.source = this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.target = this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.attrs);
                return;
            }
            case 1: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.id);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.source);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.target);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(PersistentRelation persistentRelation, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.attrs = persistentRelation.attrs;
                return;
            }
            case 1: {
                this.id = persistentRelation.id;
                return;
            }
            case 2: {
                this.source = persistentRelation.source;
                return;
            }
            case 3: {
                this.target = persistentRelation.target;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        PersistentRelation persistentRelation = (PersistentRelation)object;
        if (persistentRelation.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(persistentRelation, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        LongId longId = (LongId)object;
        fieldConsumer.storeLongField(1 + pcInheritedFieldCount, longId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        LongId longId = (LongId)object;
        this.id = longId.getId();
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$openjpa$persistence$graph$PersistentRelation != null ? class$Lorg$apache$openjpa$persistence$graph$PersistentRelation : (class$Lorg$apache$openjpa$persistence$graph$PersistentRelation = PersistentRelation.class$("org.apache.openjpa.persistence.graph.PersistentRelation"));
        return new LongId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$openjpa$persistence$graph$PersistentRelation != null ? class$Lorg$apache$openjpa$persistence$graph$PersistentRelation : (class$Lorg$apache$openjpa$persistence$graph$PersistentRelation = PersistentRelation.class$("org.apache.openjpa.persistence.graph.PersistentRelation"));
        return new LongId(clazz, this.id);
    }

    private static final Properties pcGetattrs(PersistentRelation persistentRelation) {
        if (persistentRelation.pcStateManager == null) {
            return persistentRelation.attrs;
        }
        int n = pcInheritedFieldCount + 0;
        persistentRelation.pcStateManager.accessingField(n);
        return persistentRelation.attrs;
    }

    private static final void pcSetattrs(PersistentRelation persistentRelation, Properties properties) {
        if (persistentRelation.pcStateManager == null) {
            persistentRelation.attrs = properties;
            return;
        }
        persistentRelation.pcStateManager.settingObjectField((PersistenceCapable)persistentRelation, pcInheritedFieldCount + 0, (Object)persistentRelation.attrs, (Object)properties, 0);
    }

    private static final long pcGetid(PersistentRelation persistentRelation) {
        if (persistentRelation.pcStateManager == null) {
            return persistentRelation.id;
        }
        int n = pcInheritedFieldCount + 1;
        persistentRelation.pcStateManager.accessingField(n);
        return persistentRelation.id;
    }

    private static final void pcSetid(PersistentRelation persistentRelation, long l) {
        if (persistentRelation.pcStateManager == null) {
            persistentRelation.id = l;
            return;
        }
        persistentRelation.pcStateManager.settingLongField((PersistenceCapable)persistentRelation, pcInheritedFieldCount + 1, persistentRelation.id, l, 0);
    }

    private static final Object pcGetsource(PersistentRelation persistentRelation) {
        if (persistentRelation.pcStateManager == null) {
            return persistentRelation.source;
        }
        int n = pcInheritedFieldCount + 2;
        persistentRelation.pcStateManager.accessingField(n);
        return persistentRelation.source;
    }

    private static final void pcSetsource(PersistentRelation persistentRelation, Object object) {
        if (persistentRelation.pcStateManager == null) {
            persistentRelation.source = object;
            return;
        }
        persistentRelation.pcStateManager.settingObjectField((PersistenceCapable)persistentRelation, pcInheritedFieldCount + 2, persistentRelation.source, object, 0);
    }

    private static final Object pcGettarget(PersistentRelation persistentRelation) {
        if (persistentRelation.pcStateManager == null) {
            return persistentRelation.target;
        }
        int n = pcInheritedFieldCount + 3;
        persistentRelation.pcStateManager.accessingField(n);
        return persistentRelation.target;
    }

    private static final void pcSettarget(PersistentRelation persistentRelation, Object object) {
        if (persistentRelation.pcStateManager == null) {
            persistentRelation.target = object;
            return;
        }
        persistentRelation.pcStateManager.settingObjectField((PersistenceCapable)persistentRelation, pcInheritedFieldCount + 3, persistentRelation.target, object, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.id != 0L) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        if (this.pcGetDetachedState() == null) {
            return Boolean.FALSE;
        }
        return null;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

