/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.generationtype;

import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.generationtype.Dog;
import org.apache.openjpa.persistence.test.AbstractPersistenceTestCase;

public class TestTableGeneratorMultithreadedInitialization
extends AbstractPersistenceTestCase {
    Object[] props = new Object[]{Dog.class, CLEAR_TABLES};

    public void setUp() throws Exception {
    }

    public void test() throws Exception {
        OpenJPAEntityManagerFactorySPI emf1 = this.createNamedEMF(this.getPersistenceUnitName(), this.props);
        OpenJPAEntityManagerFactorySPI emf2 = this.createNamedEMF(this.getPersistenceUnitName(), this.props);
        OpenJPAEntityManagerFactorySPI emf3 = this.createNamedEMF(this.getPersistenceUnitName(), this.props);
        TestTableGeneratorMultithreadedInitialization.assertNotEquals(emf1, emf2);
        emf1.createEntityManager().close();
        emf2.createEntityManager().close();
        EntityManager em1 = emf1.createEntityManager();
        EntityManager em2 = emf2.createEntityManager();
        EntityManager em3 = emf3.createEntityManager();
        Worker w1 = new Worker(em1);
        Worker w2 = new Worker(em2);
        w1.start();
        w2.start();
        w1.join();
        w2.join();
        TestTableGeneratorMultithreadedInitialization.assertNull((String)("Caught an exception in worker 1" + w1.getException()), (Object)w1.getException());
        TestTableGeneratorMultithreadedInitialization.assertNull((String)("Caught an exception in worker 2" + w2.getException()), (Object)w2.getException());
        Dog d1 = w1.getDog();
        Dog d2 = w2.getDog();
        TestTableGeneratorMultithreadedInitialization.assertNotNull((Object)d1);
        TestTableGeneratorMultithreadedInitialization.assertNotNull((Object)d2);
        TestTableGeneratorMultithreadedInitialization.assertNotEquals(d1, d2);
        Dog d1_found = (Dog)em3.find(Dog.class, (Object)d1.getId());
        Dog d2_found = (Dog)em3.find(Dog.class, (Object)d2.getId());
        TestTableGeneratorMultithreadedInitialization.assertEquals((Object)d1_found, (Object)d1);
        TestTableGeneratorMultithreadedInitialization.assertEquals((Object)d2_found, (Object)d2);
        emf1.close();
        emf2.close();
        emf3.close();
    }

    class Worker
    extends Thread {
        final EntityManager em;
        Dog dog = new Dog();
        Exception exception;

        Worker(EntityManager e) {
            this.em = e;
        }

        public Dog getDog() {
            return this.dog;
        }

        public Exception getException() {
            return this.exception;
        }

        @Override
        public void run() {
            try {
                this.em.getTransaction().begin();
                this.em.persist((Object)this.dog);
                this.em.getTransaction().commit();
                this.em.close();
            }
            catch (Exception e) {
                this.exception = e;
                e.printStackTrace();
            }
        }
    }
}

