/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.generationtype;

import java.util.ArrayList;
import org.apache.openjpa.jdbc.kernel.TableJDBCSeq;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.meta.SequenceMetaData;
import org.apache.openjpa.persistence.EntityManagerImpl;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.generationtype.Dog;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestTableGeneratorMultithreaded
extends SingleEMFTestCase {
    public final int ALLOC_SIZE = 100000;
    public final int INITIAL = 1;
    public final int LOOPS = 100000;
    public final int THREADS = 5;

    @Override
    public void setUp() {
        this.setUp(Dog.class, CLEAR_TABLES);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        MetaDataRepository repo = this.emf.getConfiguration().getMetaDataRepositoryInstance();
        repo.getMetaData(Dog.class, loader, true);
        repo.getSequenceMetaData("Dog_Gen", loader, true);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAllIdsAreUsed() throws Exception {
        ArrayList<WorkerThread> threads = new ArrayList<WorkerThread>();
        for (int i = 0; i < 5; ++i) {
            threads.add(new WorkerThread(this.emf));
        }
        for (Thread thread : threads) {
            thread.start();
        }
        long max = 0L;
        for (WorkerThread w : threads) {
            w.join();
            max = Math.max(max, (Long)w.getLast());
        }
        TestTableGeneratorMultithreaded.assertEquals((long)500000L, (long)max);
    }

    class WorkerThread
    extends Thread {
        Object _first = null;
        Object _last = null;
        int _count = 0;
        StoreContext _ctx;
        TableJDBCSeq _seq;
        ClassMetaData _cmd;
        EntityManagerImpl _em;
        MetaDataRepository _repo;

        public WorkerThread(OpenJPAEntityManagerFactorySPI emf) {
            this._repo = emf.getConfiguration().getMetaDataRepositoryInstance();
        }

        @Override
        public void run() {
            Object obj;
            ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
            SequenceMetaData meta = this._repo.getSequenceMetaData("Dog_Gen", contextLoader, true);
            meta.setInitialValue(1);
            meta.setIncrement(10000);
            this._em = (EntityManagerImpl)TestTableGeneratorMultithreaded.this.emf.createEntityManager();
            this._ctx = this._em.getBroker();
            this._cmd = this._repo.getMetaData(Dog.class, contextLoader, true);
            this._seq = (TableJDBCSeq)meta.getInstance(contextLoader);
            this._seq.setAllocate(100000);
            this._seq.setInitialValue(1);
            this._first = obj = this._seq.next(this._ctx, this._cmd);
            for (int i = 1; i < 100000; ++i) {
                obj = this._seq.next(this._ctx, this._cmd);
            }
            this._last = obj;
            this._em.close();
        }

        public Object getLast() {
            return this._last;
        }

        public Object getFirst() {
            return this._first;
        }

        public int getCount() {
            return this._count;
        }
    }
}

