/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.generationtype;

import javax.persistence.EntityExistsException;
import javax.persistence.EntityManager;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.PostgresDictionary;
import org.apache.openjpa.persistence.InvalidStateException;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.generationtype.GeneratedValues;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestGeneratedValues
extends SingleEMFTestCase {
    DBDictionary _dict;

    @Override
    public void setUp() {
        this.setUp(GeneratedValues.class, CLEAR_TABLES);
        this._dict = ((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance();
    }

    public void testDefaultValues() {
        if (this._dict instanceof PostgresDictionary) {
            return;
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        GeneratedValues gv = new GeneratedValues();
        GeneratedValues gv2 = new GeneratedValues();
        em.getTransaction().begin();
        em.persist((Object)gv);
        em.persist((Object)gv2);
        em.getTransaction().commit();
        em.refresh((Object)gv);
        em.refresh((Object)gv2);
        TestGeneratedValues.assertFalse((gv.getId() == gv2.getId() ? 1 : 0) != 0);
        TestGeneratedValues.assertFalse((gv.getField() == gv2.getField() ? 1 : 0) != 0);
        TestGeneratedValues.assertFalse((boolean)gv.getUuidhex().equals(gv2.getUuidhex()));
        TestGeneratedValues.assertFalse((boolean)gv.getUuidT4hex().equals(gv2.getUuidT4hex()));
        TestGeneratedValues.assertFalse((boolean)gv.getUuidT4string().equals(gv2.getUuidT4string()));
        this.closeEM((EntityManager)em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInitialValues() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        GeneratedValues gv = new GeneratedValues(7, 9L, "a", "b", "c", "d");
        try {
            em.getTransaction().begin();
            em.persist((Object)gv);
            em.getTransaction().commit();
        }
        catch (EntityExistsException | InvalidStateException ise) {
            return;
        }
        finally {
            this.closeEM((EntityManager)em);
        }
        TestGeneratedValues.fail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIdSetter() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        GeneratedValues gv = new GeneratedValues();
        gv.setId(3);
        try {
            em.getTransaction().begin();
            em.persist((Object)gv);
            em.getTransaction().commit();
        }
        catch (EntityExistsException | InvalidStateException ise) {
            return;
        }
        finally {
            this.closeEM((EntityManager)em);
        }
        TestGeneratedValues.fail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFieldSetter() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        GeneratedValues gv = new GeneratedValues();
        gv.setField(5L);
        try {
            em.getTransaction().begin();
            em.persist((Object)gv);
            em.getTransaction().commit();
        }
        catch (InvalidStateException ise) {
            return;
        }
        finally {
            this.closeEM((EntityManager)em);
        }
        TestGeneratedValues.fail();
    }

    public void testCustomSequenceGeneratorWithIndirection() {
        if (this._dict instanceof PostgresDictionary) {
            return;
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        GeneratedValues gv = new GeneratedValues();
        em.getTransaction().begin();
        em.persist((Object)gv);
        em.getTransaction().commit();
        TestGeneratedValues.assertNotEquals(0, gv.getCustomSeqWithIndirectionField());
        this.closeEM((EntityManager)em);
    }

    public void testUUIDGenerators() {
        if (this._dict instanceof PostgresDictionary) {
            return;
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        GeneratedValues gv = new GeneratedValues();
        em.getTransaction().begin();
        em.persist((Object)gv);
        em.getTransaction().commit();
        int id = gv.getId();
        TestGeneratedValues.assertTrue((boolean)this.isStringUUID(gv.getUuidT4string(), 4));
        TestGeneratedValues.assertTrue((boolean)this.isStringUUID(gv.getUuidstring(), 1));
        TestGeneratedValues.assertTrue((boolean)this.isHexUUID(gv.getUuidhex(), 1));
        TestGeneratedValues.assertTrue((boolean)this.isHexUUID(gv.getUuidT4hex(), 4));
        em.clear();
        GeneratedValues gv2 = (GeneratedValues)em.find(GeneratedValues.class, (Object)id);
        TestGeneratedValues.assertNotNull((Object)gv2);
        TestGeneratedValues.assertNotNull((Object)gv2.getUuidstring());
        TestGeneratedValues.assertTrue((boolean)this.isHexUUID(gv2.getUuidhex(), 1));
        TestGeneratedValues.assertNotNull((Object)gv2.getUuidT4string());
        TestGeneratedValues.assertTrue((boolean)this.isHexUUID(gv2.getUuidT4hex(), 4));
        TestGeneratedValues.assertTrue((gv.getId() == gv2.getId() ? 1 : 0) != 0);
        TestGeneratedValues.assertTrue((gv.getField() == gv2.getField() ? 1 : 0) != 0);
        TestGeneratedValues.assertTrue((boolean)gv.getUuidhex().equals(gv2.getUuidhex()));
        TestGeneratedValues.assertTrue((boolean)gv.getUuidT4hex().equals(gv2.getUuidT4hex()));
        this.closeEM((EntityManager)em);
    }

    private boolean isStringUUID(String value, int type) {
        if (value.length() != 16) {
            return false;
        }
        byte version = (byte)(value.charAt(6) >>> 4);
        return type == version;
    }

    private boolean isHexUUID(String value, int type) {
        if (value.length() != 32) {
            return false;
        }
        char[] chArr = value.toCharArray();
        for (int i = 0; i < 32; ++i) {
            char ch = chArr[i];
            if (!(Character.isDigit(ch) || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F')) {
                return false;
            }
            if (i != 12) continue;
            if (type == 1 && ch != '1') {
                return false;
            }
            if (type != 4 || ch == '4') continue;
            return false;
        }
        return true;
    }
}

