/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.flush;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.flush.Assignment;
import org.apache.openjpa.persistence.flush.ClassPeriod;
import org.apache.openjpa.persistence.flush.Course;
import org.apache.openjpa.persistence.flush.SubTopic;
import org.apache.openjpa.persistence.flush.Topic;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestCascadingFlush
extends SingleEMFTestCase {
    boolean supportsNativeSequence = false;

    @Override
    public void setUp() {
        this.setUp(Assignment.class, ClassPeriod.class, Course.class, SubTopic.class, Topic.class, CLEAR_TABLES);
        try {
            this.supportsNativeSequence = ((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance().nextSequenceQuery != null;
        }
        catch (Throwable t) {
            this.supportsNativeSequence = false;
        }
    }

    public void testCascadingFlushBasic() {
        if (!this.supportsNativeSequence) {
            return;
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Long courseId = TestCascadingFlush.populate((EntityManager)em);
        em.clear();
        Course course = (Course)em.find(Course.class, (Object)courseId);
        this.verifyCascadingFlush((EntityManager)em, course);
        em.close();
    }

    public void testCascadingFlushDetach() {
        if (!this.supportsNativeSequence) {
            return;
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Long courseId = TestCascadingFlush.populate((EntityManager)em);
        em.clear();
        Course tmpCourse = (Course)em.find(Course.class, (Object)courseId);
        Course course = (Course)OpenJPAPersistence.cast((EntityManager)em).detachCopy((Object)tmpCourse);
        TestCascadingFlush.assertNotEquals(course, tmpCourse);
        this.verifyCascadingFlush((EntityManager)em, course);
        em.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCascadingFlushSerialize() {
        if (!this.supportsNativeSequence) {
            return;
        }
        try (OpenJPAEntityManagerSPI em = this.emf.createEntityManager();){
            Long courseId = TestCascadingFlush.populate((EntityManager)em);
            em.clear();
            Course tmpCourse = (Course)em.find(Course.class, (Object)courseId);
            Course course = null;
            try {
                course = (Course)TestCascadingFlush.roundtrip(tmpCourse, false);
            }
            catch (Throwable t) {
                TestCascadingFlush.fail((String)"Failed to serialize and deserialize persistent object.");
            }
            TestCascadingFlush.assertNotEquals(course, tmpCourse);
            this.verifyCascadingFlush((EntityManager)em, course);
        }
    }

    private void verifyCascadingFlush(EntityManager em, Course course) {
        try {
            TestCascadingFlush.beginTx(em);
            TestCascadingFlush.addClassPeriod(course);
            Course course2 = (Course)em.merge((Object)course);
            em.flush();
            TestCascadingFlush.assertTrue((course2.getCourseId() > 0L ? 1 : 0) != 0);
            TestCascadingFlush.assertNotNull(course2.getClassPeriods());
            Set<ClassPeriod> cps = course2.getClassPeriods();
            TestCascadingFlush.assertTrue((cps.size() == 2 ? 1 : 0) != 0);
            for (ClassPeriod cp : cps) {
                TestCascadingFlush.assertNotNull((Object)cp);
                TestCascadingFlush.assertTrue((cp.getClassPeriodId() > 0L ? 1 : 0) != 0);
                TestCascadingFlush.assertEquals((Object)cp.getCourse(), (Object)course2);
                Set<Topic> topics = cp.getTopics();
                TestCascadingFlush.assertNotNull(topics);
                TestCascadingFlush.assertTrue((topics.size() > 0 ? 1 : 0) != 0);
                for (Topic t : topics) {
                    TestCascadingFlush.assertNotNull((Object)t);
                    TestCascadingFlush.assertTrue((t.getTopicId() > 0L ? 1 : 0) != 0);
                    Set<Assignment> assignments = t.getAssignments();
                    TestCascadingFlush.assertNotNull(assignments);
                    TestCascadingFlush.assertTrue((assignments.size() == 1 ? 1 : 0) != 0);
                    for (Assignment a : assignments) {
                        TestCascadingFlush.assertNotNull((Object)a);
                        TestCascadingFlush.assertTrue((a.getAssignmentId() > 0L ? 1 : 0) != 0);
                    }
                    Set<SubTopic> subTopics = t.getSubTopics();
                    TestCascadingFlush.assertNotNull(subTopics);
                    TestCascadingFlush.assertTrue((subTopics.size() == 1 ? 1 : 0) != 0);
                    for (SubTopic s : subTopics) {
                        TestCascadingFlush.assertNotNull((Object)s);
                        TestCascadingFlush.assertTrue((s.getSubtopicId() > 0L ? 1 : 0) != 0);
                    }
                }
            }
            TestCascadingFlush.commitTx(em);
        }
        catch (Exception e) {
            e.printStackTrace();
            em.getTransaction().rollback();
            TestCascadingFlush.fail();
        }
    }

    public static Long populate(EntityManager em) {
        TestCascadingFlush.beginTx(em);
        Course course = TestCascadingFlush.createNewCourse();
        em.persist((Object)course);
        em.flush();
        TestCascadingFlush.commitTx(em);
        return course.getCourseId();
    }

    public static Course createNewCourse() {
        Course course = new Course();
        course.setCourseText("Nuclear Physics");
        Assignment assignment1 = new Assignment();
        assignment1.setAssignmentText("Lab: Nuclear Fusion");
        HashSet<Assignment> assignments = new HashSet<Assignment>();
        assignments.add(assignment1);
        SubTopic subtopic1 = new SubTopic();
        subtopic1.setSubtopicText("Nuclear Fusion");
        HashSet<SubTopic> subtopics = new HashSet<SubTopic>();
        subtopics.add(subtopic1);
        Topic topic1 = new Topic();
        topic1.setTopicText("Fundamentals of Nuclear Energy");
        topic1.setAssignments(assignments);
        topic1.setSubTopics(subtopics);
        assignment1.setTopic(topic1);
        subtopic1.setTopic(topic1);
        HashSet<Topic> topics = new HashSet<Topic>();
        topics.add(topic1);
        ClassPeriod cp1 = new ClassPeriod();
        cp1.setClassPeriodText("8844: M,W,Th 8:00AM");
        cp1.setTopics(topics);
        cp1.setCourse(course);
        topic1.setClassPeriod(cp1);
        HashSet<ClassPeriod> cps = new HashSet<ClassPeriod>();
        cps.add(cp1);
        course.setClassPeriods(cps);
        return course;
    }

    public static void addClassPeriod(Course course) {
        Assignment assignment = new Assignment();
        assignment.setAssignmentText("Read pages 442-645");
        HashSet<Assignment> assignments = new HashSet<Assignment>();
        assignments.add(assignment);
        SubTopic subTopic = new SubTopic();
        subTopic.setSubtopicText("Newton");
        HashSet<SubTopic> subTopics = new HashSet<SubTopic>();
        subTopics.add(subTopic);
        Topic topic = new Topic();
        topic.setTopicText("Gravity");
        topic.setSubTopics(subTopics);
        topic.setAssignments(assignments);
        assignment.setTopic(topic);
        subTopic.setTopic(topic);
        HashSet<Topic> topics = new HashSet<Topic>();
        topics.add(topic);
        Assignment assignment2 = new Assignment();
        assignment2.setAssignmentText("Read pages 645-785");
        HashSet<Assignment> assignments2 = new HashSet<Assignment>();
        assignments2.add(assignment2);
        SubTopic subTopic2 = new SubTopic();
        subTopic2.setSubtopicText("Forces");
        HashSet<SubTopic> subTopics2 = new HashSet<SubTopic>();
        subTopics2.add(subTopic2);
        Topic topic2 = new Topic();
        topic2.setTopicText("Magnetism");
        topic2.setSubTopics(subTopics2);
        topic2.setAssignments(assignments2);
        subTopic2.setTopic(topic);
        subTopic2.setTopic(topic);
        topics.add(topic2);
        ClassPeriod cp2 = new ClassPeriod();
        cp2.setClassPeriodText("8846: M,W,Th 11:00AM");
        cp2.setTopics(topics);
        cp2.setCourse(course);
        topic.setClassPeriod(cp2);
        topic2.setClassPeriod(cp2);
        course.getClassPeriods().add(cp2);
    }

    private static void beginTx(EntityManager em) {
        em.getTransaction().begin();
    }

    private static void commitTx(EntityManager em) {
        em.getTransaction().commit();
    }

    public static Object roundtrip(Object orig, boolean validateEquality) throws IOException, ClassNotFoundException {
        TestCascadingFlush.assertNotNull((Object)orig);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bout);
        out.writeObject(orig);
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bin);
        Object result = in.readObject();
        if (validateEquality) {
            TestCascadingFlush.assertEquals((int)orig.hashCode(), (int)result.hashCode());
            TestCascadingFlush.assertEquals((Object)orig, (Object)result);
        }
        return result;
    }
}

