/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.fields;

import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.fields.EnumFieldType;
import org.apache.openjpa.persistence.fields.SampleEnum;
import org.apache.openjpa.persistence.test.SingleEMTestCase;

public class TestEnumsInJPQL
extends SingleEMTestCase {
    @Override
    public void setUp() {
        this.setUp(EnumFieldType.class, CLEAR_TABLES);
        EnumFieldType o = new EnumFieldType();
        o.setEnumField(SampleEnum.BAR);
        o.getEnumList().add(SampleEnum.FOO);
        this.em.getTransaction().begin();
        this.em.persist((Object)o);
        this.em.getTransaction().commit();
        this.em.close();
        this.em = this.emf.createEntityManager();
    }

    public void testEnumLiteralInSelect() {
        OpenJPAQuery q = this.em.createQuery("select count(o) from EnumFieldType o where o.enumField = org.apache.openjpa.persistence.fields.SampleEnum.BAR");
        TestEnumsInJPQL.assertEquals((int)1, (int)((Number)q.getSingleResult()).intValue());
    }

    public void testEnumLiteralInSetInUpdate() {
        this.testEnumLiteralInSelect();
        this.em.getTransaction().begin();
        OpenJPAQuery q = this.em.createQuery("update EnumFieldType o set o.enumField = org.apache.openjpa.persistence.fields.SampleEnum.BAZ");
        TestEnumsInJPQL.assertEquals((int)1, (int)q.executeUpdate());
        this.em.getTransaction().commit();
        this.postUpdateCheck(true);
    }

    public void testEnumLiteralInWhereInUpdate() {
        this.testEnumLiteralInSelect();
        this.em.getTransaction().begin();
        OpenJPAQuery q = this.em.createQuery("update EnumFieldType o set o.intField = 3 where o.enumField = org.apache.openjpa.persistence.fields.SampleEnum.BAR");
        TestEnumsInJPQL.assertEquals((int)1, (int)q.executeUpdate());
        this.em.getTransaction().commit();
        this.postUpdateCheck(false);
    }

    private void postUpdateCheck(boolean wasEnumModified) {
        OpenJPAQuery q = this.em.createQuery("select count(o) from EnumFieldType o where o.enumField = org.apache.openjpa.persistence.fields.SampleEnum.BAR");
        TestEnumsInJPQL.assertEquals((int)(wasEnumModified ? 0 : 1), (int)((Number)q.getSingleResult()).intValue());
        q = this.em.createQuery("select count(o) from EnumFieldType o where o.enumField = org.apache.openjpa.persistence.fields.SampleEnum.BAZ");
        TestEnumsInJPQL.assertEquals((int)(wasEnumModified ? 1 : 0), (int)((Number)q.getSingleResult()).intValue());
    }

    public void testEnumPositionalParamInSelect() {
        OpenJPAQuery q = this.em.createQuery("select count(o) from EnumFieldType o where o.enumField = ?1");
        q.setParameter(1, (Object)SampleEnum.BAR);
        TestEnumsInJPQL.assertEquals((int)1, (int)((Number)q.getSingleResult()).intValue());
    }

    public void testEnumNamedParamInSelect() {
        OpenJPAQuery q = this.em.createQuery("select count(o) from EnumFieldType o where o.enumField = :e");
        q.setParameter("e", (Object)SampleEnum.BAR);
        TestEnumsInJPQL.assertEquals((int)1, (int)((Number)q.getSingleResult()).intValue());
    }

    public void testEnumParamInSetInUpdate() {
        this.testEnumLiteralInSelect();
        this.em.getTransaction().begin();
        OpenJPAQuery q = this.em.createQuery("update EnumFieldType o set o.enumField = :e");
        q.setParameter("e", (Object)SampleEnum.BAZ);
        TestEnumsInJPQL.assertEquals((int)1, (int)q.executeUpdate());
        this.em.getTransaction().commit();
        this.postUpdateCheck(true);
    }

    public void testEnumParamInWhereInUpdate() {
        this.testEnumLiteralInSelect();
        this.em.getTransaction().begin();
        OpenJPAQuery q = this.em.createQuery("update EnumFieldType o set o.intField = 3 where o.enumField = :e");
        q.setParameter("e", (Object)SampleEnum.BAR);
        TestEnumsInJPQL.assertEquals((int)1, (int)q.executeUpdate());
        this.em.getTransaction().commit();
        this.postUpdateCheck(false);
    }

    public void testMemberOf() {
        TestEnumsInJPQL.assertEquals((Object)1L, (Object)this.em.createQuery("select count(o) from EnumFieldType o where (:param member of o.enumList or :param2 member of o.enumList)").setParameter("param", (Object)SampleEnum.FOO).setParameter("param2", (Object)SampleEnum.BAR).getSingleResult());
    }
}

