/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.exception;

import java.io.InputStream;
import java.sql.SQLException;
import java.util.List;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityNotFoundException;
import javax.persistence.OptimisticLockException;
import javax.persistence.Query;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.SQLErrorCodeReader;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.exception.PObject;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestException
extends SingleEMFTestCase {
    private static long ID_COUNTER = System.currentTimeMillis();

    @Override
    public void setUp() {
        super.setUp(PObject.class, CLEAR_TABLES);
    }

    public void disabledTestThrowsOptimisticException() {
        boolean supportsQueryTimeout = ((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance().supportsQueryTimeout;
        OpenJPAEntityManagerSPI em1 = this.emf.createEntityManager();
        OpenJPAEntityManagerSPI em2 = this.emf.createEntityManager();
        TestException.assertNotEquals(em1, em2);
        em1.getTransaction().begin();
        PObject pc = new PObject();
        long id = ++ID_COUNTER;
        pc.setId(id);
        em1.persist((Object)pc);
        em1.getTransaction().commit();
        em1.clear();
        em1.getTransaction().begin();
        em2.getTransaction().begin();
        PObject pc1 = (PObject)em1.find(PObject.class, (Object)id);
        PObject pc2 = (PObject)em2.find(PObject.class, (Object)id);
        TestException.assertTrue((pc1 != pc2 ? 1 : 0) != 0);
        pc1.setName("Modified in TXN1");
        if (supportsQueryTimeout) {
            em1.flush();
            try {
                pc2.setName("Modified in TXN2");
                em2.flush();
                TestException.fail((String)("Expected " + OptimisticLockException.class));
            }
            catch (Throwable t) {
                this.assertException(t, (Class)OptimisticLockException.class);
            }
        } else {
            pc2.setName("Modified in TXN2");
        }
        em1.getTransaction().commit();
        try {
            em2.getTransaction().commit();
            TestException.fail((String)("Expected " + OptimisticLockException.class));
        }
        catch (Throwable t) {
            this.assertException(t, (Class)OptimisticLockException.class);
        }
    }

    public void testThrowsEntityExistsException() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        PObject pc = new PObject();
        long id = ++ID_COUNTER;
        pc.setId(id);
        em.persist((Object)pc);
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        PObject pc2 = new PObject();
        pc2.setId(id);
        em.persist((Object)pc2);
        try {
            em.getTransaction().commit();
            TestException.fail((String)("Expected " + EntityExistsException.class));
        }
        catch (Throwable t) {
            this.assertException(t, (Class)EntityExistsException.class);
        }
        em.close();
    }

    public void testThrowsEntityNotFoundException() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        PObject pc = new PObject();
        long id = ++ID_COUNTER;
        pc.setId(id);
        em.persist((Object)pc);
        em.getTransaction().commit();
        OpenJPAEntityManagerSPI em2 = this.emf.createEntityManager();
        em2.getTransaction().begin();
        PObject pc2 = (PObject)em2.find(PObject.class, (Object)id);
        TestException.assertNotNull((Object)pc2);
        em2.remove((Object)pc2);
        em2.getTransaction().commit();
        try {
            em.refresh((Object)pc);
            TestException.fail((String)("Expected " + EntityNotFoundException.class));
        }
        catch (Throwable t) {
            this.assertException(t, (Class)EntityNotFoundException.class);
        }
        em.close();
    }

    public void testErrorCodeConfigurationHasAllKnownDictionaries() {
        SQLErrorCodeReader reader = new SQLErrorCodeReader();
        InputStream in = DBDictionary.class.getResourceAsStream("sql-error-state-codes.xml");
        TestException.assertNotNull((Object)in);
        List names = reader.getDictionaries(in);
        TestException.assertTrue((names.size() >= 18 ? 1 : 0) != 0);
        for (String name : names) {
            try {
                Class.forName(name, false, Thread.currentThread().getContextClassLoader());
            }
            catch (Throwable t) {
                TestException.fail((String)("DB dictionary " + name + " can not be loaded"));
                t.printStackTrace();
            }
        }
    }

    public void testIllegalArgumennExceptionOnInvalidQuery() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            em.createQuery("This is not a valid JPQL query");
            TestException.fail((String)"Did not throw IllegalArgumentException for invalid query.");
        }
        catch (Throwable t) {
            this.assertException(t, (Class)IllegalArgumentException.class);
        }
        em.close();
    }

    public void testIllegalArgumennExceptionOnInvalidNamedQuery() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            Query query = em.createNamedQuery("This is invalid Named query");
            TestException.fail((String)"Did not throw IllegalArgumentException for invalid query.");
        }
        catch (Throwable t) {
            this.assertException(t, (Class)IllegalArgumentException.class);
        }
        em.close();
    }

    public void assertException(Throwable t, Class expectedType) {
        if (!this.isExpectedException(t, expectedType)) {
            this.getLog().error((Object)"TestException.assertException() - unexpected exception type", t);
            this.print(t, 0);
            TestException.fail((String)(t + " or its cause is not instanceof " + expectedType));
        } else if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)("TestException.assertException() - caught expected exception type=" + expectedType), t);
        }
    }

    boolean isExpectedException(Throwable t, Class expectedType) {
        if (t == null) {
            return false;
        }
        if (expectedType.isAssignableFrom(t.getClass())) {
            return true;
        }
        return this.isExpectedException(t.getCause(), expectedType);
    }

    void print(Throwable t, int tab) {
        if (t == null) {
            return;
        }
        StringBuilder str = new StringBuilder(80);
        for (int i = 0; i < tab * 4; ++i) {
            str.append(" ");
        }
        String sqlState = t instanceof SQLException ? "(SQLState=" + ((SQLException)t).getSQLState() + ":" + t.getMessage() + ")" : "";
        str.append(t.getClass().getName() + sqlState);
        this.getLog().error((Object)str);
        if (t.getCause() == t) {
            return;
        }
        this.print(t.getCause(), tab + 1);
    }
}

