/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.event;

import java.util.Collection;
import java.util.HashMap;
import javax.persistence.EntityManager;
import org.apache.openjpa.event.RemoteCommitEvent;
import org.apache.openjpa.event.RemoteCommitListener;
import org.apache.openjpa.event.TCPRemoteCommitProvider;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.event.common.apps.Duration;
import org.apache.openjpa.persistence.event.common.apps.RuntimeTest1;
import org.apache.openjpa.persistence.test.AllowFailure;

@AllowFailure(message="surefire excluded")
public class TestTCPRemoteEventsDuration
extends AbstractTestCase {
    private static final int NUM_OBJECTS = 200;
    private static final int NUM_TO_AVERAGE = 3;
    private static final int NUM_CONCURRENT = 3;
    static int _fetchGroupSerial = 0;

    public TestTCPRemoteEventsDuration(String s) {
        super(s, "eventcactusapp");
    }

    public void setUp() {
        this.deleteAll(RuntimeTest1.class);
    }

    public void tearDownTestClass() throws Exception {
    }

    public void testDurationDifference() {
        int i;
        OpenJPAEntityManagerFactory factorySingle = this.createDistinctFactory(null, "");
        OpenJPAEntityManager pmSingle = factorySingle.createEntityManager();
        OpenJPAEntityManagerFactory senderFactory1TCP = this.createDistinctFactory(TCPRemoteCommitProvider.class, "MaxTotal=4, RecoveryTimeMillis=1000, Port=5636, Addresses=127.0.0.1:5636;127.0.0.1:6636");
        OpenJPAEntityManagerFactory factory2TCP = this.createDistinctFactory(TCPRemoteCommitProvider.class, "Port=6636, Addresses=127.0.0.1:6636;127.0.0.1:5636");
        RemoteCommitListenerTestImpl listenerAtReceiver = new RemoteCommitListenerTestImpl();
        ((OpenJPAEntityManagerFactorySPI)factory2TCP).getConfiguration().getRemoteCommitEventManager().addListener((RemoteCommitListener)listenerAtReceiver);
        System.out.println("-------------------");
        System.out.println("3 PMFs created, 1 as standalone, and 2 acting as a cluster using ports 5636 and 6636");
        this.doTransactions((EntityManager)pmSingle, 200);
        double benchmarkSingle = 0.0;
        for (int i2 = 0; i2 < 3; ++i2) {
            benchmarkSingle += this.doTransactions((EntityManager)pmSingle, 200);
        }
        benchmarkSingle /= 3.0;
        OpenJPAEntityManager pmOneThread = senderFactory1TCP.createEntityManager();
        double benchmarkClusterOneThread = this.doTransactions((EntityManager)pmOneThread, 200);
        pmOneThread.close();
        Duration timeThreaded = new Duration("For 3 concurrent threads performing Adds, removes, and dletes for 200 objects.");
        Thread[] concurrentThreads = new Thread[3];
        timeThreaded.start();
        for (i = 0; i < 3; ++i) {
            Worker worker = new Worker((EntityManager)senderFactory1TCP.createEntityManager());
            concurrentThreads[i] = new Thread(worker);
            concurrentThreads[i].start();
        }
        for (i = 0; i < 3; ++i) {
            try {
                concurrentThreads[i].join();
                continue;
            }
            catch (Exception e) {
                TestTCPRemoteEventsDuration.assertTrue((boolean)false);
                break;
            }
        }
        timeThreaded.stop();
        double benchmarkCluster = timeThreaded.getDurationAsSeconds();
        System.out.println("For 200 objects, and 3 concurrent threads, the receiving pmf of the cluster received :" + listenerAtReceiver.totalAddedClasses + " claases adds, " + listenerAtReceiver.totalDeleted + " deletes, " + listenerAtReceiver.totalUpdated + " updates");
        System.out.println("\nSingle pmf - " + benchmarkSingle + "(s).\n Clustered pmfs (one worker thread) -" + benchmarkClusterOneThread + "(s).\n Clustered pmfs (" + 3 + " threads - " + benchmarkCluster + "(s).\n");
        Thread.currentThread();
        Thread.yield();
        try {
            Thread.currentThread();
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            TestTCPRemoteEventsDuration.fail((String)"unexecpted exception during pause");
        }
        TestTCPRemoteEventsDuration.assertEquals((int)800, (int)listenerAtReceiver.totalAddedClasses);
        TestTCPRemoteEventsDuration.assertEquals((int)800, (int)listenerAtReceiver.totalDeleted);
        TestTCPRemoteEventsDuration.assertEquals((int)800, (int)listenerAtReceiver.totalUpdated);
        pmSingle.close();
        factorySingle.close();
        factory2TCP.close();
        senderFactory1TCP.close();
    }

    protected double doTransactions(EntityManager pm, int numObjects) {
        Duration timeToAMD = new Duration("Adds, removes, and dletes for " + numObjects + " objects.");
        timeToAMD.start();
        RuntimeTest1[] persistables = new RuntimeTest1[numObjects];
        for (int i = 0; i < persistables.length; ++i) {
            persistables[i] = new RuntimeTest1("foo #" + i, i);
        }
        for (RuntimeTest1 runtimeTest1 : persistables) {
            this.startTx(pm);
            pm.persist((Object)runtimeTest1);
            this.endTx(pm);
        }
        this.startTx(pm);
        for (int i = 0; i < persistables.length; ++i) {
            persistables[i].setStringField("bazzed" + i);
        }
        this.endTx(pm);
        this.startTx(pm);
        for (RuntimeTest1 persistable : persistables) {
            pm.remove((Object)persistable);
        }
        this.endTx(pm);
        timeToAMD.stop();
        return timeToAMD.getDurationAsSeconds();
    }

    protected OpenJPAEntityManagerFactory createDistinctFactory(Class providerClass, String classProps1) {
        HashMap<String, String> propsMap;
        String transmit = "TransmitPersistedObjectIds=true";
        classProps1 = classProps1 == null || classProps1.length() == 0 ? transmit : classProps1 + "," + transmit;
        if (providerClass != null) {
            propsMap = new HashMap<String, String>();
            propsMap.put("openjpa.RemoteCommitProvider", Configurations.getPlugin((String)providerClass.getName(), (String)classProps1));
            propsMap.put("openjpa.FetchGroups", "differentiatingFetchGroup" + _fetchGroupSerial);
        } else {
            propsMap = new HashMap();
            propsMap.put("openjpa.RemoteCommitProvider", "sjvm(TransmitPersistedObjectIds=true)");
            propsMap.put("openjpa.FetchGroups", "differentiatingFetchGroup" + _fetchGroupSerial);
        }
        ++_fetchGroupSerial;
        return this.getEmf(propsMap);
    }

    protected static class RemoteCommitListenerTestImpl
    implements RemoteCommitListener {
        Collection addClasses;
        Collection added;
        Collection updated;
        Collection deleted;
        int totalAddedClasses;
        int totalUpdated;
        int totalDeleted;

        protected RemoteCommitListenerTestImpl() {
        }

        public synchronized void afterCommit(RemoteCommitEvent event) {
            this.addClasses = event.getPersistedTypeNames();
            this.updated = event.getUpdatedObjectIds();
            this.deleted = event.getDeletedObjectIds();
            this.totalAddedClasses += this.addClasses.size();
            this.totalUpdated += this.updated.size();
            this.totalDeleted += this.deleted.size();
        }

        public void close() {
        }
    }

    private class Worker
    implements Runnable {
        private EntityManager _pm;

        public Worker(EntityManager pm) {
            this._pm = pm;
        }

        @Override
        public void run() {
            TestTCPRemoteEventsDuration.this.doTransactions(this._pm, 200);
            TestTCPRemoteEventsDuration.this.endEm(this._pm);
        }
    }
}

