/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.event;

import java.util.Collection;
import java.util.Collections;
import javax.persistence.EntityManager;
import junit.framework.AssertionFailedError;
import org.apache.openjpa.event.TransactionEvent;
import org.apache.openjpa.event.TransactionListener;
import org.apache.openjpa.persistence.CallbackMode;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.event.common.apps.RuntimeTest1;
import org.apache.openjpa.persistence.test.AllowFailure;

@AllowFailure(message="surefire excluded")
public class TestEvents
extends AbstractTestCase {
    private TransactionEventListenerTestImpl transactionListener;

    public TestEvents(String s) {
        super(s, "eventcactusapp");
    }

    public void setUp() {
        this.transactionListener = new TransactionEventListenerTestImpl();
        this.deleteAll(RuntimeTest1.class);
    }

    public void testCommit() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        ((OpenJPAEntityManagerSPI)pm).addTransactionListener((Object)this.transactionListener);
        TestEvents.assertEquals((int)0, (int)this.transactionListener.status);
        RuntimeTest1 t1 = new RuntimeTest1("foo", 5);
        this.startTx((EntityManager)pm);
        TestEvents.assertEquals((int)TransactionEventListenerTestImpl.STARTED, (int)this.transactionListener.status);
        pm.persist((Object)t1);
        this.endTx((EntityManager)pm);
        TestEvents.assertEquals((int)(TransactionEventListenerTestImpl.STARTED | TransactionEventListenerTestImpl.COMMIT_BEGUN | TransactionEventListenerTestImpl.COMMITTED), (int)this.transactionListener.status);
    }

    public void testRollback() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        ((OpenJPAEntityManagerSPI)pm).addTransactionListener((Object)this.transactionListener);
        TestEvents.assertEquals((int)0, (int)this.transactionListener.status);
        RuntimeTest1 t1 = new RuntimeTest1("foo", 5);
        this.startTx((EntityManager)pm);
        TestEvents.assertEquals((int)TransactionEventListenerTestImpl.STARTED, (int)this.transactionListener.status);
        pm.persist((Object)t1);
        this.rollbackTx((EntityManager)pm);
        TestEvents.assertEquals((int)(TransactionEventListenerTestImpl.STARTED | TransactionEventListenerTestImpl.ROLLEDBACK), (int)this.transactionListener.status);
    }

    public void testObjectChanges() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        ((OpenJPAEntityManagerSPI)pm).addTransactionListener((Object)this.transactionListener);
        RuntimeTest1 t1 = new RuntimeTest1("t1", 0);
        RuntimeTest1 t2 = new RuntimeTest1("t2", 1);
        this.startTx((EntityManager)pm);
        pm.persist((Object)t1);
        pm.persist((Object)t2);
        this.endTx((EntityManager)pm);
        this.transactionListener.status = 0;
        this.startTx((EntityManager)pm);
        RuntimeTest1 t3 = new RuntimeTest1("t3", 3);
        pm.persist((Object)t3);
        t1.setStringField("baz");
        pm.remove((Object)t2);
        this.endTx((EntityManager)pm);
        TestEvents.assertEquals((int)3, (int)this.transactionListener.trans.size());
        TestEvents.assertTrue((boolean)this.transactionListener.trans.contains(t1));
        TestEvents.assertTrue((boolean)this.transactionListener.trans.contains(t2));
        TestEvents.assertTrue((boolean)this.transactionListener.trans.contains(t3));
    }

    public void testIgnoreCallbackModeExceptionConsumed() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        ((OpenJPAEntityManagerSPI)pm).addTransactionListener((Object)this.transactionListener);
        ((OpenJPAEntityManagerSPI)pm).setTransactionListenerCallbackMode(CallbackMode.IGNORE);
        this.transactionListener.exception = TransactionEventListenerTestImpl.EXCEPTION;
        RuntimeTest1 t1 = new RuntimeTest1("foo", 5);
        this.startTx((EntityManager)pm);
        TestEvents.assertEquals((int)TransactionEventListenerTestImpl.STARTED, (int)this.transactionListener.status);
        pm.persist((Object)t1);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        TestEvents.assertEquals((int)(TransactionEventListenerTestImpl.STARTED | TransactionEventListenerTestImpl.COMMIT_BEGUN | TransactionEventListenerTestImpl.COMMITTED), (int)this.transactionListener.status);
    }

    public void testExceptionCausesRollback() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        ((OpenJPAEntityManagerSPI)pm).addTransactionListener((Object)this.transactionListener);
        this.transactionListener.exception = TransactionEventListenerTestImpl.EXCEPTION;
        RuntimeTest1 t1 = new RuntimeTest1("foo", 5);
        this.startTx((EntityManager)pm);
        TestEvents.assertEquals((int)TransactionEventListenerTestImpl.STARTED, (int)this.transactionListener.status);
        pm.persist((Object)t1);
        try {
            this.endTx((EntityManager)pm);
            TestEvents.fail((String)"Commit should have caused exception.");
        }
        catch (AssertionFailedError afe) {
            this.bug(1139, afe, "Listener exceptions being swallowed");
            return;
        }
        catch (Exception je) {
            TestEvents.assertEquals((String)"xxx", (String)je.getMessage());
        }
        TestEvents.assertTrue((!this.isActiveTx((EntityManager)pm) ? 1 : 0) != 0);
        this.endEm((EntityManager)pm);
        TestEvents.assertEquals((int)(TransactionEventListenerTestImpl.STARTED | TransactionEventListenerTestImpl.COMMIT_BEGUN | TransactionEventListenerTestImpl.ROLLEDBACK), (int)this.transactionListener.status);
    }

    public void testExceptionAfterCommitThrown() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        ((OpenJPAEntityManagerSPI)pm).addTransactionListener((Object)this.transactionListener);
        this.transactionListener.exception = TransactionEventListenerTestImpl.EXCEPTION_AFTER;
        RuntimeTest1 t1 = new RuntimeTest1("foo", 5);
        this.startTx((EntityManager)pm);
        TestEvents.assertEquals((int)TransactionEventListenerTestImpl.STARTED, (int)this.transactionListener.status);
        pm.persist((Object)t1);
        try {
            this.endTx((EntityManager)pm);
            TestEvents.fail((String)"Commit should have caused exception.");
        }
        catch (AssertionFailedError afe) {
            this.bug(1139, afe, "Listener exceptions being swallowed");
        }
        catch (Exception je) {
            TestEvents.assertEquals((String)"xxx", (String)je.getMessage());
        }
        TestEvents.assertFalse((boolean)this.isActiveTx((EntityManager)pm));
        this.endEm((EntityManager)pm);
        TestEvents.assertEquals((int)(TransactionEventListenerTestImpl.STARTED | TransactionEventListenerTestImpl.COMMIT_BEGUN | TransactionEventListenerTestImpl.COMMITTED), (int)this.transactionListener.status);
    }

    private static class TransactionEventListenerTestImpl
    implements TransactionListener {
        static int STARTED = 1;
        static int COMMITTED = 2;
        static int ROLLEDBACK = 4;
        static int COMMIT_BEGUN = 8;
        static int EXCEPTION = 1;
        static int EXCEPTION_AFTER = 2;
        int exception;
        int status;
        Collection trans = Collections.EMPTY_LIST;

        private TransactionEventListenerTestImpl() {
        }

        public void afterBegin(TransactionEvent event) {
            this.status |= STARTED;
        }

        public void beforeFlush(TransactionEvent event) {
        }

        public void afterFlush(TransactionEvent event) {
        }

        public void beforeCommit(TransactionEvent event) {
            this.status |= COMMIT_BEGUN;
            this.trans = event.getTransactionalObjects();
            if (this.exception == EXCEPTION) {
                throw new RuntimeException("xxx");
            }
        }

        public void afterCommit(TransactionEvent event) {
            this.status |= COMMITTED;
            if (this.exception == EXCEPTION_AFTER) {
                throw new RuntimeException("xxx");
            }
        }

        public void afterRollback(TransactionEvent event) {
            this.status |= ROLLEDBACK;
        }

        public void afterStateTransitions(TransactionEvent event) {
        }

        public void afterCommitComplete(TransactionEvent event) {
        }

        public void afterRollbackComplete(TransactionEvent event) {
        }
    }
}

