/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.entityoperation;

import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.entityoperation.common.apps.CascadesEntity;

public class TestCascades
extends AbstractTestCase {
    public TestCascades(String name) {
        super(name, "entityopcactusapp");
    }

    public void setUp() {
        this.deleteAll(CascadesEntity.class);
    }

    public void testNoCascadePersist() {
        CascadesEntity ent = new CascadesEntity();
        CascadesEntity rel = new CascadesEntity();
        ent.setNone(rel);
        ent.getNoneCollection().add(rel);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persist((Object)ent);
        TestCascades.assertTrue((boolean)em.isPersistent((Object)ent));
        TestCascades.assertFalse((boolean)em.isPersistent((Object)rel));
        this.rollbackTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testCascadePersistIsImmediate() {
        CascadesEntity ent = new CascadesEntity();
        CascadesEntity rel1 = new CascadesEntity();
        CascadesEntity rel2 = new CascadesEntity();
        ent.setAll(rel1);
        ent.getAllCollection().add(rel2);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persist((Object)ent);
        TestCascades.assertTrue((boolean)em.isPersistent((Object)ent));
        TestCascades.assertTrue((boolean)em.isPersistent((Object)rel1));
        TestCascades.assertTrue((boolean)em.isPersistent((Object)rel2));
        this.rollbackTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testNoCascadePersistFlushWithDeletedCausesException() {
        CascadesEntity rel = new CascadesEntity();
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persist((Object)rel);
        this.endTx((EntityManager)em);
        long id = rel.getId();
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        rel = (CascadesEntity)em.find(CascadesEntity.class, (Object)id);
        TestCascades.assertNotNull((Object)rel);
        CascadesEntity ent = new CascadesEntity();
        ent.setNone(rel);
        this.startTx((EntityManager)em);
        em.remove((Object)rel);
        em.persist((Object)ent);
        try {
            this.endTx((EntityManager)em);
            TestCascades.fail((String)"Allowed flush with deleted object in non-cascade-persist relation field");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestCascades.assertTrue((!em.getTransaction().isActive() ? 1 : 0) != 0);
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        rel = (CascadesEntity)em.find(CascadesEntity.class, (Object)id);
        TestCascades.assertNotNull((Object)rel);
        ent = new CascadesEntity();
        ent.getNoneCollection().add(rel);
        this.startTx((EntityManager)em);
        em.remove((Object)rel);
        em.persist((Object)ent);
        try {
            this.endTx((EntityManager)em);
            TestCascades.fail((String)"Allowed flush with deleted object in non-cascade-persist relation field");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestCascades.assertTrue((!em.getTransaction().isActive() ? 1 : 0) != 0);
        this.endEm((EntityManager)em);
    }

    public void testCascadePersistFlushWithDeleted() {
        CascadesEntity rel = new CascadesEntity();
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persist((Object)rel);
        this.endTx((EntityManager)em);
        long id = rel.getId();
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        rel = (CascadesEntity)em.find(CascadesEntity.class, (Object)id);
        TestCascades.assertNotNull((Object)rel);
        CascadesEntity ent = new CascadesEntity();
        ent.setAll(rel);
        this.startTx((EntityManager)em);
        em.remove((Object)rel);
        em.persist((Object)ent);
        this.endTx((EntityManager)em);
        TestCascades.assertTrue((!em.getTransaction().isActive() ? 1 : 0) != 0);
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        rel = (CascadesEntity)em.find(CascadesEntity.class, (Object)id);
        TestCascades.assertNotNull((Object)rel);
        ent = new CascadesEntity();
        ent.getAllCollection().add(rel);
        this.startTx((EntityManager)em);
        em.remove((Object)rel);
        em.persist((Object)ent);
        this.endTx((EntityManager)em);
        TestCascades.assertTrue((!em.getTransaction().isActive() ? 1 : 0) != 0);
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        rel = (CascadesEntity)em.find(CascadesEntity.class, (Object)id);
        TestCascades.assertNotNull((Object)rel);
        this.endEm((EntityManager)em);
    }

    public void testNoCascadePersistFlushWithTransientCausesException() {
        CascadesEntity ent = new CascadesEntity();
        CascadesEntity rel = new CascadesEntity();
        ent.setNone(rel);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persist((Object)ent);
        try {
            this.endTx((EntityManager)em);
            TestCascades.fail((String)"Allowed flush with transient object in non-cascade-persist relation field");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestCascades.assertTrue((!em.getTransaction().isActive() ? 1 : 0) != 0);
        this.endEm((EntityManager)em);
        ent = new CascadesEntity();
        rel = new CascadesEntity();
        ent.getNoneCollection().add(rel);
        em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persist((Object)ent);
        try {
            this.endTx((EntityManager)em);
            TestCascades.fail((String)"Allowed flush with transient object in non-cascade-persist relation field");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestCascades.assertTrue((!em.getTransaction().isActive() ? 1 : 0) != 0);
        this.endEm((EntityManager)em);
    }

    public void testNoCascadePersistFlushWithPersistent() {
        CascadesEntity ent = new CascadesEntity();
        CascadesEntity rel = new CascadesEntity();
        ent.setNone(rel);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persist((Object)ent);
        TestCascades.assertFalse((boolean)em.isPersistent((Object)rel));
        em.persist((Object)rel);
        this.endTx((EntityManager)em);
        long id = rel.getId();
        this.endEm((EntityManager)em);
        ent = new CascadesEntity();
        rel = new CascadesEntity();
        ent.getNoneCollection().add(rel);
        em = this.currentEntityManager();
        TestCascades.assertNotNull((Object)em.find(CascadesEntity.class, (Object)id));
        this.startTx((EntityManager)em);
        em.persist((Object)ent);
        TestCascades.assertFalse((boolean)em.isPersistent((Object)rel));
        em.persist((Object)rel);
        this.endTx((EntityManager)em);
        id = rel.getId();
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        TestCascades.assertNotNull((Object)em.find(CascadesEntity.class, (Object)id));
        this.endEm((EntityManager)em);
    }

    public void testCascadePersistFlushWithTransient() {
        CascadesEntity ent = new CascadesEntity();
        CascadesEntity rel = new CascadesEntity();
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persist((Object)ent);
        ent.setAll(rel);
        TestCascades.assertFalse((boolean)em.isPersistent((Object)rel));
        this.endTx((EntityManager)em);
        long id = rel.getId();
        this.endEm((EntityManager)em);
        ent = new CascadesEntity();
        rel = new CascadesEntity();
        em = this.currentEntityManager();
        TestCascades.assertNotNull((Object)em.find(CascadesEntity.class, (Object)id));
        this.startTx((EntityManager)em);
        em.persist((Object)ent);
        ent.getAllCollection().add(rel);
        TestCascades.assertFalse((boolean)em.isPersistent((Object)rel));
        this.endTx((EntityManager)em);
        id = rel.getId();
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        TestCascades.assertNotNull((Object)em.find(CascadesEntity.class, (Object)id));
        this.endEm((EntityManager)em);
    }

    public void testCascadePersistFlushWithPersistent() {
        CascadesEntity ent = new CascadesEntity();
        CascadesEntity rel = new CascadesEntity();
        ent.setAll(rel);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persist((Object)ent);
        TestCascades.assertTrue((boolean)em.isPersistent((Object)rel));
        this.endTx((EntityManager)em);
        long id = rel.getId();
        this.endEm((EntityManager)em);
        ent = new CascadesEntity();
        rel = new CascadesEntity();
        ent.getAllCollection().add(rel);
        em = this.currentEntityManager();
        TestCascades.assertNotNull((Object)em.find(CascadesEntity.class, (Object)id));
        this.startTx((EntityManager)em);
        em.persist((Object)ent);
        TestCascades.assertTrue((boolean)em.isPersistent((Object)rel));
        this.endTx((EntityManager)em);
        id = rel.getId();
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        TestCascades.assertNotNull((Object)em.find(CascadesEntity.class, (Object)id));
        this.endEm((EntityManager)em);
    }

    public void testCascadeCircleThroughPersistent() {
        CascadesEntity ent = new CascadesEntity();
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persist((Object)ent);
        this.endTx((EntityManager)em);
        long id = ent.getId();
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        ent = (CascadesEntity)em.find(CascadesEntity.class, (Object)id);
        CascadesEntity top = new CascadesEntity();
        top.setAll(ent);
        CascadesEntity rel = new CascadesEntity();
        this.startTx((EntityManager)em);
        ent.setAll(rel);
        rel.setAll(top);
        em.persist((Object)top);
        TestCascades.assertTrue((boolean)em.isPersistent((Object)top));
        TestCascades.assertTrue((boolean)em.isPersistent((Object)ent));
        TestCascades.assertTrue((boolean)em.isPersistent((Object)rel));
        this.rollbackTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testNoCascadeDelete() {
        CascadesEntity ent = new CascadesEntity();
        CascadesEntity rel = new CascadesEntity();
        CascadesEntity depend = new CascadesEntity();
        ent.setNone(rel);
        ent.setDependent(depend);
        ent.getNoneCollection().add(rel);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persistAll(new Object[]{ent, rel, depend});
        this.endTx((EntityManager)em);
        long id = ent.getId();
        long relId = rel.getId();
        long dependId = depend.getId();
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        ent = (CascadesEntity)em.find(CascadesEntity.class, (Object)id);
        rel = ent.getNone();
        depend = ent.getDependent();
        TestCascades.assertEquals((long)relId, (long)rel.getId());
        TestCascades.assertEquals((long)dependId, (long)depend.getId());
        TestCascades.assertEquals((int)1, (int)ent.getNoneCollection().size());
        TestCascades.assertEquals((long)relId, (long)ent.getNoneCollection().iterator().next().getId());
        this.startTx((EntityManager)em);
        em.remove((Object)ent);
        TestCascades.assertTrue((boolean)em.isRemoved((Object)ent));
        TestCascades.assertFalse((boolean)em.isRemoved((Object)rel));
        TestCascades.assertFalse((boolean)em.isRemoved((Object)depend));
        this.endTx((EntityManager)em);
        TestCascades.assertFalse((boolean)em.isPersistent((Object)ent));
        TestCascades.assertTrue((boolean)em.isPersistent((Object)rel));
        TestCascades.assertFalse((boolean)em.isPersistent((Object)depend));
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        TestCascades.assertNull((Object)em.find(CascadesEntity.class, (Object)id));
        TestCascades.assertNotNull((Object)em.find(CascadesEntity.class, (Object)relId));
        TestCascades.assertNull((Object)em.find(CascadesEntity.class, (Object)dependId));
        this.endEm((EntityManager)em);
    }

    public void testDeepCascadeDelete() {
        CascadesEntity ent = new CascadesEntity();
        CascadesEntity rel1 = new CascadesEntity();
        CascadesEntity rel2 = new CascadesEntity();
        CascadesEntity depend = new CascadesEntity();
        CascadesEntity deep1 = new CascadesEntity();
        CascadesEntity deep2 = new CascadesEntity();
        CascadesEntity deep3 = new CascadesEntity();
        ent.setAll(rel1);
        rel1.setAll(deep1);
        ent.getAllCollection().add(rel2);
        rel2.getAllCollection().add(deep2);
        ent.setDependent(depend);
        depend.setAll(deep3);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persistAll(new Object[]{ent, depend});
        this.endTx((EntityManager)em);
        long id = ent.getId();
        long rel1Id = rel1.getId();
        long rel2Id = rel2.getId();
        long deep1Id = deep1.getId();
        long deep2Id = deep2.getId();
        long deep3Id = deep3.getId();
        long dependId = depend.getId();
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        ent = (CascadesEntity)em.find(CascadesEntity.class, (Object)id);
        rel1 = ent.getAll();
        TestCascades.assertEquals((long)rel1Id, (long)rel1.getId());
        deep1 = rel1.getAll();
        TestCascades.assertEquals((long)deep1Id, (long)deep1.getId());
        TestCascades.assertEquals((int)1, (int)ent.getAllCollection().size());
        rel2 = ent.getAllCollection().iterator().next();
        TestCascades.assertEquals((long)rel2Id, (long)rel2.getId());
        TestCascades.assertEquals((int)1, (int)rel2.getAllCollection().size());
        deep2 = rel2.getAllCollection().iterator().next();
        TestCascades.assertEquals((long)deep2Id, (long)deep2.getId());
        depend = ent.getDependent();
        TestCascades.assertEquals((long)dependId, (long)depend.getId());
        deep3 = depend.getAll();
        TestCascades.assertEquals((long)deep3Id, (long)deep3.getId());
        this.startTx((EntityManager)em);
        em.remove((Object)ent);
        TestCascades.assertTrue((boolean)em.isRemoved((Object)ent));
        TestCascades.assertTrue((boolean)em.isRemoved((Object)rel1));
        TestCascades.assertTrue((boolean)em.isRemoved((Object)rel2));
        TestCascades.assertTrue((boolean)em.isRemoved((Object)deep1));
        TestCascades.assertTrue((boolean)em.isRemoved((Object)deep2));
        TestCascades.assertFalse((boolean)em.isRemoved((Object)depend));
        TestCascades.assertFalse((boolean)em.isRemoved((Object)deep3));
        this.endTx((EntityManager)em);
        TestCascades.assertFalse((boolean)em.isPersistent((Object)ent));
        TestCascades.assertFalse((boolean)em.isPersistent((Object)rel1));
        TestCascades.assertFalse((boolean)em.isPersistent((Object)rel2));
        TestCascades.assertFalse((boolean)em.isPersistent((Object)deep1));
        TestCascades.assertFalse((boolean)em.isPersistent((Object)depend));
        TestCascades.assertFalse((boolean)em.isPersistent((Object)deep2));
        TestCascades.assertFalse((boolean)em.isPersistent((Object)deep3));
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        TestCascades.assertNull((Object)em.find(CascadesEntity.class, (Object)id));
        TestCascades.assertNull((Object)em.find(CascadesEntity.class, (Object)rel1Id));
        TestCascades.assertNull((Object)em.find(CascadesEntity.class, (Object)rel2Id));
        TestCascades.assertNull((Object)em.find(CascadesEntity.class, (Object)deep1Id));
        TestCascades.assertNull((Object)em.find(CascadesEntity.class, (Object)deep2Id));
        TestCascades.assertNull((Object)em.find(CascadesEntity.class, (Object)deep3Id));
        TestCascades.assertNull((Object)em.find(CascadesEntity.class, (Object)dependId));
        this.endEm((EntityManager)em);
    }

    public void testCircularCascadeDelete() {
        CascadesEntity ent = new CascadesEntity();
        CascadesEntity rel = new CascadesEntity();
        ent.setAll(rel);
        ent.getAllCollection().add(rel);
        rel.setAll(ent);
        rel.getAllCollection().add(ent);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persist((Object)ent);
        this.endTx((EntityManager)em);
        long id = ent.getId();
        long relId = rel.getId();
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        ent = (CascadesEntity)em.find(CascadesEntity.class, (Object)id);
        rel = ent.getAll();
        TestCascades.assertEquals((long)relId, (long)rel.getId());
        TestCascades.assertEquals((Object)rel, (Object)ent.getAllCollection().iterator().next());
        TestCascades.assertEquals((Object)ent, (Object)rel.getAllCollection().iterator().next());
        this.startTx((EntityManager)em);
        em.remove((Object)ent);
        TestCascades.assertTrue((boolean)em.isRemoved((Object)ent));
        TestCascades.assertTrue((boolean)em.isRemoved((Object)rel));
        this.endTx((EntityManager)em);
        TestCascades.assertFalse((boolean)em.isPersistent((Object)ent));
        TestCascades.assertFalse((boolean)em.isPersistent((Object)rel));
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        TestCascades.assertNull((Object)em.find(CascadesEntity.class, (Object)id));
        TestCascades.assertNull((Object)em.find(CascadesEntity.class, (Object)relId));
        this.endEm((EntityManager)em);
    }

    public void testNoCascadeRefresh() {
        CascadesEntity ent = new CascadesEntity();
        CascadesEntity rel = new CascadesEntity();
        ent.setNone(rel);
        ent.getNoneCollection().add(rel);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persistAll(new Object[]{ent, rel});
        this.endTx((EntityManager)em);
        long id = ent.getId();
        long relId = rel.getId();
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        ent = (CascadesEntity)em.find(CascadesEntity.class, (Object)id);
        rel = ent.getNone();
        TestCascades.assertEquals((long)relId, (long)rel.getId());
        this.startTx((EntityManager)em);
        TestCascades.assertNull((Object)ent.getDependent());
        TestCascades.assertNull((Object)rel.getDependent());
        ent.setDependent(new CascadesEntity());
        rel.setDependent(new CascadesEntity());
        em.persist((Object)ent.getDependent());
        em.persist((Object)rel.getDependent());
        em.refresh((Object)ent);
        TestCascades.assertNull((Object)ent.getDependent());
        TestCascades.assertNotNull((Object)rel.getDependent());
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        TestCascades.assertNull((Object)((CascadesEntity)em.find(CascadesEntity.class, (Object)id)).getDependent());
        TestCascades.assertNotNull((Object)((CascadesEntity)em.find(CascadesEntity.class, (Object)relId)).getDependent());
        this.endEm((EntityManager)em);
    }

    public void testCircularCascadeRefresh() {
        CascadesEntity ent = new CascadesEntity();
        CascadesEntity rel = new CascadesEntity();
        ent.setAll(rel);
        rel.setAll(ent);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persist((Object)ent);
        this.endTx((EntityManager)em);
        long id = ent.getId();
        long relId = rel.getId();
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        ent = (CascadesEntity)em.find(CascadesEntity.class, (Object)id);
        rel = ent.getAll();
        TestCascades.assertEquals((long)relId, (long)rel.getId());
        TestCascades.assertEquals((Object)ent, (Object)rel.getAll());
        this.startTx((EntityManager)em);
        TestCascades.assertNull((Object)ent.getDependent());
        TestCascades.assertNull((Object)rel.getDependent());
        ent.setDependent(new CascadesEntity());
        rel.setDependent(new CascadesEntity());
        em.persist((Object)ent.getDependent());
        em.persist((Object)rel.getDependent());
        em.refresh((Object)ent);
        TestCascades.assertNull((Object)ent.getDependent());
        TestCascades.assertNull((Object)rel.getDependent());
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        ent = (CascadesEntity)em.find(CascadesEntity.class, (Object)id);
        TestCascades.assertEquals((long)relId, (long)ent.getAll().getId());
        TestCascades.assertNull((Object)ent.getDependent());
        TestCascades.assertNull((Object)((CascadesEntity)em.find(CascadesEntity.class, (Object)relId)).getDependent());
        this.endEm((EntityManager)em);
        ent = new CascadesEntity();
        rel = new CascadesEntity();
        CascadesEntity deep = new CascadesEntity();
        ent.getAllCollection().add(rel);
        rel.getAllCollection().add(ent);
        rel.getAllCollection().add(deep);
        em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persist((Object)ent);
        this.endTx((EntityManager)em);
        id = ent.getId();
        relId = rel.getId();
        long deepId = deep.getId();
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        ent = (CascadesEntity)em.find(CascadesEntity.class, (Object)id);
        rel = ent.getAllCollection().iterator().next();
        TestCascades.assertEquals((long)relId, (long)rel.getId());
        TestCascades.assertEquals((int)2, (int)rel.getAllCollection().size());
        deep = null;
        for (CascadesEntity elem : rel.getAllCollection()) {
            if (elem == ent) continue;
            deep = elem;
        }
        TestCascades.assertEquals((long)deepId, (long)deep.getId());
        this.startTx((EntityManager)em);
        TestCascades.assertNull((Object)ent.getDependent());
        TestCascades.assertNull((Object)rel.getDependent());
        TestCascades.assertNull((Object)deep.getDependent());
        ent.setDependent(new CascadesEntity());
        ent.getAllCollection().add(new CascadesEntity());
        rel.setDependent(new CascadesEntity());
        deep.setDependent(new CascadesEntity());
        em.persistAll(ent.getAllCollection());
        em.persist((Object)ent.getDependent());
        em.persist((Object)rel.getDependent());
        em.persist((Object)deep.getDependent());
        em.refresh((Object)ent);
        TestCascades.assertNull((Object)ent.getDependent());
        TestCascades.assertEquals((int)1, (int)ent.getAllCollection().size());
        TestCascades.assertTrue((boolean)ent.getAllCollection().contains(rel));
        TestCascades.assertNull((Object)rel.getDependent());
        TestCascades.assertEquals((int)2, (int)rel.getAllCollection().size());
        TestCascades.assertTrue((boolean)rel.getAllCollection().contains(ent));
        TestCascades.assertTrue((boolean)rel.getAllCollection().contains(deep));
        TestCascades.assertNull((Object)deep.getDependent());
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        ent = (CascadesEntity)em.find(CascadesEntity.class, (Object)id);
        TestCascades.assertEquals((int)1, (int)ent.getAllCollection().size());
        TestCascades.assertEquals((long)relId, (long)ent.getAllCollection().iterator().next().getId());
        TestCascades.assertNull((Object)ent.getDependent());
        TestCascades.assertNull((Object)((CascadesEntity)em.find(CascadesEntity.class, (Object)relId)).getDependent());
        TestCascades.assertNull((Object)((CascadesEntity)em.find(CascadesEntity.class, (Object)deepId)).getDependent());
        this.endEm((EntityManager)em);
    }

    public void testNoCascadeAttachClean() {
        CascadesEntity ent = new CascadesEntity();
        CascadesEntity rel = new CascadesEntity();
        ent.setName("ent");
        rel.setName("rel");
        ent.setNone(rel);
        ent.getNoneCollection().add(rel);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persistAll(new Object[]{ent, rel});
        this.endTx((EntityManager)em);
        long id = ent.getId();
        long relId = rel.getId();
        this.endEm((EntityManager)em);
        TestCascades.assertEquals((String)"ent", (String)ent.getName());
        TestCascades.assertEquals((String)"rel", (String)rel.getName());
        TestCascades.assertEquals((Object)rel, (Object)ent.getNone());
        TestCascades.assertEquals((Object)rel, (Object)ent.getNoneCollection().iterator().next());
        em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        ent = (CascadesEntity)em.merge((Object)ent);
        TestCascades.assertTrue((!em.isDirty((Object)ent) ? 1 : 0) != 0);
        TestCascades.assertEquals((String)"ent", (String)ent.getName());
        TestCascades.assertEquals((long)id, (long)ent.getId());
        TestCascades.assertTrue((ent.getNone() != rel ? 1 : 0) != 0);
        rel = ent.getNone();
        TestCascades.assertNotNull((Object)rel);
        TestCascades.assertTrue((!em.isDirty((Object)rel) ? 1 : 0) != 0);
        TestCascades.assertEquals((int)1, (int)ent.getNoneCollection().size());
        TestCascades.assertEquals((Object)rel, (Object)ent.getNoneCollection().iterator().next());
        TestCascades.assertTrue((boolean)em.isPersistent((Object)rel));
        TestCascades.assertEquals((long)relId, (long)rel.getId());
        TestCascades.assertEquals((String)"rel", (String)rel.getName());
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testCascadeAttachClean() {
        CascadesEntity ent = new CascadesEntity();
        CascadesEntity rel1 = new CascadesEntity();
        CascadesEntity rel2 = new CascadesEntity();
        ent.setName("ent");
        rel1.setName("rel1");
        ent.setAll(rel1);
        rel2.setName("rel2");
        ent.getAllCollection().add(rel2);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persist((Object)ent);
        this.endTx((EntityManager)em);
        long id = ent.getId();
        long rel1Id = rel1.getId();
        long rel2Id = rel2.getId();
        this.endEm((EntityManager)em);
        TestCascades.assertEquals((String)"ent", (String)ent.getName());
        TestCascades.assertEquals((String)"rel1", (String)rel1.getName());
        TestCascades.assertEquals((String)"rel2", (String)rel2.getName());
        TestCascades.assertEquals((Object)rel1, (Object)ent.getAll());
        TestCascades.assertEquals((Object)rel2, (Object)ent.getAllCollection().iterator().next());
        em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        ent = (CascadesEntity)em.merge((Object)ent);
        TestCascades.assertTrue((!em.isDirty((Object)ent) ? 1 : 0) != 0);
        TestCascades.assertEquals((String)"ent", (String)ent.getName());
        TestCascades.assertEquals((long)id, (long)ent.getId());
        TestCascades.assertTrue((rel1 != ent.getAll() ? 1 : 0) != 0);
        rel1 = ent.getAll();
        TestCascades.assertTrue((!em.isDirty((Object)rel1) ? 1 : 0) != 0);
        TestCascades.assertEquals((int)1, (int)ent.getAllCollection().size());
        rel2 = ent.getAllCollection().iterator().next();
        TestCascades.assertTrue((!em.isDirty((Object)rel2) ? 1 : 0) != 0);
        TestCascades.assertTrue((boolean)em.isPersistent((Object)rel1));
        TestCascades.assertEquals((long)rel1Id, (long)rel1.getId());
        TestCascades.assertEquals((String)"rel1", (String)rel1.getName());
        TestCascades.assertTrue((boolean)em.isPersistent((Object)rel2));
        TestCascades.assertEquals((long)rel2Id, (long)rel2.getId());
        TestCascades.assertEquals((String)"rel2", (String)rel2.getName());
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testNoCascadeAttachDirtyFields() {
        CascadesEntity ent = new CascadesEntity();
        CascadesEntity rel = new CascadesEntity();
        ent.setName("ent");
        rel.setName("rel");
        ent.setNone(rel);
        ent.getNoneCollection().add(rel);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persistAll(new Object[]{ent, rel});
        this.endTx((EntityManager)em);
        long id = ent.getId();
        long relId = rel.getId();
        this.endEm((EntityManager)em);
        TestCascades.assertEquals((String)"ent", (String)ent.getName());
        TestCascades.assertEquals((String)"rel", (String)rel.getName());
        TestCascades.assertEquals((Object)rel, (Object)ent.getNone());
        TestCascades.assertEquals((Object)rel, (Object)ent.getNoneCollection().iterator().next());
        rel.setName("foo");
        em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        ent = (CascadesEntity)em.merge((Object)ent);
        TestCascades.assertTrue((!em.isDirty((Object)ent) ? 1 : 0) != 0);
        TestCascades.assertEquals((String)"ent", (String)ent.getName());
        TestCascades.assertEquals((long)id, (long)ent.getId());
        TestCascades.assertTrue((ent.getNone() != rel ? 1 : 0) != 0);
        rel = ent.getNone();
        TestCascades.assertNotNull((Object)rel);
        TestCascades.assertTrue((!em.isDirty((Object)rel) ? 1 : 0) != 0);
        TestCascades.assertEquals((long)relId, (long)rel.getId());
        TestCascades.assertEquals((int)1, (int)ent.getNoneCollection().size());
        TestCascades.assertEquals((Object)rel, (Object)ent.getNoneCollection().iterator().next());
        TestCascades.assertTrue((boolean)em.isPersistent((Object)rel));
        TestCascades.assertEquals((long)relId, (long)rel.getId());
        TestCascades.assertEquals((String)"rel", (String)rel.getName());
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testCascadeAttachDirtyFields() {
        CascadesEntity ent = new CascadesEntity();
        CascadesEntity rel1 = new CascadesEntity();
        CascadesEntity rel2 = new CascadesEntity();
        ent.setName("ent");
        rel1.setName("rel1");
        ent.setAll(rel1);
        rel2.setName("rel2");
        ent.getAllCollection().add(rel2);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persist((Object)ent);
        this.endTx((EntityManager)em);
        long id = ent.getId();
        long rel1Id = rel1.getId();
        long rel2Id = rel2.getId();
        this.endEm((EntityManager)em);
        TestCascades.assertEquals((String)"ent", (String)ent.getName());
        TestCascades.assertEquals((String)"rel1", (String)rel1.getName());
        TestCascades.assertEquals((String)"rel2", (String)rel2.getName());
        TestCascades.assertEquals((Object)rel1, (Object)ent.getAll());
        TestCascades.assertEquals((Object)rel2, (Object)ent.getAllCollection().iterator().next());
        rel1.setName("foo");
        rel2.setName("bar");
        em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        ent = (CascadesEntity)em.merge((Object)ent);
        TestCascades.assertEquals((String)"ent", (String)ent.getName());
        TestCascades.assertTrue((!em.isDirty((Object)ent) ? 1 : 0) != 0);
        TestCascades.assertEquals((long)id, (long)ent.getId());
        TestCascades.assertTrue((rel1 != ent.getAll() ? 1 : 0) != 0);
        rel1 = ent.getAll();
        TestCascades.assertTrue((boolean)em.isDirty((Object)rel1));
        TestCascades.assertEquals((int)1, (int)ent.getAllCollection().size());
        rel2 = ent.getAllCollection().iterator().next();
        TestCascades.assertTrue((boolean)em.isDirty((Object)rel2));
        TestCascades.assertTrue((boolean)em.isPersistent((Object)rel1));
        TestCascades.assertEquals((long)rel1Id, (long)rel1.getId());
        TestCascades.assertEquals((String)"foo", (String)rel1.getName());
        TestCascades.assertTrue((boolean)em.isPersistent((Object)rel2));
        TestCascades.assertEquals((long)rel2Id, (long)rel2.getId());
        TestCascades.assertEquals((String)"bar", (String)rel2.getName());
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testNoCascadeAttachDirtyRelations() {
        CascadesEntity ent = new CascadesEntity();
        CascadesEntity rel = new CascadesEntity();
        CascadesEntity other = new CascadesEntity();
        ent.setName("ent");
        rel.setName("rel");
        other.setName("other");
        ent.setNone(rel);
        ent.getNoneCollection().add(rel);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persistAll(new Object[]{ent, rel, other});
        this.endTx((EntityManager)em);
        long id = ent.getId();
        long relId = rel.getId();
        long otherId = other.getId();
        this.endEm((EntityManager)em);
        TestCascades.assertEquals((String)"ent", (String)ent.getName());
        TestCascades.assertEquals((String)"rel", (String)rel.getName());
        TestCascades.assertEquals((String)"other", (String)other.getName());
        TestCascades.assertEquals((Object)rel, (Object)ent.getNone());
        TestCascades.assertEquals((Object)rel, (Object)ent.getNoneCollection().iterator().next());
        other.setName("foo");
        ent.setNone(other);
        ent.getNoneCollection().remove(rel);
        ent.getNoneCollection().add(other);
        em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        ent = (CascadesEntity)em.merge((Object)ent);
        TestCascades.assertTrue((boolean)em.isDirty((Object)ent));
        TestCascades.assertEquals((String)"ent", (String)ent.getName());
        TestCascades.assertEquals((long)id, (long)ent.getId());
        TestCascades.assertTrue((ent.getNone() != rel ? 1 : 0) != 0);
        TestCascades.assertTrue((ent.getNone() != other ? 1 : 0) != 0);
        other = ent.getNone();
        TestCascades.assertNotNull((Object)other);
        TestCascades.assertTrue((!em.isDirty((Object)other) ? 1 : 0) != 0);
        TestCascades.assertEquals((long)otherId, (long)other.getId());
        TestCascades.assertEquals((int)1, (int)ent.getNoneCollection().size());
        TestCascades.assertEquals((Object)other, (Object)ent.getNoneCollection().iterator().next());
        TestCascades.assertTrue((boolean)em.isPersistent((Object)other));
        TestCascades.assertFalse((boolean)em.isPersistent((Object)rel));
        TestCascades.assertEquals((long)otherId, (long)other.getId());
        TestCascades.assertEquals((String)"other", (String)other.getName());
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testCascadeAttachDirtyRelations() {
        CascadesEntity ent = new CascadesEntity();
        CascadesEntity rel1 = new CascadesEntity();
        CascadesEntity rel2 = new CascadesEntity();
        CascadesEntity other1 = new CascadesEntity();
        CascadesEntity other2 = new CascadesEntity();
        ent.setName("ent");
        rel1.setName("rel1");
        ent.setAll(rel1);
        rel2.setName("rel2");
        ent.getAllCollection().add(rel2);
        other1.setName("other1");
        other2.setName("other2");
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persistAll(new Object[]{ent, other1, other2});
        this.endTx((EntityManager)em);
        long id = ent.getId();
        long rel1Id = rel1.getId();
        long rel2Id = rel2.getId();
        long other1Id = other1.getId();
        long other2Id = other2.getId();
        this.endEm((EntityManager)em);
        TestCascades.assertEquals((String)"ent", (String)ent.getName());
        TestCascades.assertEquals((String)"rel1", (String)rel1.getName());
        TestCascades.assertEquals((String)"rel2", (String)rel2.getName());
        TestCascades.assertEquals((Object)rel1, (Object)ent.getAll());
        TestCascades.assertEquals((Object)rel2, (Object)ent.getAllCollection().iterator().next());
        TestCascades.assertEquals((String)"other1", (String)other1.getName());
        other1.setName("foo");
        TestCascades.assertEquals((String)"other2", (String)other2.getName());
        other2.setName("bar");
        ent.setAll(other1);
        ent.getAllCollection().remove(rel2);
        ent.getAllCollection().add(other2);
        em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        ent = (CascadesEntity)em.merge((Object)ent);
        TestCascades.assertEquals((String)"ent", (String)ent.getName());
        TestCascades.assertTrue((boolean)em.isDirty((Object)ent));
        TestCascades.assertEquals((long)id, (long)ent.getId());
        TestCascades.assertTrue((rel1 != ent.getAll() ? 1 : 0) != 0);
        TestCascades.assertTrue((other1 != ent.getAll() ? 1 : 0) != 0);
        other1 = ent.getAll();
        TestCascades.assertTrue((boolean)em.isDirty((Object)other1));
        TestCascades.assertEquals((int)1, (int)ent.getAllCollection().size());
        other2 = ent.getAllCollection().iterator().next();
        TestCascades.assertTrue((boolean)em.isDirty((Object)other2));
        TestCascades.assertTrue((boolean)em.isPersistent((Object)other1));
        TestCascades.assertEquals((long)other1Id, (long)other1.getId());
        TestCascades.assertEquals((String)"foo", (String)other1.getName());
        TestCascades.assertTrue((boolean)em.isPersistent((Object)other2));
        TestCascades.assertEquals((long)other2Id, (long)other2.getId());
        TestCascades.assertEquals((String)"bar", (String)other2.getName());
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testNoCascadeReferenceIsPreLoadedReference() {
        CascadesEntity ent = new CascadesEntity();
        CascadesEntity rel = new CascadesEntity();
        CascadesEntity other = new CascadesEntity();
        ent.setName("ent");
        rel.setName("rel");
        other.setName("other");
        ent.setNone(rel);
        ent.getNoneCollection().add(rel);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persistAll(new Object[]{ent, rel, other});
        this.endTx((EntityManager)em);
        long otherId = other.getId();
        this.endEm((EntityManager)em);
        ent.setNone(other);
        ent.getNoneCollection().remove(rel);
        ent.getNoneCollection().add(other);
        em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        other = (CascadesEntity)em.find(CascadesEntity.class, (Object)otherId);
        ent = (CascadesEntity)em.merge((Object)ent);
        TestCascades.assertEquals((Object)other, (Object)ent.getNone());
        TestCascades.assertEquals((Object)other, (Object)ent.getNoneCollection().iterator().next());
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testNoCascadeNewCausesException() {
        OpenJPAEntityManager em;
        block5: {
            CascadesEntity other;
            CascadesEntity ent;
            block4: {
                ent = new CascadesEntity();
                CascadesEntity rel = new CascadesEntity();
                ent.setNone(rel);
                em = this.currentEntityManager();
                this.startTx((EntityManager)em);
                em.persistAll(new Object[]{ent, rel});
                this.endTx((EntityManager)em);
                this.endEm((EntityManager)em);
                other = new CascadesEntity();
                ent.setNone(other);
                em = this.currentEntityManager();
                this.startTx((EntityManager)em);
                try {
                    ent = (CascadesEntity)em.merge((Object)ent);
                    TestCascades.fail((String)"Allowed merge of new instance in non-cascading relation.");
                }
                catch (RuntimeException re) {
                    if (!this.isActiveTx((EntityManager)em)) break block4;
                    this.rollbackTx((EntityManager)em);
                }
            }
            this.endEm((EntityManager)em);
            ent = new CascadesEntity();
            em = this.currentEntityManager();
            this.startTx((EntityManager)em);
            em.persist((Object)ent);
            this.endTx((EntityManager)em);
            this.endEm((EntityManager)em);
            other = new CascadesEntity();
            ent.getNoneCollection().add(other);
            em = this.currentEntityManager();
            this.startTx((EntityManager)em);
            try {
                ent = (CascadesEntity)em.merge((Object)ent);
                TestCascades.fail((String)"Allowed merge of new instance in non-cascading relation.");
            }
            catch (RuntimeException re) {
                if (!this.isActiveTx((EntityManager)em)) break block5;
                this.rollbackTx((EntityManager)em);
            }
        }
        this.endEm((EntityManager)em);
    }

    public void testCascadeNewPersisted() {
        CascadesEntity ent = new CascadesEntity();
        CascadesEntity rel1 = new CascadesEntity();
        CascadesEntity rel2 = new CascadesEntity();
        ent.setName("ent");
        rel1.setName("rel1");
        ent.setAll(rel1);
        rel2.setName("rel2");
        ent.getAllCollection().add(rel2);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persist((Object)ent);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        CascadesEntity other1 = new CascadesEntity();
        CascadesEntity other2 = new CascadesEntity();
        other1.setName("other1");
        other2.setName("other2");
        ent.setAll(other1);
        ent.getAllCollection().remove(rel2);
        ent.getAllCollection().add(other2);
        em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        ent = (CascadesEntity)em.merge((Object)ent);
        TestCascades.assertTrue((boolean)em.isDirty((Object)ent));
        TestCascades.assertTrue((rel1 != ent.getAll() ? 1 : 0) != 0);
        TestCascades.assertTrue((other1 != ent.getAll() ? 1 : 0) != 0);
        other1 = ent.getAll();
        TestCascades.assertEquals((String)"other1", (String)other1.getName());
        TestCascades.assertTrue((boolean)em.isNewlyPersistent((Object)other1));
        TestCascades.assertEquals((int)1, (int)ent.getAllCollection().size());
        other2 = ent.getAllCollection().iterator().next();
        TestCascades.assertEquals((String)"other2", (String)other2.getName());
        TestCascades.assertTrue((boolean)em.isNewlyPersistent((Object)other2));
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testCascadesDeleteNonPersistent() {
        CascadesEntity all = new CascadesEntity();
        CascadesEntity none = new CascadesEntity();
        CascadesEntity manyAll = new CascadesEntity();
        CascadesEntity manyNone = new CascadesEntity();
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persist((Object)all);
        em.persist((Object)none);
        em.persist((Object)manyAll);
        em.persist((Object)manyNone);
        this.endTx((EntityManager)em);
        long allId = all.getId();
        long noneId = none.getId();
        long manyAllId = manyAll.getId();
        long manyNoneId = manyNone.getId();
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        CascadesEntity ent = new CascadesEntity();
        ent.setAll((CascadesEntity)em.find(CascadesEntity.class, (Object)allId));
        ent.setNone((CascadesEntity)em.find(CascadesEntity.class, (Object)noneId));
        ent.getAllCollection().add((CascadesEntity)em.find(CascadesEntity.class, (Object)manyAllId));
        ent.getNoneCollection().add((CascadesEntity)em.find(CascadesEntity.class, (Object)manyNoneId));
        em.remove((Object)ent);
        TestCascades.assertTrue((boolean)em.isRemoved((Object)ent.getAll()));
        TestCascades.assertFalse((boolean)em.isRemoved((Object)ent.getNone()));
        for (CascadesEntity rel : ent.getAllCollection()) {
            TestCascades.assertTrue((boolean)em.isRemoved((Object)rel));
        }
        for (CascadesEntity rel : ent.getNoneCollection()) {
            TestCascades.assertFalse((boolean)em.isRemoved((Object)rel));
        }
        TestCascades.assertFalse((boolean)em.contains((Object)ent));
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        TestCascades.assertNull((Object)em.find(CascadesEntity.class, (Object)allId));
        TestCascades.assertNotNull((Object)em.find(CascadesEntity.class, (Object)noneId));
        TestCascades.assertNull((Object)em.find(CascadesEntity.class, (Object)manyAllId));
        TestCascades.assertNotNull((Object)em.find(CascadesEntity.class, (Object)manyNoneId));
        this.endEm((EntityManager)em);
    }
}

