/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.enhance.identity;

import java.util.Arrays;
import java.util.List;
import org.apache.openjpa.jdbc.sql.DB2Dictionary;
import org.apache.openjpa.jdbc.sql.DerbyDictionary;
import org.apache.openjpa.jdbc.sql.OracleDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.enhance.identity.Book1;
import org.apache.openjpa.persistence.enhance.identity.BookId1;
import org.apache.openjpa.persistence.enhance.identity.Library1;
import org.apache.openjpa.persistence.enhance.identity.Line1;
import org.apache.openjpa.persistence.enhance.identity.LineId1;
import org.apache.openjpa.persistence.enhance.identity.Page1;
import org.apache.openjpa.persistence.enhance.identity.PageId1;
import org.apache.openjpa.persistence.jdbc.SQLSniffer;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestMultipleLevelDerivedIdentity1
extends SQLListenerTestCase {
    private static String LIBRARY_NAME = "LIB";
    private static String BOOK_NAME = "foo";
    private static int NUM_PAGES = 3;
    private static int NUM_LINES = 20;

    @Override
    public void setUp() throws Exception {
        this.setSupportedDatabases(DerbyDictionary.class, DB2Dictionary.class, OracleDictionary.class);
        if (this.isTestsDisabled()) {
            return;
        }
        super.setUp(DROP_TABLES, Library1.class, Book1.class, Page1.class, BookId1.class, PageId1.class, Line1.class, LineId1.class, "openjpa.RuntimeUnenhancedClasses", "unsupported");
        this.create();
    }

    public void testPersist() {
        this.sql.clear();
        this.create();
    }

    public void testQueryRootLevel() {
        this.sql.clear();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        List list = em.createQuery("SELECT p FROM Library1 p").getResultList();
        TestMultipleLevelDerivedIdentity1.assertFalse((boolean)list.isEmpty());
        Library1 lib = (Library1)list.get(0);
        BookId1 bid = new BookId1(BOOK_NAME, lib.getName());
        Book1 b = lib.getBook(bid);
        TestMultipleLevelDerivedIdentity1.assertNotNull((Object)b);
        Page1 p = b.getPage(new PageId1(1, bid));
        TestMultipleLevelDerivedIdentity1.assertNotNull((Object)p);
        em.close();
    }

    public void testQueryIntermediateLevel() {
        this.sql.clear();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        List list = em.createQuery("SELECT p FROM Book1 p").getResultList();
        TestMultipleLevelDerivedIdentity1.assertFalse((boolean)list.isEmpty());
        Book1 book = (Book1)list.get(0);
        Library1 lib = book.getLibrary();
        for (int i = 1; i <= NUM_PAGES; ++i) {
            PageId1 pid = new PageId1(i, book.getBid());
            Page1 page = book.getPage(pid);
            TestMultipleLevelDerivedIdentity1.assertNotNull((Object)page);
            TestMultipleLevelDerivedIdentity1.assertEquals((Object)book, (Object)page.getBook());
            TestMultipleLevelDerivedIdentity1.assertEquals((Object)lib, (Object)page.getBook().getLibrary());
            TestMultipleLevelDerivedIdentity1.assertEquals((Object)page, (Object)page.getBook().getPage(new PageId1(pid.getNumber(), book.getBid())));
        }
        em.close();
    }

    public void testQueryLeafLevel() {
        this.sql.clear();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        List list = em.createQuery("SELECT p FROM Page1 p").getResultList();
        TestMultipleLevelDerivedIdentity1.assertFalse((boolean)list.isEmpty());
        Book1 book = ((Page1)list.get(0)).getBook();
        Library1 lib = book.getLibrary();
        for (Page1 page : list) {
            TestMultipleLevelDerivedIdentity1.assertEquals((Object)book, (Object)page.getBook());
            TestMultipleLevelDerivedIdentity1.assertEquals((Object)lib, (Object)page.getBook().getLibrary());
            TestMultipleLevelDerivedIdentity1.assertEquals((Object)page, (Object)page.getBook().getPage(page.getPid()));
        }
        em.close();
    }

    public void testFindRootNode() {
        this.sql.clear();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Library1 lib = (Library1)em.find(Library1.class, (Object)LIBRARY_NAME);
        TestMultipleLevelDerivedIdentity1.assertNotNull((Object)lib);
        BookId1 bid = new BookId1(BOOK_NAME, lib.getName());
        Book1 b = lib.getBook(bid);
        TestMultipleLevelDerivedIdentity1.assertNotNull((Object)b);
        PageId1 pid = new PageId1(1, bid);
        TestMultipleLevelDerivedIdentity1.assertNotNull((Object)b.getPage(pid));
        em.close();
    }

    public void testFindIntermediateNode() {
        this.sql.clear();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        BookId1 bookId = new BookId1();
        bookId.setLibrary(LIBRARY_NAME);
        bookId.setName(BOOK_NAME);
        Book1 book = (Book1)em.find(Book1.class, (Object)bookId);
        TestMultipleLevelDerivedIdentity1.assertNotNull((Object)book);
        em.close();
    }

    public void testFindLeafNode() {
        this.sql.clear();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        BookId1 bookId = new BookId1();
        bookId.setLibrary(LIBRARY_NAME);
        bookId.setName(BOOK_NAME);
        PageId1 pageId = new PageId1();
        pageId.setBook(bookId);
        pageId.setNumber(2);
        Page1 page = (Page1)em.find(Page1.class, (Object)pageId);
        TestMultipleLevelDerivedIdentity1.assertNotNull((Object)page);
        em.close();
    }

    public void testUpdate() {
        this.sql.clear();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        BookId1 bookId = new BookId1();
        bookId.setLibrary(LIBRARY_NAME);
        bookId.setName(BOOK_NAME);
        Book1 book = (Book1)em.find(Book1.class, (Object)bookId);
        TestMultipleLevelDerivedIdentity1.assertNotNull((Object)book);
        book.setAuthor("modifiy Author");
        em.getTransaction().commit();
        em.close();
    }

    public void testDeleteRoot() {
        this.sql.clear();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Library1 lib = (Library1)em.find(Library1.class, (Object)LIBRARY_NAME);
        em.remove((Object)lib);
        em.getTransaction().commit();
        TestMultipleLevelDerivedIdentity1.assertEquals((int)0, (int)this.count(Library1.class));
        TestMultipleLevelDerivedIdentity1.assertEquals((int)0, (int)this.count(Book1.class));
        TestMultipleLevelDerivedIdentity1.assertEquals((int)0, (int)this.count(Page1.class));
        em.close();
    }

    public void testDeleteLeafObtainedByQuery() {
        this.sql.clear();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Page1 page = (Page1)em.createQuery("SELECT p FROM Page1 p WHERE p.pid.number=2").getSingleResult();
        TestMultipleLevelDerivedIdentity1.assertNotNull((Object)page);
        em.remove((Object)page);
        em.getTransaction().commit();
        TestMultipleLevelDerivedIdentity1.assertEquals((int)1, (int)this.count(Library1.class));
        TestMultipleLevelDerivedIdentity1.assertEquals((int)1, (int)this.count(Book1.class));
        TestMultipleLevelDerivedIdentity1.assertEquals((int)(NUM_PAGES - 1), (int)this.count(Page1.class));
        em.close();
    }

    public void testDeleteLeafObtainedByFind() {
        this.sql.clear();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        BookId1 bookId = new BookId1();
        bookId.setLibrary(LIBRARY_NAME);
        bookId.setName(BOOK_NAME);
        PageId1 pageId = new PageId1();
        pageId.setBook(bookId);
        pageId.setNumber(2);
        Page1 page = (Page1)em.find(Page1.class, (Object)pageId);
        TestMultipleLevelDerivedIdentity1.assertNotNull((Object)page);
        em.remove((Object)page);
        em.getTransaction().commit();
        TestMultipleLevelDerivedIdentity1.assertEquals((int)1, (int)this.count(Library1.class));
        TestMultipleLevelDerivedIdentity1.assertEquals((int)1, (int)this.count(Book1.class));
        TestMultipleLevelDerivedIdentity1.assertEquals((int)(NUM_PAGES - 1), (int)this.count(Page1.class));
        em.close();
    }

    public void testOrderBy() {
        this.sql.clear();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Library1 lib = (Library1)em.find(Library1.class, (Object)LIBRARY_NAME);
        TestMultipleLevelDerivedIdentity1.assertNotNull((Object)lib);
        this.assertSQLFragnments(this.sql, "ORDER BY", "t1.LIBRARY_NAME ASC, t1.BOOK_NAME ASC");
        em.close();
    }

    public void create() {
        if (this.count(Library1.class) > 0) {
            return;
        }
        OpenJPAEntityManagerSPI em = null;
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Library1 lib = new Library1();
        lib.setName(LIBRARY_NAME);
        Book1 book = new Book1();
        BookId1 bid = new BookId1();
        bid.setName(BOOK_NAME);
        bid.setLibrary(lib.getName());
        book.setBid(bid);
        lib.addBook(book);
        for (int i = 1; i <= NUM_PAGES; ++i) {
            Page1 page = new Page1();
            PageId1 pid = new PageId1(i, bid);
            page.setPid(pid);
            book.addPage(page);
            for (int j = 1; j <= NUM_LINES; ++j) {
                Line1 line = new Line1();
                LineId1 lid = new LineId1(j, pid);
                line.setLid(lid);
                page.addLine(line);
            }
        }
        em.persist((Object)lib);
        em.getTransaction().commit();
        em.clear();
        this.assertSQLFragnments(this.sql, "CREATE TABLE DI_LIBRARY1", "LIBRARY_NAME");
        this.assertSQLFragnments(this.sql, "CREATE TABLE DI_BOOK1", "LIBRARY_NAME", "BOOK_NAME");
        this.assertSQLFragnments(this.sql, "CREATE TABLE DI_PAGE1", "LIBRARY_NAME", "BOOK_NAME", "PAGE_NUM");
        this.assertSQLFragnments(this.sql, "CREATE TABLE DI_LINE1", "LIBRARY_NAME", "BOOK_NAME", "PAGE_NUM", "LINE_NUM");
        em.close();
    }

    void assertSQLFragnments(List<String> list, String ... keys) {
        if (SQLSniffer.matches(list, keys)) {
            return;
        }
        TestMultipleLevelDerivedIdentity1.fail((String)("None of the following " + this.sql.size() + " SQL \r\n" + this.toString(this.sql) + "\r\n contains all keys \r\n" + this.toString(Arrays.asList(keys))));
    }

    @Override
    public String toString(List<String> list) {
        StringBuilder buf = new StringBuilder();
        for (String s : list) {
            buf.append(s).append("\r\n");
        }
        return buf.toString();
    }
}

