/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.enhance.identity;

import java.util.List;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.enhance.identity.Book;
import org.apache.openjpa.persistence.enhance.identity.BookId;
import org.apache.openjpa.persistence.enhance.identity.Library;
import org.apache.openjpa.persistence.enhance.identity.Page;
import org.apache.openjpa.persistence.enhance.identity.PageId;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestMultipleLevelDerivedIdentity
extends SingleEMFTestCase {
    private static String LIBRARY_NAME = "LIB";
    private static String BOOK_NAME = "foo";
    private static int NUM_PAGES = 3;

    @Override
    public void setUp() throws Exception {
        super.setUp(CLEAR_TABLES, Library.class, Book.class, Page.class, "openjpa.RuntimeUnenhancedClasses", "unsupported");
        this.create();
    }

    public void testMerge() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Library lib = new Library();
        lib.setName("Congress Library");
        Book book = new Book();
        book.setName("Kite Runner");
        book.setLibrary(lib);
        em.merge((Object)book);
        em.getTransaction().begin();
        em.getTransaction().commit();
        em.clear();
        try {
            em.merge((Object)book);
            em.getTransaction().begin();
            em.getTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestMultipleLevelDerivedIdentity.fail((String)("Fail to merge twice: " + e.getMessage()));
        }
        em.close();
    }

    public void testPersist() {
        this.create();
    }

    public void testQueryRootLevel() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        List list = em.createQuery("SELECT p FROM Library p").getResultList();
        TestMultipleLevelDerivedIdentity.assertFalse((boolean)list.isEmpty());
        Library lib = (Library)list.get(0);
        TestMultipleLevelDerivedIdentity.assertNotNull((Object)lib.getBook(BOOK_NAME));
        TestMultipleLevelDerivedIdentity.assertNotNull((Object)lib.getBook(BOOK_NAME).getPage(1));
        em.close();
    }

    public void testQueryIntermediateLevel() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        List list = em.createQuery("SELECT p FROM Book p").getResultList();
        TestMultipleLevelDerivedIdentity.assertFalse((boolean)list.isEmpty());
        Book book = (Book)list.get(0);
        Library lib = book.getLibrary();
        for (int i = 1; i <= NUM_PAGES; ++i) {
            Page page = book.getPage(i);
            TestMultipleLevelDerivedIdentity.assertNotNull((Object)page);
            TestMultipleLevelDerivedIdentity.assertEquals((Object)book, (Object)page.getBook());
            TestMultipleLevelDerivedIdentity.assertEquals((Object)lib, (Object)page.getBook().getLibrary());
            TestMultipleLevelDerivedIdentity.assertEquals((Object)page, (Object)page.getBook().getPage(page.getNumber()));
        }
        em.close();
    }

    public void testQueryLeafLevel() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        List list = em.createQuery("SELECT p FROM Page p").getResultList();
        TestMultipleLevelDerivedIdentity.assertFalse((boolean)list.isEmpty());
        Book book = ((Page)list.get(0)).getBook();
        Library lib = book.getLibrary();
        for (Page page : list) {
            TestMultipleLevelDerivedIdentity.assertEquals((Object)book, (Object)page.getBook());
            TestMultipleLevelDerivedIdentity.assertEquals((Object)lib, (Object)page.getBook().getLibrary());
            TestMultipleLevelDerivedIdentity.assertEquals((Object)page, (Object)page.getBook().getPage(page.getNumber()));
        }
        em.close();
    }

    public void testFindRootNode() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Library lib = (Library)em.find(Library.class, (Object)LIBRARY_NAME);
        TestMultipleLevelDerivedIdentity.assertNotNull((Object)lib);
        TestMultipleLevelDerivedIdentity.assertNotNull((Object)lib.getBook(BOOK_NAME));
        TestMultipleLevelDerivedIdentity.assertNotNull((Object)lib.getBook(BOOK_NAME).getPage(1));
        em.close();
    }

    public void testFindIntermediateNode() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        BookId bookId = new BookId();
        bookId.setLibrary(LIBRARY_NAME);
        bookId.setName(BOOK_NAME);
        Book book = (Book)em.find(Book.class, (Object)bookId);
        TestMultipleLevelDerivedIdentity.assertNotNull((Object)book);
        em.close();
    }

    public void testFindLeafNode() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        BookId bookId = new BookId();
        bookId.setLibrary(LIBRARY_NAME);
        bookId.setName(BOOK_NAME);
        PageId pageId = new PageId();
        pageId.setBook(bookId);
        pageId.setNumber(2);
        Page page = (Page)em.find(Page.class, (Object)pageId);
        TestMultipleLevelDerivedIdentity.assertNotNull((Object)page);
        em.close();
    }

    public void testUpdate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        BookId bookId = new BookId();
        bookId.setLibrary(LIBRARY_NAME);
        bookId.setName(BOOK_NAME);
        Book book = (Book)em.find(Book.class, (Object)bookId);
        TestMultipleLevelDerivedIdentity.assertNotNull((Object)book);
        book.setAuthor("modifiy Author");
        em.getTransaction().commit();
        em.close();
    }

    public void testDeleteRoot() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Library lib = (Library)em.find(Library.class, (Object)LIBRARY_NAME);
        em.remove((Object)lib);
        em.getTransaction().commit();
        TestMultipleLevelDerivedIdentity.assertEquals((int)0, (int)this.count(Library.class));
        TestMultipleLevelDerivedIdentity.assertEquals((int)0, (int)this.count(Book.class));
        TestMultipleLevelDerivedIdentity.assertEquals((int)0, (int)this.count(Page.class));
        em.close();
    }

    public void testDeleteLeafObtainedByQuery() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Page page = (Page)em.createQuery("SELECT p FROM Page p WHERE p.number=2").getSingleResult();
        TestMultipleLevelDerivedIdentity.assertNotNull((Object)page);
        em.remove((Object)page);
        em.getTransaction().commit();
        TestMultipleLevelDerivedIdentity.assertEquals((int)1, (int)this.count(Library.class));
        TestMultipleLevelDerivedIdentity.assertEquals((int)1, (int)this.count(Book.class));
        TestMultipleLevelDerivedIdentity.assertEquals((int)(NUM_PAGES - 1), (int)this.count(Page.class));
        em.close();
    }

    public void testDeleteLeafObtainedByFind() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        BookId bookId = new BookId();
        bookId.setLibrary(LIBRARY_NAME);
        bookId.setName(BOOK_NAME);
        PageId pageId = new PageId();
        pageId.setBook(bookId);
        pageId.setNumber(2);
        Page page = (Page)em.find(Page.class, (Object)pageId);
        TestMultipleLevelDerivedIdentity.assertNotNull((Object)page);
        em.remove((Object)page);
        em.getTransaction().commit();
        TestMultipleLevelDerivedIdentity.assertEquals((int)1, (int)this.count(Library.class));
        TestMultipleLevelDerivedIdentity.assertEquals((int)1, (int)this.count(Book.class));
        TestMultipleLevelDerivedIdentity.assertEquals((int)(NUM_PAGES - 1), (int)this.count(Page.class));
        em.close();
    }

    public void create() {
        if (this.count(Library.class) > 0) {
            return;
        }
        OpenJPAEntityManagerSPI em = null;
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Library lib = new Library();
        lib.setName(LIBRARY_NAME);
        Book book = new Book();
        book.setName(BOOK_NAME);
        lib.addBook(book);
        for (int i = 1; i <= NUM_PAGES; ++i) {
            Page page = new Page();
            page.setNumber(i);
            book.addPage(page);
        }
        em.persist((Object)lib);
        em.getTransaction().commit();
        em.clear();
        em.close();
    }
}

