/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.enhance.identity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.enhance.identity.BeneContact;
import org.apache.openjpa.persistence.enhance.identity.BeneContactId;
import org.apache.openjpa.persistence.enhance.identity.Beneficiary;
import org.apache.openjpa.persistence.enhance.identity.Dependent1;
import org.apache.openjpa.persistence.enhance.identity.Dependent2;
import org.apache.openjpa.persistence.enhance.identity.Dependent3;
import org.apache.openjpa.persistence.enhance.identity.Dependent4;
import org.apache.openjpa.persistence.enhance.identity.Dependent5;
import org.apache.openjpa.persistence.enhance.identity.DependentId1;
import org.apache.openjpa.persistence.enhance.identity.DependentId2;
import org.apache.openjpa.persistence.enhance.identity.DependentId3;
import org.apache.openjpa.persistence.enhance.identity.DependentId5;
import org.apache.openjpa.persistence.enhance.identity.Employee;
import org.apache.openjpa.persistence.enhance.identity.Employee1;
import org.apache.openjpa.persistence.enhance.identity.Employee2;
import org.apache.openjpa.persistence.enhance.identity.Employee3;
import org.apache.openjpa.persistence.enhance.identity.Employee4;
import org.apache.openjpa.persistence.enhance.identity.Employee5;
import org.apache.openjpa.persistence.enhance.identity.EmployeeId2;
import org.apache.openjpa.persistence.enhance.identity.EmployeeId5;
import org.apache.openjpa.persistence.enhance.identity.MedicalHistory1;
import org.apache.openjpa.persistence.enhance.identity.MedicalHistory2;
import org.apache.openjpa.persistence.enhance.identity.MedicalHistory3;
import org.apache.openjpa.persistence.enhance.identity.MedicalHistory4;
import org.apache.openjpa.persistence.enhance.identity.Parent3;
import org.apache.openjpa.persistence.enhance.identity.Person1;
import org.apache.openjpa.persistence.enhance.identity.Person2;
import org.apache.openjpa.persistence.enhance.identity.Person3;
import org.apache.openjpa.persistence.enhance.identity.Person4;
import org.apache.openjpa.persistence.enhance.identity.PersonId1;
import org.apache.openjpa.persistence.enhance.identity.PersonId3;
import org.apache.openjpa.persistence.enhance.identity.PersonId4;
import org.apache.openjpa.persistence.enhance.identity.PhoneNumber;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;
import org.apache.openjpa.util.ObjectId;

public class TestMappedById
extends SingleEMFTestCase {
    public int numEmployees = 4;
    public int numDependentsPerEmployee = 2;
    public int numPersons = 4;
    public Map<Integer, Employee1> emps1 = new HashMap<Integer, Employee1>();
    public Map<String, Dependent1> deps1 = new HashMap<String, Dependent1>();
    public Map<Integer, Employee2> emps2 = new HashMap<Integer, Employee2>();
    public Map<String, Dependent2> deps2 = new HashMap<String, Dependent2>();
    public Map<String, Person1> persons1 = new HashMap<String, Person1>();
    public Map<String, MedicalHistory1> medicals1 = new HashMap<String, MedicalHistory1>();
    public Map<String, Person2> persons2 = new HashMap<String, Person2>();
    public Map<String, MedicalHistory2> medicals2 = new HashMap<String, MedicalHistory2>();
    public Map<String, Person3> persons3 = new HashMap<String, Person3>();
    public Map<String, MedicalHistory3> medicals3 = new HashMap<String, MedicalHistory3>();
    public Map<String, Person4> persons4 = new HashMap<String, Person4>();
    public Map<String, MedicalHistory4> medicals4 = new HashMap<String, MedicalHistory4>();
    public Map<Integer, Employee3> emps3 = new HashMap<Integer, Employee3>();
    public Map<Object, Dependent3> depMap3 = new HashMap<Object, Dependent3>();
    public List dids3 = new ArrayList();
    public List<Dependent3> deps3 = new ArrayList<Dependent3>();
    public int eId1 = 1;
    public int dId1 = 1;
    public int eId2 = 1;
    public int dId2 = 1;
    public int eId3 = 1;
    public int eId4 = 1;
    public int dId4 = 1;
    public int dId3 = 1;
    public int pId1 = 1;
    public int mId1 = 1;
    public int pId2 = 1;
    public int mId2 = 1;
    public int pId3 = 1;
    public int mId3 = 1;
    public int pId4 = 1;
    public int mId4 = 1;

    @Override
    public void setUp() throws Exception {
        super.setUp(DROP_TABLES, Dependent1.class, Employee.class, Employee1.class, DependentId1.class, Dependent2.class, Employee2.class, DependentId2.class, EmployeeId2.class, MedicalHistory1.class, Person1.class, PersonId1.class, MedicalHistory2.class, Person2.class, Person3.class, MedicalHistory3.class, Person4.class, PersonId4.class, MedicalHistory4.class, Dependent3.class, Employee3.class, DependentId3.class, Parent3.class, Dependent4.class, Employee4.class, PhoneNumber.class, BeneContact.class, BeneContactId.class, Beneficiary.class, Dependent5.class, Employee5.class, EmployeeId5.class);
    }

    public void testMapsId1() {
        this.createObj1();
        this.findObj1();
        this.queryObj1();
    }

    public void testMapsId2() {
        this.createObj2();
        this.findObj2();
        this.queryObj2();
    }

    public void testMapsId3() {
        this.createObj3();
        this.findObj3();
        this.queryObj3();
    }

    public void testMapsId4() {
        if (!((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance().supportsAutoAssign) {
            return;
        }
        this.createObj4();
        this.queryObj4();
    }

    public void testMapsId5() {
        if (!((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance().supportsAutoAssign) {
            return;
        }
        this.createObj5();
        this.findObj5();
        this.queryObj5();
    }

    public void testMapsId6() {
        this.createObj6();
        this.findObj6();
        this.queryObj6();
    }

    public void testMapsId7() {
        this.createObj7();
        this.findObj7();
        this.queryObj7();
    }

    public void testEnumIdClass() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Employee e = new Employee();
        e.setEmpId(1);
        e.setEmpType(Employee.EmpType.A1);
        PhoneNumber phoneNumber = new PhoneNumber();
        phoneNumber.setPhNumber(1);
        phoneNumber.setEmp(e);
        e.setPhoneNumber(phoneNumber);
        em.persist((Object)phoneNumber);
        em.persist((Object)e);
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        em.flush();
        tran.commit();
        em.clear();
        PhoneNumber p = (PhoneNumber)em.find(PhoneNumber.class, (Object)1);
        Employee emp = p.getEmp();
        TestMappedById.assertEquals((int)1, (int)emp.getEmpId());
        em.close();
    }

    public void testEmbeddedIdNestedInIdClass() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EmployeeId5 eId1 = new EmployeeId5("Java", "Duke");
        Employee5 employee1 = new Employee5(eId1);
        Dependent5 dep1 = new Dependent5("1", employee1);
        em.persist((Object)dep1);
        em.persist((Object)employee1);
        em.getTransaction().begin();
        em.flush();
        em.getTransaction().commit();
        em.clear();
        DependentId5 depId1 = new DependentId5("1", eId1);
        Dependent5 newDep = (Dependent5)em.find(Dependent5.class, (Object)depId1);
        TestMappedById.assertNotNull((Object)newDep);
        em.getTransaction().begin();
        em.remove((Object)newDep);
        em.getTransaction().commit();
        newDep = (Dependent5)em.find(Dependent5.class, (Object)depId1);
        TestMappedById.assertNull((Object)newDep);
        em.close();
    }

    public void testCountDistinctMultiCols() {
        String[] jpqls;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Employee2 emp1 = new Employee2();
        EmployeeId2 empId1 = new EmployeeId2();
        empId1.setFirstName("James");
        empId1.setLastName("Bond");
        emp1.setEmpId(empId1);
        Employee2 emp2 = new Employee2();
        EmployeeId2 empId2 = new EmployeeId2();
        empId2.setFirstName("James");
        empId2.setLastName("Obama");
        emp2.setEmpId(empId2);
        Dependent2 dep1 = new Dependent2();
        DependentId2 depId1 = new DependentId2();
        depId1.setEmpPK(empId1);
        depId1.setName("Alan");
        dep1.setId(depId1);
        Dependent2 dep2 = new Dependent2();
        DependentId2 depId2 = new DependentId2();
        depId2.setEmpPK(empId2);
        depId2.setName("Darren");
        dep2.setId(depId2);
        em.persist((Object)emp1);
        em.persist((Object)emp2);
        em.persist((Object)dep1);
        em.persist((Object)dep2);
        em.getTransaction().begin();
        em.flush();
        em.getTransaction().commit();
        for (String jpql : jpqls = new String[]{"SELECT COUNT (DISTINCT d2.emp) FROM Dependent2 d2", "select count (DISTINCT d2) from Dependent2 d2"}) {
            Query q = em.createQuery(jpql);
            Long o = (Long)q.getSingleResult();
            int count = (int)o.longValue();
            TestMappedById.assertEquals((int)2, (int)count);
        }
        em.close();
    }

    public void createObj1() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        for (int i = 0; i < this.numEmployees; ++i) {
            this.createEmployee1((EntityManager)em, this.eId1++);
        }
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public Employee1 createEmployee1(EntityManager em, int id) {
        Employee1 e = new Employee1();
        e.setEmpId(id);
        e.setName("emp_" + id);
        for (int i = 0; i < this.numDependentsPerEmployee; ++i) {
            Dependent1 d = this.createDependent1(em, this.dId1++, e);
            e.addDependent(d);
            em.persist((Object)d);
        }
        em.persist((Object)e);
        this.emps1.put(id, e);
        return e;
    }

    public Dependent1 createDependent1(EntityManager em, int id, Employee1 e) {
        Dependent1 d = new Dependent1();
        DependentId1 did = new DependentId1();
        did.setName("dep_" + id);
        d.setId(did);
        d.setEmp(e);
        this.deps1.put(did.getName(), d);
        return d;
    }

    public void findObj1() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Employee1 e = (Employee1)em.find(Employee1.class, (Object)1);
        List<Dependent1> ds = e.getDependents();
        TestMappedById.assertEquals((int)this.numDependentsPerEmployee, (int)ds.size());
        Employee1 e0 = this.emps1.get(1);
        TestMappedById.assertEquals((Object)e0, (Object)e);
        em.close();
    }

    public void queryObj1() {
        this.queryDependent1();
    }

    public void queryDependent1() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        String jpql = "select d from Dependent1 d where d.id.name = 'dep_1' AND d.emp.name = 'emp_1'";
        Query q = em.createQuery(jpql);
        List ds = q.getResultList();
        for (Dependent1 d : ds) {
            this.assertDependent1(d);
        }
        tran.commit();
        em.close();
    }

    public void assertDependent1(Dependent1 d) {
        DependentId1 id = d.getId();
        Dependent1 d0 = this.deps1.get(id.getName());
        if (DependentId1.pcGetempPK(Dependent1.pcGetid(d0)) == 0L) {
            DependentId1.pcSetempPK(Dependent1.pcGetid(d0), Dependent1.pcGetemp(d0).getEmpId());
        }
        TestMappedById.assertEquals((Object)d0, (Object)d);
    }

    public void createObj2() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        for (int i = 0; i < this.numEmployees; ++i) {
            this.createEmployee2((EntityManager)em, this.eId2++);
        }
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public Employee2 createEmployee2(EntityManager em, int id) {
        Employee2 e = new Employee2();
        e.setEmpId(new EmployeeId2("f_" + id, "l_" + id));
        for (int i = 0; i < this.numDependentsPerEmployee; ++i) {
            Dependent2 d = this.createDependent2(em, this.dId2++, e);
            e.addDependent(d);
            em.persist((Object)d);
        }
        em.persist((Object)e);
        this.emps2.put(id, e);
        return e;
    }

    public Dependent2 createDependent2(EntityManager em, int id, Employee2 e) {
        Dependent2 d = new Dependent2();
        DependentId2 did = new DependentId2();
        did.setName("dep_" + id);
        d.setEmp(e);
        d.setId(did);
        em.persist((Object)d);
        this.deps2.put(did.getName(), d);
        return d;
    }

    public void findObj2() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Employee2 e = (Employee2)em.find(Employee2.class, (Object)new EmployeeId2("f_1", "l_1"));
        List<Dependent2> ds = e.getDependents();
        TestMappedById.assertEquals((int)this.numDependentsPerEmployee, (int)ds.size());
        Employee2 e0 = this.emps2.get(1);
        TestMappedById.assertEquals((Object)e0, (Object)e);
        em.close();
    }

    public void queryObj2() {
        this.queryDependent2();
    }

    public void queryDependent2() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        String jpql = "select d from Dependent2 d where d.id.name = 'dep_1' AND d.id.empPK.firstName = 'f_1'";
        Query q = em.createQuery(jpql);
        List ds = q.getResultList();
        for (Dependent2 d : ds) {
            this.assertDependent2(d);
        }
        jpql = "select d from Dependent2 d where d.id.name = 'dep_1' AND d.emp.empId.firstName = 'f_1'";
        q = em.createQuery(jpql);
        ds = q.getResultList();
        for (Dependent2 d : ds) {
            this.assertDependent2(d);
        }
        em.close();
    }

    public void assertDependent2(Dependent2 d) {
        DependentId2 did = d.getId();
        Dependent2 d0 = this.deps2.get(did.getName());
        DependentId2 did0 = d0.getId();
        did0.setEmpPK(d0.getEmp().getEmpId());
        TestMappedById.assertEquals((Object)d0, (Object)d);
    }

    public void createObj3() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        for (int i = 0; i < this.numPersons; ++i) {
            this.createPerson1((EntityManager)em, this.pId1++);
        }
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public Person1 createPerson1(EntityManager em, int id) {
        Person1 p = new Person1();
        PersonId1 pid = new PersonId1();
        pid.setFirstName("f_" + id);
        pid.setLastName("l_" + id);
        p.setId(pid);
        MedicalHistory1 m = this.createMedicalHistory1(em, this.mId1++);
        m.setPatient(p);
        p.setMedical(m);
        em.persist((Object)m);
        em.persist((Object)p);
        this.persons1.put(pid.getFirstName(), p);
        this.medicals1.put(m.getPatient().getId().getFirstName(), m);
        return p;
    }

    public MedicalHistory1 createMedicalHistory1(EntityManager em, int id) {
        MedicalHistory1 m = new MedicalHistory1();
        m.setName("medical_" + id);
        return m;
    }

    public void findObj3() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        PersonId1 pid = new PersonId1();
        pid.setFirstName("f_1");
        pid.setLastName("l_1");
        Person1 p = (Person1)em.find(Person1.class, (Object)pid);
        Person1 p0 = this.persons1.get(pid.getFirstName());
        TestMappedById.assertEquals((Object)p0, (Object)p);
        em.close();
    }

    public void queryObj3() {
        this.queryMedicalHistory1();
    }

    public void queryMedicalHistory1() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        String firstName = "f_1";
        tran.begin();
        String jpql = "select m from MedicalHistory1 m where m.patient.id.firstName = '" + firstName + "'";
        Query q = em.createQuery(jpql);
        List ms = q.getResultList();
        for (MedicalHistory1 m : ms) {
            this.assertMedicalHistory1(m, firstName);
        }
        jpql = "select m from MedicalHistory1 m where m.id.firstName = '" + firstName + "'";
        q = em.createQuery(jpql);
        ms = q.getResultList();
        for (MedicalHistory1 m : ms) {
            this.assertMedicalHistory1(m, firstName);
        }
        tran.commit();
        em.close();
    }

    public void assertMedicalHistory1(MedicalHistory1 m, String firstName) {
        MedicalHistory1 m0 = this.medicals1.get(firstName);
        TestMappedById.assertEquals((Object)m0, (Object)m);
    }

    public void createObj4() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        for (int i = 0; i < this.numPersons; ++i) {
            this.createPerson2((EntityManager)em, this.pId2++);
        }
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public Person2 createPerson2(EntityManager em, int id) {
        Person2 p = new Person2();
        p.setName("p_" + id);
        MedicalHistory2 m = this.createMedicalHistory2(em, this.mId2++);
        m.setPatient(p);
        p.setMedical(m);
        em.persist((Object)m);
        this.medicals2.put(m.getName(), m);
        em.persist((Object)p);
        this.persons2.put(p.getName(), p);
        return p;
    }

    public MedicalHistory2 createMedicalHistory2(EntityManager em, int id) {
        MedicalHistory2 m = new MedicalHistory2();
        m.setName("medical_" + id);
        return m;
    }

    public void findObj4(long ssn) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Person2 p = (Person2)em.find(Person2.class, (Object)ssn);
        Person2 p1 = p.getMedical().getPatient();
        TestMappedById.assertEquals((Object)p1, (Object)p);
        em.close();
    }

    public void queryObj4() {
        this.queryMedicalHistory4();
    }

    public void queryMedicalHistory4() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        HashMap medicals = new HashMap();
        long ssn = 0L;
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        String jpql = "select m from MedicalHistory2 m";
        Query q = em.createQuery(jpql);
        List ms = q.getResultList();
        for (MedicalHistory2 m : ms) {
            ssn = m.getId();
        }
        tran.commit();
        em.close();
        em = this.emf.createEntityManager();
        tran = em.getTransaction();
        tran.begin();
        jpql = "select m from MedicalHistory2 m where m.patient.ssn = " + ssn;
        q = em.createQuery(jpql);
        ms = q.getResultList();
        for (MedicalHistory2 m : ms) {
            this.assertMedicalHistory2(m);
        }
        tran.commit();
        em.close();
        this.findObj4(ssn);
    }

    public void assertMedicalHistory2(MedicalHistory2 m) {
        String name = m.getName();
        MedicalHistory2 m0 = this.medicals2.get(name);
        MedicalHistory2 m1 = m.getPatient().getMedical();
        TestMappedById.assertEquals((Object)m1, (Object)m);
    }

    public void createObj5() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        for (int i = 0; i < this.numEmployees; ++i) {
            this.createEmployee3((EntityManager)em, this.eId3++);
        }
        tran.begin();
        em.flush();
        tran.commit();
        for (Dependent3 d : this.deps3) {
            ObjectId did = (ObjectId)((StateManagerImpl)((PersistenceCapable)d).pcGetStateManager()).getObjectId();
            this.dids3.add(did.getId());
            this.depMap3.put(did.getId(), d);
        }
        em.close();
    }

    public Employee3 createEmployee3(EntityManager em, int id) {
        Employee3 e = new Employee3();
        e.setName("emp_" + id);
        for (int i = 0; i < this.numDependentsPerEmployee; ++i) {
            Dependent3 d = this.createDependent3(em, this.dId3++, e);
            e.addDependent(d);
            em.persist((Object)d);
        }
        em.persist((Object)e);
        this.emps3.put(id, e);
        return e;
    }

    public Dependent3 createDependent3(EntityManager em, int id, Employee3 e) {
        Dependent3 d = new Dependent3();
        DependentId3 did = new DependentId3();
        did.setName("dep_" + id);
        d.setId(did);
        d.setEmp(e);
        this.deps3.add(d);
        Parent3 p = new Parent3();
        p.setName("p_" + id);
        p.setDependent(d);
        d.setParent(p);
        em.persist((Object)p);
        return d;
    }

    public void findObj5() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Dependent3 d = (Dependent3)em.find(Dependent3.class, this.dids3.get(1));
        Dependent3 d0 = this.depMap3.get(this.dids3.get(1));
        TestMappedById.assertEquals((Object)d0, (Object)d);
        em.close();
    }

    public void queryObj5() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        String jpql = "select d from Dependent3 d where d.id.name = 'dep_1' AND d.emp.name = 'emp_1'";
        Query q = em.createQuery(jpql);
        List ds = q.getResultList();
        for (Dependent3 d : ds) {
            this.assertDependent3(d);
        }
        tran.commit();
        em.close();
    }

    public void assertDependent3(Dependent3 d) {
        DependentId3 id = d.getId();
        Dependent3 d0 = this.depMap3.get(id);
        if (DependentId3.pcGetempPK(Dependent3.pcGetid(d0)) == 0L) {
            DependentId3.pcSetempPK(Dependent3.pcGetid(d0), Dependent3.pcGetemp(d0).getEmpId());
        }
        TestMappedById.assertEquals((Object)d0, (Object)d);
    }

    public void createObj6() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        for (int i = 0; i < this.numPersons; ++i) {
            this.createPerson3((EntityManager)em, this.pId3++);
        }
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public Person3 createPerson3(EntityManager em, int id) {
        Person3 p = new Person3();
        p.setFirstName("f_" + id);
        p.setLastName("l_" + id);
        MedicalHistory3 m = this.createMedicalHistory3(em, this.mId3++);
        m.setPatient(p);
        p.setMedical(m);
        em.persist((Object)m);
        em.persist((Object)p);
        this.persons3.put(p.getFirstName(), p);
        this.medicals3.put(m.getPatient().getFirstName(), m);
        return p;
    }

    public MedicalHistory3 createMedicalHistory3(EntityManager em, int id) {
        MedicalHistory3 m = new MedicalHistory3();
        m.setName("medical_" + id);
        return m;
    }

    public void findObj6() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Person3 p = (Person3)em.find(Person3.class, (Object)new PersonId3("f_1", "l_1"));
        Person3 p0 = this.persons3.get("f_1");
        Person3 p1 = p.getMedical().getPatient();
        TestMappedById.assertEquals((Object)p, (Object)p1);
        em.clear();
        MedicalHistory3 m = (MedicalHistory3)em.find(MedicalHistory3.class, (Object)new PersonId3("f_1", "l_1"));
        MedicalHistory3 m0 = this.medicals3.get("f_1");
        TestMappedById.assertEquals((Object)m, (Object)m0);
        em.getTransaction().begin();
        em.remove((Object)m);
        em.getTransaction().commit();
        em.close();
    }

    public void queryObj6() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        String firstName = "f_1";
        String jpql = "select m from MedicalHistory3 m where m.patient.firstName = '" + firstName + "'";
        Query q = em.createQuery(jpql);
        List ms = q.getResultList();
        for (MedicalHistory3 m : ms) {
            this.assertMedicalHistory3(m, firstName);
        }
        tran.commit();
        em.close();
    }

    public void assertMedicalHistory3(MedicalHistory3 m, String firstName) {
        MedicalHistory3 m0 = this.medicals3.get(firstName);
        TestMappedById.assertEquals((Object)m0, (Object)m);
    }

    public void createObj7() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        for (int i = 0; i < this.numPersons; ++i) {
            this.createPerson4((EntityManager)em, this.pId4++);
        }
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public Person4 createPerson4(EntityManager em, int id) {
        Person4 p = new Person4();
        p.setId(new PersonId4("f_" + id, "l_" + id));
        MedicalHistory4 m = this.createMedicalHistory4(em, this.mId4++);
        m.setPatient(p);
        p.setMedical(m);
        em.persist((Object)p);
        em.persist((Object)m);
        this.persons4.put(p.getId().getFirstName(), p);
        this.medicals4.put(m.getPatient().getId().getFirstName(), m);
        return p;
    }

    public MedicalHistory4 createMedicalHistory4(EntityManager em, int id) {
        MedicalHistory4 m = new MedicalHistory4();
        m.setName("medical_" + id);
        return m;
    }

    public void findObj7() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Person4 p = (Person4)em.find(Person4.class, (Object)new PersonId4("f_1", "l_1"));
        Person4 p0 = this.persons4.get("f_1");
        Person4 p1 = p.getMedical().getPatient();
        TestMappedById.assertEquals((Object)p1, (Object)p);
        em.clear();
        MedicalHistory4 m = (MedicalHistory4)em.find(MedicalHistory4.class, (Object)new PersonId4("f_1", "l_1"));
        MedicalHistory4 m0 = this.medicals4.get("f_1");
        TestMappedById.assertEquals((Object)m, (Object)m0);
        em.close();
    }

    public void queryObj7() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        String firstName = "f_1";
        String jpql = "select m from MedicalHistory4 m where m.patient.id.firstName = '" + firstName + "'";
        Query q = em.createQuery(jpql);
        List ms = q.getResultList();
        for (MedicalHistory4 m : ms) {
            this.assertMedicalHistory4(m, firstName);
        }
        tran.commit();
        em.close();
    }

    public void assertMedicalHistory4(MedicalHistory4 m, String firstName) {
        MedicalHistory4 m0 = this.medicals4.get(firstName);
        MedicalHistory4 m1 = m.getPatient().getMedical();
        TestMappedById.assertEquals((Object)m1, (Object)m);
    }

    public void testPersistDerivedIdentityUsingIdClassAndGeneratedKey() {
        if (!((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance().supportsAutoAssign) {
            return;
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        for (int i = 0; i < this.numEmployees; ++i) {
            this.persistEmployee4((EntityManager)em, this.eId4++);
        }
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public void testMergeDerivedIdentityUsingIdClassAndGeneratedKey() {
        if (!((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance().supportsAutoAssign) {
            return;
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        for (int i = 0; i < this.numEmployees; ++i) {
            this.mergeEmployee4((EntityManager)em, this.eId4++);
        }
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public Employee4 persistEmployee4(EntityManager em, int id) {
        Employee4 p = new Employee4();
        p.setAge(id);
        for (int i = 0; i < this.numDependentsPerEmployee; ++i) {
            Dependent4 c = this.persistDependent4(em, this.dId4++, p);
            p.addChild(c);
        }
        em.persist((Object)p);
        return p;
    }

    public Dependent4 persistDependent4(EntityManager em, int id, Employee4 p) {
        Dependent4 c = new Dependent4();
        c.setId(id);
        c.setParent(p);
        em.persist((Object)c);
        return c;
    }

    public Employee4 mergeEmployee4(EntityManager em, int id) {
        Employee4 e = new Employee4();
        e.setAge(id);
        e = (Employee4)em.merge((Object)e);
        for (int i = 0; i < this.numDependentsPerEmployee; ++i) {
            Dependent4 d = new Dependent4();
            d.setId(this.dId4++);
            d.setParent(e);
            d = (Dependent4)em.merge((Object)d);
            e.addChild(d);
        }
        return e;
    }

    public void testEnumInEmbeddedId() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Beneficiary b = new Beneficiary();
        b.setId("b8");
        ArrayList<BeneContact> contacts = new ArrayList<BeneContact>();
        BeneContact c = new BeneContact();
        c.setEmail("email8");
        BeneContactId id = new BeneContactId();
        id.setContactType(BeneContactId.ContactType.HOME);
        c.setBeneficiary(b);
        c.setId(id);
        em.persist((Object)c);
        contacts.add(c);
        b.setContacts(contacts);
        em.persist((Object)b);
        em.getTransaction().begin();
        em.flush();
        em.getTransaction().commit();
        em.clear();
        BeneContactId id1 = c.getId();
        BeneContact c1 = (BeneContact)em.find(BeneContact.class, (Object)id1);
        TestMappedById.assertEquals((String)"email8", (String)c1.getEmail());
        em.close();
    }
}

