/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.enhance;

import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.enhance.common.apps.NoClone;
import org.apache.openjpa.persistence.enhance.common.apps.PCClone;
import org.apache.openjpa.persistence.enhance.common.apps.SubclassClone;

public class TestClone
extends AbstractTestCase {
    public TestClone(String name) {
        super(name, "enhancecactusapp");
    }

    public void setUp() {
        this.deleteAll(NoClone.class);
        this.deleteAll(PCClone.class);
        this.deleteAll(SubclassClone.class);
    }

    public void testNoClone() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        NoClone orig = new NoClone("test");
        pm.persist((Object)orig);
        this.endTx((EntityManager)pm);
        pm.refresh((Object)orig);
        NoClone copy = orig.safeClone();
        TestClone.assertEquals((String)"test", (String)copy.getString());
        TestClone.assertTrue((boolean)pm.isPersistent((Object)orig));
        TestClone.assertFalse((boolean)pm.isPersistent((Object)copy));
        this.endEm((EntityManager)pm);
    }

    public void testSubclassClone() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        SubclassClone orig = new SubclassClone("test");
        pm.persist((Object)orig);
        this.endTx((EntityManager)pm);
        pm.refresh((Object)orig);
        SubclassClone copy = orig.safeClone();
        TestClone.assertEquals((String)"test", (String)copy.getString());
        TestClone.assertTrue((boolean)pm.isPersistent((Object)orig));
        TestClone.assertTrue((boolean)pm.isPersistent((Object)copy));
        this.endEm((EntityManager)pm);
    }

    public void testPCClone() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        PCClone orig = new PCClone("test");
        pm.persist((Object)orig);
        this.endTx((EntityManager)pm);
        pm.refresh((Object)orig);
        PCClone copy = (PCClone)orig.clone();
        TestClone.assertEquals((String)"test", (String)copy.getString());
        TestClone.assertTrue((boolean)pm.isPersistent((Object)orig));
        TestClone.assertFalse((boolean)pm.isPersistent((Object)copy));
        this.endEm((EntityManager)pm);
    }
}

