/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.embed.compositepk;

import java.util.ArrayList;
import java.util.Arrays;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.openjpa.persistence.embed.compositepk.Subject;
import org.apache.openjpa.persistence.embed.compositepk.SubjectKey;
import org.apache.openjpa.persistence.embed.compositepk.SubjectWithIdClass;
import org.apache.openjpa.persistence.embed.compositepk.Topic;
import org.apache.openjpa.persistence.embed.compositepk.Topic_;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;
import org.junit.Assert;

public class TestCompositePrimaryKeys
extends SingleEMFTestCase {
    protected EntityManager em;
    private EntityTransaction tx;

    @Override
    public void setUp() {
        super.setUp(DROP_TABLES, Subject.class, SubjectKey.class, SubjectWithIdClass.class, Topic.class);
        this.em = this.emf.createEntityManager();
        this.tx = this.em.getTransaction();
        this.tx.begin();
        this.createData();
    }

    public void testFindUsingFindOnSubjectKey() {
        Subject s = this.createSubject();
        Subject s2 = (Subject)this.em.find(Subject.class, (Object)s.getKey());
        this.verifySubject(s, s2);
    }

    public void testFindUsingEqualsOnObjectJPQL() {
        Subject s = this.createSubject();
        TypedQuery query = this.em.createQuery("select distinct s from Subject s where s.key.subjectNummer = :subjectNummer AND s.key.subjectTypeCode = :subjectTypeCode", Subject.class);
        query.setParameter("subjectNummer", (Object)s.getKey().getSubjectNummer());
        query.setParameter("subjectTypeCode", (Object)s.getKey().getSubjectTypeCode());
        Subject s2 = (Subject)query.getSingleResult();
        this.verifySubject(s, s2);
    }

    public void testFindUsingJPQLEqualsOnSubjectKeyAttributes() {
        Subject s = this.createSubject();
        TypedQuery query = this.em.createQuery("select distinct t from Topic t where t.subject.key.subjectNummer = :subjectNummer AND t.subject.key.subjectTypeCode = :subjectTypeCode", Topic.class);
        query.setParameter("subjectNummer", (Object)s.getKey().getSubjectNummer());
        query.setParameter("subjectTypeCode", (Object)s.getKey().getSubjectTypeCode());
        Topic topic = (Topic)query.getSingleResult();
        this.verifyResults(topic, s);
    }

    public void testFindUsingJPQLEqualsOnSubjectKey() {
        try {
            this.em.createQuery("select distinct t from Topic t where t.subject.key = :subjectKey");
        }
        catch (Throwable t) {
            Assert.assertTrue((boolean)t.getMessage().contains("does not support conditional expression"));
        }
    }

    public void testFindSubjectUsingJPQLEqualsOnSubject() {
        Subject s = this.createSubject();
        TypedQuery query = this.em.createQuery("select s from Subject s where s = :subject", Subject.class);
        query.setParameter("subject", (Object)s);
        Subject s2 = (Subject)query.getSingleResult();
        this.verifySubject(s, s2);
    }

    public void testFindUsingNamedQuery() {
        Subject s = this.createSubject();
        TypedQuery q = this.em.createNamedQuery("bySubject", Topic.class);
        q.setParameter("subject", (Object)s);
        Topic topic = (Topic)q.getSingleResult();
        this.verifyResults(topic, s);
    }

    public void testFindUsingJPQLEqualsOnSubject() {
        Subject s = this.createSubject();
        TypedQuery query = this.em.createQuery("select distinct t from Topic t where t.subject = :subject", Topic.class);
        query.setParameter("subject", (Object)s);
        Topic topic = (Topic)query.getSingleResult();
        this.verifyResults(topic, s);
    }

    public void testFindUsingJPQLSubjectKeyIn() {
        Query query = this.em.createQuery("select distinct s from Subject s where s.key in :subjectKeyList");
        query.setParameter("subjectKeyList", Arrays.asList(new SubjectKey(1, "Type"), new SubjectKey(2, "Type2"), new SubjectKey(3, "Type3")));
        query.getResultList();
    }

    public void testFindSubjectUsingCriteriaBuilderEqualsAndParameter() {
        Subject s = this.createSubject();
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery cq = builder.createQuery(Subject.class);
        Root subjectRoot = cq.from(Subject.class);
        cq.select((Selection)subjectRoot);
        ParameterExpression param1 = builder.parameter(Subject.class, "subject");
        Predicate subjectPredicate = builder.equal((Expression)subjectRoot, (Expression)param1);
        cq.where((Expression)subjectPredicate);
        TypedQuery query = this.em.createQuery(cq);
        query.setParameter("subject", (Object)s);
        Subject s2 = (Subject)query.getSingleResult();
        this.verifySubject(s, s2);
    }

    public void testFindSubjectUsingCriteriaBuilderEquals() {
        Subject s = this.createSubject();
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery cq = builder.createQuery(Subject.class);
        Root subjectRoot = cq.from(Subject.class);
        cq.select((Selection)subjectRoot);
        Predicate subjectPredicate = builder.equal((Expression)subjectRoot, (Object)s);
        cq.where((Expression)subjectPredicate);
        TypedQuery query = this.em.createQuery(cq);
        Subject s2 = (Subject)query.getSingleResult();
        this.verifySubject(s, s2);
    }

    public void testFindTopicUsingCriteriaBuilderEquals() {
        Topic t = new Topic();
        t.setId(5);
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery cq = builder.createQuery(Topic.class);
        Root topicRoot = cq.from(Topic.class);
        cq.select((Selection)topicRoot);
        Predicate topicPredicate = builder.equal((Expression)topicRoot, (Object)t);
        cq.where((Expression)topicPredicate);
        TypedQuery query = this.em.createQuery(cq);
        Topic topic = (Topic)query.getSingleResult();
        this.verifyResults(topic, this.createSubject());
    }

    public void testFindUsingCriteriaBuilderEquals() {
        Subject s = this.createSubject();
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery cq = builder.createQuery(Topic.class);
        Root topic = cq.from(Topic.class);
        cq.select((Selection)topic).distinct(true);
        Predicate topicPredicate = builder.equal((Expression)topic.get("subject"), (Object)s);
        cq.where((Expression)topicPredicate);
        TypedQuery query = this.em.createQuery(cq);
        Topic t = (Topic)query.getSingleResult();
        this.verifyResults(t, s);
    }

    public void testFindUsingJPQLInClauseOnSubject() {
        Subject s = this.createSubject();
        SubjectKey key = new SubjectKey(999, "Bla");
        Subject s2 = new Subject();
        s2.setKey(key);
        ArrayList<Subject> subjectList = new ArrayList<Subject>();
        subjectList.add(s);
        subjectList.add(s2);
        TypedQuery query = this.em.createQuery("select distinct t from Topic t where t.subject in :subjectList", Topic.class);
        query.setParameter("subjectList", subjectList);
        Topic t = (Topic)query.getSingleResult();
        this.verifyResults(t, s);
    }

    public void testFindUsingCriteriaBuilderInClauseOnSubject() {
        Subject s = this.createSubject();
        SubjectKey key = new SubjectKey(999, "Bla");
        Subject s2 = new Subject();
        s2.setKey(key);
        ArrayList<Subject> subjectList = new ArrayList<Subject>();
        subjectList.add(s);
        subjectList.add(s2);
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery cq = builder.createQuery(Topic.class);
        Root topic = cq.from(Topic.class);
        cq.select((Selection)topic).distinct(true);
        Predicate subjectInSubjectList = topic.get(Topic_.subject).in(subjectList);
        cq.where((Expression)subjectInSubjectList);
        TypedQuery query = this.em.createQuery(cq);
        Topic t = (Topic)query.getSingleResult();
        this.verifyResults(t, s);
    }

    public void testFindUsingJPQLEqualsOnSubjectWithIdClass() {
        SubjectWithIdClass s = new SubjectWithIdClass();
        s.setSubjectNummer(1);
        s.setSubjectTypeCode("Type");
        TypedQuery query = this.em.createQuery("select s from SubjectWithIdClass s where s = :subject", SubjectWithIdClass.class);
        query.setParameter("subject", (Object)s);
        SubjectWithIdClass s2 = (SubjectWithIdClass)query.getSingleResult();
        Assert.assertNotNull((Object)s2);
        Assert.assertEquals((Object)s.getSubjectNummer(), (Object)s2.getSubjectNummer());
        Assert.assertEquals((Object)s.getSubjectTypeCode(), (Object)s2.getSubjectTypeCode());
    }

    public void testFindUsingCriteriaBuilderOnSubjectWithIdClass() {
        SubjectWithIdClass s = new SubjectWithIdClass();
        s.setSubjectNummer(1);
        s.setSubjectTypeCode("Type");
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery cq = builder.createQuery(SubjectWithIdClass.class);
        Root subjectRoot = cq.from(SubjectWithIdClass.class);
        cq.select((Selection)subjectRoot);
        Predicate subjectPredicate = builder.equal((Expression)subjectRoot, (Object)s);
        cq.where((Expression)subjectPredicate);
        TypedQuery query = this.em.createQuery(cq);
        SubjectWithIdClass s2 = (SubjectWithIdClass)query.getSingleResult();
        Assert.assertNotNull((Object)s2);
        Assert.assertEquals((Object)s.getSubjectNummer(), (Object)s2.getSubjectNummer());
        Assert.assertEquals((Object)s.getSubjectTypeCode(), (Object)s2.getSubjectTypeCode());
    }

    private void createData() {
        Subject s = new Subject();
        SubjectKey sk = new SubjectKey();
        sk.setSubjectNummer(1);
        sk.setSubjectType("Type2");
        s.setKey(sk);
        this.em.persist((Object)s);
        s = new Subject();
        sk = new SubjectKey();
        sk.setSubjectNummer(1);
        sk.setSubjectType("Type");
        s.setKey(sk);
        this.em.persist((Object)s);
        Topic t = new Topic();
        t.setId(5);
        t.setSubject(s);
        this.em.persist((Object)t);
        SubjectWithIdClass swic = new SubjectWithIdClass();
        swic.setSubjectNummer(1);
        swic.setSubjectTypeCode("Type");
        this.em.persist((Object)swic);
        swic = new SubjectWithIdClass();
        swic.setSubjectNummer(1);
        swic.setSubjectTypeCode("Type2");
        this.em.persist((Object)swic);
        this.em.flush();
    }

    private Subject createSubject() {
        SubjectKey key = new SubjectKey(1, "Type");
        Subject result = new Subject();
        result.setKey(key);
        return result;
    }

    public void verifyResults(Topic topic, Subject s) {
        Assert.assertNotNull((Object)topic);
        Assert.assertEquals((Object)new Integer(5), (Object)topic.getId());
        Subject s2 = topic.getSubject();
        this.verifySubject(s, s2);
    }

    public void verifySubject(Subject expected, Subject actual) {
        Assert.assertNotNull((Object)expected);
        Assert.assertEquals((Object)expected.getKey().getSubjectNummer(), (Object)actual.getKey().getSubjectNummer());
        Assert.assertEquals((Object)expected.getKey().getSubjectTypeCode(), (Object)actual.getKey().getSubjectTypeCode());
    }

    @Override
    public void tearDown() {
        if (this.tx != null && this.tx.isActive()) {
            this.tx.rollback();
            this.tx = null;
        }
        if (this.em != null && this.em.isOpen()) {
            this.em.close();
            this.em = null;
        }
    }
}

