/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.embed.attrOverrides;

import java.math.BigDecimal;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.embed.attrOverrides.Address;
import org.apache.openjpa.persistence.embed.attrOverrides.Customer;
import org.apache.openjpa.persistence.embed.attrOverrides.Person;
import org.apache.openjpa.persistence.embed.attrOverrides.PropertyInfo;
import org.apache.openjpa.persistence.embed.attrOverrides.PropertyOwner;
import org.apache.openjpa.persistence.embed.attrOverrides.PropertyRecord;
import org.apache.openjpa.persistence.embed.attrOverrides.Zipcode;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestAttrOverrides
extends SQLListenerTestCase {
    public int numPersons = 4;
    public int numPropertiesPerPersons = 4;
    public int eId = 1;
    public int pId = 1;

    @Override
    public void setUp() throws Exception {
        super.setUp(DROP_TABLES, Address.class, Customer.class, PropertyInfo.class, PropertyOwner.class, PropertyRecord.class, Zipcode.class, Person.class);
    }

    public void testAttrOverride1() {
        this.sql.clear();
        this.createObj1();
        this.findObj1();
        this.queryObj1();
        this.assertAttrOverrides("CUS_ATTROVER");
    }

    public void testAttrOverride2() {
        this.sql.clear();
        this.createObj2();
        this.findObj2();
        this.queryObj2();
        this.assertAttrOverrides("PROPREC_ATTROVER_parcels");
    }

    public void testEmbeddableOrderBy() {
        this.sql.clear();
        this.createObj3();
        this.findObj3();
    }

    public void createObj1() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        for (int i = 0; i < this.numPersons; ++i) {
            this.createCustomer((EntityManager)em, this.eId++);
        }
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public Customer createCustomer(EntityManager em, int id) {
        Customer p = new Customer();
        p.setId(id);
        Address addr = new Address();
        addr.setCity("city_" + id);
        addr.setState("state_" + id);
        addr.setStreet("street_" + id);
        p.setAddress(addr);
        p.setName("name_" + id);
        em.persist((Object)p);
        return p;
    }

    public void findObj1() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Customer p = (Customer)em.find(Customer.class, (Object)1);
        TestAttrOverrides.assertEquals((Object)p.getId(), (Object)new Integer(1));
        TestAttrOverrides.assertEquals((String)p.getAddress().getCity(), (String)"city_1");
        TestAttrOverrides.assertEquals((String)p.getAddress().getStreet(), (String)"street_1");
        TestAttrOverrides.assertEquals((String)p.getAddress().getState(), (String)"state_1");
        TestAttrOverrides.assertEquals((String)p.getName(), (String)"name_1");
        em.close();
    }

    public void queryObj1() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        String jpql = "select p from Customer p";
        Query q = em.createQuery(jpql);
        List ps = q.getResultList();
        TestAttrOverrides.assertEquals((int)ps.size(), (int)this.numPersons);
        tran.commit();
        em.close();
    }

    public void createObj2() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        for (int i = 0; i < this.numPersons; ++i) {
            this.createPropertyRecord((EntityManager)em, this.pId++);
        }
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public PropertyRecord createPropertyRecord(EntityManager em, int id) {
        PropertyRecord p = new PropertyRecord();
        PropertyOwner owner = new PropertyOwner();
        owner.setSsn("ssn_" + id);
        Address addr = new Address();
        addr.setCity("city_" + id);
        addr.setState("state_" + id);
        addr.setStreet("street_" + id);
        Zipcode zipcode = new Zipcode();
        zipcode.setZip("zip_" + id);
        zipcode.setPlusFour("+4_" + id);
        addr.setZipcode(zipcode);
        owner.setAddress(addr);
        p.setOwner(owner);
        for (int i = 0; i < this.numPropertiesPerPersons; ++i) {
            PropertyInfo info = new PropertyInfo();
            info.setParcelNumber(id * 10 + i);
            info.setSize(id * 10 + i);
            info.setTax(new BigDecimal(id * 10 + i));
            Address paddr = new Address();
            paddr.setCity("pcity_" + id + "_" + i);
            paddr.setState("pstate_" + id + "_" + i);
            paddr.setStreet("pstreet_" + id + "_" + i);
            Zipcode pzipcode = new Zipcode();
            pzipcode.setZip("pzip_" + id + "_" + i);
            pzipcode.setPlusFour("p+4_" + id + "_" + i);
            paddr.setZipcode(zipcode);
            p.addParcel(paddr, info);
        }
        em.persist((Object)p);
        return p;
    }

    public void findObj2() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        PropertyOwner owner = new PropertyOwner();
        owner.setSsn("ssn_1");
        Address addr = new Address();
        addr.setCity("city_1");
        addr.setState("state_1");
        addr.setStreet("street_1");
        Zipcode zipcode = new Zipcode();
        zipcode.setZip("zip_1");
        zipcode.setPlusFour("+4_1");
        addr.setZipcode(zipcode);
        owner.setAddress(addr);
        PropertyRecord p = (PropertyRecord)em.find(PropertyRecord.class, (Object)owner);
        TestAttrOverrides.assertEquals((String)p.getOwner().getSsn(), (String)"ssn_1");
        TestAttrOverrides.assertEquals((String)p.getOwner().getAddress().getCity(), (String)"city_1");
        TestAttrOverrides.assertEquals((String)p.getOwner().getAddress().getStreet(), (String)"street_1");
        TestAttrOverrides.assertEquals((String)p.getOwner().getAddress().getState(), (String)"state_1");
        TestAttrOverrides.assertEquals((String)p.getOwner().getAddress().getZipcode().getZip(), (String)"zip_1");
        TestAttrOverrides.assertEquals((String)p.getOwner().getAddress().getZipcode().getPlusFour(), (String)"+4_1");
        TestAttrOverrides.assertEquals((int)p.getParcels().size(), (int)this.numPropertiesPerPersons);
        em.close();
    }

    public void queryObj2() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        String jpql = "select p from PropertyRecord p";
        Query q = em.createQuery(jpql);
        List ps = q.getResultList();
        TestAttrOverrides.assertEquals((int)ps.size(), (int)this.numPersons);
        tran.commit();
        em.close();
    }

    public void assertAttrOverrides(String tableName) {
        boolean found = false;
        for (String sqlStr : this.sql) {
            if (sqlStr.indexOf("CREATE TABLE " + tableName + " ") == -1) continue;
            if (tableName.equals("CUS_ATTROVER")) {
                found = true;
                if (sqlStr.indexOf("ADDR_STATE") != -1 && sqlStr.indexOf("ADDR_ZIP") != -1 && sqlStr.indexOf("ADDR_PLUSFOUR") != -1) break;
                TestAttrOverrides.fail();
                break;
            }
            if (!tableName.equals("PROPREC_ATTROVER_parcels")) break;
            found = true;
            if (sqlStr.indexOf("STREET_NAME") != -1 && sqlStr.indexOf("SQUARE_FEET") != -1 && sqlStr.indexOf("ASSESSMENT") != -1) break;
            TestAttrOverrides.fail();
            break;
        }
        if (!found) {
            TestAttrOverrides.fail();
        }
    }

    public void createObj3() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        for (int i = 0; i < this.numPersons; ++i) {
            this.createPerson((EntityManager)em, this.eId++);
        }
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public Person createPerson(EntityManager em, int id) {
        Person p = new Person();
        p.setSsn("ssn" + id);
        p.setName("name_" + id);
        for (int i = 4; i > 0; --i) {
            Address addr = new Address();
            addr.setCity("city_" + id + "_" + i);
            addr.setState("state_" + id + "_" + i);
            addr.setStreet("street_" + id + "_" + i);
            Zipcode zipCode = new Zipcode();
            zipCode.setZip("zip_" + id + "_" + i);
            zipCode.setPlusFour("plusFour_" + id + "_" + i);
            addr.setZipcode(zipCode);
            p.addResidence(addr);
            p.addNickName("nickName_ + " + i);
        }
        em.persist((Object)p);
        return p;
    }

    public void findObj3() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Person p = (Person)em.find(Person.class, (Object)"ssn1");
        List<Address> residences = p.getResidences();
        TestAttrOverrides.assertEquals((int)4, (int)residences.size());
        int i = 1;
        for (Address a : residences) {
            String zip = a.getZipcode().getZip();
            String plusFour = a.getZipcode().getPlusFour();
            String expZip = "zip_1_";
            String expPlusFour = "plusFour_1_";
            expZip = expZip + i;
            expPlusFour = expPlusFour + i;
            TestAttrOverrides.assertEquals((String)expZip, (String)zip);
            TestAttrOverrides.assertEquals((String)expPlusFour, (String)plusFour);
            ++i;
        }
        List<String> nickNames = p.getNickNames();
        TestAttrOverrides.assertEquals((int)4, (int)nickNames.size());
        i = 4;
        for (String s : nickNames) {
            String expNickName = "nickName_ + " + i;
            TestAttrOverrides.assertEquals((String)expNickName, (String)s);
            --i;
        }
        em.close();
    }
}

