/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.embed.attrOverrides;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.lib.jdbc.AbstractJDBCListener;
import org.apache.openjpa.lib.jdbc.JDBCEvent;
import org.apache.openjpa.lib.jdbc.JDBCListener;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.embed.attrOverrides.XMLAssocOverEmbed;
import org.apache.openjpa.persistence.embed.attrOverrides.XMLAssocOverEntityA;
import org.apache.openjpa.persistence.embed.attrOverrides.XMLAssocOverEntityB;
import org.apache.openjpa.persistence.jdbc.SQLSniffer;
import org.apache.openjpa.persistence.test.AbstractPersistenceTestCase;

public class TestAssocOverridesXML
extends AbstractPersistenceTestCase {
    protected List<String> _sql = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testElementCollectionAssocOverrides() {
        this._sql.clear();
        HashMap<String, JDBCListener[]> props = new HashMap<String, JDBCListener[]>();
        props.put("openjpa.jdbc.JDBCListeners", new JDBCListener[]{new SQLListener()});
        OpenJPAEntityManagerFactorySPI emf1 = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"AssocOverPU", (String)"org/apache/openjpa/persistence/embed/embed-persistence.xml", props);
        OpenJPAEntityManagerSPI em = emf1.createEntityManager();
        XMLAssocOverEntityA ea = new XMLAssocOverEntityA();
        XMLAssocOverEntityB eb = new XMLAssocOverEntityB();
        XMLAssocOverEntityB meb = new XMLAssocOverEntityB();
        XMLAssocOverEmbed emb = new XMLAssocOverEmbed();
        eb.setName("XMLAssocOverEntityB");
        meb.setName("XMLAssocOverEntityBM21");
        ArrayList<XMLAssocOverEntityA> eaList1 = new ArrayList<XMLAssocOverEntityA>();
        eaList1.add(ea);
        ArrayList<XMLAssocOverEntityA> eaList2 = new ArrayList<XMLAssocOverEntityA>();
        eaList2.add(ea);
        eb.setEaList(eaList1);
        meb.setEaList(eaList2);
        emb.setName("XMLAssocOverEmbed");
        emb.setEb(eb);
        emb.setMeb(meb);
        ArrayList<XMLAssocOverEmbed> embList = new ArrayList<XMLAssocOverEmbed>();
        embList.add(emb);
        ea.setEmbA(embList);
        em.getTransaction().begin();
        em.persist((Object)ea);
        em.getTransaction().commit();
        em.close();
        try {
            this.assertSQLFragnments(this._sql, "CREATE TABLE XML_EMBALIST .* .*emba_entb.*emba_mentb");
            this.assertSQLFragnments(this._sql, "CREATE TABLE XML_EMBAMAP_3 .* .*key_emba_entb.*key_emba_mentb .*value_emba_entb.*value_emba_mentb");
        }
        finally {
            try {
                if (emf1 != null) {
                    this.cleanupEMF(emf1);
                }
                this._sql.clear();
            }
            catch (Exception e) {
                TestAssocOverridesXML.fail((String)e.getMessage());
            }
        }
    }

    void assertSQLFragnments(List<String> list, String ... keys) {
        if (SQLSniffer.matches(list, keys)) {
            return;
        }
        TestAssocOverridesXML.fail((String)("None of the following " + list.size() + " SQL \r\n" + TestAssocOverridesXML.toString(list) + "\r\n contains all keys \r\n" + TestAssocOverridesXML.toString(Arrays.asList(keys))));
    }

    private static String toString(List<String> list) {
        StringBuilder buf = new StringBuilder();
        for (String s : list) {
            buf.append(s).append("\r\n");
        }
        return buf.toString();
    }

    private void cleanupEMF(OpenJPAEntityManagerFactorySPI emf1) throws Exception {
        if (emf1 == null) {
            return;
        }
        try {
            this.clear((EntityManagerFactory)emf1);
        }
        catch (Exception e) {
            if (this.testResult.wasSuccessful()) {
                throw e;
            }
        }
        finally {
            this.closeEMF((EntityManagerFactory)emf1);
        }
    }

    public class SQLListener
    extends AbstractJDBCListener {
        public void beforeExecuteStatement(JDBCEvent event) {
            if (event.getSQL() != null && TestAssocOverridesXML.this._sql != null) {
                TestAssocOverridesXML.this._sql.add(event.getSQL());
            }
        }
    }
}

