/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.embed;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.embed.EChild;
import org.apache.openjpa.persistence.embed.EGeneric;
import org.apache.openjpa.persistence.embed.EParent;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestEmbeddedWithQuery
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(EParent.class, EChild.class, EGeneric.class, "openjpa.MaxFetchDepth", "1", "openjpa.jdbc.EagerFetchMode", "none", "openjpa.jdbc.SubclassFetchMode", "none", CLEAR_TABLES);
        this.populate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFullEmbeddableLoadByJPQLQuery() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            String queryStr = "SELECT id AS idparent, longVal AS idchild, CAST(NULL AS CHAR)  as missing FROM EGENERIC";
            Query q1 = em.createNativeQuery(queryStr, EParent.class);
            List resultList = q1.getResultList();
            TestEmbeddedWithQuery.assertNotNull((Object)resultList);
            ArrayList pList = new ArrayList(resultList);
            em.clear();
            TestEmbeddedWithQuery.assertNotEquals(0, pList.size());
            EParent pFind = (EParent)pList.get(0);
            TestEmbeddedWithQuery.assertNotNull((Object)pFind);
            TestEmbeddedWithQuery.assertEquals((Object)pFind.getIdParent(), (Object)new Integer(1));
            TestEmbeddedWithQuery.assertNotNull((Object)pFind.getChildTo());
            TestEmbeddedWithQuery.assertEquals((Object)pFind.getChildTo().getIdChild(), (Object)new Long(10L));
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPartialEmbeddableLoadByJPQLQuery() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            String queryStr = "SELECT id AS idparent, longVal AS idchild FROM EGENERIC";
            Query q1 = em.createNativeQuery(queryStr, EParent.class);
            List resultList = q1.getResultList();
            TestEmbeddedWithQuery.assertNotNull((Object)resultList);
            ArrayList pList = new ArrayList(resultList);
            em.clear();
            TestEmbeddedWithQuery.assertNotEquals(0, pList.size());
            EParent pFind = (EParent)pList.get(0);
            TestEmbeddedWithQuery.assertNotNull((Object)pFind);
            TestEmbeddedWithQuery.assertEquals((Object)pFind.getIdParent(), (Object)new Integer(1));
            TestEmbeddedWithQuery.assertNotNull((Object)pFind.getChildTo());
            TestEmbeddedWithQuery.assertEquals((Object)pFind.getChildTo().getIdChild(), (Object)new Long(10L));
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            if (em.isOpen()) {
                em.close();
            }
        }
    }

    private void populate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            EGeneric generic = new EGeneric();
            generic.setId(1);
            generic.setLongVal(10L);
            generic.setStrVal("Nope");
            em.getTransaction().begin();
            em.persist((Object)generic);
            em.getTransaction().commit();
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }
}

