/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.embed;

import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.Query;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.embed.A;
import org.apache.openjpa.persistence.embed.Book;
import org.apache.openjpa.persistence.embed.Company1;
import org.apache.openjpa.persistence.embed.Company2;
import org.apache.openjpa.persistence.embed.ContactInfo;
import org.apache.openjpa.persistence.embed.Department1;
import org.apache.openjpa.persistence.embed.Department2;
import org.apache.openjpa.persistence.embed.Department3;
import org.apache.openjpa.persistence.embed.Division;
import org.apache.openjpa.persistence.embed.Embed;
import org.apache.openjpa.persistence.embed.Embed_Coll_Embed;
import org.apache.openjpa.persistence.embed.Embed_Coll_Integer;
import org.apache.openjpa.persistence.embed.Embed_Coll_Map;
import org.apache.openjpa.persistence.embed.Embed_Embed;
import org.apache.openjpa.persistence.embed.Embed_Embed_ToMany;
import org.apache.openjpa.persistence.embed.Embed_MappedToOne;
import org.apache.openjpa.persistence.embed.Embed_MappedToOneCascadeDelete;
import org.apache.openjpa.persistence.embed.Embed_Single_Coll;
import org.apache.openjpa.persistence.embed.Embed_ToMany;
import org.apache.openjpa.persistence.embed.Embed_ToOne;
import org.apache.openjpa.persistence.embed.Employee;
import org.apache.openjpa.persistence.embed.Employee1;
import org.apache.openjpa.persistence.embed.Employee2;
import org.apache.openjpa.persistence.embed.Employee3;
import org.apache.openjpa.persistence.embed.EmployeeName3;
import org.apache.openjpa.persistence.embed.EmployeePK2;
import org.apache.openjpa.persistence.embed.EntityA_Coll_Embed_Embed;
import org.apache.openjpa.persistence.embed.EntityA_Coll_Embed_ToOne;
import org.apache.openjpa.persistence.embed.EntityA_Coll_String;
import org.apache.openjpa.persistence.embed.EntityA_Embed;
import org.apache.openjpa.persistence.embed.EntityA_Embed_Coll_Embed;
import org.apache.openjpa.persistence.embed.EntityA_Embed_Coll_Integer;
import org.apache.openjpa.persistence.embed.EntityA_Embed_Coll_Map;
import org.apache.openjpa.persistence.embed.EntityA_Embed_Complex;
import org.apache.openjpa.persistence.embed.EntityA_Embed_Embed;
import org.apache.openjpa.persistence.embed.EntityA_Embed_Embed_ToMany;
import org.apache.openjpa.persistence.embed.EntityA_Embed_MappedToOne;
import org.apache.openjpa.persistence.embed.EntityA_Embed_MappedToOneCascadeDelete;
import org.apache.openjpa.persistence.embed.EntityA_Embed_Single_Coll;
import org.apache.openjpa.persistence.embed.EntityA_Embed_ToMany;
import org.apache.openjpa.persistence.embed.EntityA_Embed_ToOne;
import org.apache.openjpa.persistence.embed.EntityB1;
import org.apache.openjpa.persistence.embed.EntityB2;
import org.apache.openjpa.persistence.embed.FileName4;
import org.apache.openjpa.persistence.embed.Item1;
import org.apache.openjpa.persistence.embed.Item2;
import org.apache.openjpa.persistence.embed.Item3;
import org.apache.openjpa.persistence.embed.Item4;
import org.apache.openjpa.persistence.embed.Item5;
import org.apache.openjpa.persistence.embed.JobInfo;
import org.apache.openjpa.persistence.embed.Listing;
import org.apache.openjpa.persistence.embed.LocationDetails;
import org.apache.openjpa.persistence.embed.ParkingSpot;
import org.apache.openjpa.persistence.embed.PhoneNumber;
import org.apache.openjpa.persistence.embed.ProgramManager;
import org.apache.openjpa.persistence.embed.Seller;
import org.apache.openjpa.persistence.embed.VicePresident;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestEmbeddable
extends SQLListenerTestCase {
    private static final Calendar cal = new GregorianCalendar();
    private static final Integer timeHash = cal.hashCode();
    public int numEmbeddables = 1;
    public int numBasicTypes = 1;
    public int numProgramManagers = 2;
    public int numNickNames = 3;
    public int numEmployeesPerPhoneNumber = 1;
    public int numPhoneNumbersPerEmployee = 2;
    public int numEmployeesPerProgramManager = 2;
    public int numEmployees = this.numProgramManagers * this.numEmployeesPerProgramManager;
    public int numPhoneNumbers = this.numEmployees * this.numPhoneNumbersPerEmployee;
    public int numDepartments = 2;
    public int numEmployeesPerDept = 2;
    public int numItems = 2;
    public int numImagesPerItem = 3;
    public int numCompany = 2;
    public int numDivisionsPerCo = 2;
    public int ID = 1;
    public int itemId = 1;
    public int compId = 1;
    public int divId = 1;
    public int vpId = 1;
    public int deptId = 1;
    public int empId = 1;
    public int phoneId = 1;
    public int pmId = 1;
    public int parkingSpotId = 1;
    public Map<Integer, PhoneNumber> phones = new HashMap<Integer, PhoneNumber>();
    public Map<Integer, Employee> employees = new HashMap<Integer, Employee>();

    @Override
    public void setUp() {
        this.setUp(Embed.class, Embed_Coll_Embed.class, Embed_Coll_Integer.class, Embed_Embed.class, Embed_Embed_ToMany.class, Embed_ToMany.class, Embed_ToOne.class, EntityA_Coll_Embed_ToOne.class, EntityA_Coll_String.class, EntityA_Embed_Coll_Embed.class, EntityA_Embed_Coll_Integer.class, EntityA_Embed_Embed.class, EntityA_Embed_Embed_ToMany.class, EntityA_Embed_ToMany.class, EntityA_Embed_ToOne.class, EntityB1.class, EntityA_Coll_Embed_Embed.class, ContactInfo.class, Employee.class, JobInfo.class, LocationDetails.class, ParkingSpot.class, PhoneNumber.class, ProgramManager.class, Department1.class, Employee1.class, Department2.class, Employee2.class, EmployeePK2.class, Department3.class, Employee3.class, EmployeeName3.class, Item1.class, Item2.class, Item3.class, Item4.class, Item5.class, FileName4.class, Company1.class, Company2.class, Division.class, VicePresident.class, EntityA_Embed_MappedToOne.class, Embed_MappedToOne.class, Embed_MappedToOneCascadeDelete.class, EntityA_Embed_MappedToOneCascadeDelete.class, EntityB2.class, Book.class, Listing.class, Seller.class, EntityA_Embed_Coll_Map.class, Embed_Coll_Map.class, EntityA_Embed_Single_Coll.class, Embed_Single_Coll.class, EntityA_Embed.class, EntityA_Embed_Complex.class, A.class, CLEAR_TABLES);
        this.sql.clear();
    }

    public void testGroupByEmbed() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String[] query = new String[]{"select KEY(e) from Department3 d join d.emps e group by KEY(e)", "select a.embed from EntityA_Embed_Embed a group by a.embed", "select e from EntityA_Embed_Embed a join a.embed e group by e"};
        List rs = null;
        for (String s : query) {
            try {
                rs = em.createQuery(s).getResultList();
            }
            catch (ArgumentException e) {
                System.out.println(e.getMessage());
            }
        }
        em.close();
    }

    public void testKeyEmbeddableCompare() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String[] query = new String[]{"select o from Company1 c join c.organization o where KEY(o) = ?1", "select d from Department3 d join d.emps e where KEY(e) = ? 1"};
        List rs = null;
        Division d = new Division();
        d.setId(10);
        d.setName("division 10");
        EmployeeName3 name = new EmployeeName3("fname1", "lname1");
        block6: for (int i = 0; i < query.length; ++i) {
            switch (i) {
                case 0: {
                    rs = em.createQuery(query[i]).setParameter(1, (Object)d).getResultList();
                    continue block6;
                }
                case 1: {
                    try {
                        rs = em.createQuery(query[i]).setParameter(1, (Object)name).getResultList();
                        continue block6;
                    }
                    catch (ArgumentException e) {
                        System.out.println(e.getMessage());
                    }
                }
            }
        }
        em.close();
    }

    public void testEntityA_Embed_Coll_Map() {
        this.queryEntityA_Embed_Coll_Map();
    }

    public void testEntityA_Embed_Single_Coll() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityA_Embed_Single_Coll eesc = new EntityA_Embed_Single_Coll();
        Embed_Single_Coll esc = new Embed_Single_Coll();
        Date date = Date.valueOf("2010-10-13");
        esc.setDate(date);
        eesc.setEmbed(esc);
        em.getTransaction().begin();
        em.persist((Object)eesc);
        em.flush();
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        Query query1 = em.createQuery("SELECT e FROM EntityA_Embed_Single_Coll e where e.embed.date = :wheredate");
        query1.setParameter("wheredate", (Object)date);
        eesc = (EntityA_Embed_Single_Coll)query1.getSingleResult();
        TestEmbeddable.assertEquals((String)eesc.getEmbed().getDate().toString(), (String)date.toString());
        em.close();
    }

    public void testSettingEmbeddableMultipleTimesOnManagedEntity() {
        this.createEntityA_Embed();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityA_Embed ee = (EntityA_Embed)em.find(EntityA_Embed.class, (Object)this.ID);
        Embed embed = this.createEmbed(this.ID, 0);
        ee.setEmbed(embed);
        Embed embed1 = this.createEmbed(this.ID, 1);
        ee.setEmbed(embed1);
        em.close();
    }

    public void queryEntityA_Embed_Coll_Map() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String[] query = new String[]{"select e from EntityA_Embed_Coll_Map a join a.embed e join e.mapKeyInteger i where value(i) > 0 "};
        List rs = null;
        for (String s : query) {
            rs = em.createQuery(s).getResultList();
            em.clear();
        }
        em.close();
    }

    public void testEntityA_Coll_String() {
        this.createEntityA_Coll_String();
        this.queryEntityA_Coll_String();
        this.findEntityA_Coll_String();
    }

    public void testEntityA_Embed_ToOne() {
        this.createEntityA_Embed_ToOne();
        this.queryEntityA_Embed_ToOne();
        this.findEntityA_Embed_ToOne();
    }

    public void testEntityA_Embed_MappedToOne() {
        this.createEntityA_Embed_MappedToOne();
        this.queryEntityA_Embed_MappedToOne();
        this.findEntityA_Embed_MappedToOne();
    }

    public void testEntityA_Coll_Embed_ToOne() {
        this.createEntityA_Coll_Embed_ToOne();
        this.queryEntityA_Coll_Embed_ToOne();
        this.findEntityA_Coll_Embed_ToOne();
    }

    public void testEntityA_Embed_ToMany() {
        this.createEntityA_Embed_ToMany();
        this.queryEntityA_Embed_ToMany();
        this.findEntityA_Embed_ToMany();
    }

    public void testEntityA_Embed_Embed_ToMany() {
        this.createEntityA_Embed_Embed_ToMany();
        this.queryEntityA_Embed_Embed_ToMany();
        this.findEntityA_Embed_Embed_ToMany();
    }

    public void testEntityA_Embed_Coll_Integer() {
        this.createEntityA_Embed_Coll_Integer();
        this.queryEntityA_Embed_Coll_Integer();
        this.findEntityA_Embed_Coll_Integer();
    }

    public void testEntityA_Embed_Embed() {
        this.createEntityA_Embed_Embed();
        this.queryEntityA_Embed_Embed();
        this.findEntityA_Embed_Embed();
    }

    public void testEntityA_Coll_Embed_Embed() {
        this.createEntityA_Coll_Embed_Embed();
        this.queryEntityA_Coll_Embed_Embed();
        this.findEntityA_Coll_Embed_Embed();
    }

    public void testEntityA_Embed_Coll_Embed() {
        this.createEntityA_Embed_Coll_Embed();
        this.queryEntityA_Embed_Coll_Embed();
        this.findEntityA_Embed_Coll_Embed();
    }

    public void testEmployee() {
        this.createEmployeeObj();
        this.queryEmployeeObj();
        this.findEmployeeObj();
    }

    public void testMapKey() {
        this.createObjMapKey();
        this.queryObjMapKey();
        this.findObjMapKey();
    }

    public void testMapKeyClass() {
        this.createObjMapKeyClass();
        this.queryObjMapKeyClass();
        this.findObjMapKeyClass();
    }

    public void testMapKeyEnumerated() {
        this.createObjMapKeyEnumerated();
        this.findObjMapKeyEnumerated();
    }

    public void testMapKeyTemporal() {
        this.createObjMapKeyTemporal();
        this.findObjMapKeyTemporal();
        this.queryObjMapKeyTemporal();
    }

    public void testEntityA_Embed_MappedToOneCascadeDelete() {
        this.createEntityA_Embed_MappedToOneCascadeDelete();
        this.updateEntityA_Embed_MappedToOneCascadeDelete();
    }

    public void testEmbeddableContainingRelationWithGeneratedKey() throws IOException, SQLException {
        this.createEmbeddableContainingRelationWithGeneratedKey();
    }

    public void createEntityA_Coll_String() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        this.createEntityA_Coll_String((EntityManager)em, this.ID);
        EntityB1 b = new EntityB1();
        b.setId(this.ID);
        b.setName("b" + this.ID);
        em.persist((Object)b);
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public void createEntityA_Coll_String(EntityManager em, int id) {
        EntityA_Coll_String a = new EntityA_Coll_String();
        a.setId(id);
        a.setName("a" + id);
        a.setAge(id);
        for (int i = 0; i < this.numBasicTypes; ++i) {
            a.addNickName("nickName_" + id + i);
        }
        a.addCreditRating(EntityA_Coll_String.CreditRating.POOR);
        a.addTimestamp(new Timestamp(System.currentTimeMillis()));
        a.addLob("lob");
        em.persist((Object)a);
    }

    public void createEntityA_Embed_ToOne() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        this.createEntityA_Embed_ToOne((EntityManager)em, this.ID);
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public void createEntityA_Embed_ToOne(EntityManager em, int id) {
        EntityA_Embed_ToOne a = new EntityA_Embed_ToOne();
        a.setId(id);
        a.setName("a" + id);
        a.setAge(id);
        Embed_ToOne embed = this.createEmbed_ToOne(em, id);
        a.setEmbed(embed);
        em.persist((Object)a);
    }

    public Embed_ToOne createEmbed_ToOne(EntityManager em, int id) {
        Embed_ToOne embed = new Embed_ToOne();
        embed.setName1("name1");
        embed.setName2("name2");
        embed.setName3("name3");
        EntityB1 b = new EntityB1();
        b.setId(id);
        b.setName("b" + id);
        embed.setEntityB(b);
        em.persist((Object)b);
        return embed;
    }

    public void createEntityA_Embed_MappedToOne() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        this.createEntityA_Embed_MappedToOne((EntityManager)em, this.ID);
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public void createEntityA_Embed_MappedToOne(EntityManager em, int id) {
        EntityA_Embed_MappedToOne a = new EntityA_Embed_MappedToOne();
        a.setId(id);
        a.setName("a" + id);
        a.setAge(id);
        Embed_MappedToOne embed = this.createEmbed_MappedToOne(em, id, a);
        a.setEmbed(embed);
        em.persist((Object)a);
    }

    public Embed_MappedToOne createEmbed_MappedToOne(EntityManager em, int id, EntityA_Embed_MappedToOne a) {
        Embed_MappedToOne embed = new Embed_MappedToOne();
        embed.setName1("name1");
        embed.setName2("name2");
        embed.setName3("name3");
        EntityB1 b = new EntityB1();
        b.setId(id);
        b.setName("bm" + id);
        b.setEntityA(a);
        embed.setMappedEntityB(b);
        em.persist((Object)b);
        return embed;
    }

    public void createEntityA_Embed_MappedToOneCascadeDelete() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        this.createEntityA_Embed_MappedToOneCascadeDelete((EntityManager)em, this.ID);
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public void createEntityA_Embed_MappedToOneCascadeDelete(EntityManager em, int id) {
        EntityA_Embed_MappedToOneCascadeDelete a = new EntityA_Embed_MappedToOneCascadeDelete();
        a.setId(id);
        a.setName("a" + id);
        a.setAge(id);
        Embed_MappedToOneCascadeDelete embed = this.createEmbed_MappedToOneDeleteCascade(em, id, a);
        a.setEmbed(embed);
        em.persist((Object)a);
    }

    public Embed_MappedToOneCascadeDelete createEmbed_MappedToOneDeleteCascade(EntityManager em, int id, EntityA_Embed_MappedToOneCascadeDelete a) {
        Embed_MappedToOneCascadeDelete embed = new Embed_MappedToOneCascadeDelete();
        embed.setName1("name1");
        embed.setName2("name2");
        embed.setName3("name3");
        EntityB2 b = new EntityB2();
        b.setId(id);
        b.setName("bm" + id);
        b.setEntityA(a);
        embed.setMappedEntityB(b);
        em.persist((Object)b);
        return embed;
    }

    public void updateEntityA_Embed_MappedToOneCascadeDelete() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        this.updateEntityA_Embed_MappedToOneCascadeDelete((EntityManager)em, this.ID);
        tran.begin();
        em.flush();
        tran.commit();
        em.clear();
        EntityA_Embed_MappedToOneCascadeDelete a = (EntityA_Embed_MappedToOneCascadeDelete)em.find(EntityA_Embed_MappedToOneCascadeDelete.class, (Object)this.ID);
        TestEmbeddable.assertNotNull((Object)a);
        EntityB2 b2 = (EntityB2)em.find(EntityB2.class, (Object)this.ID);
        TestEmbeddable.assertNotNull((Object)b2);
        em.close();
    }

    public void updateEntityA_Embed_MappedToOneCascadeDelete(EntityManager em, int id) {
        EntityA_Embed_MappedToOneCascadeDelete a = (EntityA_Embed_MappedToOneCascadeDelete)em.find(EntityA_Embed_MappedToOneCascadeDelete.class, (Object)id);
        a.setName("newa" + id);
        a.setAge(id + 1);
        Embed_MappedToOneCascadeDelete embed = this.createEmbed_MappedToOneDeleteCascade(em, id + 1, a);
        a.setEmbed(embed);
    }

    public void createEntityA_Coll_Embed_ToOne() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        this.createEntityA_Coll_Embed_ToOne((EntityManager)em, this.ID);
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public void createEntityA_Coll_Embed_ToOne(EntityManager em, int id) {
        EntityA_Coll_Embed_ToOne a = new EntityA_Coll_Embed_ToOne();
        a.setId(id);
        a.setName("a" + id);
        a.setAge(id);
        for (int i = 0; i < this.numEmbeddables; ++i) {
            Embed_ToOne embed = this.createEmbed_ToOne(em, i + id);
            a.addEmbed1ToOne(embed);
        }
        em.persist((Object)a);
    }

    public void createEntityA_Embed_ToMany() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        this.createEntityA_Embed_ToMany((EntityManager)em, this.ID);
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public void createEntityA_Embed_ToMany(EntityManager em, int id) {
        EntityA_Embed_ToMany a = new EntityA_Embed_ToMany();
        a.setId(id);
        a.setName("a" + id);
        a.setAge(id);
        Embed_ToMany embed = this.createEmbed_ToMany(em, id);
        a.setEmbed(embed);
        em.persist((Object)a);
    }

    public Embed_ToMany createEmbed_ToMany(EntityManager em, int id) {
        Embed_ToMany embed = new Embed_ToMany();
        embed.setName1("name1");
        embed.setName2("name2");
        embed.setName3("name3");
        for (int i = 0; i < this.numEmbeddables; ++i) {
            EntityB1 b = new EntityB1();
            b.setId(id + i);
            b.setName("b" + id + i);
            embed.addEntityB(b);
            em.persist((Object)b);
        }
        return embed;
    }

    public void createEntityA_Embed_Embed_ToMany() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        this.createEntityA_Embed_Embed_ToMany((EntityManager)em, this.ID);
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public void createEntityA_Embed_Embed_ToMany(EntityManager em, int id) {
        EntityA_Embed_Embed_ToMany a = new EntityA_Embed_Embed_ToMany();
        a.setId(id);
        a.setName("a" + id);
        a.setAge(id);
        Embed_Embed_ToMany embed = this.createEmbed_Embed_ToMany(em, id);
        a.setEmbed(embed);
        em.persist((Object)a);
    }

    public Embed_Embed_ToMany createEmbed_Embed_ToMany(EntityManager em, int id) {
        Embed_Embed_ToMany embed = new Embed_Embed_ToMany();
        embed.setIntVal1(1);
        embed.setIntVal2(2);
        embed.setIntVal3(3);
        Embed_ToMany embed_ToMany = this.createEmbed_ToMany(em, id);
        embed.setEmbed(embed_ToMany);
        return embed;
    }

    public void createEntityA_Embed_Coll_Integer() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        this.createEntityA_Embed_Coll_Integer((EntityManager)em, this.ID);
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public void createEntityA_Embed_Coll_Integer(EntityManager em, int id) {
        EntityA_Embed_Coll_Integer a = new EntityA_Embed_Coll_Integer();
        a.setId(id);
        a.setName("a" + id);
        a.setAge(id);
        Embed_Coll_Integer embed = this.createEmbed_Coll_Integer(em, id);
        a.setEmbed(embed);
        em.persist((Object)a);
    }

    public Embed_Coll_Integer createEmbed_Coll_Integer(EntityManager em, int id) {
        Embed_Coll_Integer embed = new Embed_Coll_Integer();
        embed.setIntVal1(id * 10 + 1);
        embed.setIntVal2(id * 10 + 2);
        embed.setIntVal3(id * 10 + 3);
        for (int i = 0; i < this.numBasicTypes; ++i) {
            embed.addOtherIntVal(id * 100 + i);
        }
        return embed;
    }

    public void createEntityA_Embed_Embed() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        this.createEntityA_Embed_Embed((EntityManager)em, this.ID);
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public void createEntityA_Embed_Embed(EntityManager em, int id) {
        EntityA_Embed_Embed a = new EntityA_Embed_Embed();
        a.setId(id);
        a.setName("a" + id);
        a.setAge(id);
        Embed_Embed embed = this.createEmbed_Embed(id, 0);
        a.setEmbed(embed);
        em.persist((Object)a);
    }

    public Embed_Embed createEmbed_Embed(int id, int idx) {
        Embed_Embed embed = new Embed_Embed();
        embed.setIntVal1(id * 100 + idx * 10 + 1);
        embed.setIntVal2(id * 100 + idx * 10 + 2);
        embed.setIntVal3(id * 100 + idx * 10 + 3);
        Embed embed1 = this.createEmbed(id, idx);
        embed.setEmbed(embed1);
        return embed;
    }

    public void createEntityA_Embed() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        this.createEntityA_Embed((EntityManager)em, this.ID);
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public void createEntityA_Embed(EntityManager em, int id) {
        EntityA_Embed a = new EntityA_Embed();
        a.setId(id);
        a.setName("a" + id);
        a.setAge(id);
        Embed embed = this.createEmbed(id, 0);
        a.setEmbed(embed);
        em.persist((Object)a);
    }

    public Embed createEmbed(int id, int idx) {
        Embed embed = new Embed();
        embed.setIntVal1(id * 100 + idx * 10 + 4);
        embed.setIntVal2(id * 100 + idx * 10 + 5);
        embed.setIntVal3(id * 100 + idx * 10 + 6);
        return embed;
    }

    public void createEntityA_Coll_Embed_Embed() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        this.createEntityA_Coll_Embed_Embed((EntityManager)em, this.ID);
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public void createEntityA_Coll_Embed_Embed(EntityManager em, int id) {
        EntityA_Coll_Embed_Embed a = new EntityA_Coll_Embed_Embed();
        a.setId(id);
        a.setName("a" + id);
        a.setAge(id);
        for (int i = 0; i < this.numEmbeddables; ++i) {
            Embed_Embed embed = this.createEmbed_Embed(id, i);
            a.addEmbed(embed);
        }
        em.persist((Object)a);
    }

    public void createEntityA_Embed_Coll_Embed() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        this.createEntityA_Embed_Coll_Embed((EntityManager)em, this.ID);
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public void createEntityA_Embed_Coll_Embed(EntityManager em, int id) {
        EntityA_Embed_Coll_Embed a = new EntityA_Embed_Coll_Embed();
        a.setId(id);
        a.setName("a" + id);
        a.setAge(id);
        Embed_Coll_Embed embed = this.createEmbed_Coll_Embed(em, id);
        a.setEmbed(embed);
        em.persist((Object)a);
    }

    public Embed_Coll_Embed createEmbed_Coll_Embed(EntityManager em, int id) {
        Embed_Coll_Embed embed = new Embed_Coll_Embed();
        embed.setIntVal1(id * 10 + 1);
        embed.setIntVal2(id * 10 + 2);
        embed.setIntVal3(id * 10 + 3);
        for (int i = 0; i < this.numEmbeddables; ++i) {
            Embed embed1 = this.createEmbed(id, i);
            embed.addEmbed(embed1);
        }
        return embed;
    }

    public void createEmployeeObj() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        this.createPhoneNumbers((EntityManager)em);
        this.createEmployees((EntityManager)em);
        this.createProgramManagers((EntityManager)em);
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public void createProgramManagers(EntityManager em) {
        this.empId = 1;
        for (int i = 0; i < this.numProgramManagers; ++i) {
            this.createProgramManager(em, this.pmId++);
        }
    }

    public void createProgramManager(EntityManager em, int id) {
        ProgramManager pm = new ProgramManager();
        pm.setId(id);
        for (int i = 0; i < this.numEmployeesPerProgramManager; ++i) {
            Employee e = this.employees.get(this.empId++);
            pm.addManage(e);
            JobInfo jobInfo = new JobInfo();
            jobInfo.setJobDescription("jobDescription" + e.getEmpId());
            jobInfo.setProgramManager(pm);
            e.setJobInfo(jobInfo);
        }
        em.persist((Object)pm);
    }

    public void createEmployees(EntityManager em) {
        this.phoneId = 1;
        for (int i = 0; i < this.numEmployees; ++i) {
            Employee e = this.createEmployee(em, this.empId++);
            this.employees.put(e.getEmpId(), e);
        }
    }

    public Employee createEmployee(EntityManager em, int id) {
        Employee e = new Employee();
        e.setEmpId(id);
        ContactInfo contactInfo = new ContactInfo();
        for (int i = 0; i < this.numPhoneNumbersPerEmployee; ++i) {
            PhoneNumber phoneNumber = this.phones.get(this.phoneId++);
            contactInfo.addPhoneNumber(phoneNumber);
            e.setContactInfo(contactInfo);
            phoneNumber.addEmployees(e);
            em.persist((Object)phoneNumber);
        }
        ParkingSpot parkingSpot = this.createParkingSpot(em, this.parkingSpotId++);
        LocationDetails location = new LocationDetails();
        location.setOfficeNumber(id);
        location.setParkingSpot(parkingSpot);
        e.setLocationDetails(location);
        parkingSpot.setAssignedTo(e);
        for (int i = 0; i < this.numNickNames; ++i) {
            e.addNickName("nickName" + id + i);
        }
        em.persist((Object)parkingSpot);
        em.persist((Object)e);
        return e;
    }

    public void createPhoneNumbers(EntityManager em) {
        for (int i = 0; i < this.numPhoneNumbers; ++i) {
            PhoneNumber p = new PhoneNumber();
            p.setNumber(this.phoneId++);
            this.phones.put(p.getNumber(), p);
            em.persist((Object)p);
        }
    }

    public ParkingSpot createParkingSpot(EntityManager em, int id) {
        ParkingSpot p = new ParkingSpot();
        p.setId(id);
        p.setGarage("garage" + id);
        em.persist((Object)p);
        return p;
    }

    public void findEmployeeObj() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        ProgramManager pm = (ProgramManager)em.find(ProgramManager.class, (Object)1);
        this.assertProgramManager(pm);
        pm = (ProgramManager)em.find(ProgramManager.class, (Object)2);
        this.assertProgramManager(pm);
        Employee e = (Employee)em.find(Employee.class, (Object)1);
        this.assertEmployee(e);
        PhoneNumber p = (PhoneNumber)em.find(PhoneNumber.class, (Object)1);
        this.assertPhoneNumber(p);
        ParkingSpot ps = (ParkingSpot)em.find(ParkingSpot.class, (Object)1);
        this.assertParkingSpot(ps);
        em.close();
    }

    public void queryEmployeeObj() {
        this.queryProgramManager((EntityManagerFactory)this.emf);
        this.queryEmployeeObj((EntityManagerFactory)this.emf);
        this.queryPhoneNumber((EntityManagerFactory)this.emf);
        this.queryParkingSpot((EntityManagerFactory)this.emf);
    }

    public void queryParkingSpot(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select p from ParkingSpot p");
        List ps = q.getResultList();
        for (ParkingSpot p : ps) {
            this.assertParkingSpot(p);
        }
        tran.commit();
        em.close();
    }

    public void queryProgramManager(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select pm from ProgramManager pm");
        List pms = q.getResultList();
        for (ProgramManager pm : pms) {
            this.assertProgramManager(pm);
        }
        tran.commit();
        em.close();
    }

    public void queryPhoneNumber(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select p from PhoneNumber p");
        List ps = q.getResultList();
        for (PhoneNumber p : ps) {
            this.assertPhoneNumber(p);
        }
        tran.commit();
        em.close();
    }

    public void queryEmployeeObj(EntityManagerFactory emf) {
        String[] query;
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select e from Employee e");
        List es = q.getResultList();
        for (Employee e : es) {
            this.assertEmployee(e);
        }
        tran.commit();
        em.clear();
        for (String s : query = new String[]{"select e from Employee e, in (e.nickNames) n  where n like '%1'"}) {
            es = em.createQuery(s).getResultList();
            for (Employee e : es) {
                this.assertEmployee(e);
            }
        }
        em.close();
    }

    public void assertProgramManager(ProgramManager pm) {
        int id = pm.getId();
        Collection<Employee> es = pm.getManages();
        TestEmbeddable.assertEquals((int)this.numEmployeesPerProgramManager, (int)es.size());
        for (Employee e : es) {
            this.assertEmployee(e);
        }
    }

    public void assertEmployee(Employee e) {
        int id = e.getEmpId();
        ContactInfo c = e.getContactInfo();
        List<PhoneNumber> phones = c.getPhoneNumbers();
        TestEmbeddable.assertEquals((int)this.numPhoneNumbersPerEmployee, (int)phones.size());
        for (PhoneNumber p : phones) {
            this.assertPhoneNumber(p);
        }
        LocationDetails loc = e.getLocationDetails();
        int officeNumber = loc.getOfficeNumber();
        ParkingSpot p = loc.getParkingSpot();
        this.assertParkingSpot(p);
        ProgramManager pm = e.getJobInfo().getProgramManager();
        Set<String> nickNames = e.getNickNames();
        TestEmbeddable.assertEquals((int)this.numNickNames, (int)nickNames.size());
    }

    public void assertPhoneNumber(PhoneNumber p) {
        int number = p.getNumber();
        Collection<Employee> es = p.getEmployees();
        TestEmbeddable.assertEquals((int)this.numEmployeesPerPhoneNumber, (int)es.size());
    }

    public void assertParkingSpot(ParkingSpot p) {
        String garage = p.getGarage();
        Employee e = p.getAssignedTo();
    }

    public void findEntityA_Coll_String() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityA_Coll_String a = (EntityA_Coll_String)em.find(EntityA_Coll_String.class, (Object)this.ID);
        this.checkEntityA_Coll_String(a);
        em.close();
    }

    public void findEntityA_Embed_ToOne() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityA_Embed_ToOne a = (EntityA_Embed_ToOne)em.find(EntityA_Embed_ToOne.class, (Object)this.ID);
        this.checkEntityA_Embed_ToOne(a);
        em.getTransaction().begin();
        em.remove((Object)a);
        em.getTransaction().commit();
        EntityB1 b = (EntityB1)em.find(EntityB1.class, (Object)this.ID);
        TestEmbeddable.assertNull((Object)b);
        em.close();
    }

    public void testLazyFetchEmbed() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityA_Embed a = new EntityA_Embed();
        a.setId(this.ID);
        a.setName("name");
        a.setAge(1);
        Embed emb = new Embed();
        emb.setIntVal1(1);
        emb.setIntVal1(2);
        emb.setIntVal1(3);
        a.setEmbed(emb);
        em.persist((Object)a);
        em.getTransaction().begin();
        em.getTransaction().commit();
        em.clear();
        PersistenceUnitUtil puu = this.emf.getPersistenceUnitUtil();
        OpenJPAEntityManager kem = OpenJPAPersistence.cast((EntityManager)em);
        kem.getFetchPlan().resetFetchGroups().removeFetchGroup("default").addField(EntityA_Embed.class, "name").addField(EntityA_Embed.class, "age");
        a = (EntityA_Embed)em.find(EntityA_Embed.class, (Object)this.ID);
        TestEmbeddable.assertNotNull((Object)a);
        Embed embed = a.getEmbed();
        TestEmbeddable.assertNull((Object)embed);
        TestEmbeddable.assertFalse((boolean)puu.isLoaded((Object)a, "embed"));
        em.close();
    }

    public void findEntityA_Embed_MappedToOne() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityA_Embed_MappedToOne a = (EntityA_Embed_MappedToOne)em.find(EntityA_Embed_MappedToOne.class, (Object)this.ID);
        this.checkEntityA_Embed_MappedToOne(a);
        em.close();
    }

    public void findEntityA_Coll_Embed_ToOne() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityA_Coll_Embed_ToOne a = (EntityA_Coll_Embed_ToOne)em.find(EntityA_Coll_Embed_ToOne.class, (Object)this.ID);
        this.checkEntityA_Coll_Embed_ToOne(a);
        em.close();
    }

    public void findEntityA_Embed_ToMany() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityA_Embed_ToMany a = (EntityA_Embed_ToMany)em.find(EntityA_Embed_ToMany.class, (Object)this.ID);
        this.checkEntityA_Embed_ToMany(a);
        em.close();
    }

    public void findEntityA_Embed_Embed_ToMany() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityA_Embed_Embed_ToMany a = (EntityA_Embed_Embed_ToMany)em.find(EntityA_Embed_Embed_ToMany.class, (Object)this.ID);
        this.checkEntityA_Embed_Embed_ToMany(a);
        em.close();
    }

    public void findEntityA_Embed_Coll_Integer() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityA_Embed_Coll_Integer a = (EntityA_Embed_Coll_Integer)em.find(EntityA_Embed_Coll_Integer.class, (Object)this.ID);
        this.checkEntityA_Embed_Coll_Integer(a);
        em.close();
    }

    public void findEntityA_Embed_Embed() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityA_Embed_Embed a = (EntityA_Embed_Embed)em.find(EntityA_Embed_Embed.class, (Object)this.ID);
        this.checkEntityA_Embed_Embed(a);
        em.close();
    }

    public void findEntityA_Coll_Embed_Embed() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityA_Coll_Embed_Embed a = (EntityA_Coll_Embed_Embed)em.find(EntityA_Coll_Embed_Embed.class, (Object)this.ID);
        this.checkEntityA_Coll_Embed_Embed(a);
        em.clear();
        em.getTransaction().begin();
        Embed_Embed embed = this.createEmbed_Embed(this.ID, 100);
        a.addEmbed(embed);
        em.merge((Object)a);
        em.getTransaction().commit();
        em.close();
    }

    public void findEntityA_Embed_Coll_Embed() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityA_Embed_Coll_Embed a = (EntityA_Embed_Coll_Embed)em.find(EntityA_Embed_Coll_Embed.class, (Object)this.ID);
        this.checkEntityA_Embed_Coll_Embed(a);
        em.close();
    }

    public void checkEntityA_Coll_String(EntityA_Coll_String a) {
        int id = a.getId();
        String name = a.getName();
        int age = a.getAge();
        TestEmbeddable.assertEquals((int)1, (int)id);
        TestEmbeddable.assertEquals((String)("a" + id), (String)name);
        TestEmbeddable.assertEquals((int)1, (int)age);
        Set<String> nickNames = a.getNickNames();
        for (String nickName : nickNames) {
            TestEmbeddable.assertEquals((String)("nickName_" + id + "0"), (String)nickName);
        }
        List<EntityA_Coll_String.CreditRating> cr = a.getCreditRating();
        for (EntityA_Coll_String.CreditRating c : cr) {
            TestEmbeddable.assertEquals((String)"POOR", (String)c.toString());
        }
    }

    public void checkEntityA_Embed_ToOne(EntityA_Embed_ToOne a) {
        int id = a.getId();
        String name = a.getName();
        int age = a.getAge();
        TestEmbeddable.assertEquals((int)1, (int)id);
        TestEmbeddable.assertEquals((String)("a" + id), (String)name);
        TestEmbeddable.assertEquals((int)1, (int)age);
        Embed_ToOne embed = a.getEmbed();
        this.checkEmbed_ToOne(embed);
    }

    public void checkEntityA_Embed_MappedToOne(EntityA_Embed_MappedToOne a) {
        int id = a.getId();
        String name = a.getName();
        int age = a.getAge();
        TestEmbeddable.assertEquals((int)1, (int)id);
        TestEmbeddable.assertEquals((String)("a" + id), (String)name);
        TestEmbeddable.assertEquals((int)1, (int)age);
        Embed_MappedToOne embed = a.getEmbed();
        this.checkEmbed_MappedToOne(embed);
    }

    public void checkEntityA_Coll_Embed_ToOne(EntityA_Coll_Embed_ToOne a) {
        int id = a.getId();
        String name = a.getName();
        int age = a.getAge();
        TestEmbeddable.assertEquals((int)1, (int)id);
        TestEmbeddable.assertEquals((String)("a" + id), (String)name);
        TestEmbeddable.assertEquals((int)1, (int)age);
        Set<Embed_ToOne> embeds = a.getEmbed1ToOnes();
        for (Embed_ToOne embed : embeds) {
            this.checkEmbed_ToOne(embed);
        }
    }

    public void checkEmbed_ToOne(Embed_ToOne embed) {
        String name1 = embed.getName1();
        String name2 = embed.getName2();
        String name3 = embed.getName3();
        TestEmbeddable.assertEquals((String)"name1", (String)name1);
        TestEmbeddable.assertEquals((String)"name2", (String)name2);
        TestEmbeddable.assertEquals((String)"name3", (String)name3);
        EntityB1 b = embed.getEntityB();
        TestEmbeddable.assertEquals((int)1, (int)b.getId());
        TestEmbeddable.assertEquals((String)("b" + b.getId()), (String)b.getName());
    }

    public void checkEmbed_MappedToOne(Embed_MappedToOne embed) {
        String name1 = embed.getName1();
        String name2 = embed.getName2();
        String name3 = embed.getName3();
        TestEmbeddable.assertEquals((String)"name1", (String)name1);
        TestEmbeddable.assertEquals((String)"name2", (String)name2);
        TestEmbeddable.assertEquals((String)"name3", (String)name3);
        EntityB1 b = embed.getMappedEntityB();
        TestEmbeddable.assertEquals((int)1, (int)b.getId());
        TestEmbeddable.assertEquals((String)("bm" + b.getId()), (String)b.getName());
    }

    public void checkEntityA_Embed_ToMany(EntityA_Embed_ToMany a) {
        int id = a.getId();
        String name = a.getName();
        int age = a.getAge();
        TestEmbeddable.assertEquals((int)1, (int)id);
        TestEmbeddable.assertEquals((String)("a" + id), (String)name);
        TestEmbeddable.assertEquals((int)1, (int)age);
        Embed_ToMany embed = a.getEmbed();
        this.checkEmbed_ToMany(embed);
    }

    public void checkEmbed_ToMany(Embed_ToMany embed) {
        String name1 = embed.getName1();
        String name2 = embed.getName2();
        String name3 = embed.getName3();
        TestEmbeddable.assertEquals((String)"name1", (String)name1);
        TestEmbeddable.assertEquals((String)"name2", (String)name2);
        TestEmbeddable.assertEquals((String)"name3", (String)name3);
        List<EntityB1> bs = embed.getEntityBs();
        for (EntityB1 b : bs) {
            TestEmbeddable.assertEquals((int)1, (int)b.getId());
            TestEmbeddable.assertEquals((String)("b" + b.getId() + "0"), (String)b.getName());
        }
    }

    public void checkEntityA_Embed_Embed_ToMany(EntityA_Embed_Embed_ToMany a) {
        int id = a.getId();
        String name = a.getName();
        int age = a.getAge();
        TestEmbeddable.assertEquals((int)1, (int)id);
        TestEmbeddable.assertEquals((String)("a" + id), (String)name);
        TestEmbeddable.assertEquals((int)1, (int)age);
        Embed_Embed_ToMany embed = a.getEmbed();
        this.checkEmbed_Embed_ToMany(embed);
    }

    public void checkEmbed_Embed_ToMany(Embed_Embed_ToMany embed) {
        int intVal1 = embed.getIntVal1();
        int intVal2 = embed.getIntVal2();
        int intVal3 = embed.getIntVal3();
        TestEmbeddable.assertEquals((int)1, (int)intVal1);
        TestEmbeddable.assertEquals((int)2, (int)intVal2);
        TestEmbeddable.assertEquals((int)3, (int)intVal3);
        Embed_ToMany embed1 = embed.getEmbed();
        this.checkEmbed_ToMany(embed1);
    }

    public void checkEntityA_Embed_Coll_Integer(EntityA_Embed_Coll_Integer a) {
        int id = a.getId();
        String name = a.getName();
        int age = a.getAge();
        TestEmbeddable.assertEquals((int)1, (int)id);
        TestEmbeddable.assertEquals((String)("a" + id), (String)name);
        TestEmbeddable.assertEquals((int)1, (int)age);
        Embed_Coll_Integer embed = a.getEmbed();
        this.checkEmbed_Integers(embed);
    }

    public void checkEmbed_Integers(Embed_Coll_Integer embed) {
        int intVal1 = embed.getIntVal1();
        int intVal2 = embed.getIntVal2();
        int intVal3 = embed.getIntVal3();
        TestEmbeddable.assertEquals((int)11, (int)intVal1);
        TestEmbeddable.assertEquals((int)12, (int)intVal2);
        TestEmbeddable.assertEquals((int)13, (int)intVal3);
        Set<Integer> intVals = embed.getOtherIntVals();
        for (Integer intVal : intVals) {
            TestEmbeddable.assertEquals((int)100, (int)intVal);
        }
    }

    public void checkEntityA_Embed_Embed(EntityA_Embed_Embed a) {
        int id = a.getId();
        String name = a.getName();
        int age = a.getAge();
        TestEmbeddable.assertEquals((int)1, (int)id);
        TestEmbeddable.assertEquals((String)("a" + id), (String)name);
        TestEmbeddable.assertEquals((int)1, (int)age);
        Embed_Embed embed = a.getEmbed();
        this.checkEmbed_Embed(embed);
    }

    public void checkEmbed_Embed(Embed_Embed embed) {
        int intVal1 = embed.getIntVal1();
        int intVal2 = embed.getIntVal2();
        int intVal3 = embed.getIntVal3();
        TestEmbeddable.assertEquals((int)101, (int)intVal1);
        TestEmbeddable.assertEquals((int)102, (int)intVal2);
        TestEmbeddable.assertEquals((int)103, (int)intVal3);
        Embed embed1 = embed.getEmbed();
        this.checkEmbed(embed1);
    }

    public void checkEmbed(Embed embed) {
        int intVal1 = embed.getIntVal1();
        int intVal2 = embed.getIntVal2();
        int intVal3 = embed.getIntVal3();
        TestEmbeddable.assertEquals((int)104, (int)intVal1);
        TestEmbeddable.assertEquals((int)105, (int)intVal2);
        TestEmbeddable.assertEquals((int)106, (int)intVal3);
    }

    public void checkEntityA_Coll_Embed_Embed(EntityA_Coll_Embed_Embed a) {
        int id = a.getId();
        String name = a.getName();
        int age = a.getAge();
        TestEmbeddable.assertEquals((int)1, (int)id);
        TestEmbeddable.assertEquals((String)("a" + id), (String)name);
        TestEmbeddable.assertEquals((int)1, (int)age);
        List<Embed_Embed> embeds = a.getEmbeds();
        for (Embed_Embed embed : embeds) {
            this.checkEmbed_Embed(embed);
        }
    }

    public void checkEntityA_Embed_Coll_Embed(EntityA_Embed_Coll_Embed a) {
        int id = a.getId();
        String name = a.getName();
        int age = a.getAge();
        TestEmbeddable.assertEquals((int)1, (int)id);
        TestEmbeddable.assertEquals((String)("a" + id), (String)name);
        TestEmbeddable.assertEquals((int)1, (int)age);
        Embed_Coll_Embed embed = a.getEmbed();
        this.checkEmbed_Coll_Embed(embed);
    }

    public void checkEmbed_Coll_Embed(Embed_Coll_Embed embed) {
        int intVal1 = embed.getIntVal1();
        int intVal2 = embed.getIntVal2();
        int intVal3 = embed.getIntVal3();
        TestEmbeddable.assertEquals((int)11, (int)intVal1);
        TestEmbeddable.assertEquals((int)12, (int)intVal2);
        TestEmbeddable.assertEquals((int)13, (int)intVal3);
        List<Embed> embeds = embed.getEmbeds();
        for (Embed embed1 : embeds) {
            this.checkEmbed(embed1);
        }
    }

    public void queryEntityA_Coll_String() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String[] query = new String[]{"select e from  EntityA_Coll_String a  , in (a.nickNames) e order by a.id", "select e from  EntityA_Coll_String a  , in (a.nickNames) e order by a.id", "select e from  EntityA_Coll_String a  , in (a.nickNames) e order by e", "select a from  EntityA_Coll_String a  WHERE a.nickNames IS EMPTY order by a", "select a from  EntityA_Coll_String a  WHERE exists (select n from EntityA_Coll_String a,  in (a.nickNames) n where n like '%1')  order by a"};
        List rs = null;
        for (int i = 0; i < query.length; ++i) {
            rs = em.createQuery(query[i]).getResultList();
            switch (i) {
                case 0: 
                case 1: 
                case 2: {
                    TestEmbeddable.assertTrue((rs.size() > 0 ? 1 : 0) != 0);
                    Object obj = rs.get(0);
                    TestEmbeddable.assertTrue((boolean)(obj instanceof String));
                    break;
                }
                case 3: 
                case 4: {
                    TestEmbeddable.assertTrue((rs.size() == 0 ? 1 : 0) != 0);
                }
            }
            em.clear();
        }
        String[] queryWithParameters = new String[]{"select b.name from EntityB1 b WHERE b.id in (select a.id FROM EntityA_Coll_String a where ?1 MEMBER OF a.nickNames)", "select b.name from EntityB1 b WHERE b.id not in (select a.id FROM EntityA_Coll_String a where ?1 MEMBER OF a.nickNames)"};
        block9: for (int i = 0; i < queryWithParameters.length; ++i) {
            Query q1 = em.createQuery(queryWithParameters[i]);
            q1.setParameter(1, (Object)"nickName_10");
            rs = q1.getResultList();
            switch (i) {
                case 0: {
                    String obj = (String)rs.get(0);
                    TestEmbeddable.assertEquals((String)"b1", (String)obj);
                    continue block9;
                }
                case 1: {
                    TestEmbeddable.assertTrue((rs.size() == 0 ? 1 : 0) != 0);
                }
            }
        }
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select a from EntityA_Coll_String a");
        List as = q.getResultList();
        for (EntityA_Coll_String a : as) {
            this.checkEntityA_Coll_String(a);
        }
        tran.commit();
        em.close();
    }

    public void queryEntityA_Embed_ToOne() {
        String[] query;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        for (String s : query = new String[]{"select a.embed from  EntityA_Embed_ToOne a ", "select a.embed from  EntityA_Embed_ToOne a ", "select e from EntityA_Embed_ToOne a  join a.embed e join e.b b where e.b.id > 0 order by a.id", "select e from EntityA_Embed_ToOne a  join a.embed e join e.b b where e.b.id > 0 order by a.id", "select a.embed from  EntityA_Embed_ToOne a ORDER BY a.embed", "select a.embed from  EntityA_Embed_ToOne a WHERE a.embed.b IS NOT NULL  ORDER BY a.embed", "select a.embed from  EntityA_Embed_ToOne a WHERE exists  (select a from EntityA_Embed_ToOne a  where a.embed.b IS NOT NULL)  ORDER BY a.embed"}) {
            List rs = null;
            rs = em.createQuery(s).getResultList();
            TestEmbeddable.assertTrue((rs.size() > 0 ? 1 : 0) != 0);
            Object obj = rs.get(0);
            TestEmbeddable.assertTrue((boolean)(obj instanceof Embed_ToOne));
            TestEmbeddable.assertTrue((((Embed_ToOne)obj).getEntityB() != null ? 1 : 0) != 0);
            em.clear();
        }
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select a from EntityA_Embed_ToOne a");
        List as = q.getResultList();
        for (EntityA_Embed_ToOne a : as) {
            this.checkEntityA_Embed_ToOne(a);
        }
        tran.commit();
        em.close();
    }

    public void queryEntityA_Embed_MappedToOne() {
        String[] query2;
        String[] query;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        for (String value : query = new String[]{"select a.embed from  EntityA_Embed_MappedToOne a ", "select e from EntityA_Embed_MappedToOne a  join a.embed e join e.bm bm where e.bm.id > 0 order by a.id", "select a.embed as e from  EntityA_Embed_MappedToOne a ORDER BY e", "select a.embed from  EntityA_Embed_MappedToOne a WHERE a.embed.bm IS NOT NULL", "select a.embed from  EntityA_Embed_MappedToOne a  WHERE exists  (select a from EntityA_Embed_MappedToOne a  where a.embed.bm IS NOT NULL)"}) {
            List rs = null;
            rs = em.createQuery(value).getResultList();
            TestEmbeddable.assertTrue((rs.size() > 0 ? 1 : 0) != 0);
            Object obj = rs.get(0);
            TestEmbeddable.assertTrue((boolean)(obj instanceof Embed_MappedToOne));
            TestEmbeddable.assertTrue((((Embed_MappedToOne)obj).getMappedEntityB() != null ? 1 : 0) != 0);
            em.clear();
        }
        for (String s : query2 = new String[]{"select a.embed from  EntityA_Embed_MappedToOne a  WHERE exists  (select e from EntityA_Embed_MappedToOne a join a.embed e  where e.bm IS NOT NULL)", "select a.embed from  EntityA_Embed_MappedToOne a  WHERE exists  (select a.embed from EntityA_Embed_MappedToOne a  where a.embed.bm IS NOT NULL)"}) {
            List rs = null;
            try {
                rs = em.createQuery(s).getResultList();
            }
            catch (ArgumentException argumentException) {
                // empty catch block
            }
        }
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select a from EntityA_Embed_MappedToOne a");
        List as = q.getResultList();
        for (EntityA_Embed_MappedToOne a : as) {
            this.checkEntityA_Embed_MappedToOne(a);
        }
        tran.commit();
        em.close();
    }

    public void queryEntityA_Coll_Embed_ToOne() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String[] query = new String[]{"select e, e.b from  EntityA_Coll_Embed_ToOne a  , in (a.embed1s) e order by e.name1", "select e, a.id from EntityA_Coll_Embed_ToOne a  , in (a.embed1s) e where e.b.id > 0 order by a.id", "select e, e.b.id  from  EntityA_Coll_Embed_ToOne a  , in (a.embed1s) e where e.name1 like '%1' order by e.name3", "select e, e.b.id  from  EntityA_Coll_Embed_ToOne a  , in (a.embed1s) e where e.name1 like '%1' order by e", "select e, e.b.id  from  EntityA_Coll_Embed_ToOne a  , in (a.embed1s) e where e.name1 like '%1' and a.embed1s IS NOT EMPTY and  e.b IS NOT NULL  order by e"};
        List rs = null;
        for (int i = 0; i < query.length; ++i) {
            rs = em.createQuery(query[i]).getResultList();
            TestEmbeddable.assertTrue((rs.size() > 0 ? 1 : 0) != 0);
            Object obj = ((Object[])rs.get(0))[0];
            TestEmbeddable.assertTrue((boolean)(obj instanceof Embed_ToOne));
            TestEmbeddable.assertTrue((((Embed_ToOne)obj).getEntityB() != null ? 1 : 0) != 0);
            switch (i) {
                case 0: {
                    Object b = ((Object[])rs.get(0))[1];
                    TestEmbeddable.assertTrue((boolean)(b instanceof EntityB1));
                    TestEmbeddable.assertEquals((int)((EntityB1)b).getId(), (int)((Embed_ToOne)obj).getEntityB().getId());
                }
            }
            em.clear();
        }
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select a from EntityA_Coll_Embed_ToOne a");
        List as = q.getResultList();
        for (EntityA_Coll_Embed_ToOne a : as) {
            this.checkEntityA_Coll_Embed_ToOne(a);
        }
        tran.commit();
        em.close();
    }

    public void queryEntityA_Embed_ToMany() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String[] query = new String[]{"select a.embed from EntityA_Embed_ToMany a", "select e from EntityA_Embed_ToMany a join a.embed e", "select b from EntityA_Embed_ToMany a join a.embed.bs b", "select e from EntityA_Embed_ToMany a join a.embed e  where e.name1 like '%1'", "select a.embed from EntityA_Embed_ToMany a ORDER BY a.embed", "select e from EntityA_Embed_ToMany a join a.embed e ORDER BY e", "select b from EntityA_Embed_ToMany a join a.embed.bs b ORDER BY b", "select e from EntityA_Embed_ToMany a join a.embed e  WHERE e.bs IS NOT EMPTY ORDER BY e", "select a from EntityA_Embed_ToMany a  WHERE exists (select a from EntityA_Embed_ToMany a where a.embed.bs IS NOT EMPTY) ORDER BY a", "select a from EntityA_Embed_ToMany a  WHERE exists (select a from EntityA_Embed_ToMany a where a.embed.bs IS NOT EMPTY) ORDER BY a"};
        List rs = null;
        for (int i = 0; i < query.length; ++i) {
            rs = em.createQuery(query[i]).getResultList();
            TestEmbeddable.assertTrue((rs.size() > 0 ? 1 : 0) != 0);
            Object obj = rs.get(0);
            switch (i) {
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 7: {
                    TestEmbeddable.assertTrue((boolean)(obj instanceof Embed_ToMany));
                    TestEmbeddable.assertTrue((((Embed_ToMany)obj).getEntityBs().size() > 0 ? 1 : 0) != 0);
                    break;
                }
                case 2: 
                case 6: {
                    TestEmbeddable.assertTrue((boolean)(obj instanceof EntityB1));
                    break;
                }
                case 8: 
                case 9: {
                    TestEmbeddable.assertTrue((boolean)(obj instanceof EntityA_Embed_ToMany));
                }
            }
            em.clear();
        }
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select a from EntityA_Embed_ToMany a");
        List as = q.getResultList();
        for (EntityA_Embed_ToMany a : as) {
            this.checkEntityA_Embed_ToMany(a);
        }
        tran.commit();
        em.close();
    }

    public void queryEntityA_Embed_Embed_ToMany() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String[] query = new String[]{"select a.embed from EntityA_Embed_Embed_ToMany a", "select a.embed from EntityA_Embed_Embed_ToMany a where a.embed.embed.name1 like '%1' ", "select a.embed.embed from EntityA_Embed_Embed_ToMany a", "select b from EntityA_Embed_Embed_ToMany a join a.embed.embed.bs b", "select a.embed.embed from EntityA_Embed_Embed_ToMany a  where a.embed.embed.name1 like '%1'", "select e2 from EntityA_Embed_Embed_ToMany a  left join a.embed e1 left join e1.embed e2", "select e2 from EntityA_Embed_Embed_ToMany a  join a.embed e1 join e1.embed e2", "select a.embed as e from EntityA_Embed_Embed_ToMany a ORDER BY e", "select a.embed.embed as e from EntityA_Embed_Embed_ToMany a  where a.embed.embed.name1 like '%1' ORDER BY e", "select a.embed from EntityA_Embed_Embed_ToMany a  where a.embed.embed.bs IS NOT EMPTY", "select a.embed from EntityA_Embed_Embed_ToMany a  where exists (select a.embed.embed.bs from  EntityA_Embed_Embed_ToMany a)", "select b from EntityA_Embed_Embed_ToMany a join a.embed.embed.bs b"};
        List rs = null;
        for (int i = 0; i < query.length; ++i) {
            rs = em.createQuery(query[i]).getResultList();
            TestEmbeddable.assertTrue((rs.size() > 0 ? 1 : 0) != 0);
            Object obj = rs.get(0);
            switch (i) {
                case 0: 
                case 1: 
                case 7: 
                case 9: 
                case 10: {
                    TestEmbeddable.assertTrue((boolean)(obj instanceof Embed_Embed_ToMany));
                    TestEmbeddable.assertTrue((((Embed_Embed_ToMany)obj).getEmbed().getEntityBs().size() > 0 ? 1 : 0) != 0);
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    TestEmbeddable.assertTrue((boolean)(obj instanceof Embed_ToMany));
                    TestEmbeddable.assertTrue((((Embed_ToMany)obj).getEntityBs().size() > 0 ? 1 : 0) != 0);
                    break;
                }
                case 3: 
                case 11: {
                    TestEmbeddable.assertTrue((boolean)(obj instanceof EntityB1));
                }
            }
            em.clear();
        }
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select a from EntityA_Embed_Embed_ToMany a");
        List as = q.getResultList();
        for (EntityA_Embed_Embed_ToMany a : as) {
            this.checkEntityA_Embed_Embed_ToMany(a);
        }
        tran.commit();
        em.close();
    }

    public void queryEntityA_Embed_Coll_Integer() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String[] query = new String[]{"select e, a.id from  EntityA_Embed_Coll_Integer a  , in (a.embed.otherIntVals) e order by e", "select e, a.id from  EntityA_Embed_Coll_Integer a  , in (a.embed.otherIntVals) e order by e", "select e, a.id from  EntityA_Embed_Coll_Integer a  , in (a.embed.otherIntVals) e order by a.id", "select e, a.embed.intVal1 from EntityA_Embed_Coll_Integer a  , in (a.embed.otherIntVals) e order by a.id", "select e, a.embed.intVal2 from  EntityA_Embed_Coll_Integer a  , in (a.embed.otherIntVals) e order by e", "select e, a.embed.intVal2 from  EntityA_Embed_Coll_Integer a  , in (a.embed.otherIntVals) e  WHERE a.embed.otherIntVals IS NOT EMPTY order by e", "select e, a.embed.intVal2 from  EntityA_Embed_Coll_Integer a  , in (a.embed.otherIntVals) e  WHERE exists (select a from  EntityA_Embed_Coll_Integer a  , in (a.embed.otherIntVals) e  where e > 0) order by e", "select e, a0.intVal2 from EntityA_Embed_Coll_Integer a JOIN a.embed a0 JOIN a0.otherIntVals e WHERE exists (select a from  EntityA_Embed_Coll_Integer a JOIN a.embed a0 JOIN a0.otherIntVals e  where e > 0) order by e"};
        List rs = null;
        for (String s : query) {
            rs = em.createQuery(s).getResultList();
            TestEmbeddable.assertTrue((rs.size() > 0 ? 1 : 0) != 0);
            Object obj = ((Object[])rs.get(0))[0];
            TestEmbeddable.assertTrue((boolean)(obj instanceof Integer));
            em.clear();
        }
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select a from EntityA_Embed_Coll_Integer a");
        List as = q.getResultList();
        for (EntityA_Embed_Coll_Integer a : as) {
            this.checkEntityA_Embed_Coll_Integer(a);
        }
        tran.commit();
        em.close();
    }

    public void queryEntityA_Embed_Embed() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String[] query = new String[]{"select a.embed from EntityA_Embed_Embed a", "select a.embed.embed from EntityA_Embed_Embed a", "select a.embed as e from EntityA_Embed_Embed a ORDER BY e"};
        String[] query2 = new String[]{"select a.embed from EntityA_Embed_Embed a WHERE a.embed.embed  IS NOT NULL", "select a.embed from EntityA_Embed_Embed a  WHERE exists  (select a.embed.embed from EntityA_Embed_Embed a where a.embed IS NOT NULL) "};
        List rs = null;
        for (int i = 0; i < query.length; ++i) {
            rs = em.createQuery(query[i]).getResultList();
            TestEmbeddable.assertTrue((rs.size() > 0 ? 1 : 0) != 0);
            switch (i) {
                case 0: 
                case 2: {
                    TestEmbeddable.assertTrue((boolean)(rs.get(0) instanceof Embed_Embed));
                    break;
                }
                case 1: {
                    TestEmbeddable.assertTrue((boolean)(rs.get(0) instanceof Embed));
                }
            }
            em.clear();
        }
        for (String s : query2) {
            try {
                rs = em.createQuery(s).getResultList();
            }
            catch (ArgumentException argumentException) {
                // empty catch block
            }
        }
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select a from EntityA_Embed_Embed a");
        List as = q.getResultList();
        for (EntityA_Embed_Embed a : as) {
            this.checkEntityA_Embed_Embed(a);
        }
        tran.commit();
        em.close();
    }

    public void queryEntityA_Coll_Embed_Embed() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String[] query = new String[]{"select e, e.intVal1, e.embed.intVal2 from  EntityA_Coll_Embed_Embed a  , in (a.embeds) e order by e.intVal3", "select e, e.intVal1, e.embed.intVal2 from  EntityA_Coll_Embed_Embed a  , in (a.embeds) e order by e.intVal3", "select e, a.id from EntityA_Coll_Embed_Embed a  , in (a.embeds) e order by a.id", "select e, a.id from EntityA_Coll_Embed_Embed a  , in (a.embeds) e order by e desc", "select e, e.intVal1, e.embed.intVal2 from  EntityA_Coll_Embed_Embed a  , in (a.embeds) e WHERE a.embeds IS NOT EMPTY  order by e.intVal3"};
        String[] query2 = new String[]{"select e, e.intVal1, e.embed.intVal2 from  EntityA_Coll_Embed_Embed a  , in (a.embeds) e WHERE e.intVal1 < ANY (select e2.intVal2  from EntityA_Coll_Embed_Embed a1, in (a1.embeds) e2)  order by e.intVal3", "select e, e.intVal1, e.embed.intVal2 from  EntityA_Coll_Embed_Embed a  , in (a.embeds) e WHERE e.intVal1 < ALL (select e2.intVal2  from EntityA_Coll_Embed_Embed a1, in (a1.embeds) e2)  order by e.intVal3", "select e, e.intVal1, e.embed.intVal2 from  EntityA_Coll_Embed_Embed a  , in (a.embeds) e WHERE e.intVal1 <= SOME  (select e2.intVal2  from EntityA_Coll_Embed_Embed a1, in (a1.embeds) e2)  order by e.intVal3", "select e, e.intVal1, e.embed.intVal2 from  EntityA_Coll_Embed_Embed a  , in (a.embeds) e WHERE e.intVal1 > ALL (select e2.intVal2  from EntityA_Coll_Embed_Embed a1, in (a1.embeds) e2)  order by e.intVal3", "select e, e.intVal1, e.embed.intVal2 from  EntityA_Coll_Embed_Embed a  , in (a.embeds) e WHERE e.intVal1 < ANY (select e.intVal2  from EntityA_Coll_Embed_Embed a, in (a.embeds) e)  order by e.intVal3", "select e, e.intVal1, e.embed.intVal2 from  EntityA_Coll_Embed_Embed a  , in (a.embeds) e WHERE e.intVal1 < ALL (select e.intVal2  from EntityA_Coll_Embed_Embed a, in (a.embeds) e)  order by e.intVal3", "select e, e.intVal1, e.embed.intVal2 from  EntityA_Coll_Embed_Embed a  , in (a.embeds) e WHERE e.intVal1 <= SOME  (select e.intVal2  from EntityA_Coll_Embed_Embed a, in (a.embeds) e)  order by e.intVal3", "select e, e.intVal1, e.embed.intVal2 from  EntityA_Coll_Embed_Embed a  , in (a.embeds) e WHERE e.intVal1 > ALL (select e.intVal2  from EntityA_Coll_Embed_Embed a, in (a.embeds) e)  order by e.intVal3", "select e, e.intVal1, e.embed.intVal2 from  EntityA_Coll_Embed_Embed a  , in (a.embeds) e WHERE e.intVal1 < ANY (select e2.intVal2  from in(a.embeds) e2)  order by e.intVal3", "select e, e.intVal1, e.embed.intVal2 from  EntityA_Coll_Embed_Embed a  , in (a.embeds) e WHERE e.intVal1 < ALL (select e2.intVal2  from a.embeds e2)  order by e.intVal3", "select e, e.intVal1, e.embed.intVal2 from  EntityA_Coll_Embed_Embed a  , in (a.embeds) e WHERE e.intVal1 <= SOME  (select e2.intVal2  from in(a.embeds) e2)  order by e.intVal3", "select e, e.intVal1, e.embed.intVal2 from  EntityA_Coll_Embed_Embed a  , in (a.embeds) e WHERE e.intVal1 > ALL (select e2.intVal2  from a.embeds e2)  order by e.intVal3"};
        String[] query3 = new String[]{"select e, e.intVal1, e.embed.intVal2 from  EntityA_Coll_Embed_Embed a  , in (a.embeds) e WHERE ?1 MEMBER OF a.embeds  order by e.intVal3", "select e, e.intVal1, e.embed.intVal2 from  EntityA_Coll_Embed_Embed a  left join a.embeds e WHERE ?1 MEMBER OF a.embeds  order by e.intVal3", "select e, e.intVal1, e.embed.intVal2 from  EntityA_Coll_Embed_Embed a  , in (a.embeds) e WHERE ?1 = e  order by e.intVal3"};
        List rs = null;
        Object obj = null;
        for (String item : query) {
            rs = em.createQuery(item).getResultList();
            TestEmbeddable.assertTrue((rs.size() > 0 ? 1 : 0) != 0);
            obj = ((Object[])rs.get(0))[0];
            TestEmbeddable.assertTrue((boolean)(obj instanceof Embed_Embed));
        }
        for (String value : query2) {
            rs = em.createQuery(value).getResultList();
            if (rs.size() <= 0) continue;
            obj = ((Object[])rs.get(0))[0];
            TestEmbeddable.assertTrue((boolean)(obj instanceof Embed_Embed));
        }
        for (String s : query3) {
            try {
                rs = em.createQuery(s).setParameter(1, obj).getResultList();
            }
            catch (ArgumentException argumentException) {
                // empty catch block
            }
        }
        em.clear();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select a from EntityA_Coll_Embed_Embed a");
        List as = q.getResultList();
        for (EntityA_Coll_Embed_Embed a : as) {
            this.checkEntityA_Coll_Embed_Embed(a);
        }
        tran.commit();
        em.close();
    }

    public void queryEntityA_Embed_Coll_Embed() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String[] query = new String[]{"select e, e.intVal1, e.intVal2 from  EntityA_Embed_Coll_Embed a  , in (a.embed.embeds) e order by e", "select e, e.intVal1 from  EntityA_Embed_Coll_Embed a  , in (a.embed.embeds) e order by e.intVal3", "select e, a.id from EntityA_Embed_Coll_Embed a  , in (a.embed.embeds) e order by a.id", "select e, e.intVal1, e.intVal2 from  EntityA_Embed_Coll_Embed a  , in (a.embed.embeds) e order by e.intVal3", "select e, e.intVal1, e.intVal2 from  EntityA_Embed_Coll_Embed a  , in (a.embed.embeds) e where a.embed.embeds IS NOT EMPTY order by e", "select e, e.intVal1, e.intVal2 from  EntityA_Embed_Coll_Embed a  , in (a.embed.embeds) e where exists (select e.intVal1  from EntityA_Embed_Coll_Embed a, in (a.embed.embeds) e  where e.intVal2 = 105)  order by e", "select e, a from  EntityA_Embed_Coll_Embed a  , in (a.embed.embeds) e  where e.intVal1 = SOME  (select e2.intVal1 from  EntityA_Embed_Coll_Embed a2  , in (a2.embed.embeds) e2)  order by e"};
        String[] query2 = new String[]{"select e, a from  EntityA_Embed_Coll_Embed a  , in (a.embed.embeds) e  where e = ?1 order by e"};
        List rs = null;
        EntityA_Embed_Coll_Embed ea = null;
        Object obj = null;
        for (int i = 0; i < query.length; ++i) {
            rs = em.createQuery(query[i]).getResultList();
            TestEmbeddable.assertTrue((rs.size() > 0 ? 1 : 0) != 0);
            obj = ((Object[])rs.get(0))[0];
            TestEmbeddable.assertTrue((boolean)(obj instanceof Embed));
            if (i != query.length - 1) continue;
            ea = (EntityA_Embed_Coll_Embed)((Object[])rs.get(0))[1];
        }
        for (String s : query2) {
            try {
                rs = em.createQuery(s).setParameter(1, (Object)((Embed)obj)).getResultList();
            }
            catch (ArgumentException argumentException) {
                // empty catch block
            }
        }
        try {
            rs = em.createQuery("select a from  EntityA_Embed_Coll_Embed a  where a.embed = ?1 order by e").setParameter(1, (Object)ea.getEmbed()).getResultList();
        }
        catch (ArgumentException i) {
            // empty catch block
        }
        em.clear();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select a from EntityA_Embed_Coll_Embed a");
        List as = q.getResultList();
        for (EntityA_Embed_Coll_Embed a : as) {
            this.checkEntityA_Embed_Coll_Embed(a);
        }
        tran.commit();
        em.close();
    }

    public void createObjMapKey() {
        int i;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        for (i = 0; i < this.numDepartments; ++i) {
            this.createDepartment1((EntityManager)em, this.deptId++);
        }
        for (i = 0; i < this.numDepartments; ++i) {
            this.createDepartment2((EntityManager)em, this.deptId++);
        }
        for (i = 0; i < this.numDepartments; ++i) {
            this.createDepartment3((EntityManager)em, this.deptId++);
        }
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public void createObjMapKeyEnumerated() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        Item4 item = new Item4();
        item.setId(1);
        FileName4 fileName1 = new FileName4("file1", "file1");
        item.addImage(Item4.Catagory.A1, fileName1);
        FileName4 fileName2 = new FileName4("file2", "file2");
        item.addImage(Item4.Catagory.A2, fileName2);
        FileName4 fileName3 = new FileName4("file3", "file3");
        item.addImage(Item4.Catagory.A3, fileName3);
        em.persist((Object)item);
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public void createObjMapKeyTemporal() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        Item5 item = new Item5();
        item.setId(1);
        long ts = System.currentTimeMillis();
        Timestamp ts1 = new Timestamp(ts);
        Timestamp ts2 = new Timestamp(ts + 1000000L);
        Timestamp ts3 = new Timestamp(ts + 2000000L);
        FileName4 fileName1 = new FileName4("file1", "file1");
        item.addImage(ts1, fileName1);
        FileName4 fileName2 = new FileName4("file2", "file2");
        item.addImage(ts2, fileName2);
        FileName4 fileName3 = new FileName4("file3", "file3");
        item.addImage(ts3, fileName3);
        em.persist((Object)item);
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public void createObjMapKeyClass() {
        int i;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        for (i = 0; i < this.numItems; ++i) {
            this.createItem1((EntityManager)em, this.itemId++);
        }
        for (i = 0; i < this.numItems; ++i) {
            this.createItem2((EntityManager)em, this.itemId++);
        }
        for (i = 0; i < this.numItems; ++i) {
            this.createItem3((EntityManager)em, this.itemId++);
        }
        for (i = 0; i < this.numCompany; ++i) {
            this.createCompany1((EntityManager)em, this.compId++);
        }
        for (i = 0; i < this.numCompany; ++i) {
            this.createCompany2((EntityManager)em, this.compId++);
        }
        tran.begin();
        em.flush();
        tran.commit();
        boolean found = false;
        for (String sqlStr : this.sql) {
            if (sqlStr.toUpperCase().indexOf("ITEM2_XXX") != -1) {
                found = true;
                break;
            }
            if (sqlStr.toUpperCase().indexOf("ITEM2_IMAGES") == -1) continue;
            found = false;
            break;
        }
        if (!found) {
            TestEmbeddable.fail((String)"Table name ITEM2_IMG specified in the MapKeyColumn annotation is not honored");
        }
        em.close();
    }

    public void createItem1(EntityManager em, int id) {
        Item1 item = new Item1();
        item.setId(id);
        for (int i = 0; i < this.numImagesPerItem; ++i) {
            item.addImage("image" + id + i, "file" + id + i);
        }
        em.persist((Object)item);
    }

    public void createItem2(EntityManager em, int id) {
        Item2 item = new Item2();
        item.setId(id);
        for (int i = 0; i < this.numImagesPerItem; ++i) {
            item.addImage("image" + id + i, "file" + id + i);
        }
        em.persist((Object)item);
    }

    public void createItem3(EntityManager em, int id) {
        Item3 item = new Item3();
        item.setId(id);
        for (int i = 0; i < this.numImagesPerItem; ++i) {
            item.addImage("image" + id + i, "file" + id + i);
        }
        em.persist((Object)item);
    }

    public void createCompany1(EntityManager em, int id) {
        Company1 c = new Company1();
        c.setId(id);
        for (int i = 0; i < this.numDivisionsPerCo; ++i) {
            Division d = this.createDivision(em, this.divId++);
            VicePresident vp = this.createVicePresident(em, this.vpId++);
            c.addToOrganization(d, vp);
            em.persist((Object)d);
            em.persist((Object)vp);
        }
        em.persist((Object)c);
    }

    public void createCompany2(EntityManager em, int id) {
        Company2 c = new Company2();
        c.setId(id);
        for (int i = 0; i < this.numDivisionsPerCo; ++i) {
            Division d = this.createDivision(em, this.divId++);
            VicePresident vp = this.createVicePresident(em, this.vpId++);
            c.addToOrganization(d, vp);
            em.persist((Object)d);
            em.persist((Object)vp);
        }
        em.persist((Object)c);
    }

    public Division createDivision(EntityManager em, int id) {
        Division d = new Division();
        d.setId(id);
        d.setName("d" + id);
        return d;
    }

    public VicePresident createVicePresident(EntityManager em, int id) {
        VicePresident vp = new VicePresident();
        vp.setId(id);
        vp.setName("vp" + id);
        return vp;
    }

    public void createDepartment1(EntityManager em, int id) {
        Department1 d = new Department1();
        d.setDeptId(id);
        HashMap<Integer, Employee1> emps = new HashMap<Integer, Employee1>();
        for (int i = 0; i < this.numEmployeesPerDept; ++i) {
            Employee1 e = this.createEmployee1(em, this.empId++);
            emps.put(e.getEmpId(), e);
            e.setDepartment(d);
            em.persist((Object)e);
        }
        d.setEmpMap(emps);
        em.persist((Object)d);
    }

    public Employee1 createEmployee1(EntityManager em, int id) {
        Employee1 e = new Employee1();
        e.setEmpId(id);
        return e;
    }

    public void createDepartment2(EntityManager em, int id) {
        Department2 d = new Department2();
        d.setDeptId(id);
        for (int i = 0; i < this.numEmployeesPerDept; ++i) {
            Employee2 e = this.createEmployee2(em, this.empId++);
            d.addEmployee(e);
            e.setDepartment(d);
            em.persist((Object)e);
        }
        em.persist((Object)d);
    }

    public Employee2 createEmployee2(EntityManager em, int id) {
        Employee2 e = new Employee2("e" + id, new java.util.Date());
        return e;
    }

    public void createDepartment3(EntityManager em, int id) {
        Department3 d = new Department3();
        d.setDeptId(id);
        for (int i = 0; i < this.numEmployeesPerDept; ++i) {
            Employee3 e = this.createEmployee3(em, this.empId++);
            d.addEmployee(e);
            e.setDepartment(d);
            em.persist((Object)e);
        }
        em.persist((Object)d);
    }

    public Employee3 createEmployee3(EntityManager em, int id) {
        Employee3 e = new Employee3();
        EmployeeName3 name = new EmployeeName3("f" + id, "l" + id);
        e.setEmpId(id);
        e.setName(name);
        return e;
    }

    public void findObjMapKey() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Department1 d1 = (Department1)em.find(Department1.class, (Object)1);
        this.assertDepartment1(d1);
        Employee1 e1 = (Employee1)em.find(Employee1.class, (Object)1);
        this.assertEmployee1(e1);
        Department2 d2 = (Department2)em.find(Department2.class, (Object)3);
        this.assertDepartment2(d2);
        Map<EmployeePK2, Employee2> emps = d2.getEmpMap();
        Set<EmployeePK2> keys = emps.keySet();
        for (EmployeePK2 key : keys) {
            Employee2 e2 = (Employee2)em.find(Employee2.class, (Object)key);
            this.assertEmployee2(e2);
        }
        Department3 d3 = (Department3)em.find(Department3.class, (Object)5);
        this.assertDepartment3(d3);
        Employee3 e3 = (Employee3)em.find(Employee3.class, (Object)9);
        this.assertEmployee3(e3);
        em.close();
    }

    public void assertDepartment1(Department1 d) {
        int id = d.getDeptId();
        Map<Integer, Employee1> es = d.getEmpMap();
        TestEmbeddable.assertEquals((int)2, (int)es.size());
        Set<Integer> keys = es.keySet();
        Iterator<Integer> iterator = keys.iterator();
        while (iterator.hasNext()) {
            Integer obj;
            Integer empId = obj = iterator.next();
            Employee1 e = es.get(empId);
            TestEmbeddable.assertEquals((int)empId, (int)e.getEmpId());
        }
    }

    public void assertDepartment2(Department2 d) {
        int id = d.getDeptId();
        Map<EmployeePK2, Employee2> es = d.getEmpMap();
        TestEmbeddable.assertEquals((int)2, (int)es.size());
        Set<EmployeePK2> keys = es.keySet();
        for (EmployeePK2 pk : keys) {
            Employee2 e = es.get(pk);
            TestEmbeddable.assertEquals((Object)pk, (Object)e.getEmpPK());
        }
    }

    public void assertDepartment3(Department3 d) {
        int id = d.getDeptId();
        Map<EmployeeName3, Employee3> es = d.getEmployees();
        TestEmbeddable.assertEquals((int)2, (int)es.size());
        Set<EmployeeName3> keys = es.keySet();
        for (EmployeeName3 key : keys) {
            Employee3 e = es.get(key);
            TestEmbeddable.assertEquals((Object)key, (Object)e.getName());
        }
    }

    public void assertEmployee1(Employee1 e) {
        int id = e.getEmpId();
        Department1 d = e.getDepartment();
        this.assertDepartment1(d);
    }

    public void assertEmployee2(Employee2 e) {
        EmployeePK2 pk = e.getEmpPK();
        Department2 d = e.getDepartment();
        this.assertDepartment2(d);
    }

    public void assertEmployee3(Employee3 e) {
        int id = e.getEmpId();
        Department3 d = e.getDepartment();
        this.assertDepartment3(d);
    }

    public void queryObjMapKey() {
        this.queryDepartment((EntityManagerFactory)this.emf);
        this.queryEmployee((EntityManagerFactory)this.emf);
    }

    public void queryDepartment(EntityManagerFactory emf) {
        String[] query;
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q1 = em.createQuery("select d from Department1 d");
        List ds1 = q1.getResultList();
        for (Department1 d : ds1) {
            this.assertDepartment1(d);
        }
        Query q2 = em.createQuery("select d from Department2 d");
        List ds2 = q2.getResultList();
        for (Department2 d : ds2) {
            this.assertDepartment2(d);
        }
        Query q3 = em.createQuery("select d from Department3 d");
        List ds3 = q3.getResultList();
        for (Department3 d : ds3) {
            this.assertDepartment3(d);
        }
        tran.commit();
        for (String s : query = new String[]{"select d from Department1 d join d.empMap e  where KEY(e) > 1 order by d", "select d from Department1 d join d.empMap e where d.deptId = KEY(e) order by d", "select d from Department1 d  where d.deptId < ANY  (select KEY(e) from in(d.empMap) e)  order by d", "select d from Department1 d  where d.deptId < SOME  (select KEY(e) from Department1 d1, in(d1.empMap) e)  order by d"}) {
            ds1 = em.createQuery(s).getResultList();
            this.assertDepartment1((Department1)ds1.get(0));
        }
        em.close();
    }

    public void queryEmployee(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q1 = em.createQuery("select e from Employee1 e");
        List es1 = q1.getResultList();
        for (Employee1 e : es1) {
            this.assertEmployee1(e);
        }
        Query q2 = em.createQuery("select e from Employee2 e");
        List es2 = q2.getResultList();
        for (Employee2 e : es2) {
            this.assertEmployee2(e);
        }
        Query q3 = em.createQuery("select e from Employee3 e");
        List es3 = q3.getResultList();
        for (Employee3 e : es3) {
            this.assertEmployee3(e);
        }
        tran.commit();
        em.close();
    }

    public void findObjMapKeyClass() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Item1 item1 = (Item1)em.find(Item1.class, (Object)1);
        this.assertItem1(item1);
        Item2 item2 = (Item2)em.find(Item2.class, (Object)3);
        this.assertItem2(item2);
        Item3 item3 = (Item3)em.find(Item3.class, (Object)5);
        this.assertItem3(item3);
        Company1 c1 = (Company1)em.find(Company1.class, (Object)1);
        this.assertCompany1(c1);
        Company2 c2 = (Company2)em.find(Company2.class, (Object)3);
        this.assertCompany2(c2);
        Division d = (Division)em.find(Division.class, (Object)1);
        this.assertDivision(d);
        VicePresident vp = (VicePresident)em.find(VicePresident.class, (Object)1);
        this.assertVicePresident(vp);
        em.close();
    }

    public void assertItem1(Item1 item) {
        int id = item.getId();
        Map<String, String> images = item.getImages();
        TestEmbeddable.assertEquals((int)this.numImagesPerItem, (int)images.size());
    }

    public void assertItem2(Item2 item) {
        int id = item.getId();
        Map<String, String> images = item.getImages();
        TestEmbeddable.assertEquals((int)this.numImagesPerItem, (int)images.size());
    }

    public void assertItem3(Item3 item) {
        int id = item.getId();
        Map<String, String> images = item.getImages();
        TestEmbeddable.assertEquals((int)this.numImagesPerItem, (int)images.size());
    }

    public void assertCompany1(Company1 c) {
        int id = c.getId();
        Map organization = c.getOrganization();
        TestEmbeddable.assertEquals((int)2, (int)organization.size());
    }

    public void assertCompany2(Company2 c) {
        int id = c.getId();
        Map organization = c.getOrganization();
        TestEmbeddable.assertEquals((int)2, (int)organization.size());
    }

    public void assertDivision(Division d) {
        int id = d.getId();
        String name = d.getName();
    }

    public void assertVicePresident(VicePresident vp) {
        int id = vp.getId();
        String name = vp.getName();
    }

    public void queryObjMapKeyClass() {
        this.queryItem((EntityManagerFactory)this.emf);
        this.queryCompany((EntityManagerFactory)this.emf);
        this.queryDivision((EntityManagerFactory)this.emf);
        this.queryVicePresident((EntityManagerFactory)this.emf);
    }

    public void findObjMapKeyEnumerated() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Item4 item = (Item4)em.find(Item4.class, (Object)1);
        FileName4 fileName1 = item.getImage(Item4.Catagory.A1);
        TestEmbeddable.assertEquals((String)"file1", (String)fileName1.getFName());
        TestEmbeddable.assertEquals((String)"file1", (String)fileName1.getLName());
        FileName4 fileName2 = item.getImage(Item4.Catagory.A2);
        TestEmbeddable.assertEquals((String)"file2", (String)fileName2.getFName());
        TestEmbeddable.assertEquals((String)"file2", (String)fileName2.getLName());
        FileName4 fileName3 = item.getImage(Item4.Catagory.A3);
        TestEmbeddable.assertEquals((String)"file3", (String)fileName3.getFName());
        TestEmbeddable.assertEquals((String)"file3", (String)fileName3.getLName());
        em.close();
    }

    public void findObjMapKeyTemporal() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Item5 item = (Item5)em.find(Item5.class, (Object)1);
        TestEmbeddable.assertEquals((int)3, (int)item.getImages().size());
        em.close();
    }

    public void queryObjMapKeyTemporal() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String jpql = "SELECT VALUE(img) FROM Item5 item, IN (item.images) img WHERE img.fName = :fName and item.id = :id";
        Query q = em.createQuery(jpql);
        q.setParameter("fName", (Object)"file1");
        q.setParameter("id", (Object)1);
        List coll = q.getResultList();
        TestEmbeddable.assertEquals((int)1, (int)coll.size());
        em.close();
    }

    public void queryItem(EntityManagerFactory emf) {
        Query q;
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q1 = em.createQuery("select i from Item1 i");
        List is1 = q1.getResultList();
        for (Item1 item : is1) {
            this.assertItem1(item);
        }
        Query q2 = em.createQuery("select i from Item2 i");
        List is2 = q2.getResultList();
        for (Item2 item : is2) {
            this.assertItem2(item);
        }
        Query q3 = em.createQuery("select i from Item3 i");
        List is3 = q3.getResultList();
        for (Item3 item : is3) {
            this.assertItem3(item);
        }
        tran.commit();
        String imageKey1 = (String)((Item1)is1.get(0)).getImages().keySet().toArray()[0];
        String imageKey2 = (String)((Item2)is2.get(0)).getImages().keySet().toArray()[0];
        String imageKey3 = (String)((Item3)is3.get(0)).getImages().keySet().toArray()[0];
        String[] query = new String[]{"select i from Item1 i where ?1 = any  (select KEY(e) from Item1 i, in(i.images) e)  order by i", "select i from Item1 i where exists  (select e from Item1 i, in(i.images) e   where ?1 = KEY(e))  order by i"};
        String[] query2 = new String[]{"select i from Item2 i where ?1 = any  (select KEY(e) from Item2 i, in(i.images) e)  order by i", "select i from Item2 i where exists  (select e from Item2 i, in(i.images) e   where ?1 = KEY(e))  order by i"};
        String[] query3 = new String[]{"select i from Item3 i where ?1 = any  (select KEY(e) from Item3 i, in(i.images) e)  order by i", "select i from Item3 i where exists  (select e from Item3 i, in(i.images) e   where ?1 = KEY(e))  order by i"};
        for (String element : query) {
            q = em.createQuery(element);
            q.setParameter(1, (Object)imageKey1);
            is1 = q.getResultList();
            for (Object item : is1) {
                this.assertItem1((Item1)item);
            }
        }
        for (String value : query2) {
            q = em.createQuery(value);
            q.setParameter(1, (Object)imageKey2);
            is2 = q.getResultList();
            for (Object item : is2) {
                this.assertItem2((Item2)item);
            }
        }
        for (String s : query3) {
            q = em.createQuery(s);
            q.setParameter(1, (Object)imageKey3);
            is3 = q.getResultList();
            for (Object item : is3) {
                this.assertItem3((Item3)item);
            }
        }
        em.close();
    }

    public void queryCompany(EntityManagerFactory emf) {
        String[] query2;
        String[] query;
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q1 = em.createQuery("select c from Company1 c");
        List cs1 = q1.getResultList();
        for (Company1 c : cs1) {
            this.assertCompany1(c);
        }
        Query q2 = em.createQuery("select c from Company2 c");
        List cs2 = q2.getResultList();
        for (Company2 c : cs2) {
            this.assertCompany2(c);
        }
        tran.commit();
        em.clear();
        Division d1 = (Division)((Company1)cs1.get(0)).getOrganization().keySet().toArray()[0];
        Division d2 = (Division)((Company2)cs2.get(0)).getOrganization().keySet().toArray()[0];
        for (String value : query = new String[]{"select c from Company1 c, in(c.organization) d  where KEY(d) = ?1", "select c from Company1 c  where ?1 =  (select KEY(d) from Company1 c, in(c.organization) d   where d.id = 1) order by c ", "select c from Company1 c where exists (select d from in(c.organization) d  where KEY(d) = ?1) order by c ", "select c from Company1 c where exists (select d from c.organization d  where KEY(d) = ?1) order by c "}) {
            Query q = em.createQuery(value);
            q.setParameter(1, (Object)d1);
            cs1 = q.getResultList();
            for (Company1 c : cs1) {
                this.assertCompany1(c);
            }
        }
        for (String s : query2 = new String[]{"select c from Company2 c where ?1 =  (select KEY(d) from Company2 c, in(c.organization) d   where d.id = 3) order by c ", "select c from Company2 c where exists (select d from in(c.organization) d  where KEY(d) = ?1) order by c ", "select c from Company2 c where exists (select d from c.organization d  where KEY(d) = ?1) order by c "}) {
            Query q = em.createQuery(s);
            q.setParameter(1, (Object)d2);
            cs2 = q.getResultList();
            for (Company2 c : cs2) {
                this.assertCompany2(c);
            }
        }
        em.close();
    }

    public void queryDivision(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select d from Division d");
        List ds = q.getResultList();
        for (Division d : ds) {
            this.assertDivision(d);
        }
        tran.commit();
        em.close();
    }

    public void queryVicePresident(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select vp from VicePresident vp");
        List vps = q.getResultList();
        for (VicePresident vp : vps) {
            this.assertVicePresident(vp);
        }
        tran.commit();
        em.close();
    }

    public void createEmbeddableContainingRelationWithGeneratedKey() throws IOException, SQLException {
        OpenJPAEntityManagerSPI ojem;
        OpenJPAEntityManagerSPI em = ojem = this.emf.createEntityManager();
        JDBCConfiguration conf = (JDBCConfiguration)ojem.getConfiguration();
        EntityTransaction tran = em.getTransaction();
        Book b = new Book(1590596455L);
        Seller bob = new Seller("Bob's books!");
        Seller jim = new Seller("Jim's books!");
        Seller mike = new Seller("Mikes's books!");
        b.addListing(new Listing(bob, 44.15));
        b.addListing(new Listing(jim, 34.15));
        b.addListing(new Listing(mike, 14.15));
        em.getTransaction().begin();
        em.persist((Object)b);
        em.getTransaction().commit();
        int id = b.getId();
        em.clear();
        Book b2 = (Book)em.find(Book.class, (Object)id);
        Set<Listing> listings = b2.getListings();
        for (Listing listing : listings) {
            Seller seller = listing.getSeller();
            TestEmbeddable.assertNotNull((Object)seller);
            TestEmbeddable.assertTrue((seller.getId() != 0 ? 1 : 0) != 0);
        }
        em.close();
    }

    public void testEntityA_Embed_Complex() {
        this.getLog().trace((Object)"testEntityA_Embed_Complex() - entered");
        this.createEntityA_Embed_Complex(null);
        this.queryEntityA_Embed_Complex(null);
        this.findEntityA_Embed_Complex(null);
    }

    public void testEntityA_Embed_Complex2() {
        this.getLog().trace((Object)"testEntityA_Embed_Complex2() - entered");
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.clear();
        this.createEntityA_Embed_Complex((EntityManager)em);
        em.clear();
        this.findEntityA_Embed_Complex((EntityManager)em);
        em.clear();
        this.updateEntityA_Embed_Complex((EntityManager)em);
        em.clear();
        this.findEntityA_Embed_Complex((EntityManager)em);
        em.clear();
        this.removeEntityA_Embed_Complex((EntityManager)em);
        em.close();
    }

    public void createEntityA_Embed_Complex(EntityManager em) {
        Boolean emClose = false;
        if (em == null) {
            em = this.emf.createEntityManager();
            emClose = true;
        }
        em.getTransaction().begin();
        this.createEntityA_Embed_Complex(em, this.ID);
        em.flush();
        em.getTransaction().commit();
        if (emClose.booleanValue()) {
            em.close();
        }
    }

    public void createEntityA_Embed_Complex(EntityManager em, int id) {
        Object embed;
        int i;
        this.getLog().trace((Object)"createEntityA_Embed_Complex() - entered");
        EntityA_Embed_Complex a = new EntityA_Embed_Complex();
        a.setId(id);
        a.setName("a" + id);
        a.setAge(id);
        for (i = 0; i < this.numBasicTypes; ++i) {
            a.addNickName("nickName_" + id + i);
        }
        a.addCreditRating(EntityA_Embed_Complex.CreditRating.POOR);
        a.addTimestamp(new Timestamp(cal.getTimeInMillis()));
        a.addLob("lob_0");
        a.setEmbed(this.createEmbed_Embed(this.numEmbeddables, 0));
        for (i = 0; i < this.numEmbeddables; ++i) {
            embed = this.createEmbed_Embed(id, i);
            a.addEmbed((Embed_Embed)embed);
        }
        for (i = 0; i < this.numEmbeddables; ++i) {
            embed = this.createEmbed_ToOne(em, i + id);
            a.addEmbed1ToOnes((Embed_ToOne)embed);
        }
        a.setTransientJavaValue(timeHash);
        a.setTransientValue(timeHash);
        em.persist((Object)a);
    }

    public void checkEntityA_Embed_Complex(EntityA_Embed_Complex a) {
        this.getLog().trace((Object)"checkEntityA_Embed_Complex() - entered");
        int id = a.getId();
        String name = a.getName();
        int age = a.getAge();
        TestEmbeddable.assertEquals((int)this.ID, (int)id);
        TestEmbeddable.assertEquals((String)("a" + id), (String)name);
        TestEmbeddable.assertEquals((int)this.ID, (int)age);
        Set<String> nickNames = a.getNickNames();
        for (String string : nickNames) {
            TestEmbeddable.assertEquals((String)("nickName_" + id + "0"), (String)string);
        }
        List<EntityA_Embed_Complex.CreditRating> cr = a.getCreditRating();
        for (EntityA_Embed_Complex.CreditRating creditRating : cr) {
            TestEmbeddable.assertEquals((String)"POOR", (String)creditRating.toString());
        }
        List<Timestamp> list = a.getTimestamps();
        for (Timestamp ts : list) {
            TestEmbeddable.assertNotEquals(0, ts.getTime());
        }
        List<String> list2 = a.getLobs();
        int i = 0;
        for (String lob : list2) {
            TestEmbeddable.assertEquals((String)("lob_" + i++), (String)lob);
        }
        Embed_Embed embedded = a.getEmbed();
        this.checkEmbed_Embed(embedded);
        List<Embed_Embed> embeds = a.getEmbeds();
        for (Embed_Embed embed : embeds) {
            this.checkEmbed_Embed(embed);
        }
        Set<Embed_ToOne> embedOnes = a.getEmbed1ToOnes();
        for (Embed_ToOne embed : embedOnes) {
            this.checkEmbed_ToOne(embed);
        }
        TestEmbeddable.assertNotEquals(a.getTransientJavaValue(), timeHash);
        TestEmbeddable.assertNotEquals(a.getTransientValue(), timeHash);
    }

    public void findEntityA_Embed_Complex(EntityManager em) {
        Boolean emClose = false;
        this.getLog().trace((Object)"findEntityA_Embed_Complex() - entered");
        if (em == null) {
            em = this.emf.createEntityManager();
            emClose = true;
        }
        EntityA_Embed_Complex a = (EntityA_Embed_Complex)em.find(EntityA_Embed_Complex.class, (Object)this.ID);
        this.checkEntityA_Embed_Complex(a);
        if (emClose.booleanValue()) {
            em.close();
        }
    }

    public void updateEntityA_Embed_Complex(EntityManager em) {
        Boolean emClose = false;
        this.getLog().trace((Object)"updateEntityA_Embed_Complex() - entered");
        if (em == null) {
            em = this.emf.createEntityManager();
            emClose = true;
        }
        em.getTransaction().begin();
        EntityA_Embed_Complex a = (EntityA_Embed_Complex)em.find(EntityA_Embed_Complex.class, (Object)this.ID);
        this.checkEntityA_Embed_Complex(a);
        for (int i = 1; i < this.numEmbeddables; ++i) {
            a.addLob("lob_" + i);
        }
        a.setTransientJavaValue(2009);
        a.setTransientValue(2009);
        em.persist((Object)a);
        em.flush();
        em.getTransaction().commit();
        if (emClose.booleanValue()) {
            em.close();
        }
    }

    public void removeEntityA_Embed_Complex(EntityManager em) {
        Boolean emClose = false;
        this.getLog().trace((Object)"removeEntityA_Embed_Complex() - entered");
        if (em == null) {
            em = this.emf.createEntityManager();
            emClose = true;
        }
        em.getTransaction().begin();
        EntityA_Embed_Complex a = (EntityA_Embed_Complex)em.find(EntityA_Embed_Complex.class, (Object)this.ID);
        this.checkEntityA_Embed_Complex(a);
        em.remove((Object)a);
        em.flush();
        em.getTransaction().commit();
        em.clear();
        a = (EntityA_Embed_Complex)em.find(EntityA_Embed_Complex.class, (Object)this.ID);
        TestEmbeddable.assertNull((String)"Entity should no longer exist", (Object)a);
        if (emClose.booleanValue()) {
            em.close();
        }
    }

    public void queryEntityA_Embed_Complex(EntityManager em) {
        Boolean emClose = false;
        this.getLog().trace((Object)"queryEntityA_Embed_Complex() - entered");
        if (em == null) {
            em = this.emf.createEntityManager();
            emClose = true;
        }
        String[] query = new String[]{"select e from  EntityA_Embed_Complex a  , in (a.nickNames) e order by a.id", "select e from  EntityA_Embed_Complex a  , in (a.nickNames) e order by a.id", "select e from  EntityA_Embed_Complex a  , in (a.nickNames) e order by e", "select a from  EntityA_Embed_Complex a  WHERE a.nickNames IS EMPTY order by a", "select a from  EntityA_Embed_Complex a  WHERE exists (select n from EntityA_Embed_Complex a,  in (a.nickNames) n where n like '%1')  order by a"};
        List rs = null;
        for (int i = 0; i < query.length; ++i) {
            rs = em.createQuery(query[i]).getResultList();
            switch (i) {
                case 0: 
                case 1: 
                case 2: {
                    TestEmbeddable.assertTrue((rs.size() > 0 ? 1 : 0) != 0);
                    Object obj = rs.get(0);
                    TestEmbeddable.assertTrue((boolean)(obj instanceof String));
                    break;
                }
                case 3: 
                case 4: {
                    TestEmbeddable.assertTrue((rs.size() == 0 ? 1 : 0) != 0);
                }
            }
            em.clear();
        }
        em.getTransaction().begin();
        Query q = em.createQuery("select a from EntityA_Embed_Complex a");
        List as = q.getResultList();
        for (EntityA_Embed_Complex a : as) {
            this.checkEntityA_Embed_Complex(a);
        }
        em.getTransaction().commit();
        if (emClose.booleanValue()) {
            em.close();
        }
    }

    public void testEmbeddableCollUsingArraysAsList() {
        this.getLog().trace((Object)"testEmbeddableCollUsingArraysAsList() - entered");
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        Embed_Embed[] embedArray = new Embed_Embed[5];
        for (int i = 1; i < 5; ++i) {
            embedArray[i] = new Embed_Embed();
            embedArray[i].setIntVal1(i);
        }
        List<Embed_Embed> embedList = Arrays.asList(embedArray);
        EntityA_Coll_Embed_Embed a1 = new EntityA_Coll_Embed_Embed();
        a1.setId(1);
        a1.setAge(1);
        a1.setName("name1");
        a1.setEmbeds(embedList);
        em.persist((Object)a1);
        tran.begin();
        em.flush();
        tran.commit();
        tran.begin();
        Embed_Embed embed1 = new Embed_Embed();
        embed1.setIntVal1(100);
        a1.addEmbed(embed1);
        tran.commit();
        em.clear();
        EntityA_Coll_Embed_Embed findA = (EntityA_Coll_Embed_Embed)em.find(EntityA_Coll_Embed_Embed.class, (Object)1);
        TestEmbeddable.assertEquals((int)6, (int)findA.getEmbeds().size());
        em.close();
    }

    public void testDefaultNameForElementCollection() {
        this.getLog().trace((Object)"testDefaultNameForElementCollection() - entered");
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        A a = new A();
        a.setId("1");
        Embed embed = new Embed();
        embed.setIntVal1(1);
        embed.setIntVal2(2);
        embed.setIntVal3(3);
        HashSet<Embed> embeds = new HashSet<Embed>();
        embeds.add(embed);
        a.setEmbeds(embeds);
        ArrayList<java.util.Date> dates = new ArrayList<java.util.Date>();
        dates.add(new java.util.Date());
        a.setCollectionDate(dates);
        em.persist((Object)a);
        tran.commit();
        boolean found = false;
        for (String sqlStr : this.sql) {
            if (sqlStr.toUpperCase().indexOf("A_EMBEDS") == -1) continue;
            found = true;
            break;
        }
        TestEmbeddable.assertTrue((boolean)found);
        found = false;
        for (String sqlStr : this.sql) {
            if (sqlStr.toUpperCase().indexOf("VALUE") == -1) continue;
            found = true;
            break;
        }
        TestEmbeddable.assertTrue((boolean)found);
        em.close();
    }
}

