/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.dynamicschema;

import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.dynamicschema.EntityReservedWords;
import org.apache.openjpa.persistence.dynamicschema.EntityVeryLongNames;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestDynamicSchemas
extends SingleEMFTestCase {
    @Override
    public void setUp() {
    }

    public void testDerbyDynamicSchema() {
        OpenJPAEntityManagerFactorySPI derbyEMF = this.createEMF(EntityVeryLongNames.class, EntityReservedWords.class, "openjpa.ConnectionURL", "jdbc:derby:net://host:1527/databaseName", "openjpa.jdbc.SynchronizeMappings", "export", "openjpa.jdbc.SchemaFactory", "dynamic", "Retain data after test run");
        this.validateTableName(derbyEMF);
        this.closeEMF((EntityManagerFactory)derbyEMF);
    }

    public void testDB2DynamicSchema() {
        OpenJPAEntityManagerFactorySPI db2EMF = this.createEMF(EntityVeryLongNames.class, EntityReservedWords.class, "openjpa.ConnectionURL", "jdbc:db2://localhost:5000/db2", "openjpa.jdbc.SynchronizeMappings", "export", "openjpa.jdbc.SchemaFactory", "dynamic", "Retain data after test run");
        this.validateTableName(db2EMF);
        this.closeEMF((EntityManagerFactory)db2EMF);
    }

    public void testOracleDynamicSchema() {
        OpenJPAEntityManagerFactorySPI oracleEMF = this.createEMF(EntityVeryLongNames.class, EntityReservedWords.class, "openjpa.ConnectionURL", "jdbc:oracle:thin:@host:1234:database_sid", "openjpa.jdbc.SynchronizeMappings", "export", "openjpa.jdbc.SchemaFactory", "dynamic", "Retain data after test run");
        this.validateTableName(oracleEMF);
        this.closeEMF((EntityManagerFactory)oracleEMF);
    }

    public void testAccessDynamicSchema() {
        OpenJPAEntityManagerFactorySPI accessEMF = this.createEMF(EntityVeryLongNames.class, EntityReservedWords.class, "openjpa.ConnectionURL", "jdbc:odbc:Driver=Microsoft Access Driver (*.mdb);DBQ=c:", "openjpa.jdbc.SynchronizeMappings", "export", "openjpa.jdbc.SchemaFactory", "dynamic", "Retain data after test run");
        this.validateTableName(accessEMF);
        this.closeEMF((EntityManagerFactory)accessEMF);
    }

    public void testSQLServerDynamicSchema() {
        OpenJPAEntityManagerFactorySPI sqlserverEMF = this.createEMF(EntityVeryLongNames.class, EntityReservedWords.class, "openjpa.ConnectionURL", "jdbc:microsoft:sqlserver:", "openjpa.jdbc.SynchronizeMappings", "export", "openjpa.jdbc.SchemaFactory", "dynamic", "Retain data after test run");
        this.validateTableName(sqlserverEMF);
        this.closeEMF((EntityManagerFactory)sqlserverEMF);
    }

    public void testMariaDBDynamicSchema() {
        OpenJPAEntityManagerFactorySPI mysqlEMF = this.createEMF(EntityVeryLongNames.class, EntityReservedWords.class, "openjpa.ConnectionURL", "jdbc:mariadb://host1:1,host2:2/database?p1=v1&p2=v2", "openjpa.jdbc.SynchronizeMappings", "export", "openjpa.jdbc.SchemaFactory", "dynamic", "Retain data after test run");
        this.validateTableName(mysqlEMF);
        this.closeEMF((EntityManagerFactory)mysqlEMF);
    }

    public void testMySQLDynamicSchema() {
        OpenJPAEntityManagerFactorySPI mysqlEMF = this.createEMF(EntityVeryLongNames.class, EntityReservedWords.class, "openjpa.ConnectionURL", "jdbc:mysql://host1:1,host2:2/database?p1=v1&p2=v2", "openjpa.jdbc.SynchronizeMappings", "export", "openjpa.jdbc.SchemaFactory", "dynamic", "Retain data after test run");
        this.validateTableName(mysqlEMF);
        this.closeEMF((EntityManagerFactory)mysqlEMF);
    }

    public void testPostgresDynamicSchema() {
        OpenJPAEntityManagerFactorySPI postgresEMF = this.createEMF(EntityVeryLongNames.class, EntityReservedWords.class, "openjpa.ConnectionURL", "jdbc:postgresql:database", "openjpa.jdbc.SynchronizeMappings", "export", "openjpa.jdbc.SchemaFactory", "dynamic", "Retain data after test run");
        this.validateTableName(postgresEMF);
        this.closeEMF((EntityManagerFactory)postgresEMF);
    }

    public void testInformixDynamicSchema() {
        OpenJPAEntityManagerFactorySPI informixEMF = this.createEMF(EntityVeryLongNames.class, EntityReservedWords.class, "openjpa.ConnectionURL", "jdbc:informix-sqli:", "openjpa.jdbc.SynchronizeMappings", "export", "openjpa.jdbc.SchemaFactory", "dynamic", "Retain data after test run");
        this.validateTableName(informixEMF);
        this.closeEMF((EntityManagerFactory)informixEMF);
    }

    public void testSybaseDynamicSchema() {
        OpenJPAEntityManagerFactorySPI sybaseEMF = this.createEMF(EntityVeryLongNames.class, EntityReservedWords.class, "openjpa.ConnectionURL", "jdbc:sybase:Tds:host:1234?ServiceName=db", "openjpa.jdbc.SynchronizeMappings", "export", "openjpa.jdbc.SchemaFactory", "dynamic", "Retain data after test run");
        this.validateTableName(sybaseEMF);
        this.closeEMF((EntityManagerFactory)sybaseEMF);
    }

    public void testFirebirdDynamicSchema() {
        OpenJPAEntityManagerFactorySPI firebirdEMF = this.createEMF(EntityVeryLongNames.class, EntityReservedWords.class, "openjpa.ConnectionURL", "jdbc:firebirdsql:host/1234:database", "openjpa.jdbc.SynchronizeMappings", "export", "openjpa.jdbc.SchemaFactory", "dynamic", "Retain data after test run");
        this.validateTableName(firebirdEMF);
        this.closeEMF((EntityManagerFactory)firebirdEMF);
    }

    @Override
    protected OpenJPAEntityManagerFactorySPI createEMF(Object ... props) {
        int propsLength = props.length;
        Object[] newProps = new Object[propsLength + 2];
        System.arraycopy(props, 0, newProps, 0, propsLength);
        newProps[propsLength] = "openjpa.jdbc.DBDictionary";
        newProps[propsLength + 1] = "";
        return super.createEMF(newProps);
    }

    private void validateTableName(OpenJPAEntityManagerFactorySPI emf) {
        JDBCConfiguration conf = (JDBCConfiguration)emf.getConfiguration();
        DBDictionary dict = conf.getDBDictionaryInstance();
        ClassMapping mapping = (ClassMapping)conf.getMetaDataRepositoryInstance().getMetaData(EntityVeryLongNames.class, ((Object)((Object)this)).getClass().getClassLoader(), true);
        Table table = mapping.getTable();
        TestDynamicSchemas.assertTrue((table.getName().length() > 0 ? 1 : 0) != 0);
        TestDynamicSchemas.assertTrue((table.getName().length() <= dict.maxTableNameLength ? 1 : 0) != 0);
        this.validateColumnNames(table, dict);
        mapping = (ClassMapping)conf.getMetaDataRepositoryInstance().getMetaData(EntityReservedWords.class, ((Object)((Object)this)).getClass().getClassLoader(), true);
        table = mapping.getTable();
        TestDynamicSchemas.assertTrue((table.getName().length() > 0 ? 1 : 0) != 0);
        TestDynamicSchemas.assertTrue((table.getName().length() <= dict.maxTableNameLength ? 1 : 0) != 0);
        this.validateColumnNames(table, dict);
    }

    private void validateColumnNames(Table table, DBDictionary dict) {
        Column[] columns;
        for (Column column : columns = table.getColumns()) {
            TestDynamicSchemas.assertTrue((column.getName().length() > 0 ? 1 : 0) != 0);
            TestDynamicSchemas.assertTrue((column.getName().length() <= dict.maxColumnNameLength ? 1 : 0) != 0);
            TestDynamicSchemas.assertFalse((String)("Column" + column.getName()), (boolean)dict.getInvalidColumnWordSet().contains(column.getName().toUpperCase()));
        }
    }
}

