/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.detachment;

import java.util.Calendar;
import javax.persistence.EntityManager;
import org.apache.openjpa.conf.Compatibility;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.detachment.TestDetach;
import org.apache.openjpa.persistence.detachment.model.DMCustomer;
import org.apache.openjpa.persistence.detachment.model.DMCustomerInventory;
import org.apache.openjpa.persistence.detachment.model.DMItem;
import org.apache.openjpa.util.Proxy;

public class TestDetachLite
extends TestDetach {
    Object[] props = new Object[]{"openjpa.DetachState", "loaded(LiteAutoDetach=true)", DMCustomer.class, DMCustomerInventory.class, DMItem.class, CLEAR_TABLES};

    @Override
    public void setUp() {
        super.setUp(this.props);
        Compatibility compat = this.emf.getConfiguration().getCompatibilityInstance();
        compat.setCopyOnDetach(false);
        compat.setFlushBeforeDetach(false);
        this.em = this.emf.createEntityManager();
        this.root = this.createData();
    }

    public void testPendingClear() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        DMCustomer dm = (DMCustomer)em.find(DMCustomer.class, (Object)this.root.getId());
        dm.setLastName(System.currentTimeMillis() + "--last");
        em.clear();
        em.getTransaction().begin();
        em.getTransaction().commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLeaveProxy() {
        Object[] p = this.props;
        p[1] = "loaded(LiteAutoDetach=true,DetachProxyFields=false)";
        try (OpenJPAEntityManagerFactorySPI iemf = this.createEMF(p);){
            DMCustomer dc = new DMCustomer();
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(System.currentTimeMillis());
            dc.setCal(cal);
            EntityManager iem = iemf.createEntityManager();
            try {
                iem.getTransaction().begin();
                iem.persist((Object)dc);
                iem.getTransaction().commit();
                Calendar beforeDetachCal = dc.getCal();
                iem.clear();
                Calendar afterDetachCal = dc.getCal();
                TestDetachLite.assertTrue((boolean)(beforeDetachCal instanceof Proxy));
                TestDetachLite.assertTrue((boolean)(afterDetachCal instanceof Proxy));
                TestDetachLite.assertNull((Object)((Proxy)afterDetachCal).getOwner());
            }
            finally {
                if (iem.getTransaction().isActive()) {
                    iem.getTransaction().rollback();
                }
                iem.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProxyClear() {
        DMCustomer dc = new DMCustomer();
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        dc.setCal(cal);
        OpenJPAEntityManagerSPI iem = this.emf.createEntityManager();
        try {
            iem.getTransaction().begin();
            iem.persist((Object)dc);
            iem.getTransaction().commit();
            Calendar beforeDetachCal = dc.getCal();
            iem.clear();
            Calendar afterDetachCal = dc.getCal();
            TestDetachLite.assertTrue((boolean)(beforeDetachCal instanceof Proxy));
            TestDetachLite.assertFalse((boolean)(afterDetachCal instanceof Proxy));
        }
        finally {
            if (iem.getTransaction().isActive()) {
                iem.getTransaction().rollback();
            }
            iem.close();
        }
    }

    public void testCloseDetach() {
        this.root = (DMCustomer)this.em.merge((Object)this.root);
        PersistenceCapable pc = this.root;
        TestDetachLite.assertFalse((boolean)pc.pcIsDetached());
        this.em.close();
        TestDetachLite.assertTrue((boolean)pc.pcIsDetached());
        for (DMCustomerInventory c : this.root.getCustomerInventories()) {
            pc = c;
            TestDetachLite.assertTrue((boolean)pc.pcIsDetached());
            pc = c.getItem();
            TestDetachLite.assertTrue((boolean)pc.pcIsDetached());
        }
    }
}

