/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.detachment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.openjpa.conf.Compatibility;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.detachment.model.DMCustomer;
import org.apache.openjpa.persistence.detachment.model.DMCustomerInventory;
import org.apache.openjpa.persistence.detachment.model.DMItem;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestDetach
extends SingleEMFTestCase {
    OpenJPAEntityManager em;
    DMCustomer root;

    @Override
    public void setUp() {
        super.setUp(DMCustomer.class, DMCustomerInventory.class, DMItem.class, CLEAR_TABLES);
        Compatibility compat = this.emf.getConfiguration().getCompatibilityInstance();
        compat.setCopyOnDetach(false);
        compat.setFlushBeforeDetach(false);
        this.em = this.emf.createEntityManager();
        this.root = this.createData();
    }

    public void testDetachCascadeIsSet() {
        MetaDataRepository repos = this.emf.getConfiguration().getMetaDataRepositoryInstance();
        ClassMetaData meta = repos.getCachedMetaData(DMCustomer.class);
        TestDetach.assertEquals((int)0, (int)meta.getField("firstName").getCascadeDetach());
        TestDetach.assertEquals((int)1, (int)meta.getField("customerInventories").getElement().getCascadeDetach());
        meta = repos.getCachedMetaData(DMCustomerInventory.class);
        TestDetach.assertEquals((int)0, (int)meta.getField("customer").getCascadeDetach());
        TestDetach.assertEquals((int)0, (int)meta.getField("item").getCascadeDetach());
    }

    public void testDetachRemovesEntityAndCascadedRelationFromContext() {
        this.em.getTransaction().begin();
        DMCustomer pc = (DMCustomer)this.em.find(DMCustomer.class, (Object)this.root.getId());
        List<DMCustomerInventory> inventories = pc.getCustomerInventories();
        DMItem item = inventories.get(0).getItem();
        this.assertNotDetached(pc);
        for (DMCustomerInventory i : inventories) {
            this.assertNotDetached(i);
        }
        this.assertNotDetached(item);
        this.em.detach((Object)pc);
        this.assertDetached(pc);
        for (DMCustomerInventory i : inventories) {
            this.assertDetached(i);
        }
        this.em.getTransaction().rollback();
        TestDetach.assertNotNull((Object)pc.getFirstName());
    }

    public void testDetachingDirtyEntityDoesNotImplicitlyFlush() {
        this.em.getTransaction().begin();
        DMCustomer pc = (DMCustomer)this.em.find(DMCustomer.class, (Object)this.root.getId());
        String original = pc.getLastName();
        pc.setLastName("Changed That Should not be Saved");
        this.em.detach((Object)pc);
        this.em.getTransaction().commit();
        DMCustomer pc2 = (DMCustomer)this.em.find(DMCustomer.class, (Object)this.root.getId());
        TestDetach.assertNotNull((Object)pc2);
        TestDetach.assertEquals((String)original, (String)pc2.getLastName());
    }

    public void testDetachingNewEntityIsIgnored() {
        this.em.getTransaction().begin();
        DMCustomer pc = (DMCustomer)this.em.find(DMCustomer.class, (Object)this.root.getId());
        List<DMCustomerInventory> inventories = pc.getCustomerInventories();
        DMCustomer newPC = new DMCustomer();
        newPC.setCustomerInventories(inventories);
        for (DMCustomerInventory inventory : inventories) {
            inventory.setCustomer(newPC);
        }
        this.em.detach((Object)newPC);
        for (DMCustomerInventory inventory : inventories) {
            this.assertNotDetached(inventory);
        }
        this.em.getTransaction().rollback();
    }

    public void testDetachingDetachedEntityIsIgnored() {
        this.em.getTransaction().begin();
        DMCustomer pc = (DMCustomer)this.em.find(DMCustomer.class, (Object)this.root.getId());
        List<DMCustomerInventory> inventories = pc.getCustomerInventories();
        this.em.detach((Object)pc);
        DMCustomer detached = pc;
        this.assertDetached(detached);
        for (DMCustomerInventory inventory : inventories) {
            this.assertDetached(inventory);
        }
        ArrayList<DMCustomerInventory> newInventories = new ArrayList<DMCustomerInventory>(inventories);
        DMCustomerInventory newInventory = new DMCustomerInventory();
        newInventory.setCustomer(detached);
        newInventories.add(newInventory);
        detached.setCustomerInventories(newInventories);
        this.em.persist((Object)newInventory);
        this.assertNotDetached(newInventory);
        this.em.detach((Object)detached);
        this.assertDetached(detached);
        TestDetach.assertEquals((int)(inventories.size() + 1), (int)newInventories.size());
        for (DMCustomerInventory inventory : newInventories) {
            if (inventory == newInventory) {
                this.assertNotDetached(inventory);
                continue;
            }
            this.assertDetached(inventory);
        }
        this.em.getTransaction().rollback();
    }

    public void testFlushingBeforeDetachingSavesChange() {
    }

    public void testManagedEntityContinuesToReferDetachedEntities() {
        this.em.getTransaction().begin();
        DMCustomer pc = (DMCustomer)this.em.find(DMCustomer.class, (Object)this.root.getId());
        List<DMCustomerInventory> inventories = pc.getCustomerInventories();
        DMItem item = inventories.get(1).getItem();
        this.em.detach((Object)inventories.get(0));
        DMCustomerInventory attached0 = inventories.get(0);
        DMCustomerInventory attached1 = inventories.get(1);
        TestDetach.assertSame((Object)pc.getCustomerInventories().get(0), (Object)attached0);
        TestDetach.assertSame((Object)pc.getCustomerInventories().get(1), (Object)attached1);
        this.em.getTransaction().rollback();
    }

    DMCustomer createData() {
        DMItem item1 = new DMItem();
        DMItem item2 = new DMItem();
        item1.setName("item-1");
        item1.setPrice(100.0);
        item2.setName("item-2");
        item2.setPrice(200.0);
        DMCustomerInventory inventory1 = new DMCustomerInventory();
        DMCustomerInventory inventory2 = new DMCustomerInventory();
        inventory1.setItem(item1);
        inventory1.setQuantity(10);
        inventory2.setItem(item2);
        inventory2.setQuantity(20);
        DMCustomer customer = new DMCustomer();
        customer.setFirstName("Detached");
        customer.setLastName("Customer");
        customer.setCustomerInventories(Arrays.asList(inventory1, inventory2));
        inventory1.setCustomer(customer);
        inventory2.setCustomer(customer);
        this.em.getTransaction().begin();
        this.em.persist((Object)customer);
        this.em.getTransaction().commit();
        this.em.clear();
        return customer;
    }

    void assertDetached(Object pc) {
        TestDetach.assertTrue((String)(pc + " should be detached"), (boolean)this.em.isDetached(pc));
        TestDetach.assertFalse((String)(pc + " should not be in cache"), (boolean)this.em.contains(pc));
    }

    void assertNotDetached(Object pc) {
        TestDetach.assertFalse((String)(pc + " should not be detached"), (boolean)this.em.isDetached(pc));
        TestDetach.assertTrue((String)(pc + " should be in cache"), (boolean)this.em.contains(pc));
    }
}

