/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.detachment;

import junit.textui.TestRunner;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.detachment.Record;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestAttachConstructedCopy
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(Record.class);
    }

    public void testAttachConstructedCopyWithGeneratedPKAndNoVersion() {
        Record record = new Record();
        record.setContent("orig");
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)record);
        em.getTransaction().commit();
        em.close();
        int id = record.getId();
        Record copy = new Record();
        copy.setId(id);
        copy.setContent("new");
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        record = (Record)em.merge((Object)copy);
        TestAttachConstructedCopy.assertTrue((record != copy ? 1 : 0) != 0);
        TestAttachConstructedCopy.assertEquals((String)"new", (String)record.getContent());
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        record = (Record)em.find(Record.class, (Object)id);
        TestAttachConstructedCopy.assertEquals((String)"new", (String)record.getContent());
        em.close();
    }

    public static void main(String[] args) {
        TestRunner.run(TestAttachConstructedCopy.class);
    }
}

