/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.detach.xml;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.detach.xml.Automobile;
import org.apache.openjpa.persistence.detach.xml.Driver;
import org.apache.openjpa.persistence.detach.xml.Owner;
import org.apache.openjpa.persistence.detach.xml.Passenger;
import org.apache.openjpa.persistence.test.AbstractPersistenceTestCase;

public class TestDetachXML
extends AbstractPersistenceTestCase {
    public void testDetach() throws Exception {
        OpenJPAEntityManagerFactorySPI emf = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"DetachXMLPU", (String)"org/apache/openjpa/persistence/detach/detach-persistence.xml");
        try {
            this.verifyCascadeDetach((EntityManagerFactory)emf, true);
        }
        finally {
            this.cleanupEMF(emf);
        }
    }

    public void testNoDetach() throws Exception {
        OpenJPAEntityManagerFactorySPI emf = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"NoDetachXMLPU", (String)"org/apache/openjpa/persistence/detach/detach-persistence.xml");
        try {
            this.verifyCascadeDetach((EntityManagerFactory)emf, false);
        }
        finally {
            this.cleanupEMF(emf);
        }
    }

    public void testAllDetach() throws Exception {
        OpenJPAEntityManagerFactorySPI emf = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"DetachAllXMLPU", (String)"org/apache/openjpa/persistence/detach/detach-persistence.xml");
        try {
            this.verifyCascadeDetach((EntityManagerFactory)emf, true);
        }
        finally {
            this.cleanupEMF(emf);
        }
    }

    private void verifyCascadeDetach(EntityManagerFactory emf, boolean cascade) {
        EntityManager em = emf.createEntityManager();
        List<Object> data = this.createData(em);
        TestDetachXML.assertNotNull(data);
        int size = data.size();
        TestDetachXML.assertTrue((data.size() > 0 ? 1 : 0) != 0);
        for (int i = 0; i < size; ++i) {
            Object entity = data.get(i);
            em.detach(entity);
            for (int j = 0; j < size; ++j) {
                if (j == i) {
                    TestDetachXML.assertFalse((boolean)em.contains(entity));
                    continue;
                }
                Object detent = data.get(j);
                TestDetachXML.assertEquals((!cascade ? 1 : 0) != 0, (boolean)em.contains(detent));
            }
            data = this.createData(em);
        }
    }

    private List<Object> createData(EntityManager em) {
        ArrayList<Object> data = new ArrayList<Object>();
        Automobile auto = new Automobile();
        auto.setMake("Ford");
        auto.setModel("Pinto");
        data.add(auto);
        Automobile auto2 = new Automobile();
        auto2.setMake("Winnebago");
        auto2.setModel("Sightseer");
        data.add(auto2);
        ArrayList<Automobile> autos = new ArrayList<Automobile>();
        autos.add(auto);
        autos.add(auto2);
        Passenger p1 = new Passenger();
        p1.setName("Crash test dummy 0");
        p1.setAutos(autos);
        data.add(p1);
        Passenger p2 = new Passenger();
        p2.setName("Crash test dummy 1");
        p2.setAutos(autos);
        data.add(p2);
        ArrayList<Passenger> passengers = new ArrayList<Passenger>();
        passengers.add(p1);
        passengers.add(p2);
        auto.setPassengers(passengers);
        auto2.setPassengers(passengers);
        Driver d1 = new Driver();
        d1.setAuto(auto);
        d1.setName("Crash test driver 0");
        auto.setPrimaryDriver(d1);
        data.add(d1);
        Driver d2 = new Driver();
        d2.setAuto(auto2);
        d2.setName("Crash test driver 1");
        auto2.setPrimaryDriver(d2);
        data.add(d2);
        Owner owner = new Owner();
        owner.setName("DMV");
        owner.setAutos(autos);
        auto.setOwner(owner);
        auto2.setOwner(owner);
        data.add(owner);
        em.getTransaction().begin();
        em.persist((Object)owner);
        em.getTransaction().commit();
        return data;
    }

    private void cleanupEMF(OpenJPAEntityManagerFactorySPI emf1) throws Exception {
        if (emf1 == null) {
            return;
        }
        try {
            this.clear((EntityManagerFactory)emf1);
        }
        catch (Exception e) {
            if (this.testResult.wasSuccessful()) {
                throw e;
            }
        }
        finally {
            this.closeEMF((EntityManagerFactory)emf1);
        }
    }
}

