/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.detach;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.openjpa.conf.Compatibility;
import org.apache.openjpa.persistence.DetachStateType;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.detach.EntityA;
import org.apache.openjpa.persistence.detach.EntityB;
import org.apache.openjpa.persistence.detach.EntityC;
import org.apache.openjpa.persistence.detach.EntityD;
import org.apache.openjpa.persistence.detach.EntityE;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestDetachStateCascade
extends SingleEMFTestCase {
    OpenJPAEntityManager em;
    int id = 0;
    Compatibility compat;
    EntityA entityA;
    EntityB entityB;
    EntityC entityC;
    EntityD entityD;
    EntityE entityE;
    List<EntityC> list = new ArrayList<EntityC>();
    Collection<Object> allEntities = new HashSet<Object>();

    @Override
    public void setUp() throws Exception {
        this.setUp(EntityA.class, EntityB.class, EntityC.class, EntityD.class, EntityE.class);
        TestDetachStateCascade.assertNotNull((Object)this.emf);
        this.em = this.emf.createEntityManager();
        TestDetachStateCascade.assertNotNull((Object)this.em);
        this.compat = this.emf.getConfiguration().getCompatibilityInstance();
        TestDetachStateCascade.assertNotNull((Object)this.compat);
        this.compat.setFlushBeforeDetach(true);
        this.compat.setCopyOnDetach(false);
        this.compat.setCascadeWithDetach(false);
        ++this.id;
        this.create(this.id);
        this.em.getTransaction().begin();
        this.em.persist((Object)this.entityA);
        this.em.getTransaction().commit();
    }

    private void create(int id) {
        this.entityA = new EntityA(id, "entityA", "top level class");
        this.entityB = new EntityB(id, "entityB");
        this.entityC = new EntityC(id, "entityC");
        this.entityD = new EntityD(id, "entityD");
        this.entityE = new EntityE(id, "entityE");
        this.entityA.setEntityB(this.entityB);
        this.entityA.setEntityC(this.entityC);
        this.entityA.setEntityD(this.entityD);
        this.entityA.setEntityE(this.entityE);
    }

    public void testLoaded() {
        this.em.getTransaction().begin();
        this.em.persist((Object)this.entityA);
        this.em.clear();
        EntityA eA = (EntityA)this.em.find(EntityA.class, (Object)this.id);
        TestDetachStateCascade.assertTrue((boolean)this.em.contains((Object)eA));
        EntityD eD = (EntityD)this.em.find(EntityD.class, (Object)this.id);
        TestDetachStateCascade.assertTrue((boolean)this.em.contains((Object)eD));
        EntityE eE = (EntityE)this.em.find(EntityE.class, (Object)this.id);
        TestDetachStateCascade.assertTrue((boolean)this.em.contains((Object)eE));
        this.em.detach((Object)eA);
        TestDetachStateCascade.assertEquals((long)this.id, (long)eA.getId());
        TestDetachStateCascade.assertEquals((String)"entityA", (String)eA.getName());
        TestDetachStateCascade.assertNull((Object)eA.getDescription());
        TestDetachStateCascade.assertNotNull((Object)eA.getEntityB());
        TestDetachStateCascade.assertNotNull((Object)eA.getEntityC());
        TestDetachStateCascade.assertNull((Object)eA.getEntityD());
        TestDetachStateCascade.assertNull((Object)eA.getEntityE());
        TestDetachStateCascade.assertTrue((boolean)this.em.isDetached((Object)eA));
        TestDetachStateCascade.assertTrue((boolean)this.em.isDetached((Object)eA.getEntityB()));
        TestDetachStateCascade.assertFalse((boolean)this.em.isDetached((Object)eA.getEntityC()));
        TestDetachStateCascade.assertFalse((boolean)this.em.isDetached((Object)eD));
        TestDetachStateCascade.assertFalse((boolean)this.em.isDetached((Object)eE));
        this.em.getTransaction().commit();
    }

    public void testDetachStateAll() {
        this.em.setDetachState(DetachStateType.ALL);
        this.em.getTransaction().begin();
        this.em.persist((Object)this.entityA);
        this.em.clear();
        EntityA eA = (EntityA)this.em.find(EntityA.class, (Object)this.id);
        TestDetachStateCascade.assertTrue((boolean)this.em.contains((Object)eA));
        this.em.detach((Object)eA);
        TestDetachStateCascade.assertEquals((long)this.id, (long)eA.getId());
        TestDetachStateCascade.assertEquals((String)"entityA", (String)eA.getName());
        TestDetachStateCascade.assertNotNull((Object)eA.getDescription());
        TestDetachStateCascade.assertNotNull((Object)eA.getEntityB());
        TestDetachStateCascade.assertNotNull((Object)eA.getEntityC());
        TestDetachStateCascade.assertNotNull((Object)eA.getEntityD());
        TestDetachStateCascade.assertNotNull((Object)eA.getEntityE());
        TestDetachStateCascade.assertTrue((boolean)this.em.isDetached((Object)eA));
        TestDetachStateCascade.assertTrue((boolean)this.em.isDetached((Object)eA.getEntityB()));
        TestDetachStateCascade.assertFalse((boolean)this.em.isDetached((Object)eA.getEntityC()));
        TestDetachStateCascade.assertTrue((boolean)this.em.isDetached((Object)eA.getEntityD()));
        TestDetachStateCascade.assertFalse((boolean)this.em.isDetached((Object)eA.getEntityE()));
        this.em.getTransaction().commit();
    }

    public void testDetachStateFetchGroup() {
        this.em.setDetachState(DetachStateType.FETCH_GROUPS);
        this.em.getFetchPlan().addFetchGroup("loadD");
        this.em.getTransaction().begin();
        this.em.persist((Object)this.entityA);
        this.em.clear();
        EntityA eA = (EntityA)this.em.find(EntityA.class, (Object)this.id);
        TestDetachStateCascade.assertTrue((boolean)this.em.contains((Object)eA));
        EntityE eE = (EntityE)this.em.find(EntityE.class, (Object)this.id);
        TestDetachStateCascade.assertTrue((boolean)this.em.contains((Object)eE));
        this.em.detach((Object)eA);
        TestDetachStateCascade.assertEquals((long)this.id, (long)eA.getId());
        TestDetachStateCascade.assertEquals((String)"entityA", (String)eA.getName());
        TestDetachStateCascade.assertNull((Object)eA.getDescription());
        TestDetachStateCascade.assertNotNull((Object)eA.getEntityB());
        TestDetachStateCascade.assertNotNull((Object)eA.getEntityC());
        TestDetachStateCascade.assertNotNull((Object)eA.getEntityD());
        TestDetachStateCascade.assertNull((Object)eA.getEntityE());
        TestDetachStateCascade.assertTrue((boolean)this.em.isDetached((Object)eA));
        TestDetachStateCascade.assertTrue((boolean)this.em.isDetached((Object)eA.getEntityB()));
        TestDetachStateCascade.assertFalse((boolean)this.em.isDetached((Object)eA.getEntityC()));
        TestDetachStateCascade.assertTrue((boolean)this.em.isDetached((Object)eA.getEntityD()));
        TestDetachStateCascade.assertFalse((boolean)this.em.isDetached((Object)eE));
        this.em.getTransaction().commit();
    }
}

